package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.TestNGToAssertJRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class TestNGToAssertJRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public TestNGToAssertJRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "Refaster rules that replace TestNG assertions with equivalent AssertJ assertions";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Some of the classes below have TestNG `@BeforeTemplate`s that reference wildcard type\n bounds (`<?>`), while the associated AssertJ `@AfterTemplate`s reference stricter\n type bounds. This introduces the risk of producing invalid code. We do this anyway, because\n TestNG's wildcard types can cause javac to infer less specific types than AssertJ requires, while\n the appropriate (more specific) types _will_ be inferred properly when plugged into AssertJ's\n API.\n\n The following is an example of a TestNG statement, which would not be rewritten if it weren't\n for the wildcard matching (note that the type parameters of the map on the right-hand side will\n be inferred to be `<Object, Object>` rather than `<String, Object>`).\n\n ```java\n List<Map<String, Object>> myMaps = new ArrayList<>();\n assertEquals(myMaps, ImmutableList.of(ImmutableMap.of()));\n ```\n.\n[Source](https://error-prone.picnic.tech/refasterrules/TestNGToAssertJRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new FailRecipe(),
                new FailWithMessageRecipe(),
                new FailWithMessageAndThrowableRecipe(),
                new AssertTrueRecipe(),
                new AssertTrueWithMessageRecipe(),
                new AssertFalseRecipe(),
                new AssertFalseWithMessageRecipe(),
                new AssertNullRecipe(),
                new AssertNullWithMessageRecipe(),
                new AssertNotNullRecipe(),
                new AssertNotNullWithMessageRecipe(),
                new AssertSameRecipe(),
                new AssertSameWithMessageRecipe(),
                new AssertNotSameRecipe(),
                new AssertNotSameWithMessageRecipe(),
                new AssertEqualRecipe(),
                new AssertEqualWithMessageRecipe(),
                new AssertEqualFloatsWithDeltaRecipe(),
                new AssertEqualFloatsWithDeltaWithMessageRecipe(),
                new AssertEqualDoublesWithDeltaRecipe(),
                new AssertEqualDoublesWithDeltaWithMessageRecipe(),
                new AssertEqualArrayIterationOrderRecipe(),
                new AssertEqualArrayIterationOrderWithMessageRecipe(),
                new AssertEqualFloatArraysWithDeltaRecipe(),
                new AssertEqualFloatArraysWithDeltaWithMessageRecipe(),
                new AssertEqualDoubleArraysWithDeltaRecipe(),
                new AssertEqualDoubleArraysWithDeltaWithMessageRecipe(),
                new AssertEqualArraysIrrespectiveOfOrderRecipe(),
                new AssertEqualArraysIrrespectiveOfOrderWithMessageRecipe(),
                new AssertEqualIteratorIterationOrderRecipe(),
                new AssertEqualIteratorIterationOrderWithMessageRecipe(),
                new AssertEqualIterableIterationOrderRecipe(),
                new AssertEqualIterableIterationOrderWithMessageRecipe(),
                new AssertEqualSetsRecipe(),
                new AssertEqualSetsWithMessageRecipe(),
                new AssertUnequalRecipe(),
                new AssertUnequalWithMessageRecipe(),
                new AssertUnequalFloatsWithDeltaRecipe(),
                new AssertUnequalFloatsWithDeltaWithMessageRecipe(),
                new AssertUnequalDoublesWithDeltaRecipe(),
                new AssertUnequalDoublesWithDeltaWithMessageRecipe(),
                new AssertThrowsRecipe(),
                new AssertThrowsWithTypeRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.Fail}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FailRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FailRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.Fail`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class Fail {\n    \n    @BeforeTemplate\n    void before() {\n        Assert.fail();\n    }\n    \n    @AfterTemplate\n    @DoNotCall\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after() {\n        fail();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.fail();")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.fail();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.testng.Assert", true),
                            new UsesMethod<>("org.testng.Assert fail(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.FailWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FailWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FailWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.FailWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithMessage {\n    \n    @BeforeTemplate\n    void before(String message) {\n        Assert.fail(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(String message) {\n        fail(message);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.fail(#{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.fail(#{message:any(java.lang.String)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.testng.Assert", true),
                            new UsesMethod<>("org.testng.Assert fail(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.FailWithMessageAndThrowable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FailWithMessageAndThrowableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FailWithMessageAndThrowableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.FailWithMessageAndThrowable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithMessageAndThrowable {\n    \n    @BeforeTemplate\n    void before(String message, Throwable throwable) {\n        Assert.fail(message, throwable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(String message, Throwable throwable) {\n        fail(message, throwable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.fail(#{message:any(java.lang.String)}, #{throwable:any(java.lang.Throwable)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.fail(#{message:any(java.lang.String)}, #{throwable:any(java.lang.Throwable)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.testng.Assert", true),
                            new UsesMethod<>("org.testng.Assert fail(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertTrue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertTrueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertTrueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertTrue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertTrue {\n    \n    @BeforeTemplate\n    void before(boolean condition) {\n        assertTrue(condition);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition) {\n        assertThat(condition).isTrue();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertTrue(#{condition:any(boolean)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertTrue");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{condition:any(boolean)}).isTrue();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertTrue(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertTrueWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertTrueWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertTrueWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertTrueWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertTrueWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean condition, String message) {\n        assertTrue(condition, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition, String message) {\n        assertThat(condition).withFailMessage(message).isTrue();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertTrue(#{condition:any(boolean)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertTrue");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{condition:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isTrue();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertTrue(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertFalse}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertFalseRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertFalseRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertFalse`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertFalse {\n    \n    @BeforeTemplate\n    void before(boolean condition) {\n        assertFalse(condition);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition) {\n        assertThat(condition).isFalse();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertFalse(#{condition:any(boolean)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertFalse");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{condition:any(boolean)}).isFalse();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertFalse(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertFalseWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertFalseWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertFalseWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertFalseWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertFalseWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean condition, String message) {\n        assertFalse(condition, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition, String message) {\n        assertThat(condition).withFailMessage(message).isFalse();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertFalse(#{condition:any(boolean)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertFalse");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{condition:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isFalse();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertFalse(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNull {\n    \n    @BeforeTemplate\n    void before(Object object) {\n        assertNull(object);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object) {\n        assertThat(object).isNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNull(#{object:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(java.lang.Object)}).isNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNull(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertNullWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertNullWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertNullWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertNullWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNullWithMessage {\n    \n    @BeforeTemplate\n    void before(Object object, String message) {\n        assertNull(object, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object, String message) {\n        assertThat(object).withFailMessage(message).isNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNull(#{object:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNull(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertNotNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertNotNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertNotNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertNotNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotNull {\n    \n    @BeforeTemplate\n    void before(Object object) {\n        assertNotNull(object);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object) {\n        assertThat(object).isNotNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotNull(#{object:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(java.lang.Object)}).isNotNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotNull(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertNotNullWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertNotNullWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertNotNullWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertNotNullWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotNullWithMessage {\n    \n    @BeforeTemplate\n    void before(Object object, String message) {\n        assertNotNull(object, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object, String message) {\n        assertThat(object).withFailMessage(message).isNotNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotNull(#{object:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotNull(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertSame}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertSameRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertSameRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertSame`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertSame {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertSame(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertSame(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertSame(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertSameWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertSameWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertSameWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertSameWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertSameWithMessage {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertSame(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertSame(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertSame(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertNotSame}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertNotSameRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertNotSameRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertNotSame`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotSame {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertNotSame(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotSame(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotSame(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertNotSameWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertNotSameWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertNotSameWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertNotSameWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotSameWithMessage {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertNotSame(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotSame(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotSame(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqual}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqual`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"java:S1448\")\nstatic final class AssertEqual {\n    \n    @BeforeTemplate\n    void before(boolean actual, boolean expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(boolean actual, Boolean expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Boolean actual, boolean expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Boolean actual, Boolean expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, byte expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, Byte expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Byte actual, byte expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Byte actual, Byte expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, char expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, Character expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Character actual, char expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Character actual, Character expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, short expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, Short expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Short actual, short expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Short actual, Short expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, int expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, Integer expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Integer actual, int expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Integer actual, Integer expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, long expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, Long expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Long actual, long expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Long actual, Long expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, float expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, Float expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Float actual, float expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Float actual, Float expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, double expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, Double expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Double actual, double expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Double actual, Double expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, Map<?, ?> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1448");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate before8;
                JavaTemplate before9;
                JavaTemplate before10;
                JavaTemplate before11;
                JavaTemplate before12;
                JavaTemplate before13;
                JavaTemplate before14;
                JavaTemplate before15;
                JavaTemplate before16;
                JavaTemplate before17;
                JavaTemplate before18;
                JavaTemplate before19;
                JavaTemplate before20;
                JavaTemplate before21;
                JavaTemplate before22;
                JavaTemplate before23;
                JavaTemplate before24;
                JavaTemplate before25;
                JavaTemplate before26;
                JavaTemplate before27;
                JavaTemplate before28;
                JavaTemplate before29;
                JavaTemplate before30;
                JavaTemplate before31;
                JavaTemplate before32;
                JavaTemplate before33;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(boolean)}, #{expected:any(boolean)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(boolean)}, #{expected:any(java.lang.Boolean)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Boolean)}, #{expected:any(boolean)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before10 == null) {
                        before10 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Character)}, #{expected:any(java.lang.Character)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before10.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before11 == null) {
                        before11 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(short)}, #{expected:any(short)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before11.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before12 == null) {
                        before12 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(short)}, #{expected:any(java.lang.Short)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before12.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before13 == null) {
                        before13 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Short)}, #{expected:any(short)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before13.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before14 == null) {
                        before14 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Short)}, #{expected:any(java.lang.Short)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before14.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before15 == null) {
                        before15 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(int)}, #{expected:any(int)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before15.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before16 == null) {
                        before16 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(int)}, #{expected:any(java.lang.Integer)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before16.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before17 == null) {
                        before17 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Integer)}, #{expected:any(int)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before17.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before18 == null) {
                        before18 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Integer)}, #{expected:any(java.lang.Integer)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before18.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before19 == null) {
                        before19 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(long)}, #{expected:any(long)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before19.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Boolean)}, #{expected:any(java.lang.Boolean)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before20 == null) {
                        before20 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(long)}, #{expected:any(java.lang.Long)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before20.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before21 == null) {
                        before21 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Long)}, #{expected:any(long)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before21.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before22 == null) {
                        before22 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Long)}, #{expected:any(java.lang.Long)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before22.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before23 == null) {
                        before23 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(float)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before23.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before24 == null) {
                        before24 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(java.lang.Float)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before24.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before25 == null) {
                        before25 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Float)}, #{expected:any(float)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before25.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before26 == null) {
                        before26 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Float)}, #{expected:any(java.lang.Float)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before26.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before27 == null) {
                        before27 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(double)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before27.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before28 == null) {
                        before28 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(java.lang.Double)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before28.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before29 == null) {
                        before29 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Double)}, #{expected:any(double)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before29.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3 == null) {
                        before3 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(byte)}, #{expected:any(byte)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before30 == null) {
                        before30 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Double)}, #{expected:any(java.lang.Double)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before30.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before31 == null) {
                        before31 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before31.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before32 == null) {
                        before32 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.String)}, #{expected:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before32.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before33 == null) {
                        before33 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.util.Map<?, ?>)}, #{expected:any(java.util.Map<?, ?>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before33.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4 == null) {
                        before4 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(byte)}, #{expected:any(java.lang.Byte)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5 == null) {
                        before5 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Byte)}, #{expected:any(byte)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before5.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6 == null) {
                        before6 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Byte)}, #{expected:any(java.lang.Byte)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before7 == null) {
                        before7 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(char)}, #{expected:any(char)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before7.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before8 == null) {
                        before8 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(char)}, #{expected:any(java.lang.Character)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before8.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before9 == null) {
                        before9 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Character)}, #{expected:any(char)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before9.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"java:S1448\")\nstatic final class AssertEqualWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message, boolean expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(boolean actual, String message, Boolean expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Boolean actual, String message, boolean expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Boolean actual, String message, Boolean expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, String message, byte expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, String message, Byte expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Byte actual, String message, byte expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Byte actual, String message, Byte expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, String message, char expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, String message, Character expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Character actual, String message, char expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Character actual, String message, Character expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, String message, short expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, String message, Short expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Short actual, String message, short expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Short actual, String message, Short expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, String message, int expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, String message, Integer expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Integer actual, String message, int expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Integer actual, String message, Integer expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, String message, long expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, String message, Long expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Long actual, String message, long expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Long actual, String message, Long expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, String message, Float expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Float actual, String message, float expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Float actual, String message, Float expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, String message, Double expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Double actual, String message, double expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Double actual, String message, Double expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String message, String expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, String message, Map<?, ?> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1448");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate before8;
                JavaTemplate before9;
                JavaTemplate before10;
                JavaTemplate before11;
                JavaTemplate before12;
                JavaTemplate before13;
                JavaTemplate before14;
                JavaTemplate before15;
                JavaTemplate before16;
                JavaTemplate before17;
                JavaTemplate before18;
                JavaTemplate before19;
                JavaTemplate before20;
                JavaTemplate before21;
                JavaTemplate before22;
                JavaTemplate before23;
                JavaTemplate before24;
                JavaTemplate before25;
                JavaTemplate before26;
                JavaTemplate before27;
                JavaTemplate before28;
                JavaTemplate before29;
                JavaTemplate before30;
                JavaTemplate before31;
                JavaTemplate before32;
                JavaTemplate before33;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(boolean)}, #{expected:any(boolean)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(boolean)}, #{expected:any(java.lang.Boolean)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Boolean)}, #{expected:any(boolean)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before10 == null) {
                        before10 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Character)}, #{expected:any(java.lang.Character)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before10.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before11 == null) {
                        before11 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(short)}, #{expected:any(short)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before11.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before12 == null) {
                        before12 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(short)}, #{expected:any(java.lang.Short)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before12.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before13 == null) {
                        before13 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Short)}, #{expected:any(short)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before13.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before14 == null) {
                        before14 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Short)}, #{expected:any(java.lang.Short)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before14.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before15 == null) {
                        before15 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(int)}, #{expected:any(int)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before15.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before16 == null) {
                        before16 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(int)}, #{expected:any(java.lang.Integer)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before16.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before17 == null) {
                        before17 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Integer)}, #{expected:any(int)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before17.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before18 == null) {
                        before18 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Integer)}, #{expected:any(java.lang.Integer)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before18.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before19 == null) {
                        before19 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(long)}, #{expected:any(long)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before19.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Boolean)}, #{expected:any(java.lang.Boolean)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before20 == null) {
                        before20 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(long)}, #{expected:any(java.lang.Long)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before20.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before21 == null) {
                        before21 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Long)}, #{expected:any(long)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before21.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before22 == null) {
                        before22 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Long)}, #{expected:any(java.lang.Long)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before22.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before23 == null) {
                        before23 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(float)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before23.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before24 == null) {
                        before24 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(java.lang.Float)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before24.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before25 == null) {
                        before25 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Float)}, #{expected:any(float)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before25.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before26 == null) {
                        before26 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Float)}, #{expected:any(java.lang.Float)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before26.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before27 == null) {
                        before27 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(double)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before27.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before28 == null) {
                        before28 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(java.lang.Double)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before28.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before29 == null) {
                        before29 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Double)}, #{expected:any(double)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before29.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3 == null) {
                        before3 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(byte)}, #{expected:any(byte)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before30 == null) {
                        before30 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Double)}, #{expected:any(java.lang.Double)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before30.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before31 == null) {
                        before31 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before31.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before32 == null) {
                        before32 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.String)}, #{expected:any(java.lang.String)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before32.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before33 == null) {
                        before33 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.util.Map<?, ?>)}, #{expected:any(java.util.Map<?, ?>)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before33.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4 == null) {
                        before4 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(byte)}, #{expected:any(java.lang.Byte)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5 == null) {
                        before5 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Byte)}, #{expected:any(byte)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before5.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6 == null) {
                        before6 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Byte)}, #{expected:any(java.lang.Byte)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before7 == null) {
                        before7 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(char)}, #{expected:any(char)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before7.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before8 == null) {
                        before8 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(char)}, #{expected:any(java.lang.Character)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before8.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before9 == null) {
                        before9 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Character)}, #{expected:any(char)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before9.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualFloatsWithDelta}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualFloatsWithDeltaRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualFloatsWithDeltaRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatsWithDelta`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatsWithDelta {\n    \n    @BeforeTemplate\n    void before(float actual, float expected, float delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Float actual, float expected, float delta) {\n        assertThat(actual).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(float)}, #{delta:any(float)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Float)}).isCloseTo(#{expected:any(float)}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualFloatsWithDeltaWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualFloatsWithDeltaWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualFloatsWithDeltaWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatsWithDeltaWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatsWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected, float delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, String message, float expected, float delta) {\n        assertThat(actual).withFailMessage(message).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(float)}, #{delta:any(float)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).withFailMessage(#{message:any(java.lang.String)}).isCloseTo(#{expected:any(float)}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualDoublesWithDelta}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualDoublesWithDeltaRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualDoublesWithDeltaRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoublesWithDelta`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoublesWithDelta {\n    \n    @BeforeTemplate\n    void before(double actual, double expected, double delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, double expected, double delta) {\n        assertThat(actual).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(double)}, #{delta:any(double)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isCloseTo(#{expected:any(double)}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualDoublesWithDeltaWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualDoublesWithDeltaWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualDoublesWithDeltaWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoublesWithDeltaWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoublesWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected, double delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, String message, double expected, double delta) {\n        assertThat(actual).withFailMessage(message).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(double)}, #{delta:any(double)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).withFailMessage(#{message:any(java.lang.String)}).isCloseTo(#{expected:any(double)}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualArrayIterationOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualArrayIterationOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualArrayIterationOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualArrayIterationOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArrayIterationOrder {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, boolean[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte[] actual, byte[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char[] actual, char[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short[] actual, short[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int[] actual, int[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long[] actual, long[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float[] actual, float[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double[] actual, double[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Object[] actual, Object[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Object[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(boolean[])}, #{expected:any(boolean[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(byte[])}, #{expected:any(byte[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(char[])}, #{expected:any(char[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(short[])}, #{expected:any(short[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3 == null) {
                        before3 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(int[])}, #{expected:any(int[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4 == null) {
                        before4 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(long[])}, #{expected:any(long[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5 == null) {
                        before5 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float[])}, #{expected:any(float[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before5.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6 == null) {
                        before6 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double[])}, #{expected:any(double[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before7 == null) {
                        before7 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Object[])}, #{expected:any(java.lang.Object[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before7.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualArrayIterationOrderWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualArrayIterationOrderWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualArrayIterationOrderWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualArrayIterationOrderWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArrayIterationOrderWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, String message, boolean[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte[] actual, String message, byte[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char[] actual, String message, char[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short[] actual, String message, short[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int[] actual, String message, int[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long[] actual, String message, long[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float[] actual, String message, float[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double[] actual, String message, double[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Object[] actual, String message, Object[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, String message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(boolean[])}, #{expected:any(boolean[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(byte[])}, #{expected:any(byte[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(char[])}, #{expected:any(char[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(short[])}, #{expected:any(short[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3 == null) {
                        before3 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(int[])}, #{expected:any(int[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4 == null) {
                        before4 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(long[])}, #{expected:any(long[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5 == null) {
                        before5 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float[])}, #{expected:any(float[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before5.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6 == null) {
                        before6 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double[])}, #{expected:any(double[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before7 == null) {
                        before7 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Object[])}, #{expected:any(java.lang.Object[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before7.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualFloatArraysWithDelta}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualFloatArraysWithDeltaRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualFloatArraysWithDeltaRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatArraysWithDelta`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatArraysWithDelta {\n    \n    @BeforeTemplate\n    void before(float[] actual, float[] expected, float delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, float[] expected, float delta) {\n        assertThat(actual).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float[])}, #{expected:any(float[])}, #{delta:any(float)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).containsExactly(#{expected:any(float[])}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualFloatArraysWithDeltaWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualFloatArraysWithDeltaWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualFloatArraysWithDeltaWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatArraysWithDeltaWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatArraysWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(float[] actual, String message, float[] expected, float delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, String message, float[] expected, float delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(float[])}, #{expected:any(float[])}, #{delta:any(float)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(float[])}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualDoubleArraysWithDelta}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualDoubleArraysWithDeltaRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualDoubleArraysWithDeltaRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoubleArraysWithDelta`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoubleArraysWithDelta {\n    \n    @BeforeTemplate\n    void before(double[] actual, double[] expected, double delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, double[] expected, double delta) {\n        assertThat(actual).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double[])}, #{expected:any(double[])}, #{delta:any(double)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).containsExactly(#{expected:any(double[])}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualDoubleArraysWithDeltaWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualDoubleArraysWithDeltaWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualDoubleArraysWithDeltaWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoubleArraysWithDeltaWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoubleArraysWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(double[] actual, String message, double[] expected, double delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, String message, double[] expected, double delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(double[])}, #{expected:any(double[])}, #{delta:any(double)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(double[])}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualArraysIrrespectiveOfOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualArraysIrrespectiveOfOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualArraysIrrespectiveOfOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualArraysIrrespectiveOfOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArraysIrrespectiveOfOrder {\n    \n    @BeforeTemplate\n    void before(Object[] actual, Object[] expected) {\n        assertEqualsNoOrder(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Object[] expected) {\n        assertThat(actual).containsExactlyInAnyOrder(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEqualsNoOrder(#{actual:any(java.lang.Object[])}, #{expected:any(java.lang.Object[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEqualsNoOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactlyInAnyOrder(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEqualsNoOrder(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualArraysIrrespectiveOfOrderWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualArraysIrrespectiveOfOrderWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualArraysIrrespectiveOfOrderWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualArraysIrrespectiveOfOrderWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArraysIrrespectiveOfOrderWithMessage {\n    \n    @BeforeTemplate\n    void before(Object[] actual, String message, Object[] expected) {\n        assertEqualsNoOrder(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, String message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactlyInAnyOrder(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEqualsNoOrder(#{actual:any(java.lang.Object[])}, #{expected:any(java.lang.Object[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEqualsNoOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactlyInAnyOrder(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEqualsNoOrder(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualIteratorIterationOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualIteratorIterationOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualIteratorIterationOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualIteratorIterationOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualIteratorIterationOrder<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Iterator<S> actual, Iterator<T> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Iterator<S> actual, Iterator<T> expected) {\n        assertThat(actual).toIterable().containsExactlyElementsOf(ImmutableList.copyOf(expected));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.util.Iterator<S>)}, #{expected:any(java.util.Iterator<T>)});")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.util.Iterator<S>)}).toIterable().containsExactlyElementsOf(com.google.common.collect.ImmutableList.copyOf(#{expected:any(java.util.Iterator<T>)}));")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Iterator", true),
                            new UsesMethod<>("org.testng.Assert assertEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualIteratorIterationOrderWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualIteratorIterationOrderWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualIteratorIterationOrderWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualIteratorIterationOrderWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualIteratorIterationOrderWithMessage<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Iterator<S> actual, String message, Iterator<T> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Iterator<S> actual, String message, Iterator<T> expected) {\n        assertThat(actual).toIterable().withFailMessage(message).containsExactlyElementsOf(ImmutableList.copyOf(expected));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.util.Iterator<S>)}, #{expected:any(java.util.Iterator<T>)}, #{message:any(java.lang.String)});")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.util.Iterator<S>)}).toIterable().withFailMessage(#{message:any(java.lang.String)}).containsExactlyElementsOf(com.google.common.collect.ImmutableList.copyOf(#{expected:any(java.util.Iterator<T>)}));")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Iterator", true),
                            new UsesMethod<>("org.testng.Assert assertEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualIterableIterationOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualIterableIterationOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualIterableIterationOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualIterableIterationOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualIterableIterationOrder<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Iterable<S> actual, Iterable<T> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Collection<S> actual, Collection<T> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Iterable<S> actual, Iterable<T> expected) {\n        assertThat(actual).containsExactlyElementsOf(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Iterable<S>)}, #{expected:any(java.lang.Iterable<T>)});")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Iterable<S>)}).containsExactlyElementsOf(#{expected:any(java.lang.Iterable<T>)});")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.util.Collection<S>)}, #{expected:any(java.util.Collection<T>)});")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Iterable<S>)}).containsExactlyElementsOf(#{expected:any(java.lang.Iterable<T>)});")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualIterableIterationOrderWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualIterableIterationOrderWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualIterableIterationOrderWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualIterableIterationOrderWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualIterableIterationOrderWithMessage<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Iterable<S> actual, String message, Iterable<T> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Collection<S> actual, String message, Collection<T> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Iterable<S> actual, String message, Iterable<T> expected) {\n        assertThat(actual).withFailMessage(message).containsExactlyElementsOf(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.lang.Iterable<S>)}, #{expected:any(java.lang.Iterable<T>)}, #{message:any(java.lang.String)});")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Iterable<S>)}).withFailMessage(#{message:any(java.lang.String)}).containsExactlyElementsOf(#{expected:any(java.lang.Iterable<T>)});")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.util.Collection<S>)}, #{expected:any(java.util.Collection<T>)}, #{message:any(java.lang.String)});")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Iterable<S>)}).withFailMessage(#{message:any(java.lang.String)}).containsExactlyElementsOf(#{expected:any(java.lang.Iterable<T>)});")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualSets}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualSetsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualSetsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualSets`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualSets<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Set<S> actual, Set<T> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Set<S> actual, Set<T> expected) {\n        assertThat(actual).hasSameElementsAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.util.Set<S>)}, #{expected:any(java.util.Set<T>)});")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.util.Set<S>)}).hasSameElementsAs(#{expected:any(java.util.Set<T>)});")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("org.testng.Assert assertEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertEqualSetsWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertEqualSetsWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertEqualSetsWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertEqualSetsWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualSetsWithMessage<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Set<S> actual, String message, Set<T> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Set<S> actual, String message, Set<T> expected) {\n        assertThat(actual).withFailMessage(message).hasSameElementsAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertEquals(#{actual:any(java.util.Set<S>)}, #{expected:any(java.util.Set<T>)}, #{message:any(java.lang.String)});")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.util.Set<S>)}).withFailMessage(#{message:any(java.lang.String)}).hasSameElementsAs(#{expected:any(java.util.Set<T>)});")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("org.testng.Assert assertEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertUnequal}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertUnequalRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertUnequalRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertUnequal`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequal {\n    \n    @BeforeTemplate\n    void before(boolean actual, boolean expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, byte expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, char expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, short expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, int expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, long expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, float expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, double expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Set<?> actual, Set<?> expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, Map<?, ?> expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isNotEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate before8;
                JavaTemplate before9;
                JavaTemplate before10;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(boolean)}, #{expected:any(boolean)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(byte)}, #{expected:any(byte)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(char)}, #{expected:any(char)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before10 == null) {
                        before10 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(java.util.Map<?, ?>)}, #{expected:any(java.util.Map<?, ?>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before10.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(short)}, #{expected:any(short)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3 == null) {
                        before3 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(int)}, #{expected:any(int)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4 == null) {
                        before4 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(long)}, #{expected:any(long)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5 == null) {
                        before5 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(float)}, #{expected:any(float)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before5.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6 == null) {
                        before6 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(double)}, #{expected:any(double)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before7 == null) {
                        before7 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before7.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before8 == null) {
                        before8 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(java.lang.String)}, #{expected:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before8.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before9 == null) {
                        before9 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(java.util.Set<?>)}, #{expected:any(java.util.Set<?>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before9.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertUnequalWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertUnequalWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertUnequalWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertUnequalWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message, boolean expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, String message, byte expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, String message, char expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, String message, short expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, String message, int expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, String message, long expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String message, String expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Set<?> actual, String message, Set<?> expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, String message, Map<?, ?> expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isNotEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate before8;
                JavaTemplate before9;
                JavaTemplate before10;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(boolean)}, #{expected:any(boolean)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(byte)}, #{expected:any(byte)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(char)}, #{expected:any(char)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before10 == null) {
                        before10 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(java.util.Map<?, ?>)}, #{expected:any(java.util.Map<?, ?>)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before10.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(short)}, #{expected:any(short)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3 == null) {
                        before3 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(int)}, #{expected:any(int)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4 == null) {
                        before4 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(long)}, #{expected:any(long)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before4.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5 == null) {
                        before5 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(float)}, #{expected:any(float)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before5.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6 == null) {
                        before6 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(double)}, #{expected:any(double)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before6.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before7 == null) {
                        before7 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before7.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before8 == null) {
                        before8 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(java.lang.String)}, #{expected:any(java.lang.String)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before8.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before9 == null) {
                        before9 = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(java.util.Set<?>)}, #{expected:any(java.util.Set<?>)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before9.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertUnequalFloatsWithDelta}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertUnequalFloatsWithDeltaRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertUnequalFloatsWithDeltaRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertUnequalFloatsWithDelta`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalFloatsWithDelta {\n    \n    @BeforeTemplate\n    void before(float actual, float expected, float delta) {\n        assertNotEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, float expected, float delta) {\n        assertThat(actual).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(float)}, #{expected:any(float)}, #{delta:any(float)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).isNotCloseTo(#{expected:any(float)}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertUnequalFloatsWithDeltaWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertUnequalFloatsWithDeltaWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertUnequalFloatsWithDeltaWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertUnequalFloatsWithDeltaWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalFloatsWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected, float delta) {\n        assertNotEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, String message, float expected, float delta) {\n        assertThat(actual).withFailMessage(message).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(float)}, #{expected:any(float)}, #{delta:any(float)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).withFailMessage(#{message:any(java.lang.String)}).isNotCloseTo(#{expected:any(float)}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertUnequalDoublesWithDelta}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertUnequalDoublesWithDeltaRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertUnequalDoublesWithDeltaRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertUnequalDoublesWithDelta`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalDoublesWithDelta {\n    \n    @BeforeTemplate\n    void before(double actual, double expected, double delta) {\n        assertNotEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, double expected, double delta) {\n        assertThat(actual).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(double)}, #{expected:any(double)}, #{delta:any(double)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isNotCloseTo(#{expected:any(double)}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertUnequalDoublesWithDeltaWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertUnequalDoublesWithDeltaWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertUnequalDoublesWithDeltaWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertUnequalDoublesWithDeltaWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalDoublesWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected, double delta) {\n        assertNotEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, String message, double expected, double delta) {\n        assertThat(actual).withFailMessage(message).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertNotEquals(#{actual:any(double)}, #{expected:any(double)}, #{delta:any(double)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).withFailMessage(#{message:any(java.lang.String)}).isNotCloseTo(#{expected:any(double)}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.testng.Assert assertNotEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertThrows}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThrowsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThrowsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertThrows`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThrows {\n    \n    @BeforeTemplate\n    void before(ThrowingRunnable runnable) {\n        assertThrows(runnable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable runnable) {\n        assertThatThrownBy(runnable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertThrows(#{runnable:any(org.testng.Assert.ThrowingRunnable)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert.ThrowingRunnable");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertThrows");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatThrownBy(#{runnable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.testng.Assert.ThrowingRunnable", true),
                            new UsesMethod<>("org.testng.Assert assertThrows(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TestNGToAssertJRules.AssertThrowsWithType}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThrowsWithTypeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThrowsWithTypeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TestNGToAssertJRules.AssertThrowsWithType`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThrowsWithType<T extends Throwable> {\n    \n    @BeforeTemplate\n    void before(ThrowingRunnable runnable, Class<T> clazz) {\n        assertThrows(clazz, runnable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable runnable, Class<T> clazz) {\n        assertThatThrownBy(runnable).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.testng.Assert.assertThrows(#{clazz:any(java.lang.Class<T>)}, #{runnable:any(org.testng.Assert.ThrowingRunnable)});")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "testng-7"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.testng.Assert.ThrowingRunnable");
                        maybeRemoveImport("org.testng.Assert");
                        maybeRemoveImport("org.testng.Assert.assertThrows");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatThrownBy(#{runnable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.testng.Assert.ThrowingRunnable", true),
                            new UsesMethod<>("org.testng.Assert assertThrows(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
