package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.RxJava2AdapterRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class RxJava2AdapterRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public RxJava2AdapterRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`RxJava2AdapterRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `RxJava2Adapter`.\n[Source](https://error-prone.picnic.tech/refasterrules/RxJava2AdapterRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new CompletableToMonoRecipe(),
                new FlowableToFluxRecipe(),
                new FluxToFlowableRecipe(),
                new FluxToObservableRecipe(),
                new MaybeToMonoRecipe(),
                new MonoToCompletableRecipe(),
                new MonoToFlowableRecipe(),
                new MonoToMaybeRecipe(),
                new MonoToSingleRecipe(),
                new ObservableToFluxRecipe(),
                new SingleToMonoRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.CompletableToMono}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CompletableToMonoRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CompletableToMonoRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.CompletableToMono`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use the fluent API style when using `RxJava2Adapter#completableToMono`.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.completableToMono(#{completable:any(io.reactivex.Completable)})")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{completable:any(io.reactivex.Completable)}.as(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{completable:any(io.reactivex.Completable)}.to(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{completable:any(io.reactivex.Completable)}.as(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Completable", true),
                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("io.reactivex.Completable to(..)", true),
                                    new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter completableToMono(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.FlowableToFlux}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FlowableToFluxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FlowableToFluxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.FlowableToFlux`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use `RxJava2Adapter#flowableToFlux` to convert a `Flowable` to a `Flux`, and do so using the fluent API style.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.core.publisher.Flux.from(#{flowable:any(io.reactivex.Flowable<T>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-core-3", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flowable:any(io.reactivex.Flowable<T>)}.to(reactor.core.publisher.Flux::from)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-core-3", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.core.publisher.Flux::from)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-core-3", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.flowableToFlux(#{flowable:any(io.reactivex.Flowable<T>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-core-3", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("#{flowable:any(io.reactivex.Flowable<T>)}.to(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-core-3", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Flowable", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            Preconditions.or(
                                    new UsesMethod<>("io.reactivex.Flowable as(..)", true),
                                    new UsesMethod<>("io.reactivex.Flowable to(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Flux from(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                                            new UsesMethod<>("io.reactivex.Flowable to(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                                            new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter flowableToFlux(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.FluxToFlowable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxToFlowableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxToFlowableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.FluxToFlowable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use `RxJava2Adapter#fluxToFlowable` to convert a `Flux` to a `Flowable`, and do so using the fluent API style.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("io.reactivex.Flowable.fromPublisher(#{flux:any(reactor.core.publisher.Flux<T>)})")
                                .bindType("io.reactivex.Flowable<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToFlowable)")
                                    .bindType("io.reactivex.Flowable<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(io.reactivex.Flowable::fromPublisher)")
                                .bindType("io.reactivex.Flowable<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToFlowable)")
                                    .bindType("io.reactivex.Flowable<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.fluxToFlowable(#{flux:any(reactor.core.publisher.Flux<T>)})")
                                .bindType("io.reactivex.Flowable<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToFlowable)")
                                    .bindType("io.reactivex.Flowable<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Flowable", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            Preconditions.or(
                                    new UsesMethod<>("io.reactivex.Flowable fromPublisher(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Flux as(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                                            new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter fluxToFlowable(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.FluxToObservable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxToObservableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxToObservableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.FluxToObservable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use `RxJava2Adapter#fluxToObservable` to convert a `Flux` to a `Observable`, and do so using the fluent API style.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("io.reactivex.Observable.fromPublisher(#{flux:any(reactor.core.publisher.Flux<T>)})")
                                .bindType("io.reactivex.Observable<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToObservable)")
                                    .bindType("io.reactivex.Observable<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(io.reactivex.Observable::fromPublisher)")
                                .bindType("io.reactivex.Observable<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToObservable)")
                                    .bindType("io.reactivex.Observable<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.fluxToObservable(#{flux:any(reactor.core.publisher.Flux<T>)})")
                                .bindType("io.reactivex.Observable<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToObservable)")
                                    .bindType("io.reactivex.Observable<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Observable", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            Preconditions.or(
                                    new UsesMethod<>("io.reactivex.Observable fromPublisher(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Flux as(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                                            new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter fluxToObservable(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.MaybeToMono}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MaybeToMonoRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MaybeToMonoRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.MaybeToMono`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use the fluent API style when using `RxJava2Adapter#maybeToMono`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.maybeToMono(#{maybe:any(io.reactivex.Maybe<T>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{maybe:any(io.reactivex.Maybe<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::maybeToMono)")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{maybe:any(io.reactivex.Maybe<T>)}.to(reactor.adapter.rxjava.RxJava2Adapter::maybeToMono)")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{maybe:any(io.reactivex.Maybe<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::maybeToMono)")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Maybe", true),
                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("io.reactivex.Maybe to(..)", true),
                                    new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter maybeToMono(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.MonoToCompletable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoToCompletableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoToCompletableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.MonoToCompletable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use `RxJava2Adapter#monoToCompletable` to convert a `Mono` to a `Completable`, and do so using the fluent API style.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("io.reactivex.Completable.fromPublisher(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("io.reactivex.Completable")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToCompletable)")
                                    .bindType("io.reactivex.Completable")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(io.reactivex.Completable::fromPublisher)")
                                .bindType("io.reactivex.Completable")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToCompletable)")
                                    .bindType("io.reactivex.Completable")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.monoToCompletable(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("io.reactivex.Completable")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToCompletable)")
                                    .bindType("io.reactivex.Completable")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Completable", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("io.reactivex.Completable fromPublisher(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Mono as(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                                            new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter monoToCompletable(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.MonoToFlowable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoToFlowableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoToFlowableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.MonoToFlowable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use `RxJava2Adapter#monoToFlowable` to convert a `Mono` to a `Flowable`, and do so using the fluent API style.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("io.reactivex.Flowable.fromPublisher(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("io.reactivex.Flowable<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToFlowable)")
                                    .bindType("io.reactivex.Flowable<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(io.reactivex.Flowable::fromPublisher)")
                                .bindType("io.reactivex.Flowable<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToFlowable)")
                                    .bindType("io.reactivex.Flowable<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.monoToFlowable(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("io.reactivex.Flowable<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToFlowable)")
                                    .bindType("io.reactivex.Flowable<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Flowable", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("io.reactivex.Flowable fromPublisher(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Mono as(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                                            new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter monoToFlowable(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.MonoToMaybe}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoToMaybeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoToMaybeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.MonoToMaybe`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use the fluent API style when using `RxJava2Adapter#monoToMaybe`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.monoToMaybe(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("io.reactivex.Maybe<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3", "rxjava-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToMaybe)")
                                    .bindType("io.reactivex.Maybe<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Maybe", true),
                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter monoToMaybe(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.MonoToSingle}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoToSingleRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoToSingleRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.MonoToSingle`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use `RxJava2Adapter#monoToSingle` to convert a `Mono` to a `Single`, and do so using the fluent API style.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("io.reactivex.Single.fromPublisher(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("io.reactivex.Single<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToSingle)")
                                    .bindType("io.reactivex.Single<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(io.reactivex.Single::fromPublisher)")
                                .bindType("io.reactivex.Single<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToSingle)")
                                    .bindType("io.reactivex.Single<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.monoToSingle(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("io.reactivex.Single<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "rxjava-2", "reactor-adapter-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToSingle)")
                                    .bindType("io.reactivex.Single<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Single", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("io.reactivex.Single fromPublisher(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Mono as(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                                            new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter monoToSingle(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.ObservableToFlux}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ObservableToFluxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ObservableToFluxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.ObservableToFlux`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use the fluent API style when using `RxJava2Adapter#observableToFlux`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.observableToFlux(#{observable:any(io.reactivex.Observable<T>)}, #{strategy:any(io.reactivex.BackpressureStrategy)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{observable:any(io.reactivex.Observable<T>)}.toFlowable(#{strategy:any(io.reactivex.BackpressureStrategy)}).as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{observable:any(io.reactivex.Observable<T>)}.as((obs)->reactor.adapter.rxjava.RxJava2Adapter.observableToFlux(obs, #{strategy:any(io.reactivex.BackpressureStrategy)}))")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{observable:any(io.reactivex.Observable<T>)}.toFlowable(#{strategy:any(io.reactivex.BackpressureStrategy)}).as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{observable:any(io.reactivex.Observable<T>)}.to((obs)->reactor.adapter.rxjava.RxJava2Adapter.observableToFlux(obs, #{strategy:any(io.reactivex.BackpressureStrategy)}))")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{observable:any(io.reactivex.Observable<T>)}.toFlowable(#{strategy:any(io.reactivex.BackpressureStrategy)}).as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactive-streams-1", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Observable", true),
                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter observableToFlux(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RxJava2AdapterRules.SingleToMono}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SingleToMonoRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SingleToMonoRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RxJava2AdapterRules.SingleToMono`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use the fluent API style when using `RxJava2Adapter#singleToMono`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.adapter.rxjava.RxJava2Adapter.singleToMono(#{single:any(io.reactivex.Single<T>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{single:any(io.reactivex.Single<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::singleToMono)")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{single:any(io.reactivex.Single<T>)}.to(reactor.adapter.rxjava.RxJava2Adapter::singleToMono)")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{single:any(io.reactivex.Single<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::singleToMono)")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "rxjava-2", "reactor-adapter-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("io.reactivex.Single", true),
                            new UsesType<>("reactor.adapter.rxjava.RxJava2Adapter", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("io.reactivex.Single to(..)", true),
                                    new UsesMethod<>("reactor.adapter.rxjava.RxJava2Adapter singleToMono(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
