package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.RandomGeneratorRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class RandomGeneratorRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public RandomGeneratorRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`RandomGeneratorRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `RandomGenerator` instances.\n[Source](https://error-prone.picnic.tech/refasterrules/RandomGeneratorRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new RandomGeneratorNextDoubleRecipe(),
                new RandomGeneratorNextIntRecipe(),
                new RandomGeneratorNextLongRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RandomGeneratorRules.RandomGeneratorNextDouble}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class RandomGeneratorNextDoubleRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public RandomGeneratorNextDoubleRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RandomGeneratorRules.RandomGeneratorNextDouble`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `RandomGenerator#nextDouble(double)` over alternatives that yield a smaller domain of values and may result in `Double#isInfinite() inifinity`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextDouble() * #{bound:any(double)}").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextDouble(#{bound:any(double)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{bound:any(double)} * #{random:any(java.util.random.RandomGenerator)}.nextDouble()").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextDouble(#{bound:any(double)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.random.RandomGenerator", true),
                            new UsesMethod<>("java.util.random.RandomGenerator nextDouble(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RandomGeneratorRules.RandomGeneratorNextInt}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class RandomGeneratorNextIntRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public RandomGeneratorNextIntRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `RandomGeneratorRules.RandomGeneratorNextInt`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `RandomGenerator#nextInt(int)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("(int)#{random:any(java.util.random.RandomGenerator)}.nextDouble(#{bound:any(int)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextInt(#{bound:any(int)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("(int)Math.round(#{random:any(java.util.random.RandomGenerator)}.nextDouble(#{bound:any(int)}))").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextInt(#{bound:any(int)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitExpression(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.random.RandomGenerator", true),
                            new UsesMethod<>("java.util.random.RandomGenerator nextDouble(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code RandomGeneratorRules.RandomGeneratorNextLong}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class RandomGeneratorNextLongRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public RandomGeneratorNextLongRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `RandomGenerator#nextLong(long)` over more contrived alternatives";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Additionally, for large bounds, the unnecessary floating point arithmetic prevents some\n `long` values from being generated.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1905");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("(long)#{random:any(java.util.random.RandomGenerator)}.nextDouble((double)#{bound:any(long)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextLong(#{bound:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Math.round(#{random:any(java.util.random.RandomGenerator)}.nextDouble((double)#{bound:any(long)}))").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextLong(#{bound:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("(long)#{random:any(java.util.random.RandomGenerator)}.nextDouble(#{bound:any(long)})").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextLong(#{bound:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("Math.round(#{random:any(java.util.random.RandomGenerator)}.nextDouble(#{bound:any(long)}))").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextLong(#{bound:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitExpression(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("(long)#{random:any(java.util.random.RandomGenerator)}.nextDouble((double)#{bound:any(long)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextLong(#{bound:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Math.round(#{random:any(java.util.random.RandomGenerator)}.nextDouble((double)#{bound:any(long)}))").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextLong(#{bound:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("(long)#{random:any(java.util.random.RandomGenerator)}.nextDouble(#{bound:any(long)})").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextLong(#{bound:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("Math.round(#{random:any(java.util.random.RandomGenerator)}.nextDouble(#{bound:any(long)}))").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{random:any(java.util.random.RandomGenerator)}.nextLong(#{bound:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.random.RandomGenerator", true),
                            new UsesMethod<>("java.util.random.RandomGenerator nextDouble(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
