package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.PreconditionsRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class PreconditionsRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public PreconditionsRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`PreconditionsRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster templates related to statements dealing with `Preconditions`.\n[Source](https://error-prone.picnic.tech/refasterrules/PreconditionsRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new RequireNonNullRecipe(),
                new RequireNonNullWithMessageRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PreconditionsRules.RequireNonNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class RequireNonNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public RequireNonNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PreconditionsRules.RequireNonNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Objects#requireNonNull(Object)` over non-JDK alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.base.Preconditions.checkNotNull(#{object:any(T)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.base.Preconditions");
                        maybeRemoveImport("com.google.common.base.Preconditions.checkNotNull");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects.requireNonNull(#{object:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("com.google.common.base.Preconditions checkNotNull(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PreconditionsRules.RequireNonNullWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class RequireNonNullWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public RequireNonNullWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PreconditionsRules.RequireNonNullWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Objects#requireNonNull(Object, String)` over non-JDK alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.base.Preconditions.checkNotNull(#{object:any(T)}, #{message:any(java.lang.String)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.base.Preconditions");
                        maybeRemoveImport("com.google.common.base.Preconditions.checkNotNull");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects.requireNonNull(#{object:any(T)}, #{message:any(java.lang.String)})")
                                    .bindType("T")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("com.google.common.base.Preconditions checkNotNull(..)", true),
                    javaVisitor
            );
        }
    }

}
