package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.MicrometerRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class MicrometerRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public MicrometerRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`MicrometerRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with Micrometer.\n[Source](https://error-prone.picnic.tech/refasterrules/MicrometerRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new TagsOf1Recipe(),
                new TagsOf2Recipe(),
                new TagsOf3Recipe(),
                new TagsOf4Recipe(),
                new TagsOf5Recipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf1}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf1Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf1Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MicrometerRules.TagsOf1`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer using `Tags` over other immutable collections.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{tag:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{tag:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesType<>("io.micrometer.core.instrument.Tag", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf2}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf2Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf2Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MicrometerRules.TagsOf2`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer using `Tags` over other immutable collections.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesType<>("io.micrometer.core.instrument.Tag", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf3}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf3Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf3Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MicrometerRules.TagsOf3`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer using `Tags` over other immutable collections.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesType<>("io.micrometer.core.instrument.Tag", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf4}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf4Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf4Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MicrometerRules.TagsOf4`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer using `Tags` over other immutable collections.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesType<>("io.micrometer.core.instrument.Tag", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MicrometerRules.TagsOf5}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TagsOf5Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TagsOf5Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MicrometerRules.TagsOf5`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer using `Tags` over other immutable collections.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})")
                                .bindType("com.google.common.collect.ImmutableCollection<io.micrometer.core.instrument.Tag>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("io.micrometer.core.instrument.Tags.of(#{tag1:any(io.micrometer.core.instrument.Tag)}, #{tag2:any(io.micrometer.core.instrument.Tag)}, #{tag3:any(io.micrometer.core.instrument.Tag)}, #{tag4:any(io.micrometer.core.instrument.Tag)}, #{tag5:any(io.micrometer.core.instrument.Tag)})")
                                    .bindType("java.lang.Iterable<io.micrometer.core.instrument.Tag>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "micrometer-core-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesType<>("io.micrometer.core.instrument.Tag", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
