package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.MapRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class MapRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public MapRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`MapRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `Map` instances.\n[Source](https://error-prone.picnic.tech/refasterrules/MapRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new MapGetOrNullRecipe(),
                new MapGetOrDefaultRecipe(),
                new MapIsEmptyRecipe(),
                new MapSizeRecipe(),
                new MapContainsKeyRecipe(),
                new MapContainsValueRecipe(),
                new MapKeyStreamRecipe(),
                new MapValueStreamRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapRules.MapGetOrNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapGetOrNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapGetOrNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapRules.MapGetOrNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class MapGetOrNull<K, V, T> {\n    \n    @BeforeTemplate\n    @Nullable\n    V before(Map<K, V> map, T key) {\n        return map.getOrDefault(key, null);\n    }\n    \n    @AfterTemplate\n    @Nullable\n    V after(Map<K, V> map, T key) {\n        return map.get(key);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.getOrDefault(#{key:any(T)}, null)")
                                .bindType("V")
                                .genericTypes("K", "V", "T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.get(#{key:any(T)})")
                                    .bindType("V")
                                    .genericTypes("K", "V", "T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesMethod<>("java.util.Map getOrDefault(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapRules.MapGetOrDefault}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapGetOrDefaultRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapGetOrDefaultRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapRules.MapGetOrDefault`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Map#getOrDefault(Object, Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Objects.requireNonNullElse(#{map:any(java.util.Map<K, V>)}.get(#{key:any(T)}), #{defaultValue:any(V)})")
                                .bindType("V")
                                .genericTypes("K", "V", "T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Objects");
                        maybeRemoveImport("java.util.Objects.requireNonNullElse");
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.getOrDefault(#{key:any(T)}, #{defaultValue:any(V)})")
                                    .bindType("V")
                                    .genericTypes("K", "V", "T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesMethod<>("java.util.Map get(..)", true),
                            new UsesMethod<>("java.util.Objects requireNonNullElse(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapRules.MapIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapRules.MapIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Map#isEmpty()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.keySet().isEmpty()")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.isEmpty()")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.values().isEmpty()")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.isEmpty()")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.entrySet().isEmpty()")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.isEmpty()")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesMethod<>("java.util.Collection isEmpty(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Map entrySet(..)", true),
                                    new UsesMethod<>("java.util.Map keySet(..)", true),
                                    new UsesMethod<>("java.util.Map values(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapRules.MapSize}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapSizeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapSizeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapRules.MapSize`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Map#size()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.keySet().size()")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.size()")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.values().size()")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.size()")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.entrySet().size()")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.size()")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesMethod<>("java.util.Collection size(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Map entrySet(..)", true),
                                    new UsesMethod<>("java.util.Map keySet(..)", true),
                                    new UsesMethod<>("java.util.Map values(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapRules.MapContainsKey}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapContainsKeyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapContainsKeyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapRules.MapContainsKey`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Map#containsKey(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.keySet().contains(#{key:any(T)})")
                                .genericTypes("K", "V", "T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.containsKey(#{key:any(T)})")
                                    .genericTypes("K", "V", "T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesMethod<>("java.util.Map keySet(..)", true),
                            new UsesMethod<>("java.util.Set contains(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapRules.MapContainsValue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapContainsValueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapContainsValueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapRules.MapContainsValue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Map#containsValue(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.values().contains(#{value:any(T)})")
                                .genericTypes("K", "V", "T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.containsValue(#{value:any(T)})")
                                    .genericTypes("K", "V", "T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesMethod<>("java.util.Collection contains(..)", true),
                            new UsesMethod<>("java.util.Map values(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapRules.MapKeyStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapKeyStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapKeyStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapRules.MapKeyStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily use `Map#entrySet()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.entrySet().stream().map(java.util.Map.Entry::getKey)")
                                .bindType("java.util.stream.Stream<K>")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.keySet().stream()")
                                    .bindType("java.util.stream.Stream<K>")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.Map entrySet(..)", true),
                            new UsesMethod<>("java.util.stream.Stream map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapRules.MapValueStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapValueStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapValueStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapRules.MapValueStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily use `Map#entrySet()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.entrySet().stream().map(java.util.Map.Entry::getValue)")
                                .bindType("java.util.stream.Stream<V>")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{map:any(java.util.Map<K, V>)}.values().stream()")
                                    .bindType("java.util.stream.Stream<V>")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.Map entrySet(..)", true),
                            new UsesMethod<>("java.util.stream.Stream map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
