package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.MapEntryRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class MapEntryRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public MapEntryRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`MapEntryRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `Map.Entry` instances.\n[Source](https://error-prone.picnic.tech/refasterrules/MapEntryRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new MapEntryRecipe(),
                new MapEntryComparingByKeyRecipe(),
                new MapEntryComparingByKeyWithCustomComparatorRecipe(),
                new MapEntryComparingByValueRecipe(),
                new MapEntryComparingByValueWithCustomComparatorRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapEntryRules.MapEntry}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapEntryRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapEntryRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Map#entry(Object, Object)` over alternative ways to create an immutable map entry";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> while both `Maps#immutableEntry(Object, Object)` and `AbstractMap.SimpleImmutableEntry` allow `null` keys and values, the preferred @link\n Map#entry(Object, Object)} variant does not. Moreover, the `Map.Entry` instances produced\n by the former approaches is `java.io.Serializable`, while this does not hold for the\n object returned by the preferred approach.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.Maps.immutableEntry(#{key:any(K)}, #{value:any(V)})")
                                .bindType("java.util.Map.Entry<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Maps");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.entry(#{key:any(K)}, #{value:any(V)})")
                                    .bindType("java.util.Map.Entry<K, V>")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.util.AbstractMap.SimpleImmutableEntry<>(#{key:any(K)}, #{value:any(V)})")
                                .bindType("java.util.Map.Entry<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.entry(#{key:any(K)}, #{value:any(V)})")
                                    .bindType("java.util.Map.Entry<K, V>")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.Maps.immutableEntry(#{key:any(K)}, #{value:any(V)})")
                                .bindType("java.util.Map.Entry<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Maps");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.entry(#{key:any(K)}, #{value:any(V)})")
                                    .bindType("java.util.Map.Entry<K, V>")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.util.AbstractMap.SimpleImmutableEntry<>(#{key:any(K)}, #{value:any(V)})")
                                .bindType("java.util.Map.Entry<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.entry(#{key:any(K)}, #{value:any(V)})")
                                    .bindType("java.util.Map.Entry<K, V>")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            new UsesMethod<>("java.util.AbstractMap.SimpleImmutableEntry <init>(..)", true),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.Maps", true),
                                    new UsesMethod<>("com.google.common.collect.Maps immutableEntry(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapEntryRules.MapEntryComparingByKey}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapEntryComparingByKeyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapEntryComparingByKeyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapEntryRules.MapEntryComparingByKey`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Map.Entry#comparingByKey()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.Comparator.comparing(java.util.Map.Entry::getKey)")
                                .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparing");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.Entry.comparingByKey()")
                                    .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Map.Entry.comparingByKey(java.util.Comparator.naturalOrder())")
                                .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.Entry.comparingByKey()")
                                    .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Comparator comparing(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.Map.Entry comparingByKey(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapEntryRules.MapEntryComparingByKeyWithCustomComparator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapEntryComparingByKeyWithCustomComparatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapEntryComparingByKeyWithCustomComparatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapEntryRules.MapEntryComparingByKeyWithCustomComparator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Map.Entry#comparingByKey(Comparator)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Comparator.comparing(java.util.Map.Entry::getKey, #{cmp:any(java.util.Comparator<? super K>)})")
                                .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparing");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.Entry.comparingByKey(#{cmp:any(java.util.Comparator<? super K>)})")
                                    .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("java.util.Comparator comparing(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapEntryRules.MapEntryComparingByValue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapEntryComparingByValueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapEntryComparingByValueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapEntryRules.MapEntryComparingByValue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Map.Entry#comparingByValue()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.Comparator.comparing(java.util.Map.Entry::getValue)")
                                .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                .genericTypes("K", "V extends java.lang.Comparable<? super V>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparing");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.Entry.comparingByValue()")
                                    .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                    .genericTypes("K", "V extends java.lang.Comparable<? super V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Map.Entry.comparingByValue(java.util.Comparator.naturalOrder())")
                                .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                .genericTypes("K", "V extends java.lang.Comparable<? super V>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.Entry.comparingByValue()")
                                    .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                    .genericTypes("K", "V extends java.lang.Comparable<? super V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Comparator comparing(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.Map.Entry comparingByValue(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MapEntryRules.MapEntryComparingByValueWithCustomComparator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapEntryComparingByValueWithCustomComparatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapEntryComparingByValueWithCustomComparatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MapEntryRules.MapEntryComparingByValueWithCustomComparator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Map.Entry#comparingByValue(Comparator)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Comparator.comparing(java.util.Map.Entry::getValue, #{cmp:any(java.util.Comparator<? super V>)})")
                                .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                .genericTypes("K", "V").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparing");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Map.Entry.comparingByValue(#{cmp:any(java.util.Comparator<? super V>)})")
                                    .bindType("java.util.Comparator<java.util.Map.Entry<K, V>>")
                                    .genericTypes("K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("java.util.Comparator comparing(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
