package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.LongStreamRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class LongStreamRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public LongStreamRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`LongStreamRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `LongStream`s.\n[Source](https://error-prone.picnic.tech/refasterrules/LongStreamRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new LongStreamClosedOpenRangeRecipe(),
                new ConcatOneLongStreamRecipe(),
                new ConcatTwoLongStreamsRecipe(),
                new LongStreamFilterSortedRecipe(),
                new LongStreamIsEmptyRecipe(),
                new LongStreamIsNotEmptyRecipe(),
                new LongStreamMinRecipe(),
                new LongStreamNoneMatchRecipe(),
                new LongStreamAnyMatchRecipe(),
                new LongStreamAllMatchRecipe(),
                new LongStreamTakeWhileRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.LongStreamClosedOpenRange}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongStreamClosedOpenRangeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongStreamClosedOpenRangeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.LongStreamClosedOpenRange`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LongStream#range(long, long)` over the more contrived alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.stream.LongStream.rangeClosed(#{from:any(long)}, #{to:any(long)} - 1)")
                                .bindType("java.util.stream.LongStream").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.LongStream.range(#{from:any(long)}, #{to:any(long)})")
                                    .bindType("java.util.stream.LongStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.LongStream", true),
                            new UsesMethod<>("java.util.stream.LongStream rangeClosed(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.ConcatOneLongStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ConcatOneLongStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ConcatOneLongStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.ConcatOneLongStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily call `Streams#concat(LongStream...)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Streams.concat(#{stream:any(java.util.stream.LongStream)})")
                                .bindType("java.util.stream.LongStream")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}")
                                    .bindType("java.util.stream.LongStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Streams", true),
                            new UsesType<>("java.util.stream.LongStream", true),
                            new UsesMethod<>("com.google.common.collect.Streams concat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.ConcatTwoLongStreams}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ConcatTwoLongStreamsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ConcatTwoLongStreamsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.ConcatTwoLongStreams`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LongStream#concat(LongStream, LongStream)` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Streams.concat(#{s1:any(java.util.stream.LongStream)}, #{s2:any(java.util.stream.LongStream)})")
                                .bindType("java.util.stream.LongStream")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.LongStream.concat(#{s1:any(java.util.stream.LongStream)}, #{s2:any(java.util.stream.LongStream)})")
                                    .bindType("java.util.stream.LongStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Streams", true),
                            new UsesType<>("java.util.stream.LongStream", true),
                            new UsesMethod<>("com.google.common.collect.Streams concat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.LongStreamFilterSorted}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongStreamFilterSortedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongStreamFilterSortedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.LongStreamFilterSorted`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Apply `LongStream#filter(LongPredicate)` before `LongStream#sorted()` to reduce the number of elements to sort.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.sorted().filter(#{predicate:any(java.util.function.LongPredicate)})")
                                .bindType("java.util.stream.LongStream").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).sorted()")
                                    .bindType("java.util.stream.LongStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.LongPredicate", true),
                            new UsesType<>("java.util.stream.LongStream", true),
                            new UsesMethod<>("java.util.stream.LongStream filter(..)", true),
                            new UsesMethod<>("java.util.stream.LongStream sorted(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.LongStreamIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongStreamIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongStreamIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.LongStreamIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "In order to test whether a stream has any element, simply try to find one.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() == 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() <= 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() < 1").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findFirst().isEmpty()").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() == 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() <= 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() < 1").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findFirst().isEmpty()").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.LongStream", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.LongStream count(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.OptionalLong isEmpty(..)", true),
                                            new UsesMethod<>("java.util.stream.LongStream findFirst(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.LongStreamIsNotEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongStreamIsNotEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongStreamIsNotEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.LongStreamIsNotEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "In order to test whether a stream has any element, simply try to find one.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() != 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() > 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() >= 1").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findFirst().isPresent()").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() != 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() > 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.count() >= 1").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findFirst().isPresent()").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.LongStream", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.LongStream count(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.OptionalLong isPresent(..)", true),
                                            new UsesMethod<>("java.util.stream.LongStream findFirst(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.LongStreamMin}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongStreamMinRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongStreamMinRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.LongStreamMin`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamMin {\n    \n    @BeforeTemplate\n    OptionalLong before(LongStream stream) {\n        return stream.sorted().findFirst();\n    }\n    \n    @AfterTemplate\n    OptionalLong after(LongStream stream) {\n        return stream.min();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.sorted().findFirst()")
                                .bindType("java.util.OptionalLong").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.min()")
                                    .bindType("java.util.OptionalLong").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.OptionalLong", true),
                            new UsesType<>("java.util.stream.LongStream", true),
                            new UsesMethod<>("java.util.stream.LongStream findFirst(..)", true),
                            new UsesMethod<>("java.util.stream.LongStream sorted(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.LongStreamNoneMatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongStreamNoneMatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongStreamNoneMatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.LongStreamNoneMatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LongStream#noneMatch(LongPredicate)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.allMatch(#{predicate:any(java.util.function.LongPredicate)}.negate())").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).findAny().isEmpty()").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.allMatch(#{predicate:any(java.util.function.LongPredicate)}.negate())").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).findAny().isEmpty()").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.LongPredicate", true),
                            new UsesType<>("java.util.stream.LongStream", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.LongStream anyMatch(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.OptionalLong isEmpty(..)", true),
                                            new UsesMethod<>("java.util.stream.LongStream filter(..)", true),
                                            new UsesMethod<>("java.util.stream.LongStream findAny(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.function.LongPredicate negate(..)", true),
                                            new UsesMethod<>("java.util.stream.LongStream allMatch(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.LongStreamAnyMatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongStreamAnyMatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongStreamAnyMatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.LongStreamAnyMatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LongStream#anyMatch(LongPredicate)` over more contrived alternatives.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4034");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).findAny().isPresent()").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).findAny().isPresent()").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.LongPredicate", true),
                            new UsesType<>("java.util.stream.LongStream", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.LongStream noneMatch(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.OptionalLong isPresent(..)", true),
                                            new UsesMethod<>("java.util.stream.LongStream filter(..)", true),
                                            new UsesMethod<>("java.util.stream.LongStream findAny(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.LongStreamAllMatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongStreamAllMatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongStreamAllMatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.LongStreamAllMatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamAllMatch {\n    \n    @BeforeTemplate\n    boolean before(LongStream stream, LongPredicate predicate) {\n        return stream.noneMatch(predicate.negate());\n    }\n    \n    @AfterTemplate\n    boolean after(LongStream stream, LongPredicate predicate) {\n        return stream.allMatch(predicate);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)}.negate())").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.allMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.LongPredicate", true),
                            new UsesType<>("java.util.stream.LongStream", true),
                            new UsesMethod<>("java.util.function.LongPredicate negate(..)", true),
                            new UsesMethod<>("java.util.stream.LongStream noneMatch(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code LongStreamRules.LongStreamTakeWhile}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongStreamTakeWhileRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongStreamTakeWhileRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `LongStreamRules.LongStreamTakeWhile`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamTakeWhile {\n    \n    @BeforeTemplate\n    LongStream before(LongStream stream, LongPredicate predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    LongStream after(LongStream stream, LongPredicate predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.takeWhile(#{predicate:any(java.util.function.LongPredicate)}).filter(#{predicate})")
                                .bindType("java.util.stream.LongStream").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.LongStream)}.takeWhile(#{predicate:any(java.util.function.LongPredicate)})")
                                    .bindType("java.util.stream.LongStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.LongPredicate", true),
                            new UsesType<>("java.util.stream.LongStream", true),
                            new UsesMethod<>("java.util.stream.LongStream filter(..)", true),
                            new UsesMethod<>("java.util.stream.LongStream takeWhile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
