package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.JacksonRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class JacksonRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public JacksonRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`JacksonRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to Jackson expressions and statements.\n[Source](https://error-prone.picnic.tech/refasterrules/JacksonRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new JsonNodeOptionalIntRecipe(),
                new JsonNodeOptionalStringRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JacksonRules.JsonNodeOptionalInt}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class JsonNodeOptionalIntRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public JsonNodeOptionalIntRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JacksonRules.JsonNodeOptionalInt`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `JsonNode#optional(int)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{index:any(int)}).asOptional()")
                                .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{index:any(int)})")
                                    .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.path(#{index:any(int)}).asOptional()")
                                .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{index:any(int)})")
                                    .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Optional.of(#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{index:any(int)}))")
                                .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{index:any(int)})")
                                    .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.util.Optional.ofNullable(#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{index:any(int)}))")
                                .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{index:any(int)})")
                                    .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.fasterxml.jackson.databind.JsonNode", true),
                            new UsesType<>("java.util.Optional", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode asOptional(..)", true),
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode get(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode asOptional(..)", true),
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode path(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode get(..)", true),
                                            new UsesMethod<>("java.util.Optional of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode get(..)", true),
                                            new UsesMethod<>("java.util.Optional ofNullable(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JacksonRules.JsonNodeOptionalString}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class JsonNodeOptionalStringRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public JsonNodeOptionalStringRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JacksonRules.JsonNodeOptionalString`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `JsonNode#optional(String)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{fieldName:any(java.lang.String)}).asOptional()")
                                .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{fieldName:any(java.lang.String)})")
                                    .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.path(#{fieldName:any(java.lang.String)}).asOptional()")
                                .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{fieldName:any(java.lang.String)})")
                                    .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Optional.of(#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{fieldName:any(java.lang.String)}))")
                                .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{fieldName:any(java.lang.String)})")
                                    .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.util.Optional.ofNullable(#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{fieldName:any(java.lang.String)}))")
                                .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{fieldName:any(java.lang.String)})")
                                    .bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jackson-databind-2", "jackson-core-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.fasterxml.jackson.databind.JsonNode", true),
                            new UsesType<>("java.util.Optional", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode asOptional(..)", true),
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode get(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode asOptional(..)", true),
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode path(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode get(..)", true),
                                            new UsesMethod<>("java.util.Optional of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.fasterxml.jackson.databind.JsonNode get(..)", true),
                                            new UsesMethod<>("java.util.Optional ofNullable(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
