package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.JUnitToAssertJRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class JUnitToAssertJRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public JUnitToAssertJRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "Refaster rules to replace JUnit assertions with AssertJ equivalents";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Note that, while both libraries throw an `AssertionError` in case of an assertion\n failure, the exact subtype used generally differs.\n[Source](https://error-prone.picnic.tech/refasterrules/JUnitToAssertJRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatBooleanArrayContainsExactlyRecipe(),
                new AssertThatBooleanArrayWithFailMessageContainsExactlyRecipe(),
                new AssertThatBooleanArrayWithFailMessageSupplierContainsExactlyRecipe(),
                new AssertThatByteArrayContainsExactlyRecipe(),
                new AssertThatByteArrayWithFailMessageContainsExactlyRecipe(),
                new AssertThatByteArrayWithFailMessageSupplierContainsExactlyRecipe(),
                new AssertThatCharArrayContainsExactlyRecipe(),
                new AssertThatCharArrayWithFailMessageContainsExactlyRecipe(),
                new AssertThatCharArrayWithFailMessageSupplierContainsExactlyRecipe(),
                new AssertThatShortArrayContainsExactlyRecipe(),
                new AssertThatShortArrayWithFailMessageContainsExactlyRecipe(),
                new AssertThatShortArrayWithFailMessageSupplierContainsExactlyRecipe(),
                new AssertThatIntArrayContainsExactlyRecipe(),
                new AssertThatIntArrayWithFailMessageContainsExactlyRecipe(),
                new AssertThatIntArrayWithFailMessageSupplierContainsExactlyRecipe(),
                new AssertThatLongArrayContainsExactlyRecipe(),
                new AssertThatLongArrayWithFailMessageContainsExactlyRecipe(),
                new AssertThatLongArrayWithFailMessageSupplierContainsExactlyRecipe(),
                new AssertThatFloatArrayContainsExactlyRecipe(),
                new AssertThatFloatArrayWithFailMessageContainsExactlyRecipe(),
                new AssertThatFloatArrayWithFailMessageSupplierContainsExactlyRecipe(),
                new AssertThatFloatArrayContainsExactlyWithOffsetRecipe(),
                new AssertThatFloatArrayWithFailMessageContainsExactlyWithOffsetRecipe(),
                new AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe(),
                new AssertThatDoubleArrayContainsExactlyRecipe(),
                new AssertThatDoubleArrayWithFailMessageContainsExactlyRecipe(),
                new AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyRecipe(),
                new AssertThatDoubleArrayContainsExactlyWithOffsetRecipe(),
                new AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffsetRecipe(),
                new AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe(),
                new AssertThatObjectArrayContainsExactlyRecipe(),
                new AssertThatObjectArrayWithFailMessageContainsExactlyRecipe(),
                new AssertThatObjectArrayWithFailMessageSupplierContainsExactlyRecipe(),
                new FailRecipe(),
                new FailWithMessageRecipe(),
                new FailWithMessageAndThrowableRecipe(),
                new FailWithThrowableRecipe(),
                new AssertThatIsTrueRecipe(),
                new AssertThatWithFailMessageStringIsTrueRecipe(),
                new AssertThatWithFailMessageSupplierIsTrueRecipe(),
                new AssertThatIsFalseRecipe(),
                new AssertThatWithFailMessageStringIsFalseRecipe(),
                new AssertThatWithFailMessageSupplierIsFalseRecipe(),
                new AssertThatIsNullRecipe(),
                new AssertThatWithFailMessageStringIsNullRecipe(),
                new AssertThatWithFailMessageSupplierIsNullRecipe(),
                new AssertThatIsNotNullRecipe(),
                new AssertThatWithFailMessageStringIsNotNullRecipe(),
                new AssertThatWithFailMessageSupplierIsNotNullRecipe(),
                new AssertThatIsSameAsRecipe(),
                new AssertThatWithFailMessageStringIsSameAsRecipe(),
                new AssertThatWithFailMessageSupplierIsSameAsRecipe(),
                new AssertThatIsNotSameAsRecipe(),
                new AssertThatWithFailMessageStringIsNotSameAsRecipe(),
                new AssertThatWithFailMessageSupplierIsNotSameAsRecipe(),
                new AssertThatThrownByIsExactlyInstanceOfRecipe(),
                new AssertThatThrownByWithFailMessageStringIsExactlyInstanceOfRecipe(),
                new AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOfRecipe(),
                new AssertThatThrownByIsInstanceOfRecipe(),
                new AssertThatThrownByWithFailMessageStringIsInstanceOfRecipe(),
                new AssertThatThrownByWithFailMessageSupplierIsInstanceOfRecipe(),
                new AssertThatCodeDoesNotThrowAnyExceptionRecipe(),
                new AssertThatCodeWithFailMessageStringDoesNotThrowAnyExceptionRecipe(),
                new AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyExceptionRecipe(),
                new AssertThatIsInstanceOfRecipe(),
                new AssertThatWithFailMessageStringIsInstanceOfRecipe(),
                new AssertThatWithFailMessageSupplierIsInstanceOfRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatBooleanArrayContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatBooleanArrayContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatBooleanArrayContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatBooleanArrayContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, boolean[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean[] actual, boolean[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(boolean[])}, #{actual:any(boolean[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean[])}).containsExactly(#{expected:any(boolean[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatBooleanArrayWithFailMessageContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatBooleanArrayWithFailMessageContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatBooleanArrayWithFailMessageContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatBooleanArrayWithFailMessageContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, String message, boolean[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean[] actual, String message, boolean[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(boolean[])}, #{actual:any(boolean[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(boolean[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatBooleanArrayWithFailMessageSupplierContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatBooleanArrayWithFailMessageSupplierContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatBooleanArrayWithFailMessageSupplierContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatBooleanArrayWithFailMessageSupplierContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(boolean[] actual, Supplier<@Nullable String> message, boolean[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean[] actual, Supplier<@Nullable String> message, boolean[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(boolean[])}, #{actual:any(boolean[])}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(boolean[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatByteArrayContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatByteArrayContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatByteArrayContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatByteArrayContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatByteArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(byte[] actual, byte[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(byte[] actual, byte[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(byte[])}, #{actual:any(byte[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(byte[])}).containsExactly(#{expected:any(byte[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatByteArrayWithFailMessageContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatByteArrayWithFailMessageContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatByteArrayWithFailMessageContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatByteArrayWithFailMessageContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatByteArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(byte[] actual, String message, byte[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(byte[] actual, String message, byte[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(byte[])}, #{actual:any(byte[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(byte[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(byte[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatByteArrayWithFailMessageSupplierContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatByteArrayWithFailMessageSupplierContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatByteArrayWithFailMessageSupplierContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatByteArrayWithFailMessageSupplierContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatByteArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(byte[] actual, Supplier<@Nullable String> message, byte[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(byte[] actual, Supplier<@Nullable String> message, byte[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(byte[])}, #{actual:any(byte[])}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(byte[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(byte[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatCharArrayContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatCharArrayContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatCharArrayContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatCharArrayContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCharArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(char[] actual, char[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(char[] actual, char[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(char[])}, #{actual:any(char[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(char[])}).containsExactly(#{expected:any(char[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatCharArrayWithFailMessageContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatCharArrayWithFailMessageContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatCharArrayWithFailMessageContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatCharArrayWithFailMessageContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCharArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(char[] actual, String message, char[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(char[] actual, String message, char[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(char[])}, #{actual:any(char[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(char[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(char[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatCharArrayWithFailMessageSupplierContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatCharArrayWithFailMessageSupplierContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatCharArrayWithFailMessageSupplierContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatCharArrayWithFailMessageSupplierContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCharArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(char[] actual, Supplier<@Nullable String> message, char[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(char[] actual, Supplier<@Nullable String> message, char[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(char[])}, #{actual:any(char[])}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(char[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(char[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatShortArrayContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatShortArrayContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatShortArrayContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatShortArrayContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatShortArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(short[] actual, short[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(short[] actual, short[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(short[])}, #{actual:any(short[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(short[])}).containsExactly(#{expected:any(short[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatShortArrayWithFailMessageContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatShortArrayWithFailMessageContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatShortArrayWithFailMessageContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatShortArrayWithFailMessageContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatShortArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(short[] actual, String message, short[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(short[] actual, String message, short[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(short[])}, #{actual:any(short[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(short[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(short[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatShortArrayWithFailMessageSupplierContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatShortArrayWithFailMessageSupplierContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatShortArrayWithFailMessageSupplierContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatShortArrayWithFailMessageSupplierContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatShortArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(short[] actual, Supplier<@Nullable String> message, short[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(short[] actual, Supplier<@Nullable String> message, short[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(short[])}, #{actual:any(short[])}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(short[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(short[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIntArrayContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIntArrayContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIntArrayContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIntArrayContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIntArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(int[] actual, int[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(int[] actual, int[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(int[])}, #{actual:any(int[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(int[])}).containsExactly(#{expected:any(int[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIntArrayWithFailMessageContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIntArrayWithFailMessageContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIntArrayWithFailMessageContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIntArrayWithFailMessageContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIntArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(int[] actual, String message, int[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(int[] actual, String message, int[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(int[])}, #{actual:any(int[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(int[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(int[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIntArrayWithFailMessageSupplierContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIntArrayWithFailMessageSupplierContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIntArrayWithFailMessageSupplierContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIntArrayWithFailMessageSupplierContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIntArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(int[] actual, Supplier<@Nullable String> message, int[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(int[] actual, Supplier<@Nullable String> message, int[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(int[])}, #{actual:any(int[])}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(int[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(int[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatLongArrayContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatLongArrayContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatLongArrayContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatLongArrayContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatLongArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(long[] actual, long[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(long[] actual, long[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(long[])}, #{actual:any(long[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(long[])}).containsExactly(#{expected:any(long[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatLongArrayWithFailMessageContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatLongArrayWithFailMessageContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatLongArrayWithFailMessageContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatLongArrayWithFailMessageContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatLongArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(long[] actual, String message, long[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(long[] actual, String message, long[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(long[])}, #{actual:any(long[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(long[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(long[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatLongArrayWithFailMessageSupplierContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatLongArrayWithFailMessageSupplierContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatLongArrayWithFailMessageSupplierContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatLongArrayWithFailMessageSupplierContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatLongArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(long[] actual, Supplier<@Nullable String> message, long[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(long[] actual, Supplier<@Nullable String> message, long[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(long[])}, #{actual:any(long[])}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(long[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(long[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatFloatArrayContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatFloatArrayContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatFloatArrayContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(float[] actual, float[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, float[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(float[])}, #{actual:any(float[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).containsExactly(#{expected:any(float[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatFloatArrayWithFailMessageContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatFloatArrayWithFailMessageContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(float[] actual, String message, float[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, String message, float[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(float[])}, #{actual:any(float[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(float[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageSupplierContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatFloatArrayWithFailMessageSupplierContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatFloatArrayWithFailMessageSupplierContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageSupplierContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(float[] actual, Supplier<@Nullable String> message, float[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, Supplier<@Nullable String> message, float[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(float[])}, #{actual:any(float[])}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(float[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatFloatArrayContainsExactlyWithOffset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatFloatArrayContainsExactlyWithOffsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatFloatArrayContainsExactlyWithOffsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayContainsExactlyWithOffset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(float[] actual, float[] expected, float delta) {\n        assertArrayEquals(expected, actual, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, float[] expected, float delta) {\n        assertThat(actual).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(float[])}, #{actual:any(float[])}, #{delta:any(float)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).containsExactly(#{expected:any(float[])}, org.assertj.core.api.Assertions.offset(#{delta:any(float)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageContainsExactlyWithOffset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatFloatArrayWithFailMessageContainsExactlyWithOffsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatFloatArrayWithFailMessageContainsExactlyWithOffsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageContainsExactlyWithOffset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayWithFailMessageContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(float[] actual, String message, float[] expected, float delta) {\n        assertArrayEquals(expected, actual, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, String message, float[] expected, float delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(float[])}, #{actual:any(float[])}, #{delta:any(float)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(float[])}, org.assertj.core.api.Assertions.offset(#{delta:any(float)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(3), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(float[] actual, Supplier<@Nullable String> message, float[] expected, float delta) {\n        assertArrayEquals(expected, actual, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, Supplier<@Nullable String> message, float[] expected, float delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(float[])}, #{actual:any(float[])}, #{delta:any(float)}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(float[])}, org.assertj.core.api.Assertions.offset(#{delta:any(float)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(3), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatDoubleArrayContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatDoubleArrayContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatDoubleArrayContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(double[] actual, double[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, double[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(double[])}, #{actual:any(double[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).containsExactly(#{expected:any(double[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatDoubleArrayWithFailMessageContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatDoubleArrayWithFailMessageContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(double[] actual, String message, double[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, String message, double[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(double[])}, #{actual:any(double[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(double[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageSupplierContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageSupplierContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(double[] actual, Supplier<@Nullable String> message, double[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, Supplier<@Nullable String> message, double[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(double[])}, #{actual:any(double[])}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(double[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatDoubleArrayContainsExactlyWithOffset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatDoubleArrayContainsExactlyWithOffsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatDoubleArrayContainsExactlyWithOffsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayContainsExactlyWithOffset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(double[] actual, double[] expected, double delta) {\n        assertArrayEquals(expected, actual, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, double[] expected, double delta) {\n        assertThat(actual).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(double[])}, #{actual:any(double[])}, #{delta:any(double)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).containsExactly(#{expected:any(double[])}, org.assertj.core.api.Assertions.offset(#{delta:any(double)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    void before(double[] actual, String message, double[] expected, double delta) {\n        assertArrayEquals(expected, actual, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, String message, double[] expected, double delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(double[])}, #{actual:any(double[])}, #{delta:any(double)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(double[])}, org.assertj.core.api.Assertions.offset(#{delta:any(double)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(3), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffset {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(double[] actual, Supplier<@Nullable String> messageSupplier, double[] expected, double delta) {\n        assertArrayEquals(expected, actual, delta, messageSupplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, Supplier<@Nullable String> messageSupplier, double[] expected, double delta) {\n        assertThat(actual).withFailMessage(messageSupplier).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(double[])}, #{actual:any(double[])}, #{delta:any(double)}, #{messageSupplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).withFailMessage(#{messageSupplier:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(double[])}, org.assertj.core.api.Assertions.offset(#{delta:any(double)}));")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(3), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatObjectArrayContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatObjectArrayContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatObjectArrayContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatObjectArrayContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatObjectArrayContainsExactly {\n    \n    @BeforeTemplate\n    void before(Object[] actual, Object[] expected) {\n        assertArrayEquals(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Object[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(java.lang.Object[])}, #{actual:any(java.lang.Object[])});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatObjectArrayWithFailMessageContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatObjectArrayWithFailMessageContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatObjectArrayWithFailMessageContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatObjectArrayWithFailMessageContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatObjectArrayWithFailMessageContainsExactly {\n    \n    @BeforeTemplate\n    void before(Object[] actual, String message, Object[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, String message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(java.lang.Object[])}, #{actual:any(java.lang.Object[])}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatObjectArrayWithFailMessageSupplierContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatObjectArrayWithFailMessageSupplierContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatObjectArrayWithFailMessageSupplierContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatObjectArrayWithFailMessageSupplierContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatObjectArrayWithFailMessageSupplierContainsExactly {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(Object[] actual, Supplier<@Nullable String> message, Object[] expected) {\n        assertArrayEquals(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Supplier<@Nullable String> message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertArrayEquals(#{expected:any(java.lang.Object[])}, #{actual:any(java.lang.Object[])}, #{message:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertArrayEquals");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.util.function.Supplier<java.lang.String>)}).containsExactly(#{expected:any(java.lang.Object[])});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.Fail}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FailRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FailRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.Fail`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class Fail<T> {\n    \n    @BeforeTemplate\n    T before() {\n        return Assertions.fail();\n    }\n    \n    @AfterTemplate\n    @DoNotCall\n    T after() {\n        return fail();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.fail()")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.fail()")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.junit.jupiter.api.Assertions", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions fail(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.FailWithMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FailWithMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FailWithMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.FailWithMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithMessage<T> {\n    \n    @BeforeTemplate\n    T before(String message) {\n        return Assertions.fail(message);\n    }\n    \n    @AfterTemplate\n    T after(String message) {\n        return fail(message);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.fail(#{message:any(java.lang.String)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.fail(#{message:any(java.lang.String)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.junit.jupiter.api.Assertions", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions fail(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.FailWithMessageAndThrowable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FailWithMessageAndThrowableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FailWithMessageAndThrowableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.FailWithMessageAndThrowable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithMessageAndThrowable<T> {\n    \n    @BeforeTemplate\n    T before(String message, Throwable throwable) {\n        return Assertions.fail(message, throwable);\n    }\n    \n    @AfterTemplate\n    T after(String message, Throwable throwable) {\n        return fail(message, throwable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.fail(#{message:any(java.lang.String)}, #{throwable:any(java.lang.Throwable)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.fail(#{message:any(java.lang.String)}, #{throwable:any(java.lang.Throwable)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.junit.jupiter.api.Assertions", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions fail(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.FailWithThrowable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FailWithThrowableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FailWithThrowableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.FailWithThrowable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithThrowable<T> {\n    \n    @BeforeTemplate\n    T before(Throwable throwable) {\n        return Assertions.fail(throwable);\n    }\n    \n    @AfterTemplate\n    @DoNotCall\n    T after(Throwable throwable) {\n        return fail(throwable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.fail(#{throwable:any(java.lang.Throwable)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.fail(#{throwable:any(java.lang.Throwable)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.junit.jupiter.api.Assertions", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions fail(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIsTrue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsTrueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsTrueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIsTrue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsTrue {\n    \n    @BeforeTemplate\n    void before(boolean actual) {\n        assertTrue(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual) {\n        assertThat(actual).isTrue();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertTrue(#{actual:any(boolean)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isTrue();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertTrue(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageStringIsTrue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageStringIsTrueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageStringIsTrueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsTrue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsTrue {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message) {\n        assertTrue(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, String message) {\n        assertThat(actual).withFailMessage(message).isTrue();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertTrue(#{actual:any(boolean)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isTrue();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertTrue(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsTrue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageSupplierIsTrueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageSupplierIsTrueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsTrue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsTrue {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(boolean actual, Supplier<@Nullable String> supplier) {\n        assertTrue(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, Supplier<@Nullable String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isTrue();\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertTrue(#{actual:any(boolean)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isTrue();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertTrue(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIsFalse}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsFalseRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsFalseRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIsFalse`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsFalse {\n    \n    @BeforeTemplate\n    void before(boolean actual) {\n        assertFalse(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual) {\n        assertThat(actual).isFalse();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertFalse(#{actual:any(boolean)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isFalse();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertFalse(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageStringIsFalse}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageStringIsFalseRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageStringIsFalseRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsFalse`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsFalse {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message) {\n        assertFalse(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, String message) {\n        assertThat(actual).withFailMessage(message).isFalse();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertFalse(#{actual:any(boolean)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isFalse();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertFalse(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsFalse}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageSupplierIsFalseRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageSupplierIsFalseRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsFalse`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsFalse {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(boolean actual, Supplier<@Nullable String> supplier) {\n        assertFalse(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, Supplier<@Nullable String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isFalse();\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertFalse(#{actual:any(boolean)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isFalse();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertFalse(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIsNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIsNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNull {\n    \n    @BeforeTemplate\n    void before(Object actual) {\n        assertNull(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual) {\n        assertThat(actual).isNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertNull(#{actual:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertNull(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageStringIsNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageStringIsNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageStringIsNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsNull {\n    \n    @BeforeTemplate\n    void before(Object actual, String message) {\n        assertNull(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message) {\n        assertThat(actual).withFailMessage(message).isNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertNull(#{actual:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertNull(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageSupplierIsNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageSupplierIsNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsNull {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(Object actual, Supplier<@Nullable String> supplier) {\n        assertNull(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<@Nullable String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isNull();\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertNull(#{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertNull(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIsNotNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsNotNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNotNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIsNotNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotNull {\n    \n    @BeforeTemplate\n    void before(Object actual) {\n        assertNotNull(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual) {\n        assertThat(actual).isNotNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertNotNull(#{actual:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertNotNull(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageStringIsNotNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageStringIsNotNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageStringIsNotNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsNotNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsNotNull {\n    \n    @BeforeTemplate\n    void before(Object actual, String message) {\n        assertNotNull(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message) {\n        assertThat(actual).withFailMessage(message).isNotNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertNotNull(#{actual:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertNotNull(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNotNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageSupplierIsNotNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageSupplierIsNotNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNotNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsNotNull {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(Object actual, Supplier<@Nullable String> supplier) {\n        assertNotNull(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<@Nullable String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isNotNull();\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertNotNull(#{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotNull");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isNotNull();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertNotNull(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIsSameAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsSameAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsSameAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIsSameAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertSame(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertSame(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageStringIsSameAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageStringIsSameAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageStringIsSameAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsSameAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertSame(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertSame(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsSameAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageSupplierIsSameAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageSupplierIsSameAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsSameAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsSameAs {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(Object actual, Supplier<@Nullable String> supplier, Object expected) {\n        assertSame(expected, actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<@Nullable String> supplier, Object expected) {\n        assertThat(actual).withFailMessage(supplier).isSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertSame(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIsNotSameAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsNotSameAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNotSameAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIsNotSameAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertNotSame(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertNotSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertNotSame(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageStringIsNotSameAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageStringIsNotSameAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageStringIsNotSameAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsNotSameAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsNotSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertNotSame(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertNotSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertNotSame(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNotSameAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageSupplierIsNotSameAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageSupplierIsNotSameAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNotSameAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsNotSameAs {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(Object actual, Supplier<@Nullable String> supplier, Object expected) {\n        assertNotSame(expected, actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<@Nullable String> supplier, Object expected) {\n        assertThat(actual).withFailMessage(supplier).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertNotSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotSame");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isNotSameAs(#{expected:any(java.lang.Object)});")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertNotSame(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatThrownByIsExactlyInstanceOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatThrownByIsExactlyInstanceOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatThrownByIsExactlyInstanceOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatThrownByIsExactlyInstanceOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIsExactlyInstanceOf<T extends Throwable> {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable, Class<T> clazz) {\n        assertThrowsExactly(clazz, throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, Class<T> clazz) {\n        assertThatThrownBy(throwingCallable).isExactlyInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertThrowsExactly(#{clazz:any(java.lang.Class<T>)}, #{throwingCallable:any(org.junit.jupiter.api.function.Executable)});")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertThrowsExactly");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isExactlyInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.junit.jupiter.api.function.Executable", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertThrowsExactly(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatThrownByWithFailMessageStringIsExactlyInstanceOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatThrownByWithFailMessageStringIsExactlyInstanceOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatThrownByWithFailMessageStringIsExactlyInstanceOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatThrownByWithFailMessageStringIsExactlyInstanceOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByWithFailMessageStringIsExactlyInstanceOf<T extends Throwable> {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable, String message, Class<T> clazz) {\n        assertThrowsExactly(clazz, throwingCallable, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, String message, Class<T> clazz) {\n        assertThatThrownBy(throwingCallable).withFailMessage(message).isExactlyInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertThrowsExactly(#{clazz:any(java.lang.Class<T>)}, #{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{message:any(java.lang.String)});")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertThrowsExactly");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{message:any(java.lang.String)}).isExactlyInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.junit.jupiter.api.function.Executable", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertThrowsExactly(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOf<T extends Throwable> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(Executable throwingCallable, Supplier<@Nullable String> supplier, Class<T> clazz) {\n        assertThrowsExactly(clazz, throwingCallable, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, Supplier<@Nullable String> supplier, Class<T> clazz) {\n        assertThatThrownBy(throwingCallable).withFailMessage(supplier).isExactlyInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertThrowsExactly(#{clazz:any(java.lang.Class<T>)}, #{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertThrowsExactly");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isExactlyInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesType<>("org.junit.jupiter.api.function.Executable", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertThrowsExactly(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatThrownByIsInstanceOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatThrownByIsInstanceOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatThrownByIsInstanceOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatThrownByIsInstanceOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIsInstanceOf<T extends Throwable> {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable, Class<T> clazz) {\n        assertThrows(clazz, throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, Class<T> clazz) {\n        assertThatThrownBy(throwingCallable).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertThrows(#{clazz:any(java.lang.Class<T>)}, #{throwingCallable:any(org.junit.jupiter.api.function.Executable)});")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertThrows");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.junit.jupiter.api.function.Executable", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertThrows(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatThrownByWithFailMessageStringIsInstanceOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatThrownByWithFailMessageStringIsInstanceOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatThrownByWithFailMessageStringIsInstanceOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatThrownByWithFailMessageStringIsInstanceOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByWithFailMessageStringIsInstanceOf<T extends Throwable> {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable, String message, Class<T> clazz) {\n        assertThrows(clazz, throwingCallable, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, String message, Class<T> clazz) {\n        assertThatThrownBy(throwingCallable).withFailMessage(message).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertThrows(#{clazz:any(java.lang.Class<T>)}, #{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{message:any(java.lang.String)});")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertThrows");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{message:any(java.lang.String)}).isInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.junit.jupiter.api.function.Executable", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertThrows(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatThrownByWithFailMessageSupplierIsInstanceOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatThrownByWithFailMessageSupplierIsInstanceOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatThrownByWithFailMessageSupplierIsInstanceOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatThrownByWithFailMessageSupplierIsInstanceOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByWithFailMessageSupplierIsInstanceOf<T extends Throwable> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(Executable throwingCallable, Supplier<@Nullable String> supplier, Class<T> clazz) {\n        assertThrows(clazz, throwingCallable, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, Supplier<@Nullable String> supplier, Class<T> clazz) {\n        assertThatThrownBy(throwingCallable).withFailMessage(supplier).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertThrows(#{clazz:any(java.lang.Class<T>)}, #{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertThrows");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatThrownBy(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesType<>("org.junit.jupiter.api.function.Executable", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertThrows(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatCodeDoesNotThrowAnyException}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatCodeDoesNotThrowAnyExceptionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatCodeDoesNotThrowAnyExceptionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatCodeDoesNotThrowAnyException`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCodeDoesNotThrowAnyException {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable) {\n        assertDoesNotThrow(throwingCallable);\n    }\n    \n    @BeforeTemplate\n    void before(ThrowingSupplier<?> throwingCallable) {\n        assertDoesNotThrow(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable) {\n        assertThatCode(throwingCallable).doesNotThrowAnyException();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.Executable)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).doesNotThrowAnyException();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.ThrowingSupplier<?>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.ThrowingSupplier");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).doesNotThrowAnyException();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertDoesNotThrow(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.junit.jupiter.api.function.Executable", true),
                                    new UsesType<>("org.junit.jupiter.api.function.ThrowingSupplier", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatCodeWithFailMessageStringDoesNotThrowAnyException}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatCodeWithFailMessageStringDoesNotThrowAnyExceptionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatCodeWithFailMessageStringDoesNotThrowAnyExceptionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatCodeWithFailMessageStringDoesNotThrowAnyException`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCodeWithFailMessageStringDoesNotThrowAnyException {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable, String message) {\n        assertDoesNotThrow(throwingCallable, message);\n    }\n    \n    @BeforeTemplate\n    void before(ThrowingSupplier<?> throwingCallable, String message) {\n        assertDoesNotThrow(throwingCallable, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, String message) {\n        assertThatCode(throwingCallable).withFailMessage(message).doesNotThrowAnyException();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{message:any(java.lang.String)}).doesNotThrowAnyException();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.ThrowingSupplier<?>)}, #{message:any(java.lang.String)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.ThrowingSupplier");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{message:any(java.lang.String)}).doesNotThrowAnyException();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertDoesNotThrow(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.junit.jupiter.api.function.Executable", true),
                                    new UsesType<>("org.junit.jupiter.api.function.ThrowingSupplier", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyExceptionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyExceptionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(Executable throwingCallable, Supplier<@Nullable String> supplier) {\n        assertDoesNotThrow(throwingCallable, supplier);\n    }\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(ThrowingSupplier<?> throwingCallable, Supplier<@Nullable String> supplier) {\n        assertDoesNotThrow(throwingCallable, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, Supplier<@Nullable String> supplier) {\n        assertThatCode(throwingCallable).withFailMessage(supplier).doesNotThrowAnyException();\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).doesNotThrowAnyException();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.ThrowingSupplier<?>)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.function.ThrowingSupplier");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).doesNotThrowAnyException();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertDoesNotThrow(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.junit.jupiter.api.function.Executable", true),
                                    new UsesType<>("org.junit.jupiter.api.function.ThrowingSupplier", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatIsInstanceOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsInstanceOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsInstanceOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatIsInstanceOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsInstanceOf<T> {\n    \n    @BeforeTemplate\n    void before(Object actual, Class<T> clazz) {\n        assertInstanceOf(clazz, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Class<T> clazz) {\n        assertThat(actual).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertInstanceOf(#{clazz:any(java.lang.Class<T>)}, #{actual:any(java.lang.Object)});")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertInstanceOf");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertInstanceOf(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageStringIsInstanceOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageStringIsInstanceOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageStringIsInstanceOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsInstanceOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsInstanceOf<T> {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Class<T> clazz) {\n        assertInstanceOf(clazz, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Class<T> clazz) {\n        assertThat(actual).withFailMessage(message).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertInstanceOf(#{clazz:any(java.lang.Class<T>)}, #{actual:any(java.lang.Object)}, #{message:any(java.lang.String)});")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertInstanceOf");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("org.junit.jupiter.api.Assertions assertInstanceOf(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsInstanceOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatWithFailMessageSupplierIsInstanceOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatWithFailMessageSupplierIsInstanceOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsInstanceOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsInstanceOf<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4449\")\n    void before(Object actual, Supplier<@Nullable String> supplier, Class<T> clazz) {\n        assertInstanceOf(clazz, actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<@Nullable String> supplier, Class<T> clazz) {\n        assertThat(actual).withFailMessage(supplier).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4449");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.junit.jupiter.api.Assertions.assertInstanceOf(#{clazz:any(java.lang.Class<T>)}, #{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "junit-jupiter-api-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        maybeRemoveImport("org.junit.jupiter.api.Assertions.assertInstanceOf");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isInstanceOf(#{clazz:any(java.lang.Class<T>)});")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("org.junit.jupiter.api.Assertions assertInstanceOf(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
