package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.IntStreamRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class IntStreamRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public IntStreamRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`IntStreamRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `IntStream`s.\n[Source](https://error-prone.picnic.tech/refasterrules/IntStreamRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new IntStreamClosedOpenRangeRecipe(),
                new ConcatOneIntStreamRecipe(),
                new ConcatTwoIntStreamsRecipe(),
                new IntStreamFilterSortedRecipe(),
                new IntStreamIsEmptyRecipe(),
                new IntStreamIsNotEmptyRecipe(),
                new IntStreamMinRecipe(),
                new IntStreamNoneMatchRecipe(),
                new IntStreamAnyMatchRecipe(),
                new IntStreamAllMatchRecipe(),
                new IntStreamTakeWhileRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.IntStreamClosedOpenRange}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntStreamClosedOpenRangeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntStreamClosedOpenRangeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.IntStreamClosedOpenRange`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `IntStream#range(int, int)` over the more contrived alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.stream.IntStream.rangeClosed(#{from:any(int)}, #{to:any(int)} - 1)")
                                .bindType("java.util.stream.IntStream").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.IntStream.range(#{from:any(int)}, #{to:any(int)})")
                                    .bindType("java.util.stream.IntStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.IntStream", true),
                            new UsesMethod<>("java.util.stream.IntStream rangeClosed(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.ConcatOneIntStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ConcatOneIntStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ConcatOneIntStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.ConcatOneIntStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily call `Streams#concat(IntStream...)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Streams.concat(#{stream:any(java.util.stream.IntStream)})")
                                .bindType("java.util.stream.IntStream")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}")
                                    .bindType("java.util.stream.IntStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Streams", true),
                            new UsesType<>("java.util.stream.IntStream", true),
                            new UsesMethod<>("com.google.common.collect.Streams concat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.ConcatTwoIntStreams}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ConcatTwoIntStreamsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ConcatTwoIntStreamsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.ConcatTwoIntStreams`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `IntStream#concat(IntStream, IntStream)` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Streams.concat(#{s1:any(java.util.stream.IntStream)}, #{s2:any(java.util.stream.IntStream)})")
                                .bindType("java.util.stream.IntStream")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.IntStream.concat(#{s1:any(java.util.stream.IntStream)}, #{s2:any(java.util.stream.IntStream)})")
                                    .bindType("java.util.stream.IntStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Streams", true),
                            new UsesType<>("java.util.stream.IntStream", true),
                            new UsesMethod<>("com.google.common.collect.Streams concat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.IntStreamFilterSorted}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntStreamFilterSortedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntStreamFilterSortedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.IntStreamFilterSorted`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Apply `IntStream#filter(IntPredicate)` before `IntStream#sorted()` to reduce the number of elements to sort.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.sorted().filter(#{predicate:any(java.util.function.IntPredicate)})")
                                .bindType("java.util.stream.IntStream").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.filter(#{predicate:any(java.util.function.IntPredicate)}).sorted()")
                                    .bindType("java.util.stream.IntStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.IntPredicate", true),
                            new UsesType<>("java.util.stream.IntStream", true),
                            new UsesMethod<>("java.util.stream.IntStream filter(..)", true),
                            new UsesMethod<>("java.util.stream.IntStream sorted(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.IntStreamIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntStreamIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntStreamIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.IntStreamIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "In order to test whether a stream has any element, simply try to find one.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() == 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() <= 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() < 1").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findFirst().isEmpty()").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() == 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() <= 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() < 1").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findFirst().isEmpty()").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isEmpty()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.IntStream", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.IntStream count(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.OptionalInt isEmpty(..)", true),
                                            new UsesMethod<>("java.util.stream.IntStream findFirst(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.IntStreamIsNotEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntStreamIsNotEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntStreamIsNotEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.IntStreamIsNotEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "In order to test whether a stream has any element, simply try to find one.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() != 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() > 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() >= 1").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findFirst().isPresent()").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() != 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() > 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.count() >= 1").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findFirst().isPresent()").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.findAny().isPresent()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.IntStream", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.IntStream count(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.OptionalInt isPresent(..)", true),
                                            new UsesMethod<>("java.util.stream.IntStream findFirst(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.IntStreamMin}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntStreamMinRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntStreamMinRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.IntStreamMin`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamMin {\n    \n    @BeforeTemplate\n    OptionalInt before(IntStream stream) {\n        return stream.sorted().findFirst();\n    }\n    \n    @AfterTemplate\n    OptionalInt after(IntStream stream) {\n        return stream.min();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.sorted().findFirst()")
                                .bindType("java.util.OptionalInt").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.min()")
                                    .bindType("java.util.OptionalInt").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.OptionalInt", true),
                            new UsesType<>("java.util.stream.IntStream", true),
                            new UsesMethod<>("java.util.stream.IntStream findFirst(..)", true),
                            new UsesMethod<>("java.util.stream.IntStream sorted(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.IntStreamNoneMatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntStreamNoneMatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntStreamNoneMatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.IntStreamNoneMatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `IntStream#noneMatch(IntPredicate)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!#{stream:any(java.util.stream.IntStream)}.anyMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.allMatch(#{predicate:any(java.util.function.IntPredicate)}.negate())").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.filter(#{predicate:any(java.util.function.IntPredicate)}).findAny().isEmpty()").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!#{stream:any(java.util.stream.IntStream)}.anyMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.allMatch(#{predicate:any(java.util.function.IntPredicate)}.negate())").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.filter(#{predicate:any(java.util.function.IntPredicate)}).findAny().isEmpty()").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.IntPredicate", true),
                            new UsesType<>("java.util.stream.IntStream", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.IntStream anyMatch(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.OptionalInt isEmpty(..)", true),
                                            new UsesMethod<>("java.util.stream.IntStream filter(..)", true),
                                            new UsesMethod<>("java.util.stream.IntStream findAny(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.function.IntPredicate negate(..)", true),
                                            new UsesMethod<>("java.util.stream.IntStream allMatch(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.IntStreamAnyMatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntStreamAnyMatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntStreamAnyMatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.IntStreamAnyMatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `IntStream#anyMatch(IntPredicate)` over more contrived alternatives.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4034");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.anyMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.filter(#{predicate:any(java.util.function.IntPredicate)}).findAny().isPresent()").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.anyMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.anyMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.filter(#{predicate:any(java.util.function.IntPredicate)}).findAny().isPresent()").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.anyMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.IntPredicate", true),
                            new UsesType<>("java.util.stream.IntStream", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.IntStream noneMatch(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.OptionalInt isPresent(..)", true),
                                            new UsesMethod<>("java.util.stream.IntStream filter(..)", true),
                                            new UsesMethod<>("java.util.stream.IntStream findAny(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.IntStreamAllMatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntStreamAllMatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntStreamAllMatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.IntStreamAllMatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamAllMatch {\n    \n    @BeforeTemplate\n    boolean before(IntStream stream, IntPredicate predicate) {\n        return stream.noneMatch(predicate.negate());\n    }\n    \n    @AfterTemplate\n    boolean after(IntStream stream, IntPredicate predicate) {\n        return stream.allMatch(predicate);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)}.negate())").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.allMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.IntPredicate", true),
                            new UsesType<>("java.util.stream.IntStream", true),
                            new UsesMethod<>("java.util.function.IntPredicate negate(..)", true),
                            new UsesMethod<>("java.util.stream.IntStream noneMatch(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code IntStreamRules.IntStreamTakeWhile}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntStreamTakeWhileRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntStreamTakeWhileRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `IntStreamRules.IntStreamTakeWhile`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamTakeWhile {\n    \n    @BeforeTemplate\n    IntStream before(IntStream stream, IntPredicate predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    IntStream after(IntStream stream, IntPredicate predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.takeWhile(#{predicate:any(java.util.function.IntPredicate)}).filter(#{predicate})")
                                .bindType("java.util.stream.IntStream").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.IntStream)}.takeWhile(#{predicate:any(java.util.function.IntPredicate)})")
                                    .bindType("java.util.stream.IntStream").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.IntPredicate", true),
                            new UsesType<>("java.util.stream.IntStream", true),
                            new UsesMethod<>("java.util.stream.IntStream filter(..)", true),
                            new UsesMethod<>("java.util.stream.IntStream takeWhile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
