package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableSortedMapRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableSortedMapRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableSortedMapRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableSortedMapRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `ImmutableSortedMap`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableSortedMapRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ImmutableSortedMapBuilderRecipe(),
                new ImmutableSortedMapNaturalOrderBuilderRecipe(),
                new ImmutableSortedMapReverseOrderBuilderRecipe(),
                new EmptyImmutableSortedMapRecipe(),
                new PairToImmutableSortedMapRecipe(),
                new EntryToImmutableSortedMapRecipe(),
                new IterableToImmutableSortedMapRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMapRules.ImmutableSortedMapBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSortedMapBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSortedMapBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMapRules.ImmutableSortedMapBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMap#orderedBy(Comparator)` over the associated constructor.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new com.google.common.collect.ImmutableSortedMap.Builder<>(#{cmp:any(java.util.Comparator<K>)})")
                                .bindType("com.google.common.collect.ImmutableSortedMap.Builder<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.orderedBy(#{cmp:any(java.util.Comparator<K>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMap.Builder<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder <init>(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMapRules.ImmutableSortedMapNaturalOrderBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSortedMapNaturalOrderBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSortedMapNaturalOrderBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMapRules.ImmutableSortedMapNaturalOrderBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMap#naturalOrder()` over the alternative that requires explicitly providing the `Comparator`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.orderedBy(java.util.Comparator.<K>naturalOrder())")
                                .bindType("com.google.common.collect.ImmutableSortedMap.Builder<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.naturalOrder()")
                                    .bindType("com.google.common.collect.ImmutableSortedMap.Builder<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMap", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap orderedBy(..)", true),
                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMapRules.ImmutableSortedMapReverseOrderBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSortedMapReverseOrderBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSortedMapReverseOrderBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMapRules.ImmutableSortedMapReverseOrderBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMap#reverseOrder()` over the alternative that requires explicitly providing the `Comparator`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.orderedBy(java.util.Comparator.<K>reverseOrder())")
                                .bindType("com.google.common.collect.ImmutableSortedMap.Builder<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.reverseOrder()")
                                    .bindType("com.google.common.collect.ImmutableSortedMap.Builder<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMap", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap orderedBy(..)", true),
                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMapRules.EmptyImmutableSortedMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EmptyImmutableSortedMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EmptyImmutableSortedMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMapRules.EmptyImmutableSortedMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMap#of()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().buildOrThrow()")
                                .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.of()")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMap", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMapRules.PairToImmutableSortedMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PairToImmutableSortedMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PairToImmutableSortedMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMapRules.PairToImmutableSortedMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMap#of(Object, Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().put(#{key:any(K)}, #{value:any(V)}).buildOrThrow()")
                                .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.of(#{key:any(K)}, #{value:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMap", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder put(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMapRules.EntryToImmutableSortedMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EntryToImmutableSortedMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EntryToImmutableSortedMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMapRules.EntryToImmutableSortedMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMap#of(Object, Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().put(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).buildOrThrow()")
                                .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.stream.Stream.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).collect(com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap(java.util.Comparator.naturalOrder(), java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMap");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMap", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder put(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap toImmutableSortedMap(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMapRules.IterableToImmutableSortedMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IterableToImmutableSortedMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IterableToImmutableSortedMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMapRules.IterableToImmutableSortedMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMap#copyOf(Iterable)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before0$2;
                JavaTemplate before1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.util.Map<? extends K, ? extends V>)}, java.util.Comparator.naturalOrder())")
                                .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.util.Map<? extends K, ? extends V>)}.entrySet())")
                                .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().putAll(#{iterable:any(java.util.Map<? extends K, ? extends V>)}).buildOrThrow()")
                                .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}, java.util.Comparator.naturalOrder())")
                                .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().putAll(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).buildOrThrow()")
                                .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$2 == null) {
                        before0$2 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).collect(com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap(java.util.Comparator.<K>naturalOrder(), java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMap");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("#{iterable:any(java.util.Collection<? extends java.util.Map.Entry<? extends K, ? extends V>>)}.stream().collect(com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap(java.util.Comparator.naturalOrder(), java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMap");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMap<K, V>")
                                    .genericTypes("K extends java.lang.Comparable<? super K>", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMap", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap copyOf(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder putAll(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesType<>("java.util.Map", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap copyOf(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesType<>("java.util.Map", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap copyOf(..)", true),
                                            new UsesMethod<>("java.util.Map entrySet(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesType<>("java.util.Map", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap.Builder putAll(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesType<>("java.util.Comparator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap toImmutableSortedMap(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMap toImmutableSortedMap(..)", true),
                                            new UsesMethod<>("java.util.Collection stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
