package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableSetRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableSetRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableSetRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableSetRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `ImmutableSet`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableSetRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ImmutableSetBuilderRecipe(),
                new IterableToImmutableSetRecipe(),
                new StreamToImmutableSetRecipe(),
                new ImmutableSetCopyOfSetViewRecipe(),
                new ImmutableSetOfRecipe(),
                new ImmutableSetOf1Recipe(),
                new ImmutableSetOf2Recipe(),
                new ImmutableSetOf3Recipe(),
                new ImmutableSetOf4Recipe(),
                new ImmutableSetOf5Recipe(),
                new SetsDifferenceRecipe(),
                new SetsDifferenceMapRecipe(),
                new SetsDifferenceMultimapRecipe(),
                new SetsIntersectionRecipe(),
                new SetsIntersectionMapRecipe(),
                new SetsIntersectionMultimapRecipe(),
                new SetsUnionRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.ImmutableSetBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSetBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSetBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.ImmutableSetBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSet#builder()` over the associated constructor.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new com.google.common.collect.ImmutableSet.Builder<>()")
                                .bindType("com.google.common.collect.ImmutableSet.Builder<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.builder()")
                                    .bindType("com.google.common.collect.ImmutableSet.Builder<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder <init>(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.IterableToImmutableSet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IterableToImmutableSetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IterableToImmutableSetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.IterableToImmutableSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSet#copyOf(Iterable)` and variants over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1$0;
                JavaTemplate before1$1;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.<T>builder().add(#{iterable:any(T[])}).build()")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Arrays.stream(#{iterable:any(T[])}).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Arrays");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.<T>builder().addAll(#{iterable:any(java.util.Iterator<T>)}).build()")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.util.Iterator<T>)}).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$0 == null) {
                        before1$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.<T>builder().addAll(#{iterable:any(java.lang.Iterable<T>)}).build()")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$1 == null) {
                        before1$1 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<T>)}).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{iterable:any(java.util.Collection<T>)}.stream().collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder add(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder addAll(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Arrays", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                                            new UsesMethod<>("java.util.Arrays stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                                            new UsesMethod<>("java.util.Collection stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder addAll(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder build(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.StreamToImmutableSet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamToImmutableSetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamToImmutableSetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.StreamToImmutableSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSet#toImmutableSet()` over less idiomatic alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{stream:any(java.util.stream.Stream<T>)}.iterator())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.distinct().collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true),
                                            new UsesMethod<>("java.util.stream.BaseStream iterator(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream distinct(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.ImmutableSetCopyOfSetView}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSetCopyOfSetViewRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSetCopyOfSetViewRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.ImmutableSetCopyOfSetView`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `SetView#immutableCopy()` over the more verbose alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{set:any(com.google.common.collect.Sets.SetView<T>)})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{set:any(com.google.common.collect.Sets.SetView<T>)}.immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("com.google.common.collect.Sets.SetView", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.ImmutableSetOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSetOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSetOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.ImmutableSetOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSet#of()` over more contrived alternatives or alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.<T>builder().build()")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.stream.Stream.<T>empty().collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("java.util.Set");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Collections.emptySet()")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        maybeRemoveImport("java.util.Collections");
                        maybeRemoveImport("java.util.Collections.emptySet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.util.Set.of()")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Collections emptySet(..)", true),
                                    new UsesMethod<>("java.util.Set of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream empty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.ImmutableSetOf1}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSetOf1Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSetOf1Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.ImmutableSetOf1`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSet#of(Object)` over more contrived alternatives or alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.<T>builder().add(#{e1:any(T)}).build()")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Collections.singleton(#{e1:any(T)})")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        maybeRemoveImport("java.util.Collections");
                        maybeRemoveImport("java.util.Collections.singleton");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Set.of(#{e1:any(T)})")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Collections singleton(..)", true),
                                    new UsesMethod<>("java.util.Set of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder add(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet.Builder build(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.ImmutableSetOf2}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSetOf2Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSetOf2Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.ImmutableSetOf2`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSet#of(Object, Object)` over alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Set.of(#{e1:any(T)}, #{e2:any(T)})")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("java.util.Set of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.ImmutableSetOf3}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSetOf3Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSetOf3Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.ImmutableSetOf3`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSet#of(Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Set.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)})")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("java.util.Set of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.ImmutableSetOf4}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSetOf4Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSetOf4Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.ImmutableSetOf4`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSet#of(Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Set.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)})")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("java.util.Set of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.ImmutableSetOf5}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSetOf5Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSetOf5Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.ImmutableSetOf5`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSet#of(Object, Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting set at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Set.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)})")
                                .bindType("java.util.Set<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("java.util.Set of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.SetsDifference}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsDifferenceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsDifferenceRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.SetsDifference`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an immutable copy of `Sets#difference(Set, Set)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{set1:any(java.util.Set<S>)}.stream().filter(java.util.function.Predicate.not(#{set2:any(java.util.Set<T>)}::contains)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<S>")
                                .genericTypes("S", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<S>")
                                    .genericTypes("S", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{set1:any(java.util.Set<S>)}.stream().filter((e)->!#{set2:any(java.util.Set<T>)}.contains(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<S>")
                                .genericTypes("S", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<S>")
                                    .genericTypes("S", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitLambda(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{set1:any(java.util.Set<S>)}.stream().filter(java.util.function.Predicate.not(#{set2:any(java.util.Set<T>)}::contains)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<S>")
                                .genericTypes("S", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<S>")
                                    .genericTypes("S", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{set1:any(java.util.Set<S>)}.stream().filter((e)->!#{set2:any(java.util.Set<T>)}.contains(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<S>")
                                .genericTypes("S", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<S>")
                                    .genericTypes("S", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Set contains(..)", true),
                                    new UsesMethod<>("java.util.function.Predicate not(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.SetsDifferenceMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsDifferenceMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsDifferenceMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.SetsDifferenceMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an immutable copy of `Sets#difference(Set, Set)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter(java.util.function.Predicate.not(#{map:any(java.util.Map<K, V>)}::containsKey)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set:any(java.util.Set<K>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<K>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter((e)->!#{map:any(java.util.Map<K, V>)}.containsKey(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set:any(java.util.Set<K>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<K>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitLambda(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter(java.util.function.Predicate.not(#{map:any(java.util.Map<K, V>)}::containsKey)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set:any(java.util.Set<K>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<K>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter((e)->!#{map:any(java.util.Map<K, V>)}.containsKey(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set:any(java.util.Set<K>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<K>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Map containsKey(..)", true),
                                    new UsesMethod<>("java.util.function.Predicate not(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.SetsDifferenceMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsDifferenceMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsDifferenceMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.SetsDifferenceMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an immutable copy of `Sets#difference(Set, Set)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter(java.util.function.Predicate.not(#{multimap:any(com.google.common.collect.Multimap<K, V>)}::containsKey)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter((e)->!#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsKey(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitLambda(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter(java.util.function.Predicate.not(#{multimap:any(com.google.common.collect.Multimap<K, V>)}::containsKey)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter((e)->!#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsKey(e)).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.difference(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.Multimap containsKey(..)", true),
                                    new UsesMethod<>("java.util.function.Predicate not(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.SetsIntersection}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsIntersectionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsIntersectionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.SetsIntersection`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an immutable copy of `Sets#intersection(Set, Set)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{set1:any(java.util.Set<S>)}.stream().filter(#{set2:any(java.util.Set<T>)}::contains).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<S>")
                                .genericTypes("S", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.intersection(#{set1:any(java.util.Set<S>)}, #{set2:any(java.util.Set<T>)}).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<S>")
                                    .genericTypes("S", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.SetsIntersectionMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsIntersectionMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsIntersectionMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.SetsIntersectionMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an immutable copy of `Sets#intersection(Set, Set)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter(#{map:any(java.util.Map<K, V>)}::containsKey).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.intersection(#{set:any(java.util.Set<T>)}, #{map:any(java.util.Map<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.SetsIntersectionMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsIntersectionMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsIntersectionMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.SetsIntersectionMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an immutable copy of `Sets#intersection(Set, Set)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().filter(#{multimap:any(com.google.common.collect.Multimap<K, V>)}::containsKey).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T", "K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.intersection(#{set:any(java.util.Set<T>)}, #{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T", "K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetRules.SetsUnion}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsUnionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsUnionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetRules.SetsUnion`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an immutable copy of `Sets#union(Set, Set)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.stream.Stream.concat(#{set1:any(java.util.Set<T>)}.stream(), #{set2:any(java.util.Set<U>)}.stream()).collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<S>")
                                .genericTypes("S", "T extends S", "U extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.union(#{set1:any(java.util.Set<T>)}, #{set2:any(java.util.Set<U>)}).immutableCopy()")
                                    .bindType("com.google.common.collect.ImmutableSet<S>")
                                    .genericTypes("S", "T extends S", "U extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("java.util.Set", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("java.util.stream.Stream concat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
