package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableMapRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableMapRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableMapRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableMapRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `ImmutableMap`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableMapRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ImmutableMapBuilderRecipe(),
                new ImmutableMapBuilderBuildOrThrowRecipe(),
                new EntryToImmutableMapRecipe(),
                new EntryIterableToImmutableMapRecipe(),
                new ImmutableMapOfRecipe(),
                new ImmutableMapOf1Recipe(),
                new ImmutableMapOf2Recipe(),
                new ImmutableMapOf3Recipe(),
                new ImmutableMapOf4Recipe(),
                new ImmutableMapOf5Recipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.ImmutableMapBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableMapBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableMapBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.ImmutableMapBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap#builder()` over the associated constructor.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new com.google.common.collect.ImmutableMap.Builder<>()")
                                .bindType("com.google.common.collect.ImmutableMap.Builder<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.builder()")
                                    .bindType("com.google.common.collect.ImmutableMap.Builder<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder <init>(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.ImmutableMapBuilderBuildOrThrow}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableMapBuilderBuildOrThrowRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableMapBuilderBuildOrThrowRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.ImmutableMapBuilderBuildOrThrow`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap.Builder#buildOrThrow()` over the less explicit `ImmutableMap.Builder#build()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{builder:any(com.google.common.collect.ImmutableMap.Builder<K, V>)}.build()")
                                .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{builder:any(com.google.common.collect.ImmutableMap.Builder<K, V>)}.buildOrThrow()")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder build(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.EntryToImmutableMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EntryToImmutableMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EntryToImmutableMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.EntryToImmutableMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap#of(Object, Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.<K, V>builder().put(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).buildOrThrow()")
                                .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.stream.Stream.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).collect(com.google.common.collect.ImmutableMap.toImmutableMap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        maybeRemoveImport("com.google.common.collect.ImmutableMap.toImmutableMap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder put(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap toImmutableMap(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.EntryIterableToImmutableMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EntryIterableToImmutableMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EntryIterableToImmutableMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.EntryIterableToImmutableMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap#copyOf(Iterable)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.util.Map<? extends K, ? extends V>)}.entrySet())")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.<K, V>builder().putAll(#{iterable:any(java.util.Map<? extends K, ? extends V>)}).buildOrThrow()")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Map.copyOf(#{iterable:any(java.util.Map<? extends K, ? extends V>)})")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.<K, V>builder().putAll(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).buildOrThrow()")
                                .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).collect(com.google.common.collect.ImmutableMap.toImmutableMap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        maybeRemoveImport("com.google.common.collect.ImmutableMap.toImmutableMap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("#{iterable:any(java.util.Collection<? extends java.util.Map.Entry<? extends K, ? extends V>>)}.stream().collect(com.google.common.collect.ImmutableMap.toImmutableMap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        maybeRemoveImport("com.google.common.collect.ImmutableMap.toImmutableMap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMap builder(..)", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder putAll(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                    new UsesType<>("com.google.common.collect.Streams", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMap toImmutableMap(..)", true),
                                    new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                    new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                    new UsesType<>("java.util.Collection", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMap toImmutableMap(..)", true),
                                    new UsesMethod<>("java.util.Collection stream(..)", true),
                                    new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                    new UsesType<>("java.util.Map", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMap builder(..)", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder putAll(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                    new UsesType<>("java.util.Map", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMap copyOf(..)", true),
                                    new UsesMethod<>("java.util.Map entrySet(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("java.util.Map", true),
                                    new UsesMethod<>("java.util.Map copyOf(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.ImmutableMapOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableMapOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableMapOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.ImmutableMapOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap#of()` over more contrived alternatives or alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.<K, V>builder().buildOrThrow()")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of()")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.ofEntries()")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of()")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Collections.emptyMap()")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.Collections");
                        maybeRemoveImport("java.util.Collections.emptyMap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of()")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.util.Map.of()")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of()")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Collections emptyMap(..)", true),
                                    new UsesMethod<>("java.util.Map of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap ofEntries(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.ImmutableMapOf1}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableMapOf1Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableMapOf1Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.ImmutableMapOf1`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap#of(Object, Object)` over more contrived alternatives or alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.<K, V>builder().put(#{k1:any(K)}, #{v1:any(V)}).buildOrThrow()")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}))")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Collections.singletonMap(#{k1:any(K)}, #{v1:any(V)})")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.Collections");
                        maybeRemoveImport("java.util.Collections.singletonMap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.util.Map.of(#{k1:any(K)}, #{v1:any(V)})")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Collections singletonMap(..)", true),
                                    new UsesMethod<>("java.util.Map of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap.Builder put(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap ofEntries(..)", true),
                                            new UsesMethod<>("java.util.Map entry(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.ImmutableMapOf2}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableMapOf2Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableMapOf2Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.ImmutableMapOf2`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap#of(Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}), java.util.Map.entry(#{k2:any(K)}, #{v2:any(V)}))")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Map.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)})")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Map of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap ofEntries(..)", true),
                                            new UsesMethod<>("java.util.Map entry(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.ImmutableMapOf3}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableMapOf3Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableMapOf3Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.ImmutableMapOf3`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap#of(Object, Object, Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}), java.util.Map.entry(#{k2:any(K)}, #{v2:any(V)}), java.util.Map.entry(#{k3:any(K)}, #{v3:any(V)}))")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Map.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)})")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Map of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap ofEntries(..)", true),
                                            new UsesMethod<>("java.util.Map entry(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.ImmutableMapOf4}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableMapOf4Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableMapOf4Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.ImmutableMapOf4`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap#of(Object, Object, Object, Object, Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S107");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}), java.util.Map.entry(#{k2:any(K)}, #{v2:any(V)}), java.util.Map.entry(#{k3:any(K)}, #{v3:any(V)}), java.util.Map.entry(#{k4:any(K)}, #{v4:any(V)}))")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5), matcher.parameter(6), matcher.parameter(7)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Map.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)})")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5), matcher.parameter(6), matcher.parameter(7)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Map of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap ofEntries(..)", true),
                                            new UsesMethod<>("java.util.Map entry(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMapRules.ImmutableMapOf5}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableMapOf5Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableMapOf5Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMapRules.ImmutableMapOf5`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMap#of(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S107");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}), java.util.Map.entry(#{k2:any(K)}, #{v2:any(V)}), java.util.Map.entry(#{k3:any(K)}, #{v3:any(V)}), java.util.Map.entry(#{k4:any(K)}, #{v4:any(V)}), java.util.Map.entry(#{k5:any(K)}, #{v5:any(V)}))")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)}, #{k5:any(K)}, #{v5:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5), matcher.parameter(6), matcher.parameter(7), matcher.parameter(8), matcher.parameter(9)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Map.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)}, #{k5:any(K)}, #{v5:any(V)})")
                                .bindType("java.util.Map<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Map");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)}, #{k5:any(K)}, #{v5:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableMap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5), matcher.parameter(6), matcher.parameter(7), matcher.parameter(8), matcher.parameter(9)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Map of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMap ofEntries(..)", true),
                                            new UsesMethod<>("java.util.Map entry(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
