package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableListMultimapRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableListMultimapRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableListMultimapRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableListMultimapRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `ImmutableListMultimap`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableListMultimapRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ImmutableListMultimapBuilderRecipe(),
                new EmptyImmutableListMultimapRecipe(),
                new PairToImmutableListMultimapRecipe(),
                new EntryToImmutableListMultimapRecipe(),
                new IterableToImmutableListMultimapRecipe(),
                new TransformMultimapValuesToImmutableListMultimap2Recipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableListMultimapRules.ImmutableListMultimapBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableListMultimapBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableListMultimapBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableListMultimapRules.ImmutableListMultimapBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableListMultimap#builder()` over the associated constructor on constructions that produce a less-specific type.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("new com.google.common.collect.ImmutableListMultimap.Builder<>()")
                                .bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.builder()")
                                    .bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new com.google.common.collect.ImmutableMultimap.Builder<>()")
                                .bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.builder()")
                                    .bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("com.google.common.collect.ImmutableMultimap.builder()")
                                .bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.builder()")
                                    .bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("new com.google.common.collect.ImmutableListMultimap.Builder<>()")
                                .bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.builder()")
                                    .bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new com.google.common.collect.ImmutableMultimap.Builder<>()")
                                .bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.builder()")
                                    .bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("com.google.common.collect.ImmutableMultimap.builder()")
                                .bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.builder()")
                                    .bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder <init>(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableMultimap.Builder <init>(..)", true),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMultimap builder(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableListMultimapRules.EmptyImmutableListMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EmptyImmutableListMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EmptyImmutableListMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableListMultimapRules.EmptyImmutableListMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableListMultimap#of()` over more contrived or less-specific alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.<K, V>builder().build()")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.of()")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableMultimap.of()")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.of()")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.ImmutableMultimap of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableListMultimap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableListMultimapRules.PairToImmutableListMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PairToImmutableListMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PairToImmutableListMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableListMultimapRules.PairToImmutableListMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableListMultimap#of(Object, Object)` over more contrived or less-specific alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.<K, V>builder().put(#{key:any(K)}, #{value:any(V)}).build()")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.of(#{key:any(K)}, #{value:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableMultimap.of(#{key:any(K)}, #{value:any(V)})")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.of(#{key:any(K)}, #{value:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.ImmutableMultimap of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableListMultimap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder put(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableListMultimapRules.EntryToImmutableListMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EntryToImmutableListMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EntryToImmutableListMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableListMultimapRules.EntryToImmutableListMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableListMultimap#of(Object, Object)` over more contrived or less-specific alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.<K, V>builder().put(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).build()")
                                .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.stream.Stream.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).collect(com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableListMultimap", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder put(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap toImmutableListMultimap(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableListMultimapRules.IterableToImmutableListMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IterableToImmutableListMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IterableToImmutableListMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableListMultimapRules.IterableToImmutableListMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableListMultimap#copyOf(Iterable)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before0$2;
                JavaTemplate before1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)}.entries())")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Multimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.<K, V>builder().putAll(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)}).build()")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Multimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("com.google.common.collect.ImmutableMultimap.copyOf(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)})")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Multimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("com.google.common.collect.ImmutableMultimap.copyOf(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)}.entries())")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Multimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.<K, V>builder().putAll(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).build()")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).collect(com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$2 == null) {
                        before0$2 = JavaTemplate.builder("com.google.common.collect.ImmutableMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                .bindType("com.google.common.collect.ImmutableMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("#{iterable:any(java.util.Collection<? extends java.util.Map.Entry<? extends K, ? extends V>>)}.stream().collect(com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableListMultimap", true),
                                    new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableListMultimap builder(..)", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder putAll(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableListMultimap", true),
                                    new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                                    new UsesType<>("com.google.common.collect.Multimap", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableListMultimap builder(..)", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableListMultimap.Builder putAll(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableListMultimap", true),
                                    new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                                    new UsesType<>("com.google.common.collect.Multimap", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableListMultimap copyOf(..)", true),
                                    new UsesMethod<>("com.google.common.collect.Multimap entries(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableListMultimap", true),
                                    new UsesType<>("java.util.Collection", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableListMultimap toImmutableListMultimap(..)", true),
                                    new UsesMethod<>("java.util.Collection stream(..)", true),
                                    new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMultimap copyOf(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                                    new UsesType<>("com.google.common.collect.Multimap", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMultimap copyOf(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                                    new UsesType<>("com.google.common.collect.Multimap", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableMultimap copyOf(..)", true),
                                    new UsesMethod<>("com.google.common.collect.Multimap entries(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableMultimap", true),
                                    new UsesType<>("com.google.common.collect.Streams", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableListMultimap toImmutableListMultimap(..)", true),
                                    new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                    new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableListMultimapRules.TransformMultimapValuesToImmutableListMultimap2}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TransformMultimapValuesToImmutableListMultimap2Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TransformMultimapValuesToImmutableListMultimap2Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableListMultimapRules.TransformMultimapValuesToImmutableListMultimap2`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer creating an immutable copy of the result of `Multimaps#transformValues(Multimap, com.google.common.base.Function)` over creating and directly collecting a stream.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V1>)}.asMap().entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.ListMultimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ListMultimap");
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.List");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.SetMultimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.SetMultimap");
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.Set");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.SortedSetMultimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.SortedSetMultimap");
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.SortedSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableListMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableListMultimap", true),
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("java.util.Map.Entry", true),
                            new UsesType<>("java.util.function.Function", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableListMultimap flatteningToImmutableListMultimap(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.Map entrySet(..)", true),
                            new UsesMethod<>("java.util.Map.Entry getValue(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("java.util.stream.Stream map(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ListMultimap", true),
                                            new UsesType<>("com.google.common.collect.Multimaps", true),
                                            new UsesType<>("java.util.List", true),
                                            new UsesMethod<>("com.google.common.collect.Multimaps asMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimap", true),
                                            new UsesType<>("com.google.common.collect.Multimaps", true),
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.Multimaps asMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimap", true),
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.Multimap asMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimaps", true),
                                            new UsesType<>("com.google.common.collect.SetMultimap", true),
                                            new UsesType<>("java.util.Set", true),
                                            new UsesMethod<>("com.google.common.collect.Multimaps asMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimaps", true),
                                            new UsesType<>("com.google.common.collect.SortedSetMultimap", true),
                                            new UsesType<>("java.util.SortedSet", true),
                                            new UsesMethod<>("com.google.common.collect.Multimaps asMap(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
