package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ComparatorRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ComparatorRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ComparatorRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ComparatorRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `Comparator`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ComparatorRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ReverseOrderRecipe(),
                new ThenComparingRecipe(),
                new ThenComparingReversedRecipe(),
                new ThenComparingCustomRecipe(),
                new ThenComparingCustomReversedRecipe(),
                new ThenComparingDoubleRecipe(),
                new ThenComparingIntRecipe(),
                new ThenComparingLongRecipe(),
                new CompareToRecipe(),
                new CollectionsSortRecipe(),
                new CollectionsMinRecipe(),
                new MinOfArrayRecipe(),
                new CollectionsMinWithComparatorRecipe(),
                new CollectionsMaxRecipe(),
                new MaxOfArrayRecipe(),
                new CollectionsMaxWithComparatorRecipe(),
                new ComparatorsMinRecipe(),
                new ComparatorsMaxRecipe(),
                new MinByNaturalOrderRecipe(),
                new MaxByNaturalOrderRecipe(),
                new IsLessThanRecipe(),
                new IsLessThanOrEqualToRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ReverseOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ReverseOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ReverseOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ReverseOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Comparator#reverseOrder()` over more complicated constructs.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.Collections.reverseOrder()")
                                .bindType("java.util.Comparator<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collections");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Comparator.reverseOrder()")
                                    .bindType("java.util.Comparator<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Collections.<T>reverseOrder(java.util.Comparator.naturalOrder())")
                                .bindType("java.util.Comparator<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collections");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Comparator.reverseOrder()")
                                    .bindType("java.util.Comparator<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Comparator.<T>naturalOrder().reversed()")
                                .bindType("java.util.Comparator<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Comparator.reverseOrder()")
                                    .bindType("java.util.Comparator<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.Comparator reversed(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collections", true),
                                            new UsesMethod<>("java.util.Collections reverseOrder(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collections", true),
                                            new UsesMethod<>("java.util.Collections reverseOrder(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ThenComparing}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ThenComparingRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ThenComparingRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ThenComparing`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{cmp:any(java.util.Comparator<S>)}.thenComparing(java.util.Comparator.comparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}))")
                                .bindType("java.util.Comparator<S>")
                                .genericTypes("S", "T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparing");
                        if (after == null) {
                            after = JavaTemplate.builder("#{cmp:any(java.util.Comparator<S>)}.thenComparing(#{function:any(java.util.function.Function<? super S, ? extends T>)})")
                                    .bindType("java.util.Comparator<S>")
                                    .genericTypes("S", "T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.function.Function", true),
                            new UsesMethod<>("java.util.Comparator comparing(..)", true),
                            new UsesMethod<>("java.util.Comparator thenComparing(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ThenComparingReversed}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ThenComparingReversedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ThenComparingReversedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ThenComparingReversed`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{cmp:any(java.util.Comparator<S>)}.thenComparing(java.util.Comparator.comparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}).reversed())")
                                .bindType("java.util.Comparator<S>")
                                .genericTypes("S", "T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparing");
                        if (after == null) {
                            after = JavaTemplate.builder("#{cmp:any(java.util.Comparator<S>)}.thenComparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, java.util.Comparator.reverseOrder())")
                                    .bindType("java.util.Comparator<S>")
                                    .genericTypes("S", "T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.function.Function", true),
                            new UsesMethod<>("java.util.Comparator comparing(..)", true),
                            new UsesMethod<>("java.util.Comparator reversed(..)", true),
                            new UsesMethod<>("java.util.Comparator thenComparing(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ThenComparingCustom}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ThenComparingCustomRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ThenComparingCustomRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ThenComparingCustom`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{cmp:any(java.util.Comparator<S>)}.thenComparing(java.util.Comparator.comparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, #{cmp2:any(java.util.Comparator<? super T>)}))")
                                .bindType("java.util.Comparator<S>")
                                .genericTypes("S", "T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparing");
                        if (after == null) {
                            after = JavaTemplate.builder("#{cmp:any(java.util.Comparator<S>)}.thenComparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, #{cmp2:any(java.util.Comparator<? super T>)})")
                                    .bindType("java.util.Comparator<S>")
                                    .genericTypes("S", "T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.function.Function", true),
                            new UsesMethod<>("java.util.Comparator comparing(..)", true),
                            new UsesMethod<>("java.util.Comparator thenComparing(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ThenComparingCustomReversed}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ThenComparingCustomReversedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ThenComparingCustomReversedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ThenComparingCustomReversed`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{cmp:any(java.util.Comparator<S>)}.thenComparing(java.util.Comparator.comparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, #{cmp2:any(java.util.Comparator<? super T>)}).reversed())")
                                .bindType("java.util.Comparator<S>")
                                .genericTypes("S", "T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparing");
                        if (after == null) {
                            after = JavaTemplate.builder("#{cmp:any(java.util.Comparator<S>)}.thenComparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, #{cmp2:any(java.util.Comparator<? super T>)}.reversed())")
                                    .bindType("java.util.Comparator<S>")
                                    .genericTypes("S", "T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.function.Function", true),
                            new UsesMethod<>("java.util.Comparator comparing(..)", true),
                            new UsesMethod<>("java.util.Comparator reversed(..)", true),
                            new UsesMethod<>("java.util.Comparator thenComparing(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ThenComparingDouble}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ThenComparingDoubleRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ThenComparingDoubleRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ThenComparingDouble`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{cmp:any(java.util.Comparator<T>)}.thenComparing(java.util.Comparator.comparingDouble(#{function:any(java.util.function.ToDoubleFunction<? super T>)}))")
                                .bindType("java.util.Comparator<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparingDouble");
                        if (after == null) {
                            after = JavaTemplate.builder("#{cmp:any(java.util.Comparator<T>)}.thenComparingDouble(#{function:any(java.util.function.ToDoubleFunction<? super T>)})")
                                    .bindType("java.util.Comparator<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.function.ToDoubleFunction", true),
                            new UsesMethod<>("java.util.Comparator comparingDouble(..)", true),
                            new UsesMethod<>("java.util.Comparator thenComparing(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ThenComparingInt}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ThenComparingIntRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ThenComparingIntRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ThenComparingInt`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{cmp:any(java.util.Comparator<T>)}.thenComparing(java.util.Comparator.comparingInt(#{function:any(java.util.function.ToIntFunction<? super T>)}))")
                                .bindType("java.util.Comparator<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparingInt");
                        if (after == null) {
                            after = JavaTemplate.builder("#{cmp:any(java.util.Comparator<T>)}.thenComparingInt(#{function:any(java.util.function.ToIntFunction<? super T>)})")
                                    .bindType("java.util.Comparator<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.function.ToIntFunction", true),
                            new UsesMethod<>("java.util.Comparator comparingInt(..)", true),
                            new UsesMethod<>("java.util.Comparator thenComparing(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ThenComparingLong}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ThenComparingLongRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ThenComparingLongRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ThenComparingLong`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{cmp:any(java.util.Comparator<T>)}.thenComparing(java.util.Comparator.comparingLong(#{function:any(java.util.function.ToLongFunction<? super T>)}))")
                                .bindType("java.util.Comparator<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.comparingLong");
                        if (after == null) {
                            after = JavaTemplate.builder("#{cmp:any(java.util.Comparator<T>)}.thenComparingLong(#{function:any(java.util.function.ToLongFunction<? super T>)})")
                                    .bindType("java.util.Comparator<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.function.ToLongFunction", true),
                            new UsesMethod<>("java.util.Comparator comparingLong(..)", true),
                            new UsesMethod<>("java.util.Comparator thenComparing(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.CompareTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CompareToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CompareToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.CompareTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Comparable#compareTo(Object)`} over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.Comparator.<T>naturalOrder().compare(#{value1:any(T)}, #{value2:any(T)})")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        if (after == null) {
                            after = JavaTemplate.builder("#{value1:any(T)}.compareTo(#{value2:any(T)})")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Comparator.<T>reverseOrder().compare(#{value2:any(T)}, #{value1:any(T)})")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        if (after == null) {
                            after = JavaTemplate.builder("#{value1:any(T)}.compareTo(#{value2:any(T)})")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("java.util.Comparator compare(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                    new UsesMethod<>("java.util.Comparator reverseOrder(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.CollectionsSort}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionsSortRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionsSortRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.CollectionsSort`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collections#sort(List)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Collections.sort(#{collection:any(java.util.List<T>)}, java.util.Comparator.naturalOrder());")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.sort(#{collection:any(java.util.List<T>)});")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collections", true),
                            new UsesType<>("java.util.List", true),
                            new UsesMethod<>("java.util.Collections sort(..)", true),
                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.CollectionsMin}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionsMinRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionsMinRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.CollectionsMin`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collections#min(Collection)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.Collections.min(#{collection:any(java.util.Collection<T>)}, java.util.Comparator.naturalOrder())")
                                .bindType("T")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.min(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("T")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Collections.max(#{collection:any(java.util.Collection<T>)}, java.util.Comparator.reverseOrder())")
                                .bindType("T")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.min(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("T")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("java.util.Collections", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Collections max(..)", true),
                                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Collections min(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.MinOfArray}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MinOfArrayRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MinOfArrayRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.MinOfArray`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid unnecessary creation of a `Stream` to determine the minimum of a known collection of values.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Arrays.stream(#{array:any(T[])}).min(#{cmp:any(java.util.Comparator<S>)}).orElseThrow()")
                                .bindType("T")
                                .genericTypes("S", "T extends S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.min(java.util.Arrays.asList(#{array:any(T[])}), #{cmp:any(java.util.Comparator<S>)})")
                                    .bindType("T")
                                    .genericTypes("S", "T extends S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Arrays", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("java.util.Arrays stream(..)", true),
                            new UsesMethod<>("java.util.Optional orElseThrow(..)", true),
                            new UsesMethod<>("java.util.stream.Stream min(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.CollectionsMinWithComparator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionsMinWithComparatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionsMinWithComparatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.CollectionsMinWithComparator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid unnecessary creation of a `Stream` to determine the minimum of a known collection of values.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().min(#{cmp:any(java.util.Comparator<S>)}).orElseThrow()")
                                .bindType("T")
                                .genericTypes("S", "T extends S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.min(#{collection:any(java.util.Collection<T>)}, #{cmp:any(java.util.Comparator<S>)})")
                                    .bindType("T")
                                    .genericTypes("S", "T extends S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.Optional orElseThrow(..)", true),
                            new UsesMethod<>("java.util.stream.Stream min(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.CollectionsMax}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionsMaxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionsMaxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.CollectionsMax`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collections#max(Collection)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.Collections.max(#{collection:any(java.util.Collection<T>)}, java.util.Comparator.naturalOrder())")
                                .bindType("T")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.max(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("T")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Collections.min(#{collection:any(java.util.Collection<T>)}, java.util.Comparator.reverseOrder())")
                                .bindType("T")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.max(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("T")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("java.util.Collections", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Collections max(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Collections min(..)", true),
                                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.MaxOfArray}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MaxOfArrayRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MaxOfArrayRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.MaxOfArray`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid unnecessary creation of a `Stream` to determine the maximum of a known collection of values.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Arrays.stream(#{array:any(T[])}).max(#{cmp:any(java.util.Comparator<S>)}).orElseThrow()")
                                .bindType("T")
                                .genericTypes("S", "T extends S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.max(java.util.Arrays.asList(#{array:any(T[])}), #{cmp:any(java.util.Comparator<S>)})")
                                    .bindType("T")
                                    .genericTypes("S", "T extends S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Arrays", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("java.util.Arrays stream(..)", true),
                            new UsesMethod<>("java.util.Optional orElseThrow(..)", true),
                            new UsesMethod<>("java.util.stream.Stream max(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.CollectionsMaxWithComparator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionsMaxWithComparatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionsMaxWithComparatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.CollectionsMaxWithComparator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid unnecessary creation of a `Stream` to determine the maximum of a known collection of values.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().max(#{cmp:any(java.util.Comparator<S>)}).orElseThrow()")
                                .bindType("T")
                                .genericTypes("S", "T extends S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.max(#{collection:any(java.util.Collection<T>)}, #{cmp:any(java.util.Comparator<S>)})")
                                    .bindType("T")
                                    .genericTypes("S", "T extends S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.Optional orElseThrow(..)", true),
                            new UsesMethod<>("java.util.stream.Stream max(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ComparatorsMin}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ComparatorsMinRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ComparatorsMinRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ComparatorsMin`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer a method reference to `Comparators#min(Comparable, Comparable)` over calling `BinaryOperator#minBy(Comparator)` with `Comparator#naturalOrder()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.function.BinaryOperator.minBy(java.util.Comparator.naturalOrder())")
                                .bindType("java.util.function.BinaryOperator<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Comparators::min")
                                    .bindType("java.util.function.BinaryOperator<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.BinaryOperator", true),
                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                            new UsesMethod<>("java.util.function.BinaryOperator minBy(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.ComparatorsMax}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ComparatorsMaxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ComparatorsMaxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.ComparatorsMax`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer a method reference to `Comparators#max(Comparable, Comparable)` over calling `BinaryOperator#minBy(Comparator)` with `Comparator#naturalOrder()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.function.BinaryOperator.maxBy(java.util.Comparator.naturalOrder())")
                                .bindType("java.util.function.BinaryOperator<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Comparators::max")
                                    .bindType("java.util.function.BinaryOperator<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.BinaryOperator", true),
                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                            new UsesMethod<>("java.util.function.BinaryOperator maxBy(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.MinByNaturalOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MinByNaturalOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MinByNaturalOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.MinByNaturalOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Comparator#naturalOrder()` over `Comparator#reverseOrder()` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.stream.Collectors.maxBy(java.util.Comparator.reverseOrder())")
                                .bindType("java.util.stream.Collector<T, ?, java.util.Optional<T>>")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.stream.Collectors.maxBy");
                        maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Collectors.minBy(java.util.Comparator.naturalOrder())")
                                    .bindType("java.util.stream.Collector<T, ?, java.util.Optional<T>>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true),
                            new UsesMethod<>("java.util.stream.Collectors maxBy(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.MaxByNaturalOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MaxByNaturalOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MaxByNaturalOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.MaxByNaturalOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Comparator#naturalOrder()` over `Comparator#reverseOrder()` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.stream.Collectors.minBy(java.util.Comparator.reverseOrder())")
                                .bindType("java.util.stream.Collector<T, ?, java.util.Optional<T>>")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.stream.Collectors.minBy");
                        maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Collectors.maxBy(java.util.Comparator.naturalOrder())")
                                    .bindType("java.util.stream.Collector<T, ?, java.util.Optional<T>>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true),
                            new UsesMethod<>("java.util.stream.Collectors minBy(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.IsLessThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IsLessThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IsLessThanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.IsLessThan`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't explicitly compare enums by their ordinal.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{value1:any(E)}.ordinal() < #{value2:any(E)}.ordinal()")
                                .genericTypes("E extends java.lang.Enum<E>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value1:any(E)}.compareTo(#{value2:any(E)}) < 0")
                                    .genericTypes("E extends java.lang.Enum<E>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Enum ordinal(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ComparatorRules.IsLessThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IsLessThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IsLessThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ComparatorRules.IsLessThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't explicitly compare enums by their ordinal.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{value1:any(E)}.ordinal() <= #{value2:any(E)}.ordinal()")
                                .genericTypes("E extends java.lang.Enum<E>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value1:any(E)}.compareTo(#{value2:any(E)}) <= 0")
                                    .genericTypes("E extends java.lang.Enum<E>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Enum ordinal(..)", true),
                    javaVisitor
            );
        }
    }

}
