package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ClassRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ClassRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ClassRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ClassRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with classes.\n[Source](https://error-prone.picnic.tech/refasterrules/ClassRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ClassIsInstanceRecipe(),
                new ClassReferenceIsInstancePredicateRecipe(),
                new ClassReferenceCastRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ClassRules.ClassIsInstance}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ClassIsInstanceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ClassIsInstanceRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ClassRules.ClassIsInstance`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Class#isInstance(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{clazz:any(java.lang.Class<T>)}.isAssignableFrom(#{object:any(S)}.getClass())")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{clazz:any(java.lang.Class<T>)}.isInstance(#{object:any(S)})")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("java.lang.Class isAssignableFrom(..)", true),
                            new UsesMethod<>("java.lang.Object getClass(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ClassRules.ClassReferenceIsInstancePredicate}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ClassReferenceIsInstancePredicateRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ClassReferenceIsInstancePredicateRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ClassRules.ClassReferenceIsInstancePredicate`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Class#isInstance(Object)` method references over lambda expressions that require naming a variable.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("(o)->#{clazz:any(java.lang.Class<T>)}.isInstance(o)")
                                .bindType("java.util.function.Predicate<S>")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{clazz:any(java.lang.Class<T>)}::isInstance")
                                    .bindType("java.util.function.Predicate<S>")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitLambda(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesMethod<>("java.lang.Class isInstance(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ClassRules.ClassReferenceCast}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ClassReferenceCastRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ClassReferenceCastRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ClassRules.ClassReferenceCast`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Class#cast(Object)` method references over lambda expressions that require naming a variable.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("(o)->#{clazz:any(java.lang.Class<? extends S>)}.cast(o)")
                                .bindType("java.util.function.Function<T, S>")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{clazz:any(java.lang.Class<? extends S>)}::cast")
                                    .bindType("java.util.function.Function<T, S>")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitLambda(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Function", true),
                            new UsesMethod<>("java.lang.Class cast(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
