package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJStringRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJStringRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJStringRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJStringRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJStringRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJStringRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AbstractStringAssertStringIsEmptyRecipe(),
                new AbstractStringAssertStringIsNotEmptyRecipe(),
                new AssertThatStringStartsWithRecipe(),
                new AssertThatStringDoesNotStartWithRecipe(),
                new AssertThatStringEndsWithRecipe(),
                new AssertThatStringDoesNotEndWithRecipe(),
                new AssertThatStringContainsRecipe(),
                new AssertThatStringDoesNotContainRecipe(),
                new AssertThatMatchesRecipe(),
                new AssertThatDoesNotMatchRecipe(),
                new AssertThatPathContentRecipe(),
                new AssertThatPathContentUtf8Recipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AbstractStringAssertStringIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractStringAssertStringIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractStringAssertStringIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AbstractStringAssertStringIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractStringAssertStringIsEmpty {\n    \n    @BeforeTemplate\n    void before(AbstractStringAssert<?> stringAssert) {\n        stringAssert.isEqualTo(\"\");\n    }\n    \n    @AfterTemplate\n    void after(AbstractStringAssert<?> stringAssert) {\n        stringAssert.isEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stringAssert:any(org.assertj.core.api.AbstractStringAssert<?>)}.isEqualTo(\"\");")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stringAssert:any(org.assertj.core.api.AbstractStringAssert<?>)}.isEmpty();")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractStringAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractStringAssert isEqualTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AbstractStringAssertStringIsNotEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractStringAssertStringIsNotEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractStringAssertStringIsNotEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AbstractStringAssertStringIsNotEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractStringAssertStringIsNotEmpty {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(AbstractStringAssert<?> stringAssert) {\n        return stringAssert.isNotEqualTo(\"\");\n    }\n    \n    @AfterTemplate\n    AbstractStringAssert<?> after(AbstractStringAssert<?> stringAssert) {\n        return stringAssert.isNotEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stringAssert:any(org.assertj.core.api.AbstractStringAssert<?>)}.isNotEqualTo(\"\")")
                                .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stringAssert:any(org.assertj.core.api.AbstractStringAssert<?>)}.isNotEmpty()")
                                    .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractStringAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isNotEqualTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatStringStartsWith}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStringStartsWithRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStringStartsWithRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatStringStartsWith`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringStartsWith {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(String string, String prefix) {\n        return assertThat(string.startsWith(prefix)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(String string, String prefix) {\n        return assertThat(string).startsWith(prefix);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.startsWith(#{prefix:any(java.lang.String)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).startsWith(#{prefix:any(java.lang.String)})")
                                    .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.lang.String startsWith(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatStringDoesNotStartWith}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStringDoesNotStartWithRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStringDoesNotStartWithRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatStringDoesNotStartWith`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringDoesNotStartWith {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(String string, String prefix) {\n        return assertThat(string.startsWith(prefix)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(String string, String prefix) {\n        return assertThat(string).doesNotStartWith(prefix);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.startsWith(#{prefix:any(java.lang.String)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).doesNotStartWith(#{prefix:any(java.lang.String)})")
                                    .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.lang.String startsWith(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatStringEndsWith}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStringEndsWithRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStringEndsWithRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatStringEndsWith`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringEndsWith {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(String string, String prefix) {\n        return assertThat(string.endsWith(prefix)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(String string, String prefix) {\n        return assertThat(string).endsWith(prefix);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.endsWith(#{prefix:any(java.lang.String)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).endsWith(#{prefix:any(java.lang.String)})")
                                    .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.lang.String endsWith(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatStringDoesNotEndWith}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStringDoesNotEndWithRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStringDoesNotEndWithRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatStringDoesNotEndWith`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringDoesNotEndWith {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(String string, String prefix) {\n        return assertThat(string.endsWith(prefix)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(String string, String prefix) {\n        return assertThat(string).doesNotEndWith(prefix);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.endsWith(#{prefix:any(java.lang.String)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).doesNotEndWith(#{prefix:any(java.lang.String)})")
                                    .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.lang.String endsWith(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatStringContains}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStringContainsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStringContainsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatStringContains`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringContains {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(String string, CharSequence substring) {\n        return assertThat(string.contains(substring)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(String string, CharSequence substring) {\n        return assertThat(string).contains(substring);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.contains(#{substring:any(java.lang.CharSequence)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).contains(#{substring:any(java.lang.CharSequence)})")
                                    .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.lang.String contains(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatStringDoesNotContain}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStringDoesNotContainRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStringDoesNotContainRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatStringDoesNotContain`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringDoesNotContain {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(String string, CharSequence substring) {\n        return assertThat(string.contains(substring)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(String string, CharSequence substring) {\n        return assertThat(string).doesNotContain(substring);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.contains(#{substring:any(java.lang.CharSequence)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).doesNotContain(#{substring:any(java.lang.CharSequence)})")
                                    .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.lang.String contains(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatMatches}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMatchesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMatchesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatMatches`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMatches {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(String string, String regex) {\n        return assertThat(string.matches(regex)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractAssert<?, ?> after(String string, String regex) {\n        return assertThat(string).matches(regex);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.matches(#{regex:any(java.lang.String)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).matches(#{regex:any(java.lang.String)})")
                                    .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesMethod<>("java.lang.String matches(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatDoesNotMatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatDoesNotMatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatDoesNotMatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatDoesNotMatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoesNotMatch {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(String string, String regex) {\n        return assertThat(string.matches(regex)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractAssert<?, ?> after(String string, String regex) {\n        return assertThat(string).doesNotMatch(regex);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.matches(#{regex:any(java.lang.String)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).doesNotMatch(#{regex:any(java.lang.String)})")
                                    .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesMethod<>("java.lang.String matches(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatPathContent}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatPathContentRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatPathContentRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatPathContent`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPathContent {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(Path path, Charset charset) throws IOException {\n        return assertThat(Files.readString(path, charset));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(Path path, Charset charset) {\n        return assertThat(path).content(charset);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, #{charset:any(java.nio.charset.Charset)}))")
                                .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.file.Files");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{path:any(java.nio.file.Path)}).content(#{charset:any(java.nio.charset.Charset)})")
                                    .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.nio.charset.Charset", true),
                            new UsesType<>("java.nio.file.Files", true),
                            new UsesType<>("java.nio.file.Path", true),
                            new UsesType<>("org.assertj.core.api.AbstractStringAssert", true),
                            new UsesMethod<>("java.nio.file.Files readString(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStringRules.AssertThatPathContentUtf8}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatPathContentUtf8Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatPathContentUtf8Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStringRules.AssertThatPathContentUtf8`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPathContentUtf8 {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(Path path) throws IOException {\n        return assertThat(Files.readString(path));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(Path path) {\n        return assertThat(path).content(UTF_8);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}))")
                                .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.file.Files");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{path:any(java.nio.file.Path)}).content(java.nio.charset.StandardCharsets.UTF_8)")
                                    .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.nio.file.Files", true),
                            new UsesType<>("java.nio.file.Path", true),
                            new UsesType<>("org.assertj.core.api.AbstractStringAssert", true),
                            new UsesMethod<>("java.nio.file.Files readString(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
