package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to AssertJ expressions and statements.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatOptionalDoubleRecipe(),
                new AssertThatOptionalIntRecipe(),
                new AssertThatOptionalLongRecipe(),
                new ObjectEnumerableContainsOneElementRecipe(),
                new ObjectEnumerableDoesNotContainOneElementRecipe(),
                new AssertThatSetContainsExactlyOneElementRecipe(),
                new AssertThatListsAreEqualRecipe(),
                new AssertThatSetsAreEqualRecipe(),
                new AssertThatMultisetsAreEqualRecipe(),
                new AssertThatMapContainsEntryRecipe(),
                new AssertThatStreamContainsAnyElementsOfRecipe(),
                new AssertThatStreamContainsAnyOfRecipe(),
                new AssertThatStreamContainsAllRecipe(),
                new AssertThatStreamContainsRecipe(),
                new AssertThatStreamContainsExactlyElementsOfRecipe(),
                new AssertThatStreamContainsExactlyRecipe(),
                new AssertThatStreamContainsExactlyInAnyOrderElementsOfRecipe(),
                new AssertThatStreamContainsExactlyInAnyOrderRecipe(),
                new AssertThatStreamContainsSequenceRecipe(),
                new AssertThatStreamContainsSubsequenceRecipe(),
                new AssertThatStreamDoesNotContainAnyElementsOfRecipe(),
                new AssertThatStreamDoesNotContainRecipe(),
                new AssertThatStreamDoesNotContainSequenceRecipe(),
                new AssertThatStreamHasSameElementsAsRecipe(),
                new AssertThatStreamContainsOnlyRecipe(),
                new AssertThatStreamIsSubsetOfRecipe(),
                new AssertThatStreamIsEmptyRecipe(),
                new AssertThatStreamIsNotEmptyRecipe(),
                new AssertThatStreamHasSizeRecipe(),
                new AssertThatPredicateAcceptsRecipe(),
                new AssertThatPredicateRejectsRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatOptionalDouble}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalDoubleRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalDoubleRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatOptionalDouble`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalDouble {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(OptionalDouble optional, double expected) {\n        return assertThat(optional.getAsDouble()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalDoubleAssert after(OptionalDouble optional, double expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalDouble)}.getAsDouble()).isEqualTo(#{expected:any(double)})")
                                .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalDouble)}).hasValue(#{expected:any(double)})")
                                    .bindType("org.assertj.core.api.OptionalDoubleAssert")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.OptionalDouble", true),
                            new UsesType<>("org.assertj.core.api.AbstractDoubleAssert", true),
                            new UsesMethod<>("java.util.OptionalDouble getAsDouble(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractDoubleAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatOptionalInt}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalIntRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalIntRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatOptionalInt`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalInt {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(OptionalInt optional, int expected) {\n        return assertThat(optional.getAsInt()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalIntAssert after(OptionalInt optional, int expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalInt)}.getAsInt()).isEqualTo(#{expected:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalInt)}).hasValue(#{expected:any(int)})")
                                    .bindType("org.assertj.core.api.OptionalIntAssert")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.OptionalInt", true),
                            new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                            new UsesMethod<>("java.util.OptionalInt getAsInt(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatOptionalLong}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalLongRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalLongRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatOptionalLong`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalLong {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(OptionalLong optional, long expected) {\n        return assertThat(optional.getAsLong()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalLongAssert after(OptionalLong optional, long expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalLong)}.getAsLong()).isEqualTo(#{expected:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalLong)}).hasValue(#{expected:any(long)})")
                                    .bindType("org.assertj.core.api.OptionalLongAssert")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.OptionalLong", true),
                            new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                            new UsesMethod<>("java.util.OptionalLong getAsLong(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.ObjectEnumerableContainsOneElement}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ObjectEnumerableContainsOneElementRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ObjectEnumerableContainsOneElementRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.ObjectEnumerableContainsOneElement`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ObjectEnumerableContainsOneElement<S, T extends S> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"unchecked\")\n    ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {\n        return Refaster.anyOf(iterAssert.containsAnyOf(element), iterAssert.containsSequence(element), iterAssert.containsSubsequence(element));\n    }\n    \n    @AfterTemplate\n    @SuppressWarnings(value = \"unchecked\")\n    ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {\n        return iterAssert.contains(element);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.containsAnyOf(#{element:any(T)})")
                                .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.contains(#{element:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.containsSequence(#{element:any(T)})")
                                .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.contains(#{element:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.containsSubsequence(#{element:any(T)})")
                                .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.contains(#{element:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.ObjectEnumerableAssert", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.ObjectEnumerableAssert containsAnyOf(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.ObjectEnumerableAssert containsSequence(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.ObjectEnumerableAssert containsSubsequence(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.ObjectEnumerableDoesNotContainOneElement}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ObjectEnumerableDoesNotContainOneElementRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ObjectEnumerableDoesNotContainOneElementRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.ObjectEnumerableDoesNotContainOneElement`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ObjectEnumerableDoesNotContainOneElement<S, T extends S> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"unchecked\")\n    ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {\n        return iterAssert.doesNotContainSequence(element);\n    }\n    \n    @AfterTemplate\n    @SuppressWarnings(value = \"unchecked\")\n    ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {\n        return iterAssert.doesNotContain(element);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.doesNotContainSequence(#{element:any(T)})")
                                .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.doesNotContain(#{element:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.ObjectEnumerableAssert", true),
                            new UsesMethod<>("org.assertj.core.api.ObjectEnumerableAssert doesNotContainSequence(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatSetContainsExactlyOneElement}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatSetContainsExactlyOneElementRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatSetContainsExactlyOneElementRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatSetContainsExactlyOneElement`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatSetContainsExactlyOneElement<S, T extends S> {\n    \n    @BeforeTemplate\n    ObjectEnumerableAssert<?, S> before(Set<S> set, T element) {\n        return assertThat(set).containsOnly(element);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectEnumerableAssert<?, S> after(Set<S> set, T element) {\n        return assertThat(set).containsExactly(element);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{set:any(java.util.Set<S>)}).containsOnly(#{element:any(T)})")
                                .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{set:any(java.util.Set<S>)}).containsExactly(#{element:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            new UsesType<>("org.assertj.core.api.ObjectEnumerableAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsOnly(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatListsAreEqual}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatListsAreEqualRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatListsAreEqualRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatListsAreEqual`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatListsAreEqual<S, T extends S> {\n    \n    @BeforeTemplate\n    ListAssert<S> before(List<S> list1, Iterable<T> list2) {\n        return assertThat(list1).isEqualTo(list2);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(List<S> list1, Iterable<T> list2) {\n        return assertThat(list1).containsExactlyElementsOf(list2);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{list1:any(java.util.List<S>)}).isEqualTo(#{list2:any(java.lang.Iterable<T>)})")
                                .bindType("org.assertj.core.api.ListAssert<S>")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{list1:any(java.util.List<S>)}).containsExactlyElementsOf(#{list2:any(java.lang.Iterable<T>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.List", true),
                            new UsesType<>("org.assertj.core.api.ListAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            new UsesMethod<>("org.assertj.core.api.ListAssert isEqualTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatSetsAreEqual}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatSetsAreEqualRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatSetsAreEqualRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatSetsAreEqual`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatSetsAreEqual<S, T extends S> {\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, ?, S, ?> before(Set<S> set1, Iterable<T> set2) {\n        return Refaster.anyOf(assertThat(set1).isEqualTo(set2), assertThat(set1).containsExactlyInAnyOrderElementsOf(set2));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractCollectionAssert<?, ?, S, ?> after(Set<S> set1, Iterable<T> set2) {\n        return assertThat(set1).hasSameElementsAs(set2);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{set1:any(java.util.Set<S>)}).isEqualTo(#{set2:any(java.lang.Iterable<T>)})")
                                .bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{set1:any(java.util.Set<S>)}).hasSameElementsAs(#{set2:any(java.lang.Iterable<T>)})")
                                    .bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{set1:any(java.util.Set<S>)}).containsExactlyInAnyOrderElementsOf(#{set2:any(java.lang.Iterable<T>)})")
                                .bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{set1:any(java.util.Set<S>)}).hasSameElementsAs(#{set2:any(java.lang.Iterable<T>)})")
                                    .bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            new UsesType<>("org.assertj.core.api.AbstractCollectionAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsExactlyInAnyOrderElementsOf(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isEqualTo(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatMultisetsAreEqual}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMultisetsAreEqualRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMultisetsAreEqualRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatMultisetsAreEqual`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMultisetsAreEqual<S, T extends S> {\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, ?, S, ?> before(Multiset<S> multiset1, Iterable<T> multiset2) {\n        return assertThat(multiset1).isEqualTo(multiset2);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractCollectionAssert<?, ?, S, ?> after(Multiset<S> multiset1, Iterable<T> multiset2) {\n        return assertThat(multiset1).containsExactlyInAnyOrderElementsOf(multiset2);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{multiset1:any(com.google.common.collect.Multiset<S>)}).isEqualTo(#{multiset2:any(java.lang.Iterable<T>)})")
                                .bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{multiset1:any(com.google.common.collect.Multiset<S>)}).containsExactlyInAnyOrderElementsOf(#{multiset2:any(java.lang.Iterable<T>)})")
                                    .bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Multiset", true),
                            new UsesType<>("org.assertj.core.api.AbstractCollectionAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatMapContainsEntry}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMapContainsEntryRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMapContainsEntryRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatMapContainsEntry`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMapContainsEntry<K, V> {\n    \n    @BeforeTemplate\n    ObjectAssert<V> before(Map<K, V> map, K key, V value) {\n        return assertThat(map.get(key)).isEqualTo(value);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    MapAssert<K, V> after(Map<K, V> map, K key, V value) {\n        return assertThat(map).containsEntry(key, value);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.get(#{key:any(K)})).isEqualTo(#{value:any(V)})")
                                .bindType("org.assertj.core.api.ObjectAssert<V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.ObjectAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).containsEntry(#{key:any(K)}, #{value:any(V)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("org.assertj.core.api.ObjectAssert", true),
                            new UsesMethod<>("java.util.Map get(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsAnyElementsOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsAnyElementsOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsAnyElementsOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsAnyElementsOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsAnyElementsOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAnyElementsOf(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAnyElementsOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsAnyElementsOf(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).containsAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsAnyElementsOf(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.IterableAssert", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsAnyOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsAnyOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsAnyOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsAnyOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsAnyOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAnyOf(array);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAnyOf(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).containsAnyOf(array);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).containsAnyOf(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAnyOf(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsAnyOf(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAnyOf(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsAnyOf(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.IterableAssert", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsAll}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsAllRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsAllRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsAll`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsAll<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAll(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAll(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsAll(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).containsAll(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAll(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsAll(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAll(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsAll(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.IterableAssert", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContains}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContains`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContains<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).contains(array);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).contains(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).contains(array);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).contains(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).contains(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).contains(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).contains(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert contains(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.IterableAssert", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsExactlyElementsOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsExactlyElementsOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsExactlyElementsOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsExactlyElementsOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsExactlyElementsOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyElementsOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsExactlyElementsOf(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsExactlyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.List", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("org.assertj.core.api.ListAssert", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsExactlyElementsOf(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsExactly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsExactlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsExactlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsExactly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsExactly<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactly(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).containsExactly(array);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsExactly(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactly(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.List", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("org.assertj.core.api.ListAssert", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsExactly(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsExactlyInAnyOrderElementsOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsExactlyInAnyOrderElementsOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsExactlyInAnyOrderElementsOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsExactlyInAnyOrderElementsOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsExactlyInAnyOrderElementsOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyInAnyOrderElementsOf(iterable);\n    }\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Multiset<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyInAnyOrderElementsOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsExactlyInAnyOrderElementsOf(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsExactlyInAnyOrderElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyInAnyOrderElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends com.google.common.collect.Multiset<T>>)})).containsExactlyInAnyOrderElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, T, ?>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("com.google.common.collect.Multiset");
                        maybeRemoveImport("org.assertj.core.api.AbstractCollectionAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyInAnyOrderElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsExactlyInAnyOrderElementsOf(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multiset", true),
                                            new UsesType<>("org.assertj.core.api.AbstractCollectionAssert", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsExactlyInAnyOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsExactlyInAnyOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsExactlyInAnyOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsExactlyInAnyOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsExactlyInAnyOrder<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyInAnyOrder(array);\n    }\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends Multiset<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyInAnyOrder(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).containsExactlyInAnyOrder(array);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsExactlyInAnyOrder(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyInAnyOrder(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends com.google.common.collect.Multiset<T>>)})).containsExactlyInAnyOrder(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, T, ?>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("com.google.common.collect.Multiset");
                        maybeRemoveImport("org.assertj.core.api.AbstractCollectionAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyInAnyOrder(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsExactlyInAnyOrder(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multiset", true),
                                            new UsesType<>("org.assertj.core.api.AbstractCollectionAssert", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsSequence}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsSequenceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsSequenceRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsSequence`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsSequence<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsSequence(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsSequence(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsSequence(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsSequence(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsSequence(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsSequence(#{iterable:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsSequence(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.List", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("org.assertj.core.api.ListAssert", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsSequence(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsSubsequence}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsSubsequenceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsSubsequenceRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsSubsequence`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsSubsequence<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsSubsequence(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsSubsequence(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsSubsequence(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsSubsequence(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsSubsequence(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsSubsequence(#{iterable:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsSubsequence(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.List", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("org.assertj.core.api.ListAssert", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsSubsequence(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamDoesNotContainAnyElementsOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamDoesNotContainAnyElementsOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamDoesNotContainAnyElementsOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamDoesNotContainAnyElementsOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamDoesNotContainAnyElementsOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContainAnyElementsOf(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContainAnyElementsOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).doesNotContainAnyElementsOf(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).doesNotContainAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContainAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).doesNotContainAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContainAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert doesNotContainAnyElementsOf(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.IterableAssert", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamDoesNotContain}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamDoesNotContainRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamDoesNotContainRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamDoesNotContain`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamDoesNotContain<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContain(array);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContain(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).doesNotContain(array);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).doesNotContain(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContain(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).doesNotContain(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContain(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert doesNotContain(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.IterableAssert", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamDoesNotContainSequence}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamDoesNotContainSequenceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamDoesNotContainSequenceRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamDoesNotContainSequence`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamDoesNotContainSequence<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContainSequence(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContainSequence(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).doesNotContainSequence(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).doesNotContainSequence(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContainSequence(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).doesNotContainSequence(#{iterable:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContainSequence(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.List", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("org.assertj.core.api.ListAssert", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert doesNotContainSequence(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamHasSameElementsAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamHasSameElementsAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamHasSameElementsAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamHasSameElementsAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamHasSameElementsAs<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).hasSameElementsAs(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).hasSameElementsAs(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).hasSameElementsAs(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).hasSameElementsAs(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).hasSameElementsAs(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).hasSameElementsAs(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).hasSameElementsAs(#{iterable:any(java.lang.Iterable<U>)})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert hasSameElementsAs(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.IterableAssert", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamContainsOnly}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamContainsOnlyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamContainsOnlyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamContainsOnly`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsOnly<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).containsOnly(array);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsOnly(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).containsOnly(array);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).containsOnly(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsOnly(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsOnly(#{array:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsOnly(#{array:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsOnly(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.IterableAssert", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamIsSubsetOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamIsSubsetOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamIsSubsetOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamIsSubsetOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamIsSubsetOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).isSubsetOf(iterable);\n    }\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).isSubsetOf(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).isSubsetOf(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).isSubsetOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] iterable) {\n        return assertThat(stream).isSubsetOf(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before2;
                JavaTemplate before20;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).isSubsetOf(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isSubsetOf(#{iterable:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).isSubsetOf(#{iterable:any(U[])})")
                                .bindType("org.assertj.core.api.IterableAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isSubsetOf(#{iterable:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).isSubsetOf(#{iterable:any(java.lang.Iterable<U>)})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isSubsetOf(#{iterable:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before20 == null) {
                        before20 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).isSubsetOf(#{iterable:any(U[])})")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("S", "T extends S", "U extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before20.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isSubsetOf(#{iterable:any(U[])})")
                                    .bindType("org.assertj.core.api.ListAssert<S>")
                                    .genericTypes("S", "T extends S", "U extends T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isSubsetOf(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.IterableAssert", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesType<>("org.assertj.core.api.ListAssert", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamIsEmpty<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector) {\n        assertThat(stream.collect(collector)).isEmpty();\n    }\n    \n    @BeforeTemplate\n    void before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector) {\n        assertThat(stream.collect(collector)).isEmpty();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Stream<S> stream) {\n        assertThat(stream).isEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).isEmpty();")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isEmpty();")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).isEmpty();")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isEmpty();")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isEmpty(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamIsNotEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamIsNotEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamIsNotEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamIsNotEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamIsNotEmpty<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector) {\n        assertThat(stream.collect(collector)).isNotEmpty();\n    }\n    \n    @BeforeTemplate\n    void before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector) {\n        assertThat(stream.collect(collector)).isNotEmpty();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Stream<S> stream) {\n        assertThat(stream).isNotEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).isNotEmpty();")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isNotEmpty();")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).isNotEmpty();")
                                .genericTypes("S", "T extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isNotEmpty();")
                                    .genericTypes("S", "T extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isNotEmpty(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatStreamHasSize}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatStreamHasSizeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatStreamHasSizeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatStreamHasSize`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamHasSize<T> {\n    \n    @BeforeTemplate\n    void before(Stream<T> stream, int size) {\n        assertThat(stream.count()).isEqualTo(size);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Stream<T> stream, int size) {\n        assertThat(stream).hasSize(size);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.count()).isEqualTo(#{size:any(int)});")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).hasSize(#{size:any(int)});")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream count(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatPredicateAccepts}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatPredicateAcceptsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatPredicateAcceptsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatPredicateAccepts`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPredicateAccepts<T> {\n    \n    @BeforeTemplate\n    void before(Predicate<T> predicate, T object) {\n        assertThat(predicate.test(object)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Predicate<T> predicate, T object) {\n        assertThat(predicate).accepts(object);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{predicate:any(java.util.function.Predicate<T>)}.test(#{object:any(T)})).isTrue();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{predicate:any(java.util.function.Predicate<T>)}).accepts(#{object:any(T)});")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesMethod<>("java.util.function.Predicate test(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJRules.AssertThatPredicateRejects}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatPredicateRejectsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatPredicateRejectsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJRules.AssertThatPredicateRejects`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPredicateRejects<T> {\n    \n    @BeforeTemplate\n    void before(Predicate<T> predicate, T object) {\n        assertThat(predicate.test(object)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Predicate<T> predicate, T object) {\n        assertThat(predicate).rejects(object);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{predicate:any(java.util.function.Predicate<T>)}.test(#{object:any(T)})).isFalse();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{predicate:any(java.util.function.Predicate<T>)}).rejects(#{object:any(T)});")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesMethod<>("java.util.function.Predicate test(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
