package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJPrimitiveRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJPrimitiveRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJPrimitiveRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJPrimitiveRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJPrimitiveRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJPrimitiveRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatIsEqualToRecipe(),
                new AssertThatIsNotEqualToRecipe(),
                new AssertThatIsLessThanRecipe(),
                new AssertThatIsLessThanOrEqualToRecipe(),
                new AssertThatIsGreaterThanRecipe(),
                new AssertThatIsGreaterThanOrEqualToRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(boolean actual, boolean expected) {\n        return Refaster.anyOf(assertThat(actual).isSameAs(expected), assertThat(actual).isSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(byte actual, byte expected) {\n        return Refaster.anyOf(assertThat(actual).isSameAs(expected), assertThat(actual).isSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractCharacterAssert<?> before(char actual, char expected) {\n        return Refaster.anyOf(assertThat(actual).isSameAs(expected), assertThat(actual).isSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(short actual, short expected) {\n        return Refaster.anyOf(assertThat(actual).isSameAs(expected), assertThat(actual).isSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(int actual, int expected) {\n        return Refaster.anyOf(assertThat(actual).isSameAs(expected), assertThat(actual).isSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(long actual, long expected) {\n        return Refaster.anyOf(assertThat(actual).isSameAs(expected), assertThat(actual).isSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(float actual, float expected) {\n        return Refaster.anyOf(assertThat(actual).isSameAs(expected), assertThat(actual).isSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual).isSameAs(expected), assertThat(actual).isSameAs(expected));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractBooleanAssert<?> after(boolean actual, boolean expected) {\n        return assertThat(actual).isEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1$0;
                JavaTemplate before1$1;
                JavaTemplate before2$0;
                JavaTemplate before2$1;
                JavaTemplate before3$0;
                JavaTemplate before3$1;
                JavaTemplate before4$0;
                JavaTemplate before4$1;
                JavaTemplate before5$0;
                JavaTemplate before5$1;
                JavaTemplate before6$0;
                JavaTemplate before6$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isSameAs(#{expected:any(boolean)})")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isSameAs(#{expected:any(boolean)})")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(byte)}).isSameAs(#{expected:any(byte)})")
                                .bindType("org.assertj.core.api.AbstractByteAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(byte)}).isSameAs(#{expected:any(byte)})")
                                .bindType("org.assertj.core.api.AbstractByteAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1$0 == null) {
                        before1$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(char)}).isSameAs(#{expected:any(char)})")
                                .bindType("org.assertj.core.api.AbstractCharacterAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractCharacterAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1$1 == null) {
                        before1$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(char)}).isSameAs(#{expected:any(char)})")
                                .bindType("org.assertj.core.api.AbstractCharacterAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractCharacterAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$0 == null) {
                        before2$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(short)}).isSameAs(#{expected:any(short)})")
                                .bindType("org.assertj.core.api.AbstractShortAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$1 == null) {
                        before2$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(short)}).isSameAs(#{expected:any(short)})")
                                .bindType("org.assertj.core.api.AbstractShortAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3$0 == null) {
                        before3$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(int)}).isSameAs(#{expected:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before3$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3$1 == null) {
                        before3$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(int)}).isSameAs(#{expected:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before3$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4$0 == null) {
                        before4$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(long)}).isSameAs(#{expected:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before4$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4$1 == null) {
                        before4$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(long)}).isSameAs(#{expected:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before4$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5$0 == null) {
                        before5$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).isSameAs(#{expected:any(float)})")
                                .bindType("org.assertj.core.api.AbstractFloatAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before5$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5$1 == null) {
                        before5$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).isSameAs(#{expected:any(float)})")
                                .bindType("org.assertj.core.api.AbstractFloatAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before5$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6$0 == null) {
                        before6$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isSameAs(#{expected:any(double)})")
                                .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before6$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6$1 == null) {
                        before6$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isSameAs(#{expected:any(double)})")
                                .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before6$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isSameAs(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractByteAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractCharacterAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractDoubleAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractFloatAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractShortAssert", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsNotEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsNotEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNotEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsNotEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(boolean actual, boolean expected) {\n        return Refaster.anyOf(assertThat(actual).isNotSameAs(expected), assertThat(actual).isNotSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(byte actual, byte expected) {\n        return Refaster.anyOf(assertThat(actual).isNotSameAs(expected), assertThat(actual).isNotSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractCharacterAssert<?> before(char actual, char expected) {\n        return Refaster.anyOf(assertThat(actual).isNotSameAs(expected), assertThat(actual).isNotSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(short actual, short expected) {\n        return Refaster.anyOf(assertThat(actual).isNotSameAs(expected), assertThat(actual).isNotSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(int actual, int expected) {\n        return Refaster.anyOf(assertThat(actual).isNotSameAs(expected), assertThat(actual).isNotSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(long actual, long expected) {\n        return Refaster.anyOf(assertThat(actual).isNotSameAs(expected), assertThat(actual).isNotSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(float actual, float expected) {\n        return Refaster.anyOf(assertThat(actual).isNotSameAs(expected), assertThat(actual).isNotSameAs(expected));\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<? extends AbstractDoubleAssert<?>> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual).isNotSameAs(expected), assertThat(actual).isNotSameAs(expected));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractBooleanAssert<?> after(boolean actual, boolean expected) {\n        return assertThat(actual).isNotEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1$0;
                JavaTemplate before1$1;
                JavaTemplate before2$0;
                JavaTemplate before2$1;
                JavaTemplate before3$0;
                JavaTemplate before3$1;
                JavaTemplate before4$0;
                JavaTemplate before4$1;
                JavaTemplate before5$0;
                JavaTemplate before5$1;
                JavaTemplate before6$0;
                JavaTemplate before6$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotSameAs(#{expected:any(boolean)})")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotSameAs(#{expected:any(boolean)})")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(byte)}).isNotSameAs(#{expected:any(byte)})")
                                .bindType("org.assertj.core.api.AbstractByteAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(byte)}).isNotSameAs(#{expected:any(byte)})")
                                .bindType("org.assertj.core.api.AbstractByteAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1$0 == null) {
                        before1$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(char)}).isNotSameAs(#{expected:any(char)})")
                                .bindType("org.assertj.core.api.AbstractCharacterAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractCharacterAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before1$1 == null) {
                        before1$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(char)}).isNotSameAs(#{expected:any(char)})")
                                .bindType("org.assertj.core.api.AbstractCharacterAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractCharacterAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$0 == null) {
                        before2$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(short)}).isNotSameAs(#{expected:any(short)})")
                                .bindType("org.assertj.core.api.AbstractShortAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$1 == null) {
                        before2$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(short)}).isNotSameAs(#{expected:any(short)})")
                                .bindType("org.assertj.core.api.AbstractShortAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3$0 == null) {
                        before3$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(int)}).isNotSameAs(#{expected:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before3$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before3$1 == null) {
                        before3$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(int)}).isNotSameAs(#{expected:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before3$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4$0 == null) {
                        before4$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(long)}).isNotSameAs(#{expected:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before4$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before4$1 == null) {
                        before4$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(long)}).isNotSameAs(#{expected:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before4$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5$0 == null) {
                        before5$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).isNotSameAs(#{expected:any(float)})")
                                .bindType("org.assertj.core.api.AbstractFloatAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before5$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before5$1 == null) {
                        before5$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).isNotSameAs(#{expected:any(float)})")
                                .bindType("org.assertj.core.api.AbstractFloatAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before5$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6$0 == null) {
                        before6$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isNotSameAs(#{expected:any(double)})")
                                .bindType("org.assertj.core.api.AbstractDoubleAssert<? extends org.assertj.core.api.AbstractDoubleAssert<?>>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before6$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before6$1 == null) {
                        before6$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isNotSameAs(#{expected:any(double)})")
                                .bindType("org.assertj.core.api.AbstractDoubleAssert<? extends org.assertj.core.api.AbstractDoubleAssert<?>>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before6$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                                    .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isNotSameAs(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractByteAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractCharacterAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractDoubleAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractFloatAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractShortAssert", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsLessThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsLessThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsLessThanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsLessThan`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsLessThan {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual < expected).isTrue(), assertThat(actual >= expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractDoubleAssert<?> after(double actual, double expected) {\n        return assertThat(actual).isLessThan(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} < #{expected:any(double)}).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isLessThan(#{expected:any(double)})")
                                    .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} >= #{expected:any(double)}).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isLessThan(#{expected:any(double)})")
                                    .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsLessThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsLessThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsLessThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsLessThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsLessThanOrEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual <= expected).isTrue(), assertThat(actual > expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractDoubleAssert<?> after(double actual, double expected) {\n        return assertThat(actual).isLessThanOrEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} <= #{expected:any(double)}).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isLessThanOrEqualTo(#{expected:any(double)})")
                                    .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} > #{expected:any(double)}).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isLessThanOrEqualTo(#{expected:any(double)})")
                                    .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsGreaterThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsGreaterThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsGreaterThanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsGreaterThan`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsGreaterThan {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual > expected).isTrue(), assertThat(actual <= expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractDoubleAssert<?> after(double actual, double expected) {\n        return assertThat(actual).isGreaterThan(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} > #{expected:any(double)}).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isGreaterThan(#{expected:any(double)})")
                                    .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} <= #{expected:any(double)}).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isGreaterThan(#{expected:any(double)})")
                                    .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsGreaterThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsGreaterThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsGreaterThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsGreaterThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsGreaterThanOrEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual >= expected).isTrue(), assertThat(actual < expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractDoubleAssert<?> after(double actual, double expected) {\n        return assertThat(actual).isGreaterThanOrEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} >= #{expected:any(double)}).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isGreaterThanOrEqualTo(#{expected:any(double)})")
                                    .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} < #{expected:any(double)}).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isGreaterThanOrEqualTo(#{expected:any(double)})")
                                    .bindType("org.assertj.core.api.AbstractDoubleAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
