package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJObjectRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJObjectRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJObjectRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJObjectRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJObjectRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJObjectRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatIsInstanceOf2Recipe(),
                new AssertThatIsIsEqualToRecipe(),
                new AssertThatIsIsNotEqualToRecipe(),
                new AssertThatHasToStringRecipe(),
                new AssertThatIsSameAsRecipe(),
                new AssertThatIsNotSameAsRecipe(),
                new AssertThatIsNullRecipe(),
                new AssertThatIsNotNullRecipe(),
                new AssertThatHasSameHashCodeAsRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJObjectRules.AssertThatIsInstanceOf2}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsInstanceOf2Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsInstanceOf2Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJObjectRules.AssertThatIsInstanceOf2`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsInstanceOf2<S, T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(T object, Class<S> clazz) {\n        return assertThat(clazz.isInstance(object)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object, Class<S> clazz) {\n        return assertThat(object).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{clazz:any(java.lang.Class<S>)}.isInstance(#{object:any(T)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .genericTypes("S", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isInstanceOf(#{clazz:any(java.lang.Class<S>)})")
                                    .bindType("org.assertj.core.api.ObjectAssert<T>")
                                    .genericTypes("S", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.lang.Class isInstance(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJObjectRules.AssertThatIsIsEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsIsEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsIsEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJObjectRules.AssertThatIsIsEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsIsEqualTo<S, T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(S object1, T object2) {\n        return assertThat(object1.equals(object2)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<S> after(S object1, T object2) {\n        return assertThat(object1).isEqualTo(object2);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(S)}.equals(#{object2:any(T)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .genericTypes("S", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(S)}).isEqualTo(#{object2:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectAssert<S>")
                                    .genericTypes("S", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.lang.Object equals(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJObjectRules.AssertThatIsIsNotEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsIsNotEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsIsNotEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJObjectRules.AssertThatIsIsNotEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsIsNotEqualTo<S, T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(S object1, T object2) {\n        return assertThat(object1.equals(object2)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<S> after(S object1, T object2) {\n        return assertThat(object1).isNotEqualTo(object2);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(S)}.equals(#{object2:any(T)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .genericTypes("S", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(S)}).isNotEqualTo(#{object2:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectAssert<S>")
                                    .genericTypes("S", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.lang.Object equals(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJObjectRules.AssertThatHasToString}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatHasToStringRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatHasToStringRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJObjectRules.AssertThatHasToString`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasToString<T> {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(T object, String str) {\n        return assertThat(object.toString()).isEqualTo(str);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object, String str) {\n        return assertThat(object).hasToString(str);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)}.toString()).isEqualTo(#{str:any(java.lang.String)})")
                                .bindType("org.assertj.core.api.AbstractStringAssert<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractStringAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).hasToString(#{str:any(java.lang.String)})")
                                    .bindType("org.assertj.core.api.ObjectAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractStringAssert", true),
                            new UsesMethod<>("java.lang.Object toString(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractStringAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJObjectRules.AssertThatIsSameAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsSameAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsSameAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJObjectRules.AssertThatIsSameAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsSameAs<T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(T object1, T object2) {\n        return Refaster.anyOf(assertThat(object1 == object2).isTrue(), assertThat(object1 != object2).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object1, T object2) {\n        return assertThat(object1).isSameAs(object2);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)} == #{object2:any(T)}).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).isSameAs(#{object2:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)} != #{object2:any(T)}).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).isSameAs(#{object2:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJObjectRules.AssertThatIsNotSameAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsNotSameAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNotSameAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJObjectRules.AssertThatIsNotSameAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotSameAs<T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(T object1, T object2) {\n        return Refaster.anyOf(assertThat(object1 == object2).isFalse(), assertThat(object1 != object2).isTrue());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object1, T object2) {\n        return assertThat(object1).isNotSameAs(object2);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)} == #{object2:any(T)}).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).isNotSameAs(#{object2:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)} != #{object2:any(T)}).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).isNotSameAs(#{object2:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJObjectRules.AssertThatIsNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJObjectRules.AssertThatIsNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNull<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatIsSameAs\")\n    void before(T object) {\n        assertThat(object == null).isTrue();\n    }\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatIsSameAs\")\n    void before2(T object) {\n        assertThat(object != null).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(T object) {\n        assertThat(object).isNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)} == null).isTrue();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isNull();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)} != null).isFalse();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isNull();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJObjectRules.AssertThatIsNotNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsNotNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNotNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJObjectRules.AssertThatIsNotNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotNull<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatIsNotSameAs\")\n    AbstractBooleanAssert<? extends AbstractBooleanAssert<?>> before(T object) {\n        return Refaster.anyOf(assertThat(object == null).isFalse(), assertThat(object != null).isTrue());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object) {\n        return assertThat(object).isNotNull();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)} == null).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<? extends org.assertj.core.api.AbstractBooleanAssert<?>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isNotNull()")
                                    .bindType("org.assertj.core.api.ObjectAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)} != null).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<? extends org.assertj.core.api.AbstractBooleanAssert<?>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isNotNull()")
                                    .bindType("org.assertj.core.api.ObjectAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJObjectRules.AssertThatHasSameHashCodeAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatHasSameHashCodeAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatHasSameHashCodeAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJObjectRules.AssertThatHasSameHashCodeAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasSameHashCodeAs<T> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T object1, T object2) {\n        return assertThat(object1.hashCode()).isEqualTo(object2.hashCode());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object1, T object2) {\n        return assertThat(object1).hasSameHashCodeAs(object2);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}.hashCode()).isEqualTo(#{object2:any(T)}.hashCode())")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).hasSameHashCodeAs(#{object2:any(T)})")
                                    .bindType("org.assertj.core.api.ObjectAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                            new UsesMethod<>("java.lang.Object hashCode(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
