package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJIterableRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJIterableRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJIterableRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJIterableRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJIterableRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJIterableRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatIterableIsEmptyRecipe(),
                new AssertThatIterableIsNotEmptyRecipe(),
                new AssertThatIterableSizeRecipe(),
                new AssertThatIterableHasOneElementEqualToRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJIterableRules.AssertThatIterableIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIterableIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIterableIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJIterableRules.AssertThatIterableIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIterableIsEmpty<E> {\n    \n    @BeforeTemplate\n    void before(Iterable<E> iterable) {\n        assertThat(iterable.iterator()).isExhausted();\n    }\n    \n    @BeforeTemplate\n    void before(Collection<E> iterable) {\n        assertThat(iterable.isEmpty()).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Iterable<E> iterable) {\n        assertThat(iterable).isEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}.iterator()).isExhausted();")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}).isEmpty();")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.util.Collection<E>)}.isEmpty()).isTrue();")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}).isEmpty();")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.lang.Iterable iterator(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIteratorAssert isExhausted(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("java.util.Collection isEmpty(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJIterableRules.AssertThatIterableIsNotEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIterableIsNotEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIterableIsNotEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJIterableRules.AssertThatIterableIsNotEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIterableIsNotEmpty<E> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Iterable<E> iterable) {\n        return assertThat(iterable.iterator()).hasNext();\n    }\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Collection<E> iterable) {\n        return assertThat(iterable.isEmpty()).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    IterableAssert<E> after(Iterable<E> iterable) {\n        return assertThat(iterable).isNotEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}.iterator()).hasNext()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}).isNotEmpty()")
                                    .bindType("org.assertj.core.api.IterableAssert<E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.util.Collection<E>)}.isEmpty()).isFalse()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}).isNotEmpty()")
                                    .bindType("org.assertj.core.api.IterableAssert<E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.lang.Iterable iterator(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIteratorAssert hasNext(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("java.util.Collection isEmpty(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJIterableRules.AssertThatIterableSize}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIterableSizeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIterableSizeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJIterableRules.AssertThatIterableSize`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIterableSize<E> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(Iterable<E> iterable) {\n        return assertThat(Iterables.size(iterable));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(Collection<E> iterable) {\n        return assertThat(iterable.size());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractIntegerAssert<?> after(Iterable<E> iterable) {\n        return assertThat(iterable).size();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(com.google.common.collect.Iterables.size(#{iterable:any(java.lang.Iterable<E>)}))")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Iterables");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}).size()")
                                    .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.util.Collection<E>)}.size())")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}).size()")
                                    .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Iterables", true),
                                            new UsesMethod<>("com.google.common.collect.Iterables size(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("java.util.Collection size(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJIterableRules.AssertThatIterableHasOneElementEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIterableHasOneElementEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIterableHasOneElementEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJIterableRules.AssertThatIterableHasOneElementEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIterableHasOneElementEqualTo<S, E extends S> {\n    \n    @BeforeTemplate\n    ObjectAssert<S> before(Iterable<S> iterable, E element) {\n        return assertThat(Iterables.getOnlyElement(iterable)).isEqualTo(element);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    IterableAssert<S> after(Iterable<S> iterable, E element) {\n        return assertThat(iterable).containsExactly(element);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(com.google.common.collect.Iterables.getOnlyElement(#{iterable:any(java.lang.Iterable<S>)})).isEqualTo(#{element:any(E)})")
                                .bindType("org.assertj.core.api.ObjectAssert<S>")
                                .genericTypes("S", "E extends S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Iterables");
                        maybeRemoveImport("org.assertj.core.api.ObjectAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<S>)}).containsExactly(#{element:any(E)})")
                                    .bindType("org.assertj.core.api.IterableAssert<S>")
                                    .genericTypes("S", "E extends S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Iterables", true),
                            new UsesType<>("org.assertj.core.api.ObjectAssert", true),
                            new UsesMethod<>("com.google.common.collect.Iterables getOnlyElement(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
