package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJInstantRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJInstantRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJInstantRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "Refaster rules related to AssertJ assertions over `Instant`s";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "These rules simplify and improve the readability of tests by using `Instant`-specific\n AssertJ assertion methods instead of generic assertions.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJInstantRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatIsAfterRecipe(),
                new AssertThatIsBeforeOrEqualToRecipe(),
                new AssertThatIsBeforeRecipe(),
                new AssertThatIsAfterOrEqualToRecipe(),
                new AssertThatIsBetweenRecipe(),
                new AssertThatIsStrictlyBetweenRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJInstantRules.AssertThatIsAfter}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsAfterRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsAfterRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJInstantRules.AssertThatIsAfter`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsAfter {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Instant actual, Instant other) {\n        return assertThat(actual.isAfter(other)).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant other) {\n        return assertThat(actual).isAfter(other);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}.isAfter(#{other:any(java.time.Instant)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isAfter(#{other:any(java.time.Instant)})")
                                    .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.time.Instant isAfter(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJInstantRules.AssertThatIsBeforeOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsBeforeOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsBeforeOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJInstantRules.AssertThatIsBeforeOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsBeforeOrEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Instant actual, Instant other) {\n        return assertThat(actual.isAfter(other)).isFalse();\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant other) {\n        return assertThat(actual).isBeforeOrEqualTo(other);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}.isAfter(#{other:any(java.time.Instant)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBeforeOrEqualTo(#{other:any(java.time.Instant)})")
                                    .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.time.Instant isAfter(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJInstantRules.AssertThatIsBefore}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsBeforeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsBeforeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJInstantRules.AssertThatIsBefore`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsBefore {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Instant actual, Instant other) {\n        return assertThat(actual.isBefore(other)).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant other) {\n        return assertThat(actual).isBefore(other);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}.isBefore(#{other:any(java.time.Instant)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBefore(#{other:any(java.time.Instant)})")
                                    .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.time.Instant isBefore(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJInstantRules.AssertThatIsAfterOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsAfterOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsAfterOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJInstantRules.AssertThatIsAfterOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsAfterOrEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Instant actual, Instant other) {\n        return assertThat(actual.isBefore(other)).isFalse();\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant other) {\n        return assertThat(actual).isAfterOrEqualTo(other);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}.isBefore(#{other:any(java.time.Instant)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isAfterOrEqualTo(#{other:any(java.time.Instant)})")
                                    .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                            new UsesMethod<>("java.time.Instant isBefore(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJInstantRules.AssertThatIsBetween}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsBetweenRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsBetweenRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJInstantRules.AssertThatIsBetween`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsBetween {\n    \n    @BeforeTemplate\n    AbstractInstantAssert<?> before(Instant actual, Instant start, Instant end) {\n        return Refaster.anyOf(assertThat(actual).isAfterOrEqualTo(start).isBeforeOrEqualTo(end), assertThat(actual).isBeforeOrEqualTo(end).isAfterOrEqualTo(start));\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant start, Instant end) {\n        return assertThat(actual).isBetween(start, end);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isAfterOrEqualTo(#{start:any(java.time.Instant)}).isBeforeOrEqualTo(#{end:any(java.time.Instant)})")
                                .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBetween(#{start:any(java.time.Instant)}, #{end:any(java.time.Instant)})")
                                    .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBeforeOrEqualTo(#{end:any(java.time.Instant)}).isAfterOrEqualTo(#{start:any(java.time.Instant)})")
                                .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBetween(#{start:any(java.time.Instant)}, #{end:any(java.time.Instant)})")
                                    .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("org.assertj.core.api.AbstractInstantAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractInstantAssert isAfterOrEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractInstantAssert isBeforeOrEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJInstantRules.AssertThatIsStrictlyBetween}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsStrictlyBetweenRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsStrictlyBetweenRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJInstantRules.AssertThatIsStrictlyBetween`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsStrictlyBetween {\n    \n    @BeforeTemplate\n    AbstractInstantAssert<?> before(Instant actual, Instant start, Instant end) {\n        return Refaster.anyOf(assertThat(actual).isAfter(start).isBefore(end), assertThat(actual).isBefore(end).isAfter(start));\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant start, Instant end) {\n        return assertThat(actual).isStrictlyBetween(start, end);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isAfter(#{start:any(java.time.Instant)}).isBefore(#{end:any(java.time.Instant)})")
                                .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isStrictlyBetween(#{start:any(java.time.Instant)}, #{end:any(java.time.Instant)})")
                                    .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBefore(#{end:any(java.time.Instant)}).isAfter(#{start:any(java.time.Instant)})")
                                .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isStrictlyBetween(#{start:any(java.time.Instant)}, #{end:any(java.time.Instant)})")
                                    .bindType("org.assertj.core.api.AbstractInstantAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("org.assertj.core.api.AbstractInstantAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractInstantAssert isAfter(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractInstantAssert isBefore(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
