package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJComparableRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJComparableRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJComparableRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJComparableRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJComparableRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJComparableRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatIsEqualByComparingToRecipe(),
                new AssertThatIsNotEqualByComparingToRecipe(),
                new AssertThatIsLessThanRecipe(),
                new AssertThatIsLessThanOrEqualToRecipe(),
                new AssertThatIsGreaterThanRecipe(),
                new AssertThatIsGreaterThanOrEqualToRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJComparableRules.AssertThatIsEqualByComparingTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsEqualByComparingToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsEqualByComparingToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJComparableRules.AssertThatIsEqualByComparingTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsEqualByComparingTo<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isEqualTo(0);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isEqualByComparingTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isEqualTo(0)")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isEqualByComparingTo(#{expected:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractComparableAssert<?, ?>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                            new UsesMethod<>("java.lang.Comparable compareTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJComparableRules.AssertThatIsNotEqualByComparingTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsNotEqualByComparingToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNotEqualByComparingToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJComparableRules.AssertThatIsNotEqualByComparingTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotEqualByComparingTo<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isNotEqualTo(0);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isNotEqualByComparingTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isNotEqualTo(0)")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isNotEqualByComparingTo(#{expected:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractComparableAssert<?, ?>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                            new UsesMethod<>("java.lang.Comparable compareTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isNotEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJComparableRules.AssertThatIsLessThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsLessThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsLessThanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJComparableRules.AssertThatIsLessThan`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsLessThan<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isNegative();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isLessThan(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isNegative()")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isLessThan(#{expected:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractComparableAssert<?, ?>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                            new UsesMethod<>("java.lang.Comparable compareTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isNegative(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJComparableRules.AssertThatIsLessThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsLessThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsLessThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJComparableRules.AssertThatIsLessThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsLessThanOrEqualTo<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isNotPositive();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isLessThanOrEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isNotPositive()")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isLessThanOrEqualTo(#{expected:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractComparableAssert<?, ?>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                            new UsesMethod<>("java.lang.Comparable compareTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isNotPositive(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJComparableRules.AssertThatIsGreaterThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsGreaterThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsGreaterThanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJComparableRules.AssertThatIsGreaterThan`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsGreaterThan<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isPositive();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isGreaterThan(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isPositive()")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isGreaterThan(#{expected:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractComparableAssert<?, ?>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                            new UsesMethod<>("java.lang.Comparable compareTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isPositive(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJComparableRules.AssertThatIsGreaterThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsGreaterThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsGreaterThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJComparableRules.AssertThatIsGreaterThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsGreaterThanOrEqualTo<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T actual, T expected) {\n        return assertThat(actual.compareTo(expected)).isNotNegative();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractComparableAssert<?, ?> after(T actual, T expected) {\n        return assertThat(actual).isGreaterThanOrEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}.compareTo(#{expected:any(T)})).isNotNegative()")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(T)}).isGreaterThanOrEqualTo(#{expected:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractComparableAssert<?, ?>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                            new UsesMethod<>("java.lang.Comparable compareTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isNotNegative(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
