/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ImmutableMapRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ImmutableMapRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `ImmutableMap`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableMapRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ImmutableMapBuilderRecipe(), new ImmutableMapBuilderBuildOrThrowRecipe(), new EntryToImmutableMapRecipe(), new EntryIterableToImmutableMapRecipe(), new ImmutableMapOfRecipe(), new ImmutableMapOf1Recipe(), new ImmutableMapOf2Recipe(), new ImmutableMapOf3Recipe(), new ImmutableMapOf4Recipe(), new ImmutableMapOf5Recipe()});
    }

    @NullMarked
    public static class ImmutableMapBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.ImmutableMapBuilder`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap#builder()` over the associated constructor.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableMap.Builder<>()").bindType("com.google.common.collect.ImmutableMap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.builder()").bindType("com.google.common.collect.ImmutableMap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.collect.ImmutableMap.Builder <init>(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableMapBuilderBuildOrThrowRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.ImmutableMapBuilderBuildOrThrow`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap.Builder#buildOrThrow()` over the less explicit `ImmutableMap.Builder#build()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{builder:any(com.google.common.collect.ImmutableMap.Builder<K, V>)}.build()").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{builder:any(com.google.common.collect.ImmutableMap.Builder<K, V>)}.buildOrThrow()").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap.Builder build(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EntryToImmutableMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.EntryToImmutableMap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap#of(Object, Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.<K, V>builder().put(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).buildOrThrow()").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).collect(com.google.common.collect.ImmutableMap.toImmutableMap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMap.toImmutableMap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableMap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableMap.Builder put(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap toImmutableMap(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EntryIterableToImmutableMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.EntryIterableToImmutableMap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap#copyOf(Iterable)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.util.Map<? extends K, ? extends V>)}.entrySet())").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.<K, V>builder().putAll(#{iterable:any(java.util.Map<? extends K, ? extends V>)}).buildOrThrow()").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.Map.copyOf(#{iterable:any(java.util.Map<? extends K, ? extends V>)})").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$0 == null) {
                        this.before0$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.<K, V>builder().putAll(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).buildOrThrow()").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$1 == null) {
                        this.before0$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).collect(com.google.common.collect.ImmutableMap.toImmutableMap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMap.toImmutableMap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"#{iterable:any(java.util.Collection<? extends java.util.Map.Entry<? extends K, ? extends V>>)}.stream().collect(com.google.common.collect.ImmutableMap.toImmutableMap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMap.toImmutableMap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableMap.Builder putAll(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap toImmutableMap(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap toImmutableMap(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableMap.Builder putAll(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap copyOf(..)", true), new UsesMethod("java.util.Map entrySet(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("java.util.Map copyOf(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableMapOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.ImmutableMapOf`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap#of()` over more contrived alternatives or alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.<K, V>builder().buildOrThrow()").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of()").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.ofEntries()").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of()").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.Collections.emptyMap()").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("java.util.Collections");
                        this.maybeRemoveImport("java.util.Collections.emptyMap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of()").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.util.Map.of()").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of()").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Collections emptyMap(..)", true), new UsesMethod("java.util.Map of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap ofEntries(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableMapOf1Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.ImmutableMapOf1`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap#of(Object, Object)` over more contrived alternatives or alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.<K, V>builder().put(#{k1:any(K)}, #{v1:any(V)}).buildOrThrow()").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}))").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.Collections.singletonMap(#{k1:any(K)}, #{v1:any(V)})").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("java.util.Collections");
                        this.maybeRemoveImport("java.util.Collections.singletonMap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.util.Map.of(#{k1:any(K)}, #{v1:any(V)})").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Collections singletonMap(..)", true), new UsesMethod("java.util.Map of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableMap.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableMap.Builder put(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap ofEntries(..)", true), new UsesMethod("java.util.Map entry(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableMapOf2Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.ImmutableMapOf2`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap#of(Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}), java.util.Map.entry(#{k2:any(K)}, #{v2:any(V)}))").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Map.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)})").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Map of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap ofEntries(..)", true), new UsesMethod("java.util.Map entry(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableMapOf3Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.ImmutableMapOf3`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap#of(Object, Object, Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}), java.util.Map.entry(#{k2:any(K)}, #{v2:any(V)}), java.util.Map.entry(#{k3:any(K)}, #{v3:any(V)}))").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Map.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)})").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Map of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap ofEntries(..)", true), new UsesMethod("java.util.Map entry(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableMapOf4Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.ImmutableMapOf4`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap#of(Object, Object, Object, Object, Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S107");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}), java.util.Map.entry(#{k2:any(K)}, #{v2:any(V)}), java.util.Map.entry(#{k3:any(K)}, #{v3:any(V)}), java.util.Map.entry(#{k4:any(K)}, #{v4:any(V)}))").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5), matcher.parameter(6), matcher.parameter(7)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Map.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)})").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5), matcher.parameter(6), matcher.parameter(7)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Map of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap ofEntries(..)", true), new UsesMethod("java.util.Map entry(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableMapOf5Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMapRules.ImmutableMapOf5`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMap#of(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)` over alternatives that don't communicate the immutability of the resulting map at the type level.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S107");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.ofEntries(java.util.Map.entry(#{k1:any(K)}, #{v1:any(V)}), java.util.Map.entry(#{k2:any(K)}, #{v2:any(V)}), java.util.Map.entry(#{k3:any(K)}, #{v3:any(V)}), java.util.Map.entry(#{k4:any(K)}, #{v4:any(V)}), java.util.Map.entry(#{k5:any(K)}, #{v5:any(V)}))").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)}, #{k5:any(K)}, #{v5:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5), matcher.parameter(6), matcher.parameter(7), matcher.parameter(8), matcher.parameter(9)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Map.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)}, #{k5:any(K)}, #{v5:any(V)})").bindType("java.util.Map<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMap.of(#{k1:any(K)}, #{v1:any(V)}, #{k2:any(K)}, #{v2:any(V)}, #{k3:any(K)}, #{v3:any(V)}, #{k4:any(K)}, #{v4:any(V)}, #{k5:any(K)}, #{v5:any(V)})").bindType("com.google.common.collect.ImmutableMap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5), matcher.parameter(6), matcher.parameter(7), matcher.parameter(8), matcher.parameter(9)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Map of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMap ofEntries(..)", true), new UsesMethod("java.util.Map entry(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }
}

