/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

final class TimeRules {
    private TimeRules() {
    }

    static final class ZonedDateTimeMinusYears {
        ZonedDateTimeMinusYears() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int years) {
            return zonedDateTime.minus(Period.ofYears(years));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long years) {
            return zonedDateTime.minus(years, ChronoUnit.YEARS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int years) {
            return zonedDateTime.minusYears(years);
        }
    }

    static final class ZonedDateTimeMinusMonths {
        ZonedDateTimeMinusMonths() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int months) {
            return zonedDateTime.minus(Period.ofMonths(months));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long months) {
            return zonedDateTime.minus(months, ChronoUnit.MONTHS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int months) {
            return zonedDateTime.minusMonths(months);
        }
    }

    static final class ZonedDateTimeMinusWeeks {
        ZonedDateTimeMinusWeeks() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int weeks) {
            return zonedDateTime.minus(Period.ofWeeks(weeks));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long weeks) {
            return zonedDateTime.minus(weeks, ChronoUnit.WEEKS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int weeks) {
            return zonedDateTime.minusWeeks(weeks);
        }
    }

    static final class ZonedDateTimeMinusDays {
        ZonedDateTimeMinusDays() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int days) {
            return zonedDateTime.minus(Period.ofDays(days));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long days) {
            return zonedDateTime.minus(days, ChronoUnit.DAYS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int days) {
            return zonedDateTime.minusDays(days);
        }
    }

    static final class ZonedDateTimeMinusHours {
        ZonedDateTimeMinusHours() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int hours) {
            return zonedDateTime.minus(Duration.ofHours(hours));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long hours) {
            return zonedDateTime.minus(hours, ChronoUnit.HOURS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int hours) {
            return zonedDateTime.minusHours(hours);
        }
    }

    static final class ZonedDateTimeMinusMinutes {
        ZonedDateTimeMinusMinutes() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int minutes) {
            return zonedDateTime.minus(Duration.ofMinutes(minutes));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long minutes) {
            return zonedDateTime.minus(minutes, ChronoUnit.MINUTES);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int minutes) {
            return zonedDateTime.minusMinutes(minutes);
        }
    }

    static final class ZonedDateTimeMinusSeconds {
        ZonedDateTimeMinusSeconds() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int seconds) {
            return zonedDateTime.minus(Duration.ofSeconds(seconds));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long seconds) {
            return zonedDateTime.minus(seconds, ChronoUnit.SECONDS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int seconds) {
            return zonedDateTime.minusSeconds(seconds);
        }
    }

    static final class ZonedDateTimeMinusNanos {
        ZonedDateTimeMinusNanos() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int nanos) {
            return zonedDateTime.minus(Duration.ofNanos(nanos));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long nanos) {
            return zonedDateTime.minus(nanos, ChronoUnit.NANOS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int nanos) {
            return zonedDateTime.minusNanos(nanos);
        }
    }

    static final class ZonedDateTimePlusYears {
        ZonedDateTimePlusYears() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int years) {
            return zonedDateTime.plus(Period.ofYears(years));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long years) {
            return zonedDateTime.plus(years, ChronoUnit.YEARS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int years) {
            return zonedDateTime.plusYears(years);
        }
    }

    static final class ZonedDateTimePlusMonths {
        ZonedDateTimePlusMonths() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int months) {
            return zonedDateTime.plus(Period.ofMonths(months));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long months) {
            return zonedDateTime.plus(months, ChronoUnit.MONTHS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int months) {
            return zonedDateTime.plusMonths(months);
        }
    }

    static final class ZonedDateTimePlusWeeks {
        ZonedDateTimePlusWeeks() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int weeks) {
            return zonedDateTime.plus(Period.ofWeeks(weeks));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long weeks) {
            return zonedDateTime.plus(weeks, ChronoUnit.WEEKS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int weeks) {
            return zonedDateTime.plusWeeks(weeks);
        }
    }

    static final class ZonedDateTimePlusDays {
        ZonedDateTimePlusDays() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int days) {
            return zonedDateTime.plus(Period.ofDays(days));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long days) {
            return zonedDateTime.plus(days, ChronoUnit.DAYS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int days) {
            return zonedDateTime.plusDays(days);
        }
    }

    static final class ZonedDateTimePlusHours {
        ZonedDateTimePlusHours() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int hours) {
            return zonedDateTime.plus(Duration.ofHours(hours));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long hours) {
            return zonedDateTime.plus(hours, ChronoUnit.HOURS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int hours) {
            return zonedDateTime.plusHours(hours);
        }
    }

    static final class ZonedDateTimePlusMinutes {
        ZonedDateTimePlusMinutes() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int minutes) {
            return zonedDateTime.plus(Duration.ofMinutes(minutes));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long minutes) {
            return zonedDateTime.plus(minutes, ChronoUnit.MINUTES);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int minutes) {
            return zonedDateTime.plusMinutes(minutes);
        }
    }

    static final class ZonedDateTimePlusSeconds {
        ZonedDateTimePlusSeconds() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int seconds) {
            return zonedDateTime.plus(Duration.ofSeconds(seconds));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long seconds) {
            return zonedDateTime.plus(seconds, ChronoUnit.SECONDS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int seconds) {
            return zonedDateTime.plusSeconds(seconds);
        }
    }

    static final class ZonedDateTimePlusNanos {
        ZonedDateTimePlusNanos() {
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, int nanos) {
            return zonedDateTime.plus(Duration.ofNanos(nanos));
        }

        ZonedDateTime before(ZonedDateTime zonedDateTime, long nanos) {
            return zonedDateTime.plus(nanos, ChronoUnit.NANOS);
        }

        ZonedDateTime after(ZonedDateTime zonedDateTime, int nanos) {
            return zonedDateTime.plusNanos(nanos);
        }
    }

    static final class OffsetDateTimeMinusYears {
        OffsetDateTimeMinusYears() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int years) {
            return offsetDateTime.minus(Period.ofYears(years));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long years) {
            return offsetDateTime.minus(years, ChronoUnit.YEARS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int years) {
            return offsetDateTime.minusYears(years);
        }
    }

    static final class OffsetDateTimeMinusMonths {
        OffsetDateTimeMinusMonths() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int months) {
            return offsetDateTime.minus(Period.ofMonths(months));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long months) {
            return offsetDateTime.minus(months, ChronoUnit.MONTHS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int months) {
            return offsetDateTime.minusMonths(months);
        }
    }

    static final class OffsetDateTimeMinusWeeks {
        OffsetDateTimeMinusWeeks() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int weeks) {
            return offsetDateTime.minus(Period.ofWeeks(weeks));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long weeks) {
            return offsetDateTime.minus(weeks, ChronoUnit.WEEKS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int weeks) {
            return offsetDateTime.minusWeeks(weeks);
        }
    }

    static final class OffsetDateTimeMinusDays {
        OffsetDateTimeMinusDays() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int days) {
            return offsetDateTime.minus(Period.ofDays(days));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long days) {
            return offsetDateTime.minus(days, ChronoUnit.DAYS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int days) {
            return offsetDateTime.minusDays(days);
        }
    }

    static final class OffsetDateTimeMinusHours {
        OffsetDateTimeMinusHours() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int hours) {
            return offsetDateTime.minus(Duration.ofHours(hours));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long hours) {
            return offsetDateTime.minus(hours, ChronoUnit.HOURS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int hours) {
            return offsetDateTime.minusHours(hours);
        }
    }

    static final class OffsetDateTimeMinusMinutes {
        OffsetDateTimeMinusMinutes() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int minutes) {
            return offsetDateTime.minus(Duration.ofMinutes(minutes));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long minutes) {
            return offsetDateTime.minus(minutes, ChronoUnit.MINUTES);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int minutes) {
            return offsetDateTime.minusMinutes(minutes);
        }
    }

    static final class OffsetDateTimeMinusSeconds {
        OffsetDateTimeMinusSeconds() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int seconds) {
            return offsetDateTime.minus(Duration.ofSeconds(seconds));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long seconds) {
            return offsetDateTime.minus(seconds, ChronoUnit.SECONDS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int seconds) {
            return offsetDateTime.minusSeconds(seconds);
        }
    }

    static final class OffsetDateTimeMinusNanos {
        OffsetDateTimeMinusNanos() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int nanos) {
            return offsetDateTime.minus(Duration.ofNanos(nanos));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long nanos) {
            return offsetDateTime.minus(nanos, ChronoUnit.NANOS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int nanos) {
            return offsetDateTime.minusNanos(nanos);
        }
    }

    static final class OffsetDateTimePlusYears {
        OffsetDateTimePlusYears() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int years) {
            return offsetDateTime.plus(Period.ofYears(years));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long years) {
            return offsetDateTime.plus(years, ChronoUnit.YEARS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int years) {
            return offsetDateTime.plusYears(years);
        }
    }

    static final class OffsetDateTimePlusMonths {
        OffsetDateTimePlusMonths() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int months) {
            return offsetDateTime.plus(Period.ofMonths(months));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long months) {
            return offsetDateTime.plus(months, ChronoUnit.MONTHS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int months) {
            return offsetDateTime.plusMonths(months);
        }
    }

    static final class OffsetDateTimePlusWeeks {
        OffsetDateTimePlusWeeks() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int weeks) {
            return offsetDateTime.plus(Period.ofWeeks(weeks));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long weeks) {
            return offsetDateTime.plus(weeks, ChronoUnit.WEEKS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int weeks) {
            return offsetDateTime.plusWeeks(weeks);
        }
    }

    static final class OffsetDateTimePlusDays {
        OffsetDateTimePlusDays() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int days) {
            return offsetDateTime.plus(Period.ofDays(days));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long days) {
            return offsetDateTime.plus(days, ChronoUnit.DAYS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int days) {
            return offsetDateTime.plusDays(days);
        }
    }

    static final class OffsetDateTimePlusHours {
        OffsetDateTimePlusHours() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int hours) {
            return offsetDateTime.plus(Duration.ofHours(hours));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long hours) {
            return offsetDateTime.plus(hours, ChronoUnit.HOURS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int hours) {
            return offsetDateTime.plusHours(hours);
        }
    }

    static final class OffsetDateTimePlusMinutes {
        OffsetDateTimePlusMinutes() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int minutes) {
            return offsetDateTime.plus(Duration.ofMinutes(minutes));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long minutes) {
            return offsetDateTime.plus(minutes, ChronoUnit.MINUTES);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int minutes) {
            return offsetDateTime.plusMinutes(minutes);
        }
    }

    static final class OffsetDateTimePlusSeconds {
        OffsetDateTimePlusSeconds() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int seconds) {
            return offsetDateTime.plus(Duration.ofSeconds(seconds));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long seconds) {
            return offsetDateTime.plus(seconds, ChronoUnit.SECONDS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int seconds) {
            return offsetDateTime.plusSeconds(seconds);
        }
    }

    static final class OffsetDateTimePlusNanos {
        OffsetDateTimePlusNanos() {
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, int nanos) {
            return offsetDateTime.plus(Duration.ofNanos(nanos));
        }

        OffsetDateTime before(OffsetDateTime offsetDateTime, long nanos) {
            return offsetDateTime.plus(nanos, ChronoUnit.NANOS);
        }

        OffsetDateTime after(OffsetDateTime offsetDateTime, int nanos) {
            return offsetDateTime.plusNanos(nanos);
        }
    }

    static final class LocalDateTimeMinusYears {
        LocalDateTimeMinusYears() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int years) {
            return localDateTime.minus(Period.ofYears(years));
        }

        LocalDateTime before(LocalDateTime localDateTime, long years) {
            return localDateTime.minus(years, ChronoUnit.YEARS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int years) {
            return localDateTime.minusYears(years);
        }
    }

    static final class LocalDateTimeMinusMonths {
        LocalDateTimeMinusMonths() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int months) {
            return localDateTime.minus(Period.ofMonths(months));
        }

        LocalDateTime before(LocalDateTime localDateTime, long months) {
            return localDateTime.minus(months, ChronoUnit.MONTHS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int months) {
            return localDateTime.minusMonths(months);
        }
    }

    static final class LocalDateTimeMinusWeeks {
        LocalDateTimeMinusWeeks() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int weeks) {
            return localDateTime.minus(Period.ofWeeks(weeks));
        }

        LocalDateTime before(LocalDateTime localDateTime, long weeks) {
            return localDateTime.minus(weeks, ChronoUnit.WEEKS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int weeks) {
            return localDateTime.minusWeeks(weeks);
        }
    }

    static final class LocalDateTimeMinusDays {
        LocalDateTimeMinusDays() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int days) {
            return localDateTime.minus(Period.ofDays(days));
        }

        LocalDateTime before(LocalDateTime localDateTime, long days) {
            return localDateTime.minus(days, ChronoUnit.DAYS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int days) {
            return localDateTime.minusDays(days);
        }
    }

    static final class LocalDateTimeMinusHours {
        LocalDateTimeMinusHours() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int hours) {
            return localDateTime.minus(Duration.ofHours(hours));
        }

        LocalDateTime before(LocalDateTime localDateTime, long hours) {
            return localDateTime.minus(hours, ChronoUnit.HOURS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int hours) {
            return localDateTime.minusHours(hours);
        }
    }

    static final class LocalDateTimeMinusMinutes {
        LocalDateTimeMinusMinutes() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int minutes) {
            return localDateTime.minus(Duration.ofMinutes(minutes));
        }

        LocalDateTime before(LocalDateTime localDateTime, long minutes) {
            return localDateTime.minus(minutes, ChronoUnit.MINUTES);
        }

        LocalDateTime after(LocalDateTime localDateTime, int minutes) {
            return localDateTime.minusMinutes(minutes);
        }
    }

    static final class LocalDateTimeMinusSeconds {
        LocalDateTimeMinusSeconds() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int seconds) {
            return localDateTime.minus(Duration.ofSeconds(seconds));
        }

        LocalDateTime before(LocalDateTime localDateTime, long seconds) {
            return localDateTime.minus(seconds, ChronoUnit.SECONDS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int seconds) {
            return localDateTime.minusSeconds(seconds);
        }
    }

    static final class LocalDateTimeMinusNanos {
        LocalDateTimeMinusNanos() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int nanos) {
            return localDateTime.minus(Duration.ofNanos(nanos));
        }

        LocalDateTime before(LocalDateTime localDateTime, long nanos) {
            return localDateTime.minus(nanos, ChronoUnit.NANOS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int nanos) {
            return localDateTime.minusNanos(nanos);
        }
    }

    static final class LocalDateTimePlusYears {
        LocalDateTimePlusYears() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int years) {
            return localDateTime.plus(Period.ofYears(years));
        }

        LocalDateTime before(LocalDateTime localDateTime, long years) {
            return localDateTime.plus(years, ChronoUnit.YEARS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int years) {
            return localDateTime.plusYears(years);
        }
    }

    static final class LocalDateTimePlusMonths {
        LocalDateTimePlusMonths() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int months) {
            return localDateTime.plus(Period.ofMonths(months));
        }

        LocalDateTime before(LocalDateTime localDateTime, long months) {
            return localDateTime.plus(months, ChronoUnit.MONTHS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int months) {
            return localDateTime.plusMonths(months);
        }
    }

    static final class LocalDateTimePlusWeeks {
        LocalDateTimePlusWeeks() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int weeks) {
            return localDateTime.plus(Period.ofWeeks(weeks));
        }

        LocalDateTime before(LocalDateTime localDateTime, long weeks) {
            return localDateTime.plus(weeks, ChronoUnit.WEEKS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int weeks) {
            return localDateTime.plusWeeks(weeks);
        }
    }

    static final class LocalDateTimePlusDays {
        LocalDateTimePlusDays() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int days) {
            return localDateTime.plus(Period.ofDays(days));
        }

        LocalDateTime before(LocalDateTime localDateTime, long days) {
            return localDateTime.plus(days, ChronoUnit.DAYS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int days) {
            return localDateTime.plusDays(days);
        }
    }

    static final class LocalDateTimePlusHours {
        LocalDateTimePlusHours() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int hours) {
            return localDateTime.plus(Duration.ofHours(hours));
        }

        LocalDateTime before(LocalDateTime localDateTime, long hours) {
            return localDateTime.plus(hours, ChronoUnit.HOURS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int hours) {
            return localDateTime.plusHours(hours);
        }
    }

    static final class LocalDateTimePlusMinutes {
        LocalDateTimePlusMinutes() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int minutes) {
            return localDateTime.plus(Duration.ofMinutes(minutes));
        }

        LocalDateTime before(LocalDateTime localDateTime, long minutes) {
            return localDateTime.plus(minutes, ChronoUnit.MINUTES);
        }

        LocalDateTime after(LocalDateTime localDateTime, int minutes) {
            return localDateTime.plusMinutes(minutes);
        }
    }

    static final class LocalDateTimePlusSeconds {
        LocalDateTimePlusSeconds() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int seconds) {
            return localDateTime.plus(Duration.ofSeconds(seconds));
        }

        LocalDateTime before(LocalDateTime localDateTime, long seconds) {
            return localDateTime.plus(seconds, ChronoUnit.SECONDS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int seconds) {
            return localDateTime.plusSeconds(seconds);
        }
    }

    static final class LocalDateTimePlusNanos {
        LocalDateTimePlusNanos() {
        }

        LocalDateTime before(LocalDateTime localDateTime, int nanos) {
            return localDateTime.plus(Duration.ofNanos(nanos));
        }

        LocalDateTime before(LocalDateTime localDateTime, long nanos) {
            return localDateTime.plus(nanos, ChronoUnit.NANOS);
        }

        LocalDateTime after(LocalDateTime localDateTime, int nanos) {
            return localDateTime.plusNanos(nanos);
        }
    }

    static final class OffsetTimeMinusHours {
        OffsetTimeMinusHours() {
        }

        OffsetTime before(OffsetTime offsetTime, int hours) {
            return offsetTime.minus(Duration.ofHours(hours));
        }

        OffsetTime before(OffsetTime offsetTime, long hours) {
            return offsetTime.minus(hours, ChronoUnit.HOURS);
        }

        OffsetTime after(OffsetTime offsetTime, int hours) {
            return offsetTime.minusHours(hours);
        }
    }

    static final class OffsetTimeMinusMinutes {
        OffsetTimeMinusMinutes() {
        }

        OffsetTime before(OffsetTime offsetTime, int minutes) {
            return offsetTime.minus(Duration.ofMinutes(minutes));
        }

        OffsetTime before(OffsetTime offsetTime, long minutes) {
            return offsetTime.minus(minutes, ChronoUnit.MINUTES);
        }

        OffsetTime after(OffsetTime offsetTime, int minutes) {
            return offsetTime.minusMinutes(minutes);
        }
    }

    static final class OffsetTimeMinusSeconds {
        OffsetTimeMinusSeconds() {
        }

        OffsetTime before(OffsetTime offsetTime, int seconds) {
            return offsetTime.minus(Duration.ofSeconds(seconds));
        }

        OffsetTime before(OffsetTime offsetTime, long seconds) {
            return offsetTime.minus(seconds, ChronoUnit.SECONDS);
        }

        OffsetTime after(OffsetTime offsetTime, int seconds) {
            return offsetTime.minusSeconds(seconds);
        }
    }

    static final class OffsetTimeMinusNanos {
        OffsetTimeMinusNanos() {
        }

        OffsetTime before(OffsetTime offsetTime, int nanos) {
            return offsetTime.minus(Duration.ofNanos(nanos));
        }

        OffsetTime before(OffsetTime offsetTime, long nanos) {
            return offsetTime.minus(nanos, ChronoUnit.NANOS);
        }

        OffsetTime after(OffsetTime offsetTime, int nanos) {
            return offsetTime.minusNanos(nanos);
        }
    }

    static final class OffsetTimePlusHours {
        OffsetTimePlusHours() {
        }

        OffsetTime before(OffsetTime offsetTime, int hours) {
            return offsetTime.plus(Duration.ofHours(hours));
        }

        OffsetTime before(OffsetTime offsetTime, long hours) {
            return offsetTime.plus(hours, ChronoUnit.HOURS);
        }

        OffsetTime after(OffsetTime offsetTime, int hours) {
            return offsetTime.plusHours(hours);
        }
    }

    static final class OffsetTimePlusMinutes {
        OffsetTimePlusMinutes() {
        }

        OffsetTime before(OffsetTime offsetTime, int minutes) {
            return offsetTime.plus(Duration.ofMinutes(minutes));
        }

        OffsetTime before(OffsetTime offsetTime, long minutes) {
            return offsetTime.plus(minutes, ChronoUnit.MINUTES);
        }

        OffsetTime after(OffsetTime offsetTime, int minutes) {
            return offsetTime.plusMinutes(minutes);
        }
    }

    static final class OffsetTimePlusSeconds {
        OffsetTimePlusSeconds() {
        }

        OffsetTime before(OffsetTime offsetTime, int seconds) {
            return offsetTime.plus(Duration.ofSeconds(seconds));
        }

        OffsetTime before(OffsetTime offsetTime, long seconds) {
            return offsetTime.plus(seconds, ChronoUnit.SECONDS);
        }

        OffsetTime after(OffsetTime offsetTime, int seconds) {
            return offsetTime.plusSeconds(seconds);
        }
    }

    static final class OffsetTimePlusNanos {
        OffsetTimePlusNanos() {
        }

        OffsetTime before(OffsetTime offsetTime, int nanos) {
            return offsetTime.plus(Duration.ofNanos(nanos));
        }

        OffsetTime before(OffsetTime offsetTime, long nanos) {
            return offsetTime.plus(nanos, ChronoUnit.NANOS);
        }

        OffsetTime after(OffsetTime offsetTime, int nanos) {
            return offsetTime.plusNanos(nanos);
        }
    }

    static final class LocalTimeMinusHours {
        LocalTimeMinusHours() {
        }

        LocalTime before(LocalTime localTime, int hours) {
            return localTime.minus(Duration.ofHours(hours));
        }

        LocalTime before(LocalTime localTime, long hours) {
            return localTime.minus(hours, ChronoUnit.HOURS);
        }

        LocalTime after(LocalTime localTime, int hours) {
            return localTime.minusHours(hours);
        }
    }

    static final class LocalTimeMinusMinutes {
        LocalTimeMinusMinutes() {
        }

        LocalTime before(LocalTime localTime, int minutes) {
            return localTime.minus(Duration.ofMinutes(minutes));
        }

        LocalTime before(LocalTime localTime, long minutes) {
            return localTime.minus(minutes, ChronoUnit.MINUTES);
        }

        LocalTime after(LocalTime localTime, int minutes) {
            return localTime.minusMinutes(minutes);
        }
    }

    static final class LocalTimeMinusSeconds {
        LocalTimeMinusSeconds() {
        }

        LocalTime before(LocalTime localTime, int seconds) {
            return localTime.minus(Duration.ofSeconds(seconds));
        }

        LocalTime before(LocalTime localTime, long seconds) {
            return localTime.minus(seconds, ChronoUnit.SECONDS);
        }

        LocalTime after(LocalTime localTime, int seconds) {
            return localTime.minusSeconds(seconds);
        }
    }

    static final class LocalTimeMinusNanos {
        LocalTimeMinusNanos() {
        }

        LocalTime before(LocalTime localTime, int nanos) {
            return localTime.minus(Duration.ofNanos(nanos));
        }

        LocalTime before(LocalTime localTime, long nanos) {
            return localTime.minus(nanos, ChronoUnit.NANOS);
        }

        LocalTime after(LocalTime localTime, int nanos) {
            return localTime.minusNanos(nanos);
        }
    }

    static final class LocalTimePlusHours {
        LocalTimePlusHours() {
        }

        LocalTime before(LocalTime localTime, int hours) {
            return localTime.plus(Duration.ofHours(hours));
        }

        LocalTime before(LocalTime localTime, long hours) {
            return localTime.plus(hours, ChronoUnit.HOURS);
        }

        LocalTime after(LocalTime localTime, int hours) {
            return localTime.plusHours(hours);
        }
    }

    static final class LocalTimePlusMinutes {
        LocalTimePlusMinutes() {
        }

        LocalTime before(LocalTime localTime, int minutes) {
            return localTime.plus(Duration.ofMinutes(minutes));
        }

        LocalTime before(LocalTime localTime, long minutes) {
            return localTime.plus(minutes, ChronoUnit.MINUTES);
        }

        LocalTime after(LocalTime localTime, int minutes) {
            return localTime.plusMinutes(minutes);
        }
    }

    static final class LocalTimePlusSeconds {
        LocalTimePlusSeconds() {
        }

        LocalTime before(LocalTime localTime, int seconds) {
            return localTime.plus(Duration.ofSeconds(seconds));
        }

        LocalTime before(LocalTime localTime, long seconds) {
            return localTime.plus(seconds, ChronoUnit.SECONDS);
        }

        LocalTime after(LocalTime localTime, int seconds) {
            return localTime.plusSeconds(seconds);
        }
    }

    static final class LocalTimePlusNanos {
        LocalTimePlusNanos() {
        }

        LocalTime before(LocalTime localTime, int nanos) {
            return localTime.plus(Duration.ofNanos(nanos));
        }

        LocalTime before(LocalTime localTime, long nanos) {
            return localTime.plus(nanos, ChronoUnit.NANOS);
        }

        LocalTime after(LocalTime localTime, int nanos) {
            return localTime.plusNanos(nanos);
        }
    }

    static final class LocalDateMinusYears {
        LocalDateMinusYears() {
        }

        LocalDate before(LocalDate localDate, int years) {
            return localDate.minus(Period.ofYears(years));
        }

        LocalDate before(LocalDate localDate, long years) {
            return localDate.minus(years, ChronoUnit.YEARS);
        }

        LocalDate after(LocalDate localDate, int years) {
            return localDate.minusYears(years);
        }
    }

    static final class LocalDateMinusMonths {
        LocalDateMinusMonths() {
        }

        LocalDate before(LocalDate localDate, int months) {
            return localDate.minus(Period.ofMonths(months));
        }

        LocalDate before(LocalDate localDate, long months) {
            return localDate.minus(months, ChronoUnit.MONTHS);
        }

        LocalDate after(LocalDate localDate, int months) {
            return localDate.minusMonths(months);
        }
    }

    static final class LocalDateMinusWeeks {
        LocalDateMinusWeeks() {
        }

        LocalDate before(LocalDate localDate, int weeks) {
            return localDate.minus(Period.ofWeeks(weeks));
        }

        LocalDate before(LocalDate localDate, long weeks) {
            return localDate.minus(weeks, ChronoUnit.WEEKS);
        }

        LocalDate after(LocalDate localDate, int weeks) {
            return localDate.minusWeeks(weeks);
        }
    }

    static final class LocalDateMinusDays {
        LocalDateMinusDays() {
        }

        LocalDate before(LocalDate localDate, int days) {
            return localDate.minus(Period.ofDays(days));
        }

        LocalDate before(LocalDate localDate, long days) {
            return localDate.minus(days, ChronoUnit.DAYS);
        }

        LocalDate after(LocalDate localDate, int days) {
            return localDate.minusDays(days);
        }
    }

    static final class LocalDatePlusYears {
        LocalDatePlusYears() {
        }

        LocalDate before(LocalDate localDate, int years) {
            return localDate.plus(Period.ofYears(years));
        }

        LocalDate before(LocalDate localDate, long years) {
            return localDate.plus(years, ChronoUnit.YEARS);
        }

        LocalDate after(LocalDate localDate, int years) {
            return localDate.plusYears(years);
        }
    }

    static final class LocalDatePlusMonths {
        LocalDatePlusMonths() {
        }

        LocalDate before(LocalDate localDate, int months) {
            return localDate.plus(Period.ofMonths(months));
        }

        LocalDate before(LocalDate localDate, long months) {
            return localDate.plus(months, ChronoUnit.MONTHS);
        }

        LocalDate after(LocalDate localDate, int months) {
            return localDate.plusMonths(months);
        }
    }

    static final class LocalDatePlusWeeks {
        LocalDatePlusWeeks() {
        }

        LocalDate before(LocalDate localDate, int weeks) {
            return localDate.plus(Period.ofWeeks(weeks));
        }

        LocalDate before(LocalDate localDate, long weeks) {
            return localDate.plus(weeks, ChronoUnit.WEEKS);
        }

        LocalDate after(LocalDate localDate, int weeks) {
            return localDate.plusWeeks(weeks);
        }
    }

    static final class LocalDatePlusDays {
        LocalDatePlusDays() {
        }

        LocalDate before(LocalDate localDate, int days) {
            return localDate.plus(Period.ofDays(days));
        }

        LocalDate before(LocalDate localDate, long days) {
            return localDate.plus(days, ChronoUnit.DAYS);
        }

        LocalDate after(LocalDate localDate, int days) {
            return localDate.plusDays(days);
        }
    }

    static final class ZeroPeriod {
        ZeroPeriod() {
        }

        Period before() {
            return (Period)Refaster.anyOf((Object[])new Period[]{Period.ofDays(0), Period.ofWeeks(0), Period.ofMonths(0), Period.ofYears(0), Period.of(0, 0, 0)});
        }

        Period after() {
            return Period.ZERO;
        }
    }

    static final class DurationIsZero {
        DurationIsZero() {
        }

        boolean before(Duration duration) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{duration.equals(Duration.ZERO), Duration.ZERO.equals(duration)});
        }

        boolean after(Duration duration) {
            return duration.isZero();
        }
    }

    static final class DurationBetweenOffsetDateTimes {
        DurationBetweenOffsetDateTimes() {
        }

        Duration before(OffsetDateTime a, OffsetDateTime b) {
            return (Duration)Refaster.anyOf((Object[])new Duration[]{Duration.between(a.toInstant(), b.toInstant()), Duration.ofSeconds(b.toEpochSecond() - a.toEpochSecond())});
        }

        Duration after(OffsetDateTime a, OffsetDateTime b) {
            return Duration.between(a, b);
        }
    }

    static final class DurationBetweenInstants {
        DurationBetweenInstants() {
        }

        Duration before(Instant a, Instant b) {
            return Duration.ofMillis(b.toEpochMilli() - a.toEpochMilli());
        }

        Duration after(Instant a, Instant b) {
            return Duration.between(a, b);
        }
    }

    static final class DurationOfSeconds {
        DurationOfSeconds() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.SECONDS);
        }

        Duration after(long amount) {
            return Duration.ofSeconds(amount);
        }
    }

    static final class DurationOfNanos {
        DurationOfNanos() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.NANOS);
        }

        Duration after(long amount) {
            return Duration.ofNanos(amount);
        }
    }

    static final class DurationOfMinutes {
        DurationOfMinutes() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.MINUTES);
        }

        Duration after(long amount) {
            return Duration.ofMinutes(amount);
        }
    }

    static final class DurationOfMillis {
        DurationOfMillis() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.MILLIS);
        }

        Duration after(long amount) {
            return Duration.ofMillis(amount);
        }
    }

    static final class DurationOfHours {
        DurationOfHours() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.HOURS);
        }

        Duration after(long amount) {
            return Duration.ofHours(amount);
        }
    }

    static final class DurationOfDays {
        DurationOfDays() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.DAYS);
        }

        Duration after(long amount) {
            return Duration.ofDays(amount);
        }
    }

    static final class ZeroDuration {
        ZeroDuration() {
        }

        Duration before(TemporalUnit temporalUnit) {
            return (Duration)Refaster.anyOf((Object[])new Duration[]{Duration.ofNanos(0L), Duration.ofMillis(0L), Duration.ofSeconds(0L), Duration.ofSeconds(0L, 0L), Duration.ofMinutes(0L), Duration.ofHours(0L), Duration.ofDays(0L), Duration.of(0L, temporalUnit)});
        }

        Duration after() {
            return Duration.ZERO;
        }
    }

    static final class OffsetDateTimeIsAfter {
        OffsetDateTimeIsAfter() {
        }

        boolean before(OffsetDateTime a, OffsetDateTime b) {
            return a.compareTo(b) > 0;
        }

        boolean after(OffsetDateTime a, OffsetDateTime b) {
            return a.isAfter(b);
        }
    }

    static final class OffsetDateTimeIsBefore {
        OffsetDateTimeIsBefore() {
        }

        boolean before(OffsetDateTime a, OffsetDateTime b) {
            return a.compareTo(b) < 0;
        }

        boolean after(OffsetDateTime a, OffsetDateTime b) {
            return a.isBefore(b);
        }
    }

    static final class ChronoZonedDateTimeIsAfter {
        ChronoZonedDateTimeIsAfter() {
        }

        boolean before(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.compareTo(b) > 0;
        }

        boolean after(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.isAfter(b);
        }
    }

    static final class ChronoZonedDateTimeIsBefore {
        ChronoZonedDateTimeIsBefore() {
        }

        boolean before(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.compareTo(b) < 0;
        }

        boolean after(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.isBefore(b);
        }
    }

    static final class ChronoLocalDateTimeIsAfter {
        ChronoLocalDateTimeIsAfter() {
        }

        boolean before(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.compareTo(b) > 0;
        }

        boolean after(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.isAfter(b);
        }
    }

    static final class ChronoLocalDateTimeIsBefore {
        ChronoLocalDateTimeIsBefore() {
        }

        boolean before(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.compareTo(b) < 0;
        }

        boolean after(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.isBefore(b);
        }
    }

    static final class ChronoLocalDateIsAfter {
        ChronoLocalDateIsAfter() {
        }

        boolean before(ChronoLocalDate a, ChronoLocalDate b) {
            return a.compareTo(b) > 0;
        }

        boolean after(ChronoLocalDate a, ChronoLocalDate b) {
            return a.isAfter(b);
        }
    }

    static final class ChronoLocalDateIsBefore {
        ChronoLocalDateIsBefore() {
        }

        boolean before(ChronoLocalDate a, ChronoLocalDate b) {
            return a.compareTo(b) < 0;
        }

        boolean after(ChronoLocalDate a, ChronoLocalDate b) {
            return a.isBefore(b);
        }
    }

    static final class LocalDateAtStartOfDay {
        LocalDateAtStartOfDay() {
        }

        LocalDateTime before(LocalDate localDate) {
            return localDate.atTime(LocalTime.MIN);
        }

        LocalDateTime after(LocalDate localDate) {
            return localDate.atStartOfDay();
        }
    }

    static final class LocalTimeMin {
        LocalTimeMin() {
        }

        LocalTime before() {
            return (LocalTime)Refaster.anyOf((Object[])new LocalTime[]{LocalTime.MIDNIGHT, LocalTime.of(0, 0), LocalTime.of(0, 0, 0), LocalTime.of(0, 0, 0, 0), LocalTime.ofNanoOfDay(0L), LocalTime.ofSecondOfDay(0L)});
        }

        LocalTime after() {
            return LocalTime.MIN;
        }
    }

    static final class InstantIsAfter {
        InstantIsAfter() {
        }

        boolean before(Instant a, Instant b) {
            return a.compareTo(b) > 0;
        }

        boolean after(Instant a, Instant b) {
            return a.isAfter(b);
        }
    }

    static final class InstantIsBefore {
        InstantIsBefore() {
        }

        boolean before(Instant a, Instant b) {
            return a.compareTo(b) < 0;
        }

        boolean after(Instant a, Instant b) {
            return a.isBefore(b);
        }
    }

    static final class EpochInstant {
        EpochInstant() {
        }

        Instant before() {
            return (Instant)Refaster.anyOf((Object[])new Instant[]{Instant.ofEpochMilli(0L), Instant.ofEpochSecond(0L), Instant.ofEpochSecond(0L, 0L)});
        }

        Instant after() {
            return Instant.EPOCH;
        }
    }

    static final class UtcClock {
        UtcClock() {
        }

        Clock before() {
            return Clock.system(ZoneOffset.UTC);
        }

        Clock after() {
            return Clock.systemUTC();
        }
    }

    static final class InstantAtZone {
        InstantAtZone() {
        }

        ZonedDateTime before(Instant instant, ZoneId zoneId) {
            return ZonedDateTime.ofInstant(instant, zoneId);
        }

        ZonedDateTime after(Instant instant, ZoneId zoneId) {
            return instant.atZone(zoneId);
        }
    }

    static final class OffsetTimeOfInstant {
        OffsetTimeOfInstant() {
        }

        OffsetTime before(Instant instant, ZoneId zoneId) {
            return OffsetDateTime.ofInstant(instant, zoneId).toOffsetTime();
        }

        OffsetTime before(Instant instant, ZoneOffset zoneId) {
            return instant.atOffset(zoneId).toOffsetTime();
        }

        OffsetTime after(Instant instant, ZoneId zoneId) {
            return OffsetTime.ofInstant(instant, zoneId);
        }
    }

    static final class InstantAtOffset {
        InstantAtOffset() {
        }

        OffsetDateTime before(Instant instant, ZoneOffset zoneOffset) {
            return OffsetDateTime.ofInstant(instant, zoneOffset);
        }

        OffsetDateTime after(Instant instant, ZoneOffset zoneOffset) {
            return instant.atOffset(zoneOffset);
        }
    }

    static final class InstantTruncatedToSeconds {
        InstantTruncatedToSeconds() {
        }

        Instant before(Instant instant) {
            return Instant.ofEpochSecond(instant.getEpochSecond());
        }

        Instant after(Instant instant) {
            return instant.truncatedTo(ChronoUnit.SECONDS);
        }
    }

    static final class InstantTruncatedToMilliseconds {
        InstantTruncatedToMilliseconds() {
        }

        Instant before(Instant instant) {
            return Instant.ofEpochMilli(instant.toEpochMilli());
        }

        Instant after(Instant instant) {
            return instant.truncatedTo(ChronoUnit.MILLIS);
        }
    }

    static final class InstantIdentity {
        InstantIdentity() {
        }

        Instant before(Instant instant, TemporalUnit temporalUnit) {
            return (Instant)Refaster.anyOf((Object[])new Instant[]{instant.plus(Duration.ZERO), instant.plus(0L, temporalUnit), instant.plusNanos(0L), instant.plusMillis(0L), instant.plusSeconds(0L), instant.minus(Duration.ZERO), instant.minus(0L, temporalUnit), instant.minusNanos(0L), instant.minusMillis(0L), instant.minusSeconds(0L), Instant.parse(instant.toString()), instant.truncatedTo(ChronoUnit.NANOS), Instant.ofEpochSecond(instant.getEpochSecond(), instant.getNano())});
        }

        Instant after(Instant instant) {
            return instant;
        }
    }

    static final class OffsetDateTimeOfInstant {
        OffsetDateTimeOfInstant() {
        }

        OffsetDateTime before(Instant instant, ZoneId zoneId) {
            return instant.atZone(zoneId).toOffsetDateTime();
        }

        OffsetDateTime after(Instant instant, ZoneId zoneId) {
            return OffsetDateTime.ofInstant(instant, zoneId);
        }
    }

    static final class LocalTimeOfInstant {
        LocalTimeOfInstant() {
        }

        LocalTime before(Instant instant, ZoneId zoneId) {
            return (LocalTime)Refaster.anyOf((Object[])new LocalTime[]{instant.atZone(zoneId).toLocalTime(), LocalDateTime.ofInstant(instant, zoneId).toLocalTime(), OffsetDateTime.ofInstant(instant, zoneId).toLocalTime(), OffsetTime.ofInstant(instant, zoneId).toLocalTime()});
        }

        LocalTime before(Instant instant, ZoneOffset zoneId) {
            return instant.atOffset(zoneId).toLocalTime();
        }

        LocalTime after(Instant instant, ZoneId zoneId) {
            return LocalTime.ofInstant(instant, zoneId);
        }
    }

    static final class LocalDateTimeOfInstant {
        LocalDateTimeOfInstant() {
        }

        LocalDateTime before(Instant instant, ZoneId zoneId) {
            return (LocalDateTime)Refaster.anyOf((Object[])new LocalDateTime[]{instant.atZone(zoneId).toLocalDateTime(), OffsetDateTime.ofInstant(instant, zoneId).toLocalDateTime()});
        }

        LocalDateTime before(Instant instant, ZoneOffset zoneId) {
            return instant.atOffset(zoneId).toLocalDateTime();
        }

        LocalDateTime after(Instant instant, ZoneId zoneId) {
            return LocalDateTime.ofInstant(instant, zoneId);
        }
    }

    static final class LocalDateOfInstant {
        LocalDateOfInstant() {
        }

        LocalDate before(Instant instant, ZoneId zoneId) {
            return (LocalDate)Refaster.anyOf((Object[])new LocalDate[]{instant.atZone(zoneId).toLocalDate(), LocalDateTime.ofInstant(instant, zoneId).toLocalDate(), OffsetDateTime.ofInstant(instant, zoneId).toLocalDate()});
        }

        LocalDate before(Instant instant, ZoneOffset zoneId) {
            return instant.atOffset(zoneId).toLocalDate();
        }

        LocalDate after(Instant instant, ZoneId zoneId) {
            return LocalDate.ofInstant(instant, zoneId);
        }
    }

    static final class UtcConstant {
        UtcConstant() {
        }

        ZoneId before() {
            return (ZoneId)Refaster.anyOf((Object[])new ZoneId[]{ZoneId.of("GMT"), ZoneId.of("UTC"), ZoneId.of("+0"), ZoneId.of("-0"), ZoneOffset.UTC.normalized(), ZoneId.from(ZoneOffset.UTC)});
        }

        ZoneOffset after() {
            return ZoneOffset.UTC;
        }
    }

    static final class ClockInstant {
        ClockInstant() {
        }

        Instant before(Clock clock) {
            return Instant.now(clock);
        }

        Instant after(Clock clock) {
            return clock.instant();
        }
    }
}

