/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.UnsignedBytes;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLongs;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Comparator;

final class PrimitiveRules {
    private PrimitiveRules() {
    }

    static final class ArraysCompareUnsignedLongs {
        ArraysCompareUnsignedLongs() {
        }

        Comparator<long[]> before() {
            return UnsignedLongs.lexicographicalComparator();
        }

        Comparator<long[]> after() {
            return Arrays::compareUnsigned;
        }
    }

    static final class ArraysCompareUnsignedInts {
        ArraysCompareUnsignedInts() {
        }

        Comparator<int[]> before() {
            return UnsignedInts.lexicographicalComparator();
        }

        Comparator<int[]> after() {
            return Arrays::compareUnsigned;
        }
    }

    static final class ArraysCompareUnsignedBytes {
        ArraysCompareUnsignedBytes() {
        }

        Comparator<byte[]> before() {
            return UnsignedBytes.lexicographicalComparator();
        }

        Comparator<byte[]> after() {
            return Arrays::compareUnsigned;
        }
    }

    static final class LongToUnsignedStringWithRadix {
        LongToUnsignedStringWithRadix() {
        }

        String before(long i, int radix) {
            return UnsignedLongs.toString((long)i, (int)radix);
        }

        String after(long i, int radix) {
            return Long.toUnsignedString(i, radix);
        }
    }

    static final class IntegerToUnsignedStringWithRadix {
        IntegerToUnsignedStringWithRadix() {
        }

        String before(int i, int radix) {
            return UnsignedInts.toString((int)i, (int)radix);
        }

        String after(int i, int radix) {
            return Integer.toUnsignedString(i, radix);
        }
    }

    static final class LongToUnsignedString {
        LongToUnsignedString() {
        }

        String before(long i) {
            return (String)Refaster.anyOf((Object[])new String[]{UnsignedLongs.toString((long)i), Long.toUnsignedString(i, 10)});
        }

        String after(long i) {
            return Long.toUnsignedString(i);
        }
    }

    static final class IntegerToUnsignedString {
        IntegerToUnsignedString() {
        }

        String before(int i) {
            return (String)Refaster.anyOf((Object[])new String[]{UnsignedInts.toString((int)i), Integer.toUnsignedString(i, 10)});
        }

        String after(int i) {
            return Integer.toUnsignedString(i);
        }
    }

    static final class LongParseUnsignedLongWithRadix {
        LongParseUnsignedLongWithRadix() {
        }

        long before(String string, int radix) {
            return UnsignedLongs.parseUnsignedLong((String)string, (int)radix);
        }

        long after(String string, int radix) {
            return Long.parseUnsignedLong(string, radix);
        }
    }

    static final class IntegerParseUnsignedIntWithRadix {
        IntegerParseUnsignedIntWithRadix() {
        }

        int before(String string, int radix) {
            return UnsignedInts.parseUnsignedInt((String)string, (int)radix);
        }

        int after(String string, int radix) {
            return Integer.parseUnsignedInt(string, radix);
        }
    }

    static final class LongParseUnsignedLong {
        LongParseUnsignedLong() {
        }

        long before(String string) {
            return (Long)Refaster.anyOf((Object[])new Long[]{UnsignedLongs.parseUnsignedLong((String)string), Long.parseUnsignedLong(string, 10)});
        }

        long after(String string) {
            return Long.parseUnsignedLong(string);
        }
    }

    static final class IntegerParseUnsignedInt {
        IntegerParseUnsignedInt() {
        }

        int before(String string) {
            return (Integer)Refaster.anyOf((Object[])new Integer[]{UnsignedInts.parseUnsignedInt((String)string), Integer.parseUnsignedInt(string, 10)});
        }

        int after(String string) {
            return Integer.parseUnsignedInt(string);
        }
    }

    static final class LongRemainderUnsigned {
        LongRemainderUnsigned() {
        }

        long before(long x, long y) {
            return UnsignedLongs.remainder((long)x, (long)y);
        }

        long after(long x, long y) {
            return Long.remainderUnsigned(x, y);
        }
    }

    static final class IntegerRemainderUnsigned {
        IntegerRemainderUnsigned() {
        }

        int before(int x, int y) {
            return UnsignedInts.remainder((int)x, (int)y);
        }

        int after(int x, int y) {
            return Integer.remainderUnsigned(x, y);
        }
    }

    static final class LongDivideUnsigned {
        LongDivideUnsigned() {
        }

        long before(long x, long y) {
            return UnsignedLongs.divide((long)x, (long)y);
        }

        long after(long x, long y) {
            return Long.divideUnsigned(x, y);
        }
    }

    static final class IntegerDivideUnsigned {
        IntegerDivideUnsigned() {
        }

        int before(int x, int y) {
            return UnsignedInts.divide((int)x, (int)y);
        }

        int after(int x, int y) {
            return Integer.divideUnsigned(x, y);
        }
    }

    static final class LongCompareUnsigned {
        LongCompareUnsigned() {
        }

        long before(long x, long y) {
            return UnsignedLongs.compare((long)x, (long)y);
        }

        long after(long x, long y) {
            return Long.compareUnsigned(x, y);
        }
    }

    static final class IntegerCompareUnsigned {
        IntegerCompareUnsigned() {
        }

        int before(int x, int y) {
            return UnsignedInts.compare((int)x, (int)y);
        }

        int after(int x, int y) {
            return Integer.compareUnsigned(x, y);
        }
    }

    static final class LongSignumIsNegative {
        LongSignumIsNegative() {
        }

        boolean before(long l) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{Long.signum(l) < 0, Long.signum(l) <= -1});
        }

        boolean after(long l) {
            return Long.signum(l) == -1;
        }
    }

    static final class LongSignumIsPositive {
        LongSignumIsPositive() {
        }

        boolean before(long l) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{Long.signum(l) > 0, Long.signum(l) >= 1});
        }

        boolean after(long l) {
            return Long.signum(l) == 1;
        }
    }

    static final class IntegerSignumIsNegative {
        IntegerSignumIsNegative() {
        }

        boolean before(int i) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{Integer.signum(i) < 0, Integer.signum(i) <= -1});
        }

        boolean after(int i) {
            return Integer.signum(i) == -1;
        }
    }

    static final class IntegerSignumIsPositive {
        IntegerSignumIsPositive() {
        }

        boolean before(int i) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{Integer.signum(i) > 0, Integer.signum(i) >= 1});
        }

        boolean after(int i) {
            return Integer.signum(i) == 1;
        }
    }

    static final class DoubleIsFinite {
        DoubleIsFinite() {
        }

        boolean before(double d) {
            return Doubles.isFinite((double)d);
        }

        boolean after(double d) {
            return Double.isFinite(d);
        }
    }

    static final class FloatIsFinite {
        FloatIsFinite() {
        }

        boolean before(float f) {
            return Floats.isFinite((float)f);
        }

        boolean after(float f) {
            return Float.isFinite(f);
        }
    }

    static final class DoubleBytes {
        DoubleBytes() {
        }

        int before() {
            return 8;
        }

        int after() {
            return 8;
        }
    }

    static final class FloatBytes {
        FloatBytes() {
        }

        int before() {
            return 4;
        }

        int after() {
            return 4;
        }
    }

    static final class LongBytes {
        LongBytes() {
        }

        int before() {
            return 8;
        }

        int after() {
            return 8;
        }
    }

    static final class IntegerBytes {
        IntegerBytes() {
        }

        int before() {
            return 4;
        }

        int after() {
            return 4;
        }
    }

    static final class ShortBytes {
        ShortBytes() {
        }

        int before() {
            return 2;
        }

        int after() {
            return 2;
        }
    }

    static final class CharacterBytes {
        CharacterBytes() {
        }

        int before() {
            return 2;
        }

        int after() {
            return 2;
        }
    }

    static final class DoubleHashCode {
        DoubleHashCode() {
        }

        int before(double d) {
            return Doubles.hashCode((double)d);
        }

        int after(double d) {
            return Double.hashCode(d);
        }
    }

    static final class FloatHashCode {
        FloatHashCode() {
        }

        int before(float f) {
            return Floats.hashCode((float)f);
        }

        int after(float f) {
            return Float.hashCode(f);
        }
    }

    static final class LongHashCode {
        LongHashCode() {
        }

        int before(long l) {
            return Longs.hashCode((long)l);
        }

        int after(long l) {
            return Long.hashCode(l);
        }
    }

    static final class IntegerHashCode {
        IntegerHashCode() {
        }

        int before(int i) {
            return Ints.hashCode((int)i);
        }

        int after(int i) {
            return Integer.hashCode(i);
        }
    }

    static final class ShortHashCode {
        ShortHashCode() {
        }

        int before(short s) {
            return Shorts.hashCode((short)s);
        }

        int after(short s) {
            return Short.hashCode(s);
        }
    }

    static final class CharacterHashCode {
        CharacterHashCode() {
        }

        int before(char c) {
            return Chars.hashCode((char)c);
        }

        int after(char c) {
            return Character.hashCode(c);
        }
    }

    static final class ByteHashCode {
        ByteHashCode() {
        }

        int before(byte b) {
            return Bytes.hashCode((byte)b);
        }

        int after(byte b) {
            return Byte.hashCode(b);
        }
    }

    static final class BooleanHashCode {
        BooleanHashCode() {
        }

        int before(boolean b) {
            return Booleans.hashCode((boolean)b);
        }

        int after(boolean b) {
            return Boolean.hashCode(b);
        }
    }

    static final class LongToIntExact {
        LongToIntExact() {
        }

        int before(long l) {
            return Ints.checkedCast((long)l);
        }

        int after(long l) {
            return Math.toIntExact(l);
        }
    }

    static final class GreaterThanOrEqualTo {
        GreaterThanOrEqualTo() {
        }

        boolean before(double a, double b) {
            return !(a < b);
        }

        boolean after(double a, double b) {
            return a >= b;
        }
    }

    static final class GreaterThan {
        GreaterThan() {
        }

        boolean before(double a, double b) {
            return !(a <= b);
        }

        boolean after(double a, double b) {
            return a > b;
        }
    }

    static final class LessThanOrEqualTo {
        LessThanOrEqualTo() {
        }

        boolean before(double a, double b) {
            return !(a > b);
        }

        boolean after(double a, double b) {
            return a <= b;
        }
    }

    static final class LessThan {
        LessThan() {
        }

        boolean before(double a, double b) {
            return !(a >= b);
        }

        boolean after(double a, double b) {
            return a < b;
        }
    }
}

