/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.errorprone.refaster.Refaster;
import java.util.stream.Stream;

final class ImmutableTableRules {
    private ImmutableTableRules() {
    }

    static final class ImmutableTableOf<R, C, V> {
        ImmutableTableOf() {
        }

        ImmutableTable<R, C, V> before() {
            return ImmutableTable.builder().buildOrThrow();
        }

        ImmutableTable<R, C, V> after() {
            return ImmutableTable.of();
        }
    }

    static abstract class StreamOfCellsToImmutableTable<E, R, C, V> {
        StreamOfCellsToImmutableTable() {
        }

        abstract R rowFunction(E var1);

        abstract C columnFunction(E var1);

        abstract V valueFunction(E var1);

        ImmutableTable<R, C, V> before(Stream<E> stream) {
            return (ImmutableTable)stream.map(e -> Tables.immutableCell(this.rowFunction(e), this.columnFunction(e), this.valueFunction(e))).collect(ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue));
        }

        ImmutableTable<R, C, V> after(Stream<E> stream) {
            return (ImmutableTable)stream.collect(ImmutableTable.toImmutableTable(e -> this.rowFunction(e), e -> this.columnFunction(e), e -> this.valueFunction(e)));
        }
    }

    static final class CellToImmutableTable<R, C, V> {
        CellToImmutableTable() {
        }

        ImmutableTable<R, C, V> before(Table.Cell<? extends R, ? extends C, ? extends V> cell) {
            return (ImmutableTable)Refaster.anyOf((Object[])new ImmutableTable[]{ImmutableTable.builder().put(cell).buildOrThrow(), (ImmutableTable)Stream.of(cell).collect(ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue))});
        }

        ImmutableTable<R, C, V> after(Table.Cell<? extends R, ? extends C, ? extends V> cell) {
            return ImmutableTable.of((Object)cell.getRowKey(), (Object)cell.getColumnKey(), (Object)cell.getValue());
        }
    }

    static final class ImmutableTableBuilderBuildOrThrow<R, C, V> {
        ImmutableTableBuilderBuildOrThrow() {
        }

        ImmutableTable<R, C, V> before(ImmutableTable.Builder<R, C, V> builder) {
            return builder.build();
        }

        ImmutableTable<R, C, V> after(ImmutableTable.Builder<R, C, V> builder) {
            return builder.buildOrThrow();
        }
    }

    static final class ImmutableTableBuilder<R, C, V> {
        ImmutableTableBuilder() {
        }

        ImmutableTable.Builder<R, C, V> before() {
            return new ImmutableTable.Builder();
        }

        ImmutableTable.Builder<R, C, V> after() {
            return ImmutableTable.builder();
        }
    }
}

