/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

final class AssertJObjectRules {
    private AssertJObjectRules() {
    }

    static final class AssertThatHasSameHashCodeAs<T> {
        AssertThatHasSameHashCodeAs() {
        }

        AbstractIntegerAssert<?> before(T object1, T object2) {
            return Assertions.assertThat((int)object1.hashCode()).isEqualTo(object2.hashCode());
        }

        ObjectAssert<T> after(T object1, T object2) {
            return (ObjectAssert)Assertions.assertThat(object1).hasSameHashCodeAs(object2);
        }
    }

    static final class AssertThatIsNotNull<T> {
        AssertThatIsNotNull() {
        }

        AbstractBooleanAssert<? extends AbstractBooleanAssert<?>> before(T object) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((object == null ? 1 : 0) != 0).isFalse(), Assertions.assertThat((object != null ? 1 : 0) != 0).isTrue()});
        }

        ObjectAssert<T> after(T object) {
            return (ObjectAssert)Assertions.assertThat(object).isNotNull();
        }
    }

    static final class AssertThatIsNull<T> {
        AssertThatIsNull() {
        }

        void before(T object) {
            Assertions.assertThat((object == null ? 1 : 0) != 0).isTrue();
        }

        void before2(T object) {
            Assertions.assertThat((object != null ? 1 : 0) != 0).isFalse();
        }

        void after(T object) {
            Assertions.assertThat(object).isNull();
        }
    }

    static final class AssertThatIsNotSameAs<T> {
        AssertThatIsNotSameAs() {
        }

        AbstractBooleanAssert<?> before(T object1, T object2) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((object1 == object2 ? 1 : 0) != 0).isFalse(), Assertions.assertThat((object1 != object2 ? 1 : 0) != 0).isTrue()});
        }

        ObjectAssert<T> after(T object1, T object2) {
            return (ObjectAssert)Assertions.assertThat(object1).isNotSameAs(object2);
        }
    }

    static final class AssertThatIsSameAs<T> {
        AssertThatIsSameAs() {
        }

        AbstractBooleanAssert<?> before(T object1, T object2) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((object1 == object2 ? 1 : 0) != 0).isTrue(), Assertions.assertThat((object1 != object2 ? 1 : 0) != 0).isFalse()});
        }

        ObjectAssert<T> after(T object1, T object2) {
            return (ObjectAssert)Assertions.assertThat(object1).isSameAs(object2);
        }
    }

    static final class AssertThatHasToString<T> {
        AssertThatHasToString() {
        }

        AbstractStringAssert<?> before(T object, String str) {
            return Assertions.assertThat((String)object.toString()).isEqualTo(str);
        }

        ObjectAssert<T> after(T object, String str) {
            return (ObjectAssert)Assertions.assertThat(object).hasToString(str);
        }
    }

    static final class AssertThatIsIsNotEqualTo<S, T> {
        AssertThatIsIsNotEqualTo() {
        }

        AbstractBooleanAssert<?> before(S object1, T object2) {
            return Assertions.assertThat((boolean)object1.equals(object2)).isFalse();
        }

        ObjectAssert<S> after(S object1, T object2) {
            return (ObjectAssert)Assertions.assertThat(object1).isNotEqualTo(object2);
        }
    }

    static final class AssertThatIsIsEqualTo<S, T> {
        AssertThatIsIsEqualTo() {
        }

        AbstractBooleanAssert<?> before(S object1, T object2) {
            return Assertions.assertThat((boolean)object1.equals(object2)).isTrue();
        }

        ObjectAssert<S> after(S object1, T object2) {
            return (ObjectAssert)Assertions.assertThat(object1).isEqualTo(object2);
        }
    }

    static final class AssertThatIsNotInstanceOf<S, T> {
        AssertThatIsNotInstanceOf() {
        }

        AbstractBooleanAssert<?> before(S object) {
            return Assertions.assertThat((boolean)Refaster.isInstance(object)).isFalse();
        }

        ObjectAssert<S> after(S object) {
            return (ObjectAssert)Assertions.assertThat(object).isNotInstanceOf(Refaster.clazz());
        }
    }

    static final class AssertThatIsInstanceOf2<S, T> {
        AssertThatIsInstanceOf2() {
        }

        AbstractBooleanAssert<?> before(T object, Class<S> clazz) {
            return Assertions.assertThat((boolean)clazz.isInstance(object)).isTrue();
        }

        ObjectAssert<T> after(T object, Class<S> clazz) {
            return (ObjectAssert)Assertions.assertThat(object).isInstanceOf(clazz);
        }
    }

    static final class AssertThatIsInstanceOf<S, T> {
        AssertThatIsInstanceOf() {
        }

        AbstractBooleanAssert<?> before(S object) {
            return Assertions.assertThat((boolean)Refaster.isInstance(object)).isTrue();
        }

        ObjectAssert<S> after(S object) {
            return (ObjectAssert)Assertions.assertThat(object).isInstanceOf(Refaster.clazz());
        }
    }
}

