/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.time.Duration;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDurationAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

final class AssertJDurationRules {
    private AssertJDurationRules() {
    }

    static final class AssertThatIsNegative {
        AssertThatIsNegative() {
        }

        AbstractBooleanAssert<?> before(Duration duration) {
            return Assertions.assertThat((boolean)duration.isNegative()).isTrue();
        }

        AbstractDurationAssert<?> before2(Duration duration) {
            return (AbstractDurationAssert)Assertions.assertThat((Duration)duration).isLessThan((Comparable)Duration.ZERO);
        }

        AbstractDurationAssert<?> after(Duration duration) {
            return Assertions.assertThat((Duration)duration).isNegative();
        }
    }

    static final class AssertThatIsPositive {
        AssertThatIsPositive() {
        }

        AbstractDurationAssert<?> before(Duration duration) {
            return (AbstractDurationAssert)Assertions.assertThat((Duration)duration).isGreaterThan((Comparable)Duration.ZERO);
        }

        AbstractDurationAssert<?> after(Duration duration) {
            return Assertions.assertThat((Duration)duration).isPositive();
        }
    }

    static final class AssertThatIsZero {
        AssertThatIsZero() {
        }

        AbstractBooleanAssert<?> before(Duration duration) {
            return Assertions.assertThat((boolean)duration.isZero()).isTrue();
        }

        AbstractDurationAssert<?> before2(Duration duration) {
            return (AbstractDurationAssert)Assertions.assertThat((Duration)duration).isEqualTo((Object)Duration.ZERO);
        }

        AbstractDurationAssert<?> after(Duration duration) {
            return Assertions.assertThat((Duration)duration).isZero();
        }
    }

    static final class AssertThatHasDays {
        AssertThatHasDays() {
        }

        AbstractLongAssert<?> before(Duration duration, long days) {
            return Assertions.assertThat((long)duration.toDays()).isEqualTo(days);
        }

        AbstractDurationAssert<?> after(Duration duration, long days) {
            return Assertions.assertThat((Duration)duration).hasDays(days);
        }
    }

    static final class AssertThatHasHours {
        AssertThatHasHours() {
        }

        AbstractLongAssert<?> before(Duration duration, long hours) {
            return Assertions.assertThat((long)duration.toHours()).isEqualTo(hours);
        }

        AbstractDurationAssert<?> after(Duration duration, long hours) {
            return Assertions.assertThat((Duration)duration).hasHours(hours);
        }
    }

    static final class AssertThatHasMinutes {
        AssertThatHasMinutes() {
        }

        AbstractLongAssert<?> before(Duration duration, long minutes) {
            return Assertions.assertThat((long)duration.toMinutes()).isEqualTo(minutes);
        }

        AbstractDurationAssert<?> after(Duration duration, long minutes) {
            return Assertions.assertThat((Duration)duration).hasMinutes(minutes);
        }
    }

    static final class AssertThatHasSeconds {
        AssertThatHasSeconds() {
        }

        AbstractLongAssert<?> before(Duration duration, long seconds) {
            return Assertions.assertThat((long)duration.toSeconds()).isEqualTo(seconds);
        }

        AbstractDurationAssert<?> after(Duration duration, long seconds) {
            return Assertions.assertThat((Duration)duration).hasSeconds(seconds);
        }
    }

    static final class AssertThatHasMillis {
        AssertThatHasMillis() {
        }

        AbstractLongAssert<?> before(Duration duration, long millis) {
            return Assertions.assertThat((long)duration.toMillis()).isEqualTo(millis);
        }

        AbstractDurationAssert<?> after(Duration duration, long millis) {
            return Assertions.assertThat((Duration)duration).hasMillis(millis);
        }
    }

    static final class AssertThatHasNanos {
        AssertThatHasNanos() {
        }

        AbstractLongAssert<?> before(Duration duration, long nanos) {
            return Assertions.assertThat((long)duration.toNanos()).isEqualTo(nanos);
        }

        AbstractDurationAssert<?> after(Duration duration, long nanos) {
            return Assertions.assertThat((Duration)duration).hasNanos(nanos);
        }
    }
}

