/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class DoubleStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`DoubleStreamRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `DoubleStream`s.\n[Source](https://error-prone.picnic.tech/refasterrules/DoubleStreamRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ConcatOneDoubleStreamRecipe(), new ConcatTwoDoubleStreamsRecipe(), new DoubleStreamFilterSortedRecipe(), new DoubleStreamIsEmptyRecipe(), new DoubleStreamIsNotEmptyRecipe(), new DoubleStreamMinRecipe(), new DoubleStreamNoneMatchRecipe(), new DoubleStreamAnyMatchRecipe(), new DoubleStreamAllMatchRecipe(), new DoubleStreamTakeWhileRecipe()});
    }

    @NullMarked
    public static class ConcatOneDoubleStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.ConcatOneDoubleStream`";
        }

        public String getDescription() {
            return "Don't unnecessarily call `Streams#concat(DoubleStream...)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{stream:any(java.util.stream.DoubleStream)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConcatTwoDoubleStreamsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.ConcatTwoDoubleStreams`";
        }

        public String getDescription() {
            return "Prefer `DoubleStream#concat(DoubleStream, DoubleStream)` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{s1:any(java.util.stream.DoubleStream)}, #{s2:any(java.util.stream.DoubleStream)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.DoubleStream.concat(#{s1:any(java.util.stream.DoubleStream)}, #{s2:any(java.util.stream.DoubleStream)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DoubleStreamFilterSortedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamFilterSorted`";
        }

        public String getDescription() {
            return "Apply `DoubleStream#filter(DoublePredicate)` before `DoubleStream#sorted()` to reduce the number of elements to sort.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.sorted().filter(#{predicate:any(java.util.function.DoublePredicate)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.filter(#{predicate:any(java.util.function.DoublePredicate)}).sorted()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.DoublePredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.DoubleStream filter(..)", true), new UsesMethod("java.util.stream.DoubleStream sorted(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DoubleStreamIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamIsEmpty`";
        }

        public String getDescription() {
            return "In order to test whether a stream has any element, simply try to find one.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.count() == 0").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.count() <= 0").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.count() < 1").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.findFirst().isEmpty()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.findAny().isEmpty()").build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.DoubleStream count(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalDouble isEmpty(..)", true), new UsesMethod("java.util.stream.DoubleStream findFirst(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DoubleStreamIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamIsNotEmpty`";
        }

        public String getDescription() {
            return "In order to test whether a stream has any element, simply try to find one.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.count() != 0").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.count() > 0").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.count() >= 1").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.findFirst().isPresent()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.findAny().isPresent()").build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.DoubleStream count(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalDouble isPresent(..)", true), new UsesMethod("java.util.stream.DoubleStream findFirst(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DoubleStreamMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamMin`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleStreamMin {\n    \n    @BeforeTemplate\n    OptionalDouble before(DoubleStream stream) {\n        return stream.sorted().findFirst();\n    }\n    \n    @AfterTemplate\n    OptionalDouble after(DoubleStream stream) {\n        return stream.min();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.sorted().findFirst()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.min()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalDouble", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.DoubleStream findFirst(..)", true), new UsesMethod("java.util.stream.DoubleStream sorted(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DoubleStreamNoneMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamNoneMatch`";
        }

        public String getDescription() {
            return "Prefer `DoubleStream#noneMatch(DoublePredicate)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!#{stream:any(java.util.stream.DoubleStream)}.anyMatch(#{predicate:any(java.util.function.DoublePredicate)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.allMatch(#{predicate:any(java.util.function.DoublePredicate)}.negate())").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.filter(#{predicate:any(java.util.function.DoublePredicate)}).findAny().isEmpty()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.noneMatch(#{predicate:any(java.util.function.DoublePredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.DoublePredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.DoubleStream anyMatch(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalDouble isEmpty(..)", true), new UsesMethod("java.util.stream.DoubleStream filter(..)", true), new UsesMethod("java.util.stream.DoubleStream findAny(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.function.DoublePredicate negate(..)", true), new UsesMethod("java.util.stream.DoubleStream allMatch(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DoubleStreamAnyMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamAnyMatch`";
        }

        public String getDescription() {
            return "Prefer `DoubleStream#anyMatch(DoublePredicate)` over more contrived alternatives.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4034");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!#{stream:any(java.util.stream.DoubleStream)}.noneMatch(#{predicate:any(java.util.function.DoublePredicate)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.filter(#{predicate:any(java.util.function.DoublePredicate)}).findAny().isPresent()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.anyMatch(#{predicate:any(java.util.function.DoublePredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.DoublePredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.DoubleStream noneMatch(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalDouble isPresent(..)", true), new UsesMethod("java.util.stream.DoubleStream filter(..)", true), new UsesMethod("java.util.stream.DoubleStream findAny(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DoubleStreamAllMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamAllMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleStreamAllMatch {\n    \n    @BeforeTemplate\n    boolean before(DoubleStream stream, DoublePredicate predicate) {\n        return stream.noneMatch(predicate.negate());\n    }\n    \n    @AfterTemplate\n    boolean after(DoubleStream stream, DoublePredicate predicate) {\n        return stream.allMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.noneMatch(#{predicate:any(java.util.function.DoublePredicate)}.negate())").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.allMatch(#{predicate:any(java.util.function.DoublePredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.DoublePredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("java.util.function.DoublePredicate negate(..)", true), new UsesMethod("java.util.stream.DoubleStream noneMatch(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DoubleStreamTakeWhileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamTakeWhile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleStreamTakeWhile {\n    \n    @BeforeTemplate\n    DoubleStream before(DoubleStream stream, DoublePredicate predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    DoubleStream after(DoubleStream stream, DoublePredicate predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.takeWhile(#{predicate:any(java.util.function.DoublePredicate)}).filter(#{predicate})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.DoubleStream)}.takeWhile(#{predicate:any(java.util.function.DoublePredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.DoublePredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.DoubleStream filter(..)", true), new UsesMethod("java.util.stream.DoubleStream takeWhile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

