/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.annotations.DoNotCall;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractBooleanArrayAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractCharArrayAssert;
import org.assertj.core.api.AbstractDoubleArrayAssert;
import org.assertj.core.api.AbstractFloatArrayAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.AbstractShortArrayAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;

final class JUnitToAssertJRules {
    private JUnitToAssertJRules() {
    }

    static final class AssertThatWithFailMessageSupplierIsInstanceOf<T> {
        AssertThatWithFailMessageSupplierIsInstanceOf() {
        }

        void before(Object actual, Supplier<String> supplier, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertInstanceOf(clazz, (Object)actual, supplier);
        }

        void after(Object actual, Supplier<String> supplier, Class<T> clazz) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isInstanceOf(clazz);
        }
    }

    static final class AssertThatWithFailMessageStringIsInstanceOf<T> {
        AssertThatWithFailMessageStringIsInstanceOf() {
        }

        void before(Object actual, String message, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertInstanceOf(clazz, (Object)actual, (String)message);
        }

        void after(Object actual, String message, Class<T> clazz) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isInstanceOf(clazz);
        }
    }

    static final class AssertThatIsInstanceOf<T> {
        AssertThatIsInstanceOf() {
        }

        void before(Object actual, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertInstanceOf(clazz, (Object)actual);
        }

        void after(Object actual, Class<T> clazz) {
            Assertions.assertThat((Object)actual).isInstanceOf(clazz);
        }
    }

    static final class AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException {
        AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException() {
        }

        void before(Executable throwingCallable, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)throwingCallable, supplier);
        }

        void before(ThrowingSupplier<?> throwingCallable, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(throwingCallable, supplier);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Supplier<String> supplier) {
            ((AbstractThrowableAssert)Assertions.assertThatCode((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(supplier)).doesNotThrowAnyException();
        }
    }

    static final class AssertThatCodeWithFailMessageStringDoesNotThrowAnyException {
        AssertThatCodeWithFailMessageStringDoesNotThrowAnyException() {
        }

        void before(Executable throwingCallable, String message) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)throwingCallable, (String)message);
        }

        void before(ThrowingSupplier<?> throwingCallable, String message) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(throwingCallable, (String)message);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            ((AbstractThrowableAssert)Assertions.assertThatCode((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(message, new Object[0])).doesNotThrowAnyException();
        }
    }

    static final class AssertThatCodeDoesNotThrowAnyException {
        AssertThatCodeDoesNotThrowAnyException() {
        }

        void before(Executable throwingCallable) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)throwingCallable);
        }

        void before(ThrowingSupplier<?> throwingCallable) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(throwingCallable);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable) {
            Assertions.assertThatCode((ThrowableAssert.ThrowingCallable)throwingCallable).doesNotThrowAnyException();
        }
    }

    static final class AssertThatThrownByWithFailMessageSupplierIsInstanceOf<T extends Throwable> {
        AssertThatThrownByWithFailMessageSupplierIsInstanceOf() {
        }

        void before(Executable throwingCallable, Supplier<String> supplier, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertThrows(clazz, (Executable)throwingCallable, supplier);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Supplier<String> supplier, Class<T> clazz) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(supplier)).isInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByWithFailMessageStringIsInstanceOf<T extends Throwable> {
        AssertThatThrownByWithFailMessageStringIsInstanceOf() {
        }

        void before(Executable throwingCallable, String message, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertThrows(clazz, (Executable)throwingCallable, (String)message);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Class<T> clazz) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(message, new Object[0])).isInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByIsInstanceOf<T extends Throwable> {
        AssertThatThrownByIsInstanceOf() {
        }

        void before(Executable throwingCallable, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertThrows(clazz, (Executable)throwingCallable);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> clazz) {
            Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOf<T extends Throwable> {
        AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOf() {
        }

        void before(Executable throwingCallable, Supplier<String> supplier, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertThrowsExactly(clazz, (Executable)throwingCallable, supplier);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Supplier<String> supplier, Class<T> clazz) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(supplier)).isExactlyInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByWithFailMessageStringIsExactlyInstanceOf<T extends Throwable> {
        AssertThatThrownByWithFailMessageStringIsExactlyInstanceOf() {
        }

        void before(Executable throwingCallable, String message, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertThrowsExactly(clazz, (Executable)throwingCallable, (String)message);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Class<T> clazz) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(message, new Object[0])).isExactlyInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByIsExactlyInstanceOf<T extends Throwable> {
        AssertThatThrownByIsExactlyInstanceOf() {
        }

        void before(Executable throwingCallable, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertThrowsExactly(clazz, (Executable)throwingCallable);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> clazz) {
            Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isExactlyInstanceOf(clazz);
        }
    }

    static final class AssertThatWithFailMessageSupplierIsNotSameAs {
        AssertThatWithFailMessageSupplierIsNotSameAs() {
        }

        void before(Object actual, Supplier<String> supplier, Object expected) {
            org.junit.jupiter.api.Assertions.assertNotSame((Object)expected, (Object)actual, supplier);
        }

        void after(Object actual, Supplier<String> supplier, Object expected) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isNotSameAs(expected);
        }
    }

    static final class AssertThatWithFailMessageStringIsNotSameAs {
        AssertThatWithFailMessageStringIsNotSameAs() {
        }

        void before(Object actual, String message, Object expected) {
            org.junit.jupiter.api.Assertions.assertNotSame((Object)expected, (Object)actual, (String)message);
        }

        void after(Object actual, String message, Object expected) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNotSameAs(expected);
        }
    }

    static final class AssertThatIsNotSameAs {
        AssertThatIsNotSameAs() {
        }

        void before(Object actual, Object expected) {
            org.junit.jupiter.api.Assertions.assertNotSame((Object)expected, (Object)actual);
        }

        void after(Object actual, Object expected) {
            Assertions.assertThat((Object)actual).isNotSameAs(expected);
        }
    }

    static final class AssertThatWithFailMessageSupplierIsSameAs {
        AssertThatWithFailMessageSupplierIsSameAs() {
        }

        void before(Object actual, Supplier<String> supplier, Object expected) {
            org.junit.jupiter.api.Assertions.assertSame((Object)expected, (Object)actual, supplier);
        }

        void after(Object actual, Supplier<String> supplier, Object expected) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isSameAs(expected);
        }
    }

    static final class AssertThatWithFailMessageStringIsSameAs {
        AssertThatWithFailMessageStringIsSameAs() {
        }

        void before(Object actual, String message, Object expected) {
            org.junit.jupiter.api.Assertions.assertSame((Object)expected, (Object)actual, (String)message);
        }

        void after(Object actual, String message, Object expected) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isSameAs(expected);
        }
    }

    static final class AssertThatIsSameAs {
        AssertThatIsSameAs() {
        }

        void before(Object actual, Object expected) {
            org.junit.jupiter.api.Assertions.assertSame((Object)expected, (Object)actual);
        }

        void after(Object actual, Object expected) {
            Assertions.assertThat((Object)actual).isSameAs(expected);
        }
    }

    static final class AssertThatWithFailMessageSupplierIsNotNull {
        AssertThatWithFailMessageSupplierIsNotNull() {
        }

        void before(Object actual, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)actual, supplier);
        }

        void after(Object actual, Supplier<String> supplier) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isNotNull();
        }
    }

    static final class AssertThatWithFailMessageStringIsNotNull {
        AssertThatWithFailMessageStringIsNotNull() {
        }

        void before(Object actual, String message) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)actual, (String)message);
        }

        void after(Object actual, String message) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNotNull();
        }
    }

    static final class AssertThatIsNotNull {
        AssertThatIsNotNull() {
        }

        void before(Object actual) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)actual);
        }

        void after(Object actual) {
            Assertions.assertThat((Object)actual).isNotNull();
        }
    }

    static final class AssertThatWithFailMessageSupplierIsNull {
        AssertThatWithFailMessageSupplierIsNull() {
        }

        void before(Object actual, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertNull((Object)actual, supplier);
        }

        void after(Object actual, Supplier<String> supplier) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isNull();
        }
    }

    static final class AssertThatWithFailMessageStringIsNull {
        AssertThatWithFailMessageStringIsNull() {
        }

        void before(Object actual, String message) {
            org.junit.jupiter.api.Assertions.assertNull((Object)actual, (String)message);
        }

        void after(Object actual, String message) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNull();
        }
    }

    static final class AssertThatIsNull {
        AssertThatIsNull() {
        }

        void before(Object actual) {
            org.junit.jupiter.api.Assertions.assertNull((Object)actual);
        }

        void after(Object actual) {
            Assertions.assertThat((Object)actual).isNull();
        }
    }

    static final class AssertThatWithFailMessageSupplierIsFalse {
        AssertThatWithFailMessageSupplierIsFalse() {
        }

        void before(boolean actual, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)actual, supplier);
        }

        void after(boolean actual, Supplier<String> supplier) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).withFailMessage(supplier)).isFalse();
        }
    }

    static final class AssertThatWithFailMessageStringIsFalse {
        AssertThatWithFailMessageStringIsFalse() {
        }

        void before(boolean actual, String message) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)actual, (String)message);
        }

        void after(boolean actual, String message) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).withFailMessage(message, new Object[0])).isFalse();
        }
    }

    static final class AssertThatIsFalse {
        AssertThatIsFalse() {
        }

        void before(boolean actual) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)actual);
        }

        void after(boolean actual) {
            Assertions.assertThat((boolean)actual).isFalse();
        }
    }

    static final class AssertThatWithFailMessageSupplierIsTrue {
        AssertThatWithFailMessageSupplierIsTrue() {
        }

        void before(boolean actual, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)actual, supplier);
        }

        void after(boolean actual, Supplier<String> supplier) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).withFailMessage(supplier)).isTrue();
        }
    }

    static final class AssertThatWithFailMessageStringIsTrue {
        AssertThatWithFailMessageStringIsTrue() {
        }

        void before(boolean actual, String message) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)actual, (String)message);
        }

        void after(boolean actual, String message) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).withFailMessage(message, new Object[0])).isTrue();
        }
    }

    static final class AssertThatIsTrue {
        AssertThatIsTrue() {
        }

        void before(boolean actual) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)actual);
        }

        void after(boolean actual) {
            Assertions.assertThat((boolean)actual).isTrue();
        }
    }

    static final class FailWithThrowable<T> {
        FailWithThrowable() {
        }

        T before(Throwable throwable) {
            return (T)org.junit.jupiter.api.Assertions.fail((Throwable)throwable);
        }

        @DoNotCall
        T after(Throwable throwable) {
            return (T)Assertions.fail((Throwable)throwable);
        }
    }

    static final class FailWithMessageAndThrowable<T> {
        FailWithMessageAndThrowable() {
        }

        T before(String message, Throwable throwable) {
            return (T)org.junit.jupiter.api.Assertions.fail((String)message, (Throwable)throwable);
        }

        T after(String message, Throwable throwable) {
            return (T)Assertions.fail((String)message, (Throwable)throwable);
        }
    }

    static final class FailWithMessage<T> {
        FailWithMessage() {
        }

        T before(String message) {
            return (T)org.junit.jupiter.api.Assertions.fail((String)message);
        }

        T after(String message) {
            return (T)Assertions.fail((String)message);
        }
    }

    static final class Fail<T> {
        Fail() {
        }

        T before() {
            return (T)org.junit.jupiter.api.Assertions.fail();
        }

        @DoNotCall
        T after() {
            return (T)Assertions.fail();
        }
    }

    static final class AssertThatObjectArrayWithFailMessageSupplierContainsExactly {
        AssertThatObjectArrayWithFailMessageSupplierContainsExactly() {
        }

        void before(Object[] actual, Supplier<String> message, Object[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expected, (Object[])actual, message);
        }

        void after(Object[] actual, Supplier<String> message, Object[] expected) {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).withFailMessage(message)).containsExactly(expected);
        }
    }

    static final class AssertThatObjectArrayWithFailMessageContainsExactly {
        AssertThatObjectArrayWithFailMessageContainsExactly() {
        }

        void before(Object[] actual, String message, Object[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expected, (Object[])actual, (String)message);
        }

        void after(Object[] actual, String message, Object[] expected) {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertThatObjectArrayContainsExactly {
        AssertThatObjectArrayContainsExactly() {
        }

        void before(Object[] actual, Object[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        }

        void after(Object[] actual, Object[] expected) {
            Assertions.assertThat((Object[])actual).containsExactly(expected);
        }
    }

    static final class AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffset {
        AssertThatDoubleArrayWithFailMessageSupplierContainsExactlyWithOffset() {
        }

        void before(double[] actual, Supplier<String> messageSupplier, double[] expected, double delta) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])expected, (double[])actual, (double)delta, messageSupplier);
        }

        void after(double[] actual, Supplier<String> messageSupplier, double[] expected, double delta) {
            ((AbstractDoubleArrayAssert)Assertions.assertThat((double[])actual).withFailMessage(messageSupplier)).containsExactly(expected, Assertions.offset((Double)delta));
        }
    }

    static final class AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffset {
        AssertThatDoubleArrayWithFailMessageContainsExactlyWithOffset() {
        }

        void before(double[] actual, String message, double[] expected, double delta) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])expected, (double[])actual, (double)delta, (String)message);
        }

        void after(double[] actual, String message, double[] expected, double delta) {
            ((AbstractDoubleArrayAssert)Assertions.assertThat((double[])actual).withFailMessage(message, new Object[0])).containsExactly(expected, Assertions.offset((Double)delta));
        }
    }

    static final class AssertThatDoubleArrayContainsExactlyWithOffset {
        AssertThatDoubleArrayContainsExactlyWithOffset() {
        }

        void before(double[] actual, double[] expected, double delta) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])expected, (double[])actual, (double)delta);
        }

        void after(double[] actual, double[] expected, double delta) {
            Assertions.assertThat((double[])actual).containsExactly(expected, Assertions.offset((Double)delta));
        }
    }

    static final class AssertThatDoubleArrayWithFailMessageSupplierContainsExactly {
        AssertThatDoubleArrayWithFailMessageSupplierContainsExactly() {
        }

        void before(double[] actual, Supplier<String> message, double[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])expected, (double[])actual, message);
        }

        void after(double[] actual, Supplier<String> message, double[] expected) {
            ((AbstractDoubleArrayAssert)Assertions.assertThat((double[])actual).withFailMessage(message)).containsExactly(expected);
        }
    }

    static final class AssertThatDoubleArrayWithFailMessageContainsExactly {
        AssertThatDoubleArrayWithFailMessageContainsExactly() {
        }

        void before(double[] actual, String message, double[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])expected, (double[])actual, (String)message);
        }

        void after(double[] actual, String message, double[] expected) {
            ((AbstractDoubleArrayAssert)Assertions.assertThat((double[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertThatDoubleArrayContainsExactly {
        AssertThatDoubleArrayContainsExactly() {
        }

        void before(double[] actual, double[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])expected, (double[])actual);
        }

        void after(double[] actual, double[] expected) {
            Assertions.assertThat((double[])actual).containsExactly(expected);
        }
    }

    static final class AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffset {
        AssertThatFloatArrayWithFailMessageSupplierContainsExactlyWithOffset() {
        }

        void before(float[] actual, Supplier<String> message, float[] expected, float delta) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((float[])expected, (float[])actual, (float)delta, message);
        }

        void after(float[] actual, Supplier<String> message, float[] expected, float delta) {
            ((AbstractFloatArrayAssert)Assertions.assertThat((float[])actual).withFailMessage(message)).containsExactly(expected, Assertions.offset((Float)Float.valueOf(delta)));
        }
    }

    static final class AssertThatFloatArrayWithFailMessageContainsExactlyWithOffset {
        AssertThatFloatArrayWithFailMessageContainsExactlyWithOffset() {
        }

        void before(float[] actual, String message, float[] expected, float delta) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((float[])expected, (float[])actual, (float)delta, (String)message);
        }

        void after(float[] actual, String message, float[] expected, float delta) {
            ((AbstractFloatArrayAssert)Assertions.assertThat((float[])actual).withFailMessage(message, new Object[0])).containsExactly(expected, Assertions.offset((Float)Float.valueOf(delta)));
        }
    }

    static final class AssertThatFloatArrayContainsExactlyWithOffset {
        AssertThatFloatArrayContainsExactlyWithOffset() {
        }

        void before(float[] actual, float[] expected, float delta) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((float[])expected, (float[])actual, (float)delta);
        }

        void after(float[] actual, float[] expected, float delta) {
            Assertions.assertThat((float[])actual).containsExactly(expected, Assertions.offset((Float)Float.valueOf(delta)));
        }
    }

    static final class AssertThatFloatArrayWithFailMessageSupplierContainsExactly {
        AssertThatFloatArrayWithFailMessageSupplierContainsExactly() {
        }

        void before(float[] actual, Supplier<String> message, float[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((float[])expected, (float[])actual, message);
        }

        void after(float[] actual, Supplier<String> message, float[] expected) {
            ((AbstractFloatArrayAssert)Assertions.assertThat((float[])actual).withFailMessage(message)).containsExactly(expected);
        }
    }

    static final class AssertThatFloatArrayWithFailMessageContainsExactly {
        AssertThatFloatArrayWithFailMessageContainsExactly() {
        }

        void before(float[] actual, String message, float[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((float[])expected, (float[])actual, (String)message);
        }

        void after(float[] actual, String message, float[] expected) {
            ((AbstractFloatArrayAssert)Assertions.assertThat((float[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertThatFloatArrayContainsExactly {
        AssertThatFloatArrayContainsExactly() {
        }

        void before(float[] actual, float[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((float[])expected, (float[])actual);
        }

        void after(float[] actual, float[] expected) {
            Assertions.assertThat((float[])actual).containsExactly(expected);
        }
    }

    static final class AssertThatLongArrayWithFailMessageSupplierContainsExactly {
        AssertThatLongArrayWithFailMessageSupplierContainsExactly() {
        }

        void before(long[] actual, Supplier<String> message, long[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((long[])expected, (long[])actual, message);
        }

        void after(long[] actual, Supplier<String> message, long[] expected) {
            ((AbstractLongArrayAssert)Assertions.assertThat((long[])actual).withFailMessage(message)).containsExactly(expected);
        }
    }

    static final class AssertThatLongArrayWithFailMessageContainsExactly {
        AssertThatLongArrayWithFailMessageContainsExactly() {
        }

        void before(long[] actual, String message, long[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((long[])expected, (long[])actual, (String)message);
        }

        void after(long[] actual, String message, long[] expected) {
            ((AbstractLongArrayAssert)Assertions.assertThat((long[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertThatLongArrayContainsExactly {
        AssertThatLongArrayContainsExactly() {
        }

        void before(long[] actual, long[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((long[])expected, (long[])actual);
        }

        void after(long[] actual, long[] expected) {
            Assertions.assertThat((long[])actual).containsExactly(expected);
        }
    }

    static final class AssertThatIntArrayWithFailMessageSupplierContainsExactly {
        AssertThatIntArrayWithFailMessageSupplierContainsExactly() {
        }

        void before(int[] actual, Supplier<String> message, int[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((int[])expected, (int[])actual, message);
        }

        void after(int[] actual, Supplier<String> message, int[] expected) {
            ((AbstractIntArrayAssert)Assertions.assertThat((int[])actual).withFailMessage(message)).containsExactly(expected);
        }
    }

    static final class AssertThatIntArrayWithFailMessageContainsExactly {
        AssertThatIntArrayWithFailMessageContainsExactly() {
        }

        void before(int[] actual, String message, int[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((int[])expected, (int[])actual, (String)message);
        }

        void after(int[] actual, String message, int[] expected) {
            ((AbstractIntArrayAssert)Assertions.assertThat((int[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertThatIntArrayContainsExactly {
        AssertThatIntArrayContainsExactly() {
        }

        void before(int[] actual, int[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((int[])expected, (int[])actual);
        }

        void after(int[] actual, int[] expected) {
            Assertions.assertThat((int[])actual).containsExactly(expected);
        }
    }

    static final class AssertThatShortArrayWithFailMessageSupplierContainsExactly {
        AssertThatShortArrayWithFailMessageSupplierContainsExactly() {
        }

        void before(short[] actual, Supplier<String> message, short[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((short[])expected, (short[])actual, message);
        }

        void after(short[] actual, Supplier<String> message, short[] expected) {
            ((AbstractShortArrayAssert)Assertions.assertThat((short[])actual).withFailMessage(message)).containsExactly(expected);
        }
    }

    static final class AssertThatShortArrayWithFailMessageContainsExactly {
        AssertThatShortArrayWithFailMessageContainsExactly() {
        }

        void before(short[] actual, String message, short[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((short[])expected, (short[])actual, (String)message);
        }

        void after(short[] actual, String message, short[] expected) {
            ((AbstractShortArrayAssert)Assertions.assertThat((short[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertThatShortArrayContainsExactly {
        AssertThatShortArrayContainsExactly() {
        }

        void before(short[] actual, short[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((short[])expected, (short[])actual);
        }

        void after(short[] actual, short[] expected) {
            Assertions.assertThat((short[])actual).containsExactly(expected);
        }
    }

    static final class AssertThatCharArrayWithFailMessageSupplierContainsExactly {
        AssertThatCharArrayWithFailMessageSupplierContainsExactly() {
        }

        void before(char[] actual, Supplier<String> message, char[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((char[])expected, (char[])actual, message);
        }

        void after(char[] actual, Supplier<String> message, char[] expected) {
            ((AbstractCharArrayAssert)Assertions.assertThat((char[])actual).withFailMessage(message)).containsExactly(expected);
        }
    }

    static final class AssertThatCharArrayWithFailMessageContainsExactly {
        AssertThatCharArrayWithFailMessageContainsExactly() {
        }

        void before(char[] actual, String message, char[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((char[])expected, (char[])actual, (String)message);
        }

        void after(char[] actual, String message, char[] expected) {
            ((AbstractCharArrayAssert)Assertions.assertThat((char[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertThatCharArrayContainsExactly {
        AssertThatCharArrayContainsExactly() {
        }

        void before(char[] actual, char[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((char[])expected, (char[])actual);
        }

        void after(char[] actual, char[] expected) {
            Assertions.assertThat((char[])actual).containsExactly(expected);
        }
    }

    static final class AssertThatByteArrayWithFailMessageSupplierContainsExactly {
        AssertThatByteArrayWithFailMessageSupplierContainsExactly() {
        }

        void before(byte[] actual, Supplier<String> message, byte[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expected, (byte[])actual, message);
        }

        void after(byte[] actual, Supplier<String> message, byte[] expected) {
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actual).withFailMessage(message)).containsExactly(expected);
        }
    }

    static final class AssertThatByteArrayWithFailMessageContainsExactly {
        AssertThatByteArrayWithFailMessageContainsExactly() {
        }

        void before(byte[] actual, String message, byte[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expected, (byte[])actual, (String)message);
        }

        void after(byte[] actual, String message, byte[] expected) {
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertThatByteArrayContainsExactly {
        AssertThatByteArrayContainsExactly() {
        }

        void before(byte[] actual, byte[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }

        void after(byte[] actual, byte[] expected) {
            Assertions.assertThat((byte[])actual).containsExactly(expected);
        }
    }

    static final class AssertThatBooleanArrayWithFailMessageSupplierContainsExactly {
        AssertThatBooleanArrayWithFailMessageSupplierContainsExactly() {
        }

        void before(boolean[] actual, Supplier<String> message, boolean[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((boolean[])expected, (boolean[])actual, message);
        }

        void after(boolean[] actual, Supplier<String> message, boolean[] expected) {
            ((AbstractBooleanArrayAssert)Assertions.assertThat((boolean[])actual).withFailMessage(message)).containsExactly(expected);
        }
    }

    static final class AssertThatBooleanArrayWithFailMessageContainsExactly {
        AssertThatBooleanArrayWithFailMessageContainsExactly() {
        }

        void before(boolean[] actual, String message, boolean[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((boolean[])expected, (boolean[])actual, (String)message);
        }

        void after(boolean[] actual, String message, boolean[] expected) {
            ((AbstractBooleanArrayAssert)Assertions.assertThat((boolean[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertThatBooleanArrayContainsExactly {
        AssertThatBooleanArrayContainsExactly() {
        }

        void before(boolean[] actual, boolean[] expected) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((boolean[])expected, (boolean[])actual);
        }

        void after(boolean[] actual, boolean[] expected) {
            Assertions.assertThat((boolean[])actual).containsExactly(expected);
        }
    }
}

