/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@BugPattern(summary="Make sure `Ordering#explicit` lists all of an enum's values", link="https://error-prone.picnic.tech/bugpatterns/ExplicitEnumOrdering", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class ExplicitEnumOrdering
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> EXPLICIT_ORDERING = MethodMatchers.staticMethod().onClass(Ordering.class.getCanonicalName()).named("explicit");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!EXPLICIT_ORDERING.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ImmutableSet<String> missingEnumValues = ExplicitEnumOrdering.getMissingEnumValues(tree.getArguments());
        if (missingEnumValues.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Explicit ordering lacks some enum values: %s", String.join((CharSequence)", ", missingEnumValues))).build();
    }

    private static ImmutableSet<String> getMissingEnumValues(List<? extends ExpressionTree> expressions) {
        return expressions.stream().map(ASTHelpers::getSymbol).filter(s -> s != null && s.isEnum()).collect(Collectors.collectingAndThen(ImmutableSetMultimap.toImmutableSetMultimap(Symbol::asType, Symbol::toString), ExplicitEnumOrdering::getMissingEnumValues));
    }

    private static ImmutableSet<String> getMissingEnumValues(ImmutableSetMultimap<Type, String> valuesByType) {
        return (ImmutableSet)Multimaps.asMap(valuesByType).entrySet().stream().flatMap(e -> ExplicitEnumOrdering.getMissingEnumValues((Type)e.getKey(), (Set)e.getValue())).collect(ImmutableSet.toImmutableSet());
    }

    private static Stream<String> getMissingEnumValues(Type enumType, Set<String> values) {
        Symbol.TypeSymbol typeSymbol = enumType.asElement();
        return Sets.difference((Set)ASTHelpers.enumValues((Symbol.TypeSymbol)typeSymbol), values).stream().map(v -> String.join((CharSequence)".", typeSymbol.getSimpleName(), v));
    }
}

