/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class PatternRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`PatternRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to code dealing with regular expressions\n[Source](https://error-prone.picnic.tech/refasterrules/PatternRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new PatternAsPredicateRecipe(), new PatternCompileAsPredicateRecipe()});
    }

    @NullMarked
    public static class PatternAsPredicateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PatternRules.PatternAsPredicate`";
        }

        public String getDescription() {
            return "Prefer `Pattern#asPredicate()` over non-JDK alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.base.Predicates.contains(#{pattern:any(java.util.regex.Pattern)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{pattern:any(java.util.regex.Pattern)}.asPredicate()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Predicates");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Predicates", Boolean.valueOf(true)), new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("java.util.regex.Pattern", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Predicates contains(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PatternCompileAsPredicateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PatternRules.PatternCompileAsPredicate`";
        }

        public String getDescription() {
            return "Prefer `Pattern#asPredicate()` over non-JDK alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.base.Predicates.containsPattern(#{pattern:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.regex.Pattern.compile(#{pattern:any(java.lang.String)}).asPredicate()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Predicates.containsPattern");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Predicates containsPattern(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

