/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class IntStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`IntStreamRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `IntStream`s [Source](https://error-prone.picnic.tech/refasterrules/IntStreamRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new IntStreamClosedOpenRangeRecipe(), new ConcatOneIntStreamRecipe(), new ConcatTwoIntStreamsRecipe(), new IntStreamFilterSortedRecipe(), new IntStreamIsEmptyRecipe(), new IntStreamIsNotEmptyRecipe(), new IntStreamMinRecipe(), new IntStreamNoneMatchRecipe(), new IntStreamAnyMatchRecipe(), new IntStreamAllMatchRecipe(), new IntStreamTakeWhileRecipe()});
    }

    @NullMarked
    public static class IntStreamClosedOpenRangeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamClosedOpenRange`";
        }

        public String getDescription() {
            return "Prefer `IntStream#range(int, int)` over the more contrived alternative";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.util.stream.IntStream.rangeClosed(#{from:any(int)}, #{to:any(int)} - 1)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.IntStream.range(#{from:any(int)}, #{to:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.IntStream rangeClosed(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConcatOneIntStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.ConcatOneIntStream`";
        }

        public String getDescription() {
            return "Don't unnecessarily call `Streams#concat(IntStream...)`";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{stream:any(java.util.stream.IntStream)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConcatTwoIntStreamsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.ConcatTwoIntStreams`";
        }

        public String getDescription() {
            return "Prefer `IntStream#concat(IntStream, IntStream)` over the Guava alternative";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{s1:any(java.util.stream.IntStream)}, #{s2:any(java.util.stream.IntStream)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.IntStream.concat(#{s1:any(java.util.stream.IntStream)}, #{s2:any(java.util.stream.IntStream)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntStreamFilterSortedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamFilterSorted`";
        }

        public String getDescription() {
            return "Apply `IntStream#filter(IntPredicate)` before `IntStream#sorted()` to reduce the number of elements to sort";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.sorted().filter(#{predicate:any(java.util.function.IntPredicate)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.filter(#{predicate:any(java.util.function.IntPredicate)}).sorted()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.IntPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.IntStream filter(..)", true), new UsesMethod("java.util.stream.IntStream sorted(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntStreamIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamIsEmpty`";
        }

        public String getDescription() {
            return "In order to test whether a stream has any element, simply try to find one";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.count() == 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.count() <= 0").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.count() < 1").build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.findFirst().isEmpty()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.findAny().isEmpty()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.IntStream count(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalInt isEmpty(..)", true), new UsesMethod("java.util.stream.IntStream findFirst(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntStreamIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamIsNotEmpty`";
        }

        public String getDescription() {
            return "In order to test whether a stream has any element, simply try to find one";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.count() != 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.count() > 0").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.count() >= 1").build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.findFirst().isPresent()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.findAny().isPresent()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.IntStream count(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalInt isPresent(..)", true), new UsesMethod("java.util.stream.IntStream findFirst(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntStreamMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamMin`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamMin {\n    \n    @BeforeTemplate\n    OptionalInt before(IntStream stream) {\n        return stream.sorted().findFirst();\n    }\n    \n    @AfterTemplate\n    OptionalInt after(IntStream stream) {\n        return stream.min();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.sorted().findFirst()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.min()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalInt", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.IntStream findFirst(..)", true), new UsesMethod("java.util.stream.IntStream sorted(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntStreamNoneMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamNoneMatch`";
        }

        public String getDescription() {
            return "Prefer `IntStream#noneMatch(IntPredicate)` over more contrived alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!#{stream:any(java.util.stream.IntStream)}.anyMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.allMatch(#{predicate:any(java.util.function.IntPredicate)}.negate())").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.filter(#{predicate:any(java.util.function.IntPredicate)}).findAny().isEmpty()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.IntPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.IntStream anyMatch(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalInt isEmpty(..)", true), new UsesMethod("java.util.stream.IntStream filter(..)", true), new UsesMethod("java.util.stream.IntStream findAny(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.function.IntPredicate negate(..)", true), new UsesMethod("java.util.stream.IntStream allMatch(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntStreamAnyMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamAnyMatch`";
        }

        public String getDescription() {
            return "Prefer `IntStream#anyMatch(IntPredicate)` over more contrived alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.filter(#{predicate:any(java.util.function.IntPredicate)}).findAny().isPresent()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.anyMatch(#{predicate:any(java.util.function.IntPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.IntPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.IntStream noneMatch(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalInt isPresent(..)", true), new UsesMethod("java.util.stream.IntStream filter(..)", true), new UsesMethod("java.util.stream.IntStream findAny(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntStreamAllMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamAllMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamAllMatch {\n    \n    @BeforeTemplate\n    boolean before(IntStream stream, IntPredicate predicate) {\n        return stream.noneMatch(predicate.negate());\n    }\n    \n    @AfterTemplate\n    boolean after(IntStream stream, IntPredicate predicate) {\n        return stream.allMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.noneMatch(#{predicate:any(java.util.function.IntPredicate)}.negate())").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.allMatch(#{predicate:any(java.util.function.IntPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.IntPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.function.IntPredicate negate(..)", true), new UsesMethod("java.util.stream.IntStream noneMatch(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IntStreamTakeWhileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamTakeWhile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamTakeWhile {\n    \n    @BeforeTemplate\n    IntStream before(IntStream stream, IntPredicate predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    IntStream after(IntStream stream, IntPredicate predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.takeWhile(#{predicate:any(java.util.function.IntPredicate)}).filter(#{predicate})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.IntStream)}.takeWhile(#{predicate:any(java.util.function.IntPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.IntPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.IntStream filter(..)", true), new UsesMethod("java.util.stream.IntStream takeWhile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

