/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class BugCheckerRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`BugCheckerRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to `com.google.errorprone.bugpatterns.BugChecker` classes [Source](https://error-prone.picnic.tech/refasterrules/BugCheckerRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new BugCheckerRefactoringTestHelperIdentityRecipe(), new BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe(), new NameContentEqualsRecipe()});
    }

    @NullMarked
    public static class BugCheckerRefactoringTestHelperIdentityRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `BugCheckerRules.BugCheckerRefactoringTestHelperIdentity`";
        }

        public String getDescription() {
            return "Avoid calling `BugCheckerRefactoringTestHelper#setFixChooser(FixChooser)` or `BugCheckerRefactoringTestHelper#setImportOrder(String)` with their respective default values";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setFixChooser(com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers.FIRST)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setImportOrder(\"static-first\")").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper setImportOrder(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper setFixChooser(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `BugCheckerRules.BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged`";
        }

        public String getDescription() {
            return "Prefer `BugCheckerRefactoringTestHelper.ExpectOutput#expectUnchanged()` over repeating the input";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).addOutputLines(#{path}, #{source})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).expectUnchanged()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper addInputLines(..)", true), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput addOutputLines(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NameContentEqualsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `BugCheckerRules.NameContentEquals`";
        }

        public String getDescription() {
            return "Prefer `Name#contentEquals(CharSequence)` over more verbose alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.CharSequence)}.toString())").build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.String)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.contentEquals(#{string:any(java.lang.CharSequence)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.lang.model.element.Name", Boolean.valueOf(true)), new UsesMethod("java.lang.CharSequence toString(..)", true), new UsesMethod("java.lang.String equals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

