/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

final class AssertJBooleanTemplates {
    private AssertJBooleanTemplates() {
    }

    static final class AssertThatBooleanIsFalse {
        AssertThatBooleanIsFalse() {
        }

        AbstractBooleanAssert<?> before(boolean b) {
            return Assertions.assertThat((!b ? 1 : 0) != 0).isTrue();
        }

        AbstractBooleanAssert<?> after(boolean b) {
            return Assertions.assertThat((boolean)b).isFalse();
        }
    }

    static final class AbstractBooleanAssertIsFalse {
        AbstractBooleanAssertIsFalse() {
        }

        AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{boolAssert.isEqualTo(false), (AbstractBooleanAssert)boolAssert.isEqualTo((Object)Boolean.FALSE), boolAssert.isNotEqualTo(true), (AbstractBooleanAssert)boolAssert.isNotEqualTo((Object)Boolean.TRUE)});
        }

        AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert) {
            return boolAssert.isFalse();
        }
    }

    static final class AssertThatBooleanIsTrue {
        AssertThatBooleanIsTrue() {
        }

        AbstractBooleanAssert<?> before(boolean b) {
            return Assertions.assertThat((!b ? 1 : 0) != 0).isFalse();
        }

        AbstractBooleanAssert<?> after(boolean b) {
            return Assertions.assertThat((boolean)b).isTrue();
        }
    }

    static final class AbstractBooleanAssertIsTrue {
        AbstractBooleanAssertIsTrue() {
        }

        AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{boolAssert.isEqualTo(true), (AbstractBooleanAssert)boolAssert.isEqualTo((Object)Boolean.TRUE), boolAssert.isNotEqualTo(false), (AbstractBooleanAssert)boolAssert.isNotEqualTo((Object)Boolean.FALSE)});
        }

        AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert) {
            return boolAssert.isTrue();
        }
    }

    static final class AbstractBooleanAssertIsNotEqualTo {
        AbstractBooleanAssertIsNotEqualTo() {
        }

        AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert, boolean other) {
            return boolAssert.isEqualTo(!other);
        }

        AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert, boolean other) {
            return boolAssert.isNotEqualTo(other);
        }
    }

    static final class AbstractBooleanAssertIsEqualTo {
        AbstractBooleanAssertIsEqualTo() {
        }

        AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert, boolean other) {
            return boolAssert.isNotEqualTo(!other);
        }

        AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert, boolean other) {
            return boolAssert.isEqualTo(other);
        }
    }
}

