/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Sort annotations lexicographically where possible", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class LexicographicalAnnotationListing
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final long serialVersionUID = 1L;

    public Description matchMethod(MethodTree tree, VisitorState state) {
        List<? extends AnnotationTree> originalOrdering = tree.getModifiers().getAnnotations();
        if (originalOrdering.size() < 2) {
            return Description.NO_MATCH;
        }
        ImmutableList<? extends AnnotationTree> sortedAnnotations = LexicographicalAnnotationListing.sort(originalOrdering, state);
        if (originalOrdering.equals(sortedAnnotations)) {
            return Description.NO_MATCH;
        }
        Optional<Fix> fix = LexicographicalAnnotationListing.tryFixOrdering(originalOrdering, sortedAnnotations, state);
        Description.Builder description = this.buildDescription(originalOrdering.get(0));
        fix.ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
        return description.build();
    }

    private static ImmutableList<? extends AnnotationTree> sort(List<? extends AnnotationTree> annotations, VisitorState state) {
        return (ImmutableList)annotations.stream().sorted(Comparator.comparing(annotation -> SourceCode.treeToString(annotation, state))).collect(ImmutableList.toImmutableList());
    }

    private static Optional<Fix> tryFixOrdering(List<? extends AnnotationTree> originalAnnotations, ImmutableList<? extends AnnotationTree> sortedAnnotations, VisitorState state) {
        return Streams.zip(originalAnnotations.stream(), (Stream)sortedAnnotations.stream(), (original, replacement) -> SuggestedFix.builder().replace((Tree)original, SourceCode.treeToString(replacement, state))).reduce(SuggestedFix.Builder::merge).map(SuggestedFix.Builder::build);
    }
}

