/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.Splitter;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@BugPattern(summary="Test code should follow the Google Java style", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class ErrorProneTestHelperSourceFormat
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Formatter FORMATTER = new Formatter();
    private static final Matcher<ExpressionTree> INPUT_SOURCE_ACCEPTING_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("com.google.errorprone.CompilationTestHelper").named("addSourceLines"), Matchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper").named("addInputLines")});
    private static final Matcher<ExpressionTree> OUTPUT_SOURCE_ACCEPTING_METHOD = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput").named("addOutputLines");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        boolean isOutputSource = OUTPUT_SOURCE_ACCEPTING_METHOD.matches((Tree)tree, state);
        if (!isOutputSource && !INPUT_SOURCE_ACCEPTING_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> sourceLines = tree.getArguments().subList(1, tree.getArguments().size());
        if (sourceLines.isEmpty()) {
            return this.buildDescription(tree).setMessage("No source code provided").build();
        }
        int startPos = ASTHelpers.getStartPosition((Tree)sourceLines.get(0));
        int endPos = state.getEndPosition((Tree)sourceLines.get(sourceLines.size() - 1));
        return ErrorProneTestHelperSourceFormat.getConstantSourceCode(sourceLines).map(source -> this.flagFormattingIssues(startPos, endPos, (String)source, isOutputSource, state)).orElse(Description.NO_MATCH);
    }

    private Description flagFormattingIssues(int startPos, int endPos, String source, boolean retainUnusedImports, VisitorState state) {
        String formatted;
        Tree methodInvocation = state.getPath().getLeaf();
        try {
            formatted = ErrorProneTestHelperSourceFormat.formatSourceCode(source, retainUnusedImports).trim();
        }
        catch (FormatterException e) {
            return this.buildDescription(methodInvocation).setMessage(String.format("Source code is malformed: %s", e.getMessage())).build();
        }
        if (source.trim().equals(formatted)) {
            return Description.NO_MATCH;
        }
        if (startPos == -1 || endPos == -1) {
            return this.describeMatch(methodInvocation);
        }
        return this.describeMatch(methodInvocation, (Fix)SuggestedFix.replace((int)startPos, (int)endPos, (String)Splitter.on((char)'\n').splitToStream((CharSequence)formatted).map(arg_0 -> ((VisitorState)state).getConstantExpression(arg_0)).collect(Collectors.joining(", "))));
    }

    private static String formatSourceCode(String source, boolean retainUnusedImports) throws FormatterException {
        String withReorderedImports = ImportOrderer.reorderImports((String)source, (JavaFormatterOptions.Style)JavaFormatterOptions.Style.GOOGLE);
        String withOptionallyRemovedImports = retainUnusedImports ? withReorderedImports : RemoveUnusedImports.removeUnusedImports((String)withReorderedImports);
        return FORMATTER.formatSource(withOptionallyRemovedImports);
    }

    private static Optional<String> getConstantSourceCode(List<? extends ExpressionTree> sourceLines) {
        StringBuilder source = new StringBuilder();
        for (ExpressionTree expressionTree : sourceLines) {
            Object value = ASTHelpers.constValue((Tree)expressionTree);
            if (value == null) {
                return Optional.empty();
            }
            source.append(value).append('\n');
        }
        return Optional.of(source.toString());
    }
}

