/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.refaster.Refaster;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.Optional;
import java.util.stream.Collectors;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Prefer `Optional#orElseGet` over `Optional#orElse` if the fallback requires additional computation", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.WARNING, tags={"Performance"})
@AutoService(value={BugChecker.class})
public final class OptionalOrElse
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> OPTIONAL_OR_ELSE_METHOD = Matchers.instanceMethod().onExactClass(Optional.class.getCanonicalName()).namedAnyOf(new String[]{"orElse"});
    private static final Matcher<ExpressionTree> REFASTER_METHOD = Matchers.staticMethod().onClass(Refaster.class.getCanonicalName());

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!OPTIONAL_OR_ELSE_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        if (!OptionalOrElse.requiresComputation(argument) || REFASTER_METHOD.matches((Tree)argument, state)) {
            return Description.NO_MATCH;
        }
        String newArgument = OptionalOrElse.tryMethodReferenceConversion(argument, state).orElseGet(() -> "() -> " + SourceCode.treeToString((Tree)argument, (VisitorState)state));
        SuggestedFix fix = SuggestedFix.builder().merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"orElseGet", (VisitorState)state)).replace((Tree)argument, newArgument).build();
        return this.describeMatch(tree, (Fix)fix);
    }

    private static boolean requiresComputation(ExpressionTree tree) {
        MemberSelectTree memberSelect;
        return !(tree instanceof IdentifierTree || tree instanceof LiteralTree || tree instanceof MemberSelectTree && !OptionalOrElse.requiresComputation((memberSelect = (MemberSelectTree)tree).getExpression()) || ASTHelpers.constValue((Tree)tree) != null);
    }

    private static Optional<String> tryMethodReferenceConversion(ExpressionTree tree, VisitorState state) {
        if (!(tree instanceof MethodInvocationTree)) {
            return Optional.empty();
        }
        MethodInvocationTree methodInvocation = (MethodInvocationTree)tree;
        if (!methodInvocation.getArguments().isEmpty()) {
            return Optional.empty();
        }
        ExpressionTree expressionTree = methodInvocation.getMethodSelect();
        if (!(expressionTree instanceof MemberSelectTree)) {
            return Optional.empty();
        }
        MemberSelectTree memberSelect = (MemberSelectTree)expressionTree;
        if (OptionalOrElse.requiresComputation(memberSelect.getExpression())) {
            return Optional.empty();
        }
        return Optional.of(SourceCode.treeToString((Tree)memberSelect.getExpression(), (VisitorState)state) + "::" + (methodInvocation.getTypeArguments().isEmpty() ? "" : methodInvocation.getTypeArguments().stream().map(arg -> SourceCode.treeToString((Tree)arg, (VisitorState)state)).collect(Collectors.joining(",", "<", ">"))) + String.valueOf(memberSelect.getIdentifier()));
    }
}

