/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import tech.picnic.errorprone.utils.MoreTypePredicates;
import tech.picnic.errorprone.utils.MoreTypes;

@BugPattern(summary="Don't pass a `Mono<Void>` or `Mono.empty()` argument to `Mono#{zip,With}`", link="https://error-prone.picnic.tech/bugpatterns/EmptyMonoZip", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class EmptyMonoZip
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Supplier<Type> MONO = Suppliers.typeFromString((String)"reactor.core.publisher.Mono");
    private static final Matcher<ExpressionTree> MONO_ZIP_OR_ZIP_WITH = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf(MONO).named("zipWith"), Matchers.staticMethod().onClass(MONO).named("zip")});
    private static final Matcher<ExpressionTree> EMPTY_MONO = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onDescendantOf(MONO).named("empty"), Matchers.typePredicateMatcher((TypePredicate)MoreTypePredicates.isSubTypeOf((Supplier)MoreTypes.generic(MONO, (Supplier[])new Supplier[]{MoreTypes.type((String)Void.class.getCanonicalName())})))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MONO_ZIP_OR_ZIP_WITH.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (EmptyMonoZip.hasEmptyReceiver(tree, state)) {
            return this.buildDescription(tree).setMessage("Invoking `Mono#zipWith` on `Mono#empty()` or a `Mono<Void>` is a no-op").build();
        }
        if (EmptyMonoZip.hasEmptyArguments(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean hasEmptyReceiver(MethodInvocationTree tree, VisitorState state) {
        MemberSelectTree memberSelect;
        ExpressionTree expressionTree = tree.getMethodSelect();
        return expressionTree instanceof MemberSelectTree && EMPTY_MONO.matches((Tree)(memberSelect = (MemberSelectTree)expressionTree).getExpression(), state);
    }

    private static boolean hasEmptyArguments(MethodInvocationTree tree, VisitorState state) {
        return tree.getArguments().stream().anyMatch(arg -> EMPTY_MONO.matches((Tree)arg, state));
    }
}

