/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class JUnitToAssertJRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules to replace JUnit assertions with AssertJ equivalents";
    }

    public String getDescription() {
        return "<p>Note that, while both libraries throw an `AssertionError` in case of an assertion\n failure, the exact subtype used generally differs. [Source](https://error-prone.picnic.tech/refasterrules/JUnitToAssertJRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ThrowNewAssertionErrorRecipe(), new FailWithThrowableRecipe(), new AssertThatIsTrueRecipe(), new AssertThatWithFailMessageStringIsTrueRecipe(), new AssertThatWithFailMessageSupplierIsTrueRecipe(), new AssertThatIsFalseRecipe(), new AssertThatWithFailMessageStringIsFalseRecipe(), new AssertThatWithFailMessageSupplierIsFalseRecipe(), new AssertThatIsNullRecipe(), new AssertThatWithFailMessageStringIsNullRecipe(), new AssertThatWithFailMessageSupplierIsNullRecipe(), new AssertThatIsNotNullRecipe(), new AssertThatWithFailMessageStringIsNotNullRecipe(), new AssertThatWithFailMessageSupplierIsNotNullRecipe(), new AssertThatIsSameAsRecipe(), new AssertThatWithFailMessageStringIsSameAsRecipe(), new AssertThatWithFailMessageSupplierIsSameAsRecipe(), new AssertThatIsNotSameAsRecipe(), new AssertThatWithFailMessageStringIsNotSameAsRecipe(), new AssertThatWithFailMessageSupplierIsNotSameAsRecipe(), new AssertThatCodeDoesNotThrowAnyExceptionRecipe(), new AssertThatCodeWithFailMessageStringDoesNotThrowAnyExceptionRecipe(), new AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyExceptionRecipe()});
    }

    @NonNullApi
    public static class ThrowNewAssertionErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.ThrowNewAssertionError`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ThrowNewAssertionError {\n    \n    @BeforeTemplate\n    void before() {\n        Assertions.fail();\n    }\n    \n    @AfterTemplate\n    @DoNotCall\n    void after() {\n        throw new AssertionError();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.fail()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"throw new AssertionError();").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.Assertions", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions fail(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FailWithThrowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.FailWithThrowable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithThrowable {\n    \n    @BeforeTemplate\n    void before(Throwable throwable) {\n        Assertions.fail(throwable);\n    }\n    \n    @AfterTemplate\n    @DoNotCall\n    void after(Throwable throwable) {\n        throw new AssertionError(throwable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.fail(#{throwable:any(java.lang.Throwable)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"throw new AssertionError(#{throwable:any(java.lang.Throwable)});").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.Assertions", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions fail(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatIsTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsTrue {\n    \n    @BeforeTemplate\n    void before(boolean actual) {\n        assertTrue(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual) {\n        assertThat(actual).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(#{actual:any(boolean)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isTrue()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageStringIsTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsTrue {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message) {\n        assertTrue(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, String message) {\n        assertThat(actual).withFailMessage(message).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(#{actual:any(boolean)}, #{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isTrue()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageSupplierIsTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsTrue {\n    \n    @BeforeTemplate\n    void before(boolean actual, Supplier<String> supplier) {\n        assertTrue(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, Supplier<String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(#{actual:any(boolean)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isTrue()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatIsFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsFalse {\n    \n    @BeforeTemplate\n    void before(boolean actual) {\n        assertFalse(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual) {\n        assertThat(actual).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(#{actual:any(boolean)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isFalse()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageStringIsFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsFalse {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message) {\n        assertFalse(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, String message) {\n        assertThat(actual).withFailMessage(message).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(#{actual:any(boolean)}, #{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isFalse()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageSupplierIsFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsFalse {\n    \n    @BeforeTemplate\n    void before(boolean actual, Supplier<String> supplier) {\n        assertFalse(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean actual, Supplier<String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(#{actual:any(boolean)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isFalse()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatIsNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNull {\n    \n    @BeforeTemplate\n    void before(Object actual) {\n        assertNull(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual) {\n        assertThat(actual).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNull(#{actual:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNull()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNull(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageStringIsNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsNull {\n    \n    @BeforeTemplate\n    void before(Object actual, String message) {\n        assertNull(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message) {\n        assertThat(actual).withFailMessage(message).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNull(#{actual:any(java.lang.Object)}, #{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNull()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNull(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageSupplierIsNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsNull {\n    \n    @BeforeTemplate\n    void before(Object actual, Supplier<String> supplier) {\n        assertNull(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNull(#{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isNull()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertNull(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatIsNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsNotNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotNull {\n    \n    @BeforeTemplate\n    void before(Object actual) {\n        assertNotNull(actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual) {\n        assertThat(actual).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotNull(#{actual:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotNull()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNotNull(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageStringIsNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsNotNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsNotNull {\n    \n    @BeforeTemplate\n    void before(Object actual, String message) {\n        assertNotNull(actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message) {\n        assertThat(actual).withFailMessage(message).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotNull(#{actual:any(java.lang.Object)}, #{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotNull()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNotNull(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageSupplierIsNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNotNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsNotNull {\n    \n    @BeforeTemplate\n    void before(Object actual, Supplier<String> supplier) {\n        assertNotNull(actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<String> supplier) {\n        assertThat(actual).withFailMessage(supplier).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotNull(#{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isNotNull()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertNotNull(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatIsSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertSame(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isSameAs(#{expected:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertSame(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageStringIsSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertSame(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isSameAs(#{expected:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertSame(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageSupplierIsSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Supplier<String> supplier, Object expected) {\n        assertSame(expected, actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<String> supplier, Object expected) {\n        assertThat(actual).withFailMessage(supplier).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isSameAs(#{expected:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertSame(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatIsNotSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatIsNotSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertNotSame(expected, actual);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotSameAs(#{expected:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNotSame(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageStringIsNotSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageStringIsNotSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageStringIsNotSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertNotSame(expected, actual, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotSameAs(#{expected:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertNotSame(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatWithFailMessageSupplierIsNotSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatWithFailMessageSupplierIsNotSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatWithFailMessageSupplierIsNotSameAs {\n    \n    @BeforeTemplate\n    void before(Object actual, Supplier<String> supplier, Object expected) {\n        assertNotSame(expected, actual, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Supplier<String> supplier, Object expected) {\n        assertThat(actual).withFailMessage(supplier).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertNotSame(#{expected:any(java.lang.Object)}, #{actual:any(java.lang.Object)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).isNotSameAs(#{expected:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertNotSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertNotSame(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatCodeDoesNotThrowAnyExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatCodeDoesNotThrowAnyException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCodeDoesNotThrowAnyException {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable) {\n        assertDoesNotThrow(throwingCallable);\n    }\n    \n    @BeforeTemplate\n    void before(ThrowingSupplier<?> throwingCallable) {\n        assertDoesNotThrow(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable) {\n        assertThatCode(throwingCallable).doesNotThrowAnyException();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.Executable)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.ThrowingSupplier<?>)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).doesNotThrowAnyException()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.ThrowingSupplier");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.function.ThrowingSupplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertDoesNotThrow(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatCodeWithFailMessageStringDoesNotThrowAnyExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatCodeWithFailMessageStringDoesNotThrowAnyException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCodeWithFailMessageStringDoesNotThrowAnyException {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable, String message) {\n        assertDoesNotThrow(throwingCallable, message);\n    }\n    \n    @BeforeTemplate\n    void before(ThrowingSupplier<?> throwingCallable, String message) {\n        assertDoesNotThrow(throwingCallable, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, String message) {\n        assertThatCode(throwingCallable).withFailMessage(message).doesNotThrowAnyException();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.ThrowingSupplier<?>)}, #{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{message:any(java.lang.String)}).doesNotThrowAnyException()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.ThrowingSupplier");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.function.ThrowingSupplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertDoesNotThrow(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `JUnitToAssertJRules.AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException {\n    \n    @BeforeTemplate\n    void before(Executable throwingCallable, Supplier<String> supplier) {\n        assertDoesNotThrow(throwingCallable, supplier);\n    }\n    \n    @BeforeTemplate\n    void before(ThrowingSupplier<?> throwingCallable, Supplier<String> supplier) {\n        assertDoesNotThrow(throwingCallable, supplier);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable throwingCallable, Supplier<String> supplier) {\n        assertThatCode(throwingCallable).withFailMessage(supplier).doesNotThrowAnyException();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.Executable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertDoesNotThrow(#{throwingCallable:any(org.junit.jupiter.api.function.ThrowingSupplier<?>)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatCode(#{throwingCallable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).withFailMessage(#{supplier:any(java.util.function.Supplier<java.lang.String>)}).doesNotThrowAnyException()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.Executable");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.function.ThrowingSupplier");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertDoesNotThrow");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.function.ThrowingSupplier", Boolean.valueOf(true)), new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("org.junit.jupiter.api.Assertions assertDoesNotThrow(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

