/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.inject.Inject;
import tech.picnic.errorprone.utils.Flags;

@BugPattern(summary="By default, `@RequestParam` does not support `ImmutableCollection` and `ImmutableMap` subtypes", link="https://error-prone.picnic.tech/bugpatterns/RequestParamType", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class RequestParamType
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String SUPPORTED_CUSTOM_TYPES_FLAG = "RequestParamType:SupportedCustomTypes";
    private final Matcher<VariableTree> hasUnsupportedRequestParamType;

    public RequestParamType() {
        this(ErrorProneFlags.empty());
    }

    @Inject
    RequestParamType(ErrorProneFlags flags) {
        this.hasUnsupportedRequestParamType = RequestParamType.hasUnsupportedRequestParamType(flags);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.hasUnsupportedRequestParamType.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    private static Matcher<VariableTree> hasUnsupportedRequestParamType(ErrorProneFlags flags) {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"org.springframework.web.bind.annotation.RequestParam")), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf(ImmutableCollection.class), Matchers.isSubtypeOf(ImmutableMap.class)}), Matchers.not(RequestParamType.isSubtypeOfAny((ImmutableList<String>)Flags.getList((ErrorProneFlags)flags, (String)SUPPORTED_CUSTOM_TYPES_FLAG)))});
    }

    private static Matcher<Tree> isSubtypeOfAny(ImmutableList<String> inclusions) {
        return Matchers.anyOf((Iterable)((Iterable)inclusions.stream().map(inclusion -> Matchers.isSubtypeOf((Supplier)Suppliers.typeFromString((String)inclusion))).collect(ImmutableList.toImmutableList())));
    }
}

