/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;
import org.springframework.http.HttpMethod;

public class WebClientRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `org.springframework.web.reactive.function.client.WebClient` and related types";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.WebClientRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new WebClientGetRecipe(), new WebClientHeadRecipe(), new WebClientOptionsRecipe(), new WebClientPatchRecipe(), new WebClientPostRecipe(), new WebClientPutRecipe()});
    }

    @NonNullApi
    public static class WebClientGetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `WebClient#get()` over `WebClient#method(HttpMethod)` with `HttpMethod#GET`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientGet {\n    \n    @BeforeTemplate\n    RequestHeadersSpec<?> before(WebClient webClient) {\n        return webClient.method(GET);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestHeadersSpec<?> before(WebTestClient webClient) {\n        return webClient.method(GET);\n    }\n    \n    @AfterTemplate\n    RequestHeadersSpec<?> after(WebClient webClient) {\n        return webClient.get();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", webClient -> webClient.method(HttpMethod.GET)).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", webClient -> webClient.method(HttpMethod.GET)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", webClient -> webClient.get()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.GET");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.GET");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)")}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)")})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class WebClientHeadRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `WebClient#head()` over `WebClient#method(HttpMethod)` with `HttpMethod#HEAD`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientHead {\n    \n    @BeforeTemplate\n    RequestHeadersSpec<?> before(WebClient webClient) {\n        return webClient.method(HEAD);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestHeadersSpec<?> before(WebTestClient webClient) {\n        return webClient.method(HEAD);\n    }\n    \n    @AfterTemplate\n    RequestHeadersSpec<?> after(WebClient webClient) {\n        return webClient.head();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", webClient -> webClient.method(HttpMethod.HEAD)).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", webClient -> webClient.method(HttpMethod.HEAD)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", webClient -> webClient.head()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.HEAD");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.HEAD");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)")}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)")})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class WebClientOptionsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `WebClient#options()` over `WebClient#method(HttpMethod)` with `HttpMethod#OPTIONS`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientOptions {\n    \n    @BeforeTemplate\n    RequestHeadersSpec<?> before(WebClient webClient) {\n        return webClient.method(OPTIONS);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestHeadersSpec<?> before(WebTestClient webClient) {\n        return webClient.method(OPTIONS);\n    }\n    \n    @AfterTemplate\n    RequestHeadersSpec<?> after(WebClient webClient) {\n        return webClient.options();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", webClient -> webClient.method(HttpMethod.OPTIONS)).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", webClient -> webClient.method(HttpMethod.OPTIONS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", webClient -> webClient.options()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.OPTIONS");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.OPTIONS");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)")}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)")})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class WebClientPatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `WebClient#patch()` over `WebClient#method(HttpMethod)` with `HttpMethod#PATCH`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientPatch {\n    \n    @BeforeTemplate\n    RequestBodyUriSpec before(WebClient webClient) {\n        return webClient.method(PATCH);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestBodyUriSpec before(WebTestClient webClient) {\n        return webClient.method(PATCH);\n    }\n    \n    @AfterTemplate\n    RequestBodyUriSpec after(WebClient webClient) {\n        return webClient.patch();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", webClient -> webClient.method(HttpMethod.PATCH)).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", webClient -> webClient.method(HttpMethod.PATCH)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", webClient -> webClient.patch()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.PATCH");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.PATCH");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)")}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)")})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class WebClientPostRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `WebClient#post()` over `WebClient#method(HttpMethod)` with `HttpMethod#POST`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientPost {\n    \n    @BeforeTemplate\n    RequestBodyUriSpec before(WebClient webClient) {\n        return webClient.method(POST);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestBodyUriSpec before(WebTestClient webClient) {\n        return webClient.method(POST);\n    }\n    \n    @AfterTemplate\n    RequestBodyUriSpec after(WebClient webClient) {\n        return webClient.post();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", webClient -> webClient.method(HttpMethod.POST)).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", webClient -> webClient.method(HttpMethod.POST)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", webClient -> webClient.post()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.POST");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.POST");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)")}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)")})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class WebClientPutRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `WebClient#put()` over `WebClient#method(HttpMethod)` with `HttpMethod#PUT`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class WebClientPut {\n    \n    @BeforeTemplate\n    RequestBodyUriSpec before(WebClient webClient) {\n        return webClient.method(PUT);\n    }\n    \n    @BeforeTemplate\n    WebTestClient.RequestBodyUriSpec before(WebTestClient webClient) {\n        return webClient.method(PUT);\n    }\n    \n    @AfterTemplate\n    RequestBodyUriSpec after(WebClient webClient) {\n        return webClient.put();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", webClient -> webClient.method(HttpMethod.PUT)).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", webClient -> webClient.method(HttpMethod.PUT)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", webClient -> webClient.put()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.PUT");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.PUT");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)")}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)")})}), (TreeVisitor)javaVisitor);
        }
    }
}

