/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class TimeRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with time";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.TimeRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ClockInstantRecipe(), new OffsetDateTimeOfInstantRecipe(), new InstantAtOffsetRecipe(), new OffsetTimeOfInstantRecipe(), new InstantAtZoneRecipe(), new UtcClockRecipe(), new LocalDateAtStartOfDayRecipe(), new DurationOfDaysRecipe(), new DurationOfHoursRecipe(), new DurationOfMillisRecipe(), new DurationOfMinutesRecipe(), new DurationOfNanosRecipe(), new DurationOfSecondsRecipe(), new DurationBetweenInstantsRecipe(), new LocalDatePlusDaysRecipe(), new LocalDatePlusWeeksRecipe(), new LocalDatePlusMonthsRecipe(), new LocalDatePlusYearsRecipe(), new LocalDateMinusDaysRecipe(), new LocalDateMinusWeeksRecipe(), new LocalDateMinusMonthsRecipe(), new LocalDateMinusYearsRecipe(), new LocalTimePlusNanosRecipe(), new LocalTimePlusSecondsRecipe(), new LocalTimePlusMinutesRecipe(), new LocalTimePlusHoursRecipe(), new LocalTimeMinusNanosRecipe(), new LocalTimeMinusSecondsRecipe(), new LocalTimeMinusMinutesRecipe(), new LocalTimeMinusHoursRecipe(), new OffsetTimePlusNanosRecipe(), new OffsetTimePlusSecondsRecipe(), new OffsetTimePlusMinutesRecipe(), new OffsetTimePlusHoursRecipe(), new OffsetTimeMinusNanosRecipe(), new OffsetTimeMinusSecondsRecipe(), new OffsetTimeMinusMinutesRecipe(), new OffsetTimeMinusHoursRecipe(), new LocalDateTimePlusNanosRecipe(), new LocalDateTimePlusSecondsRecipe(), new LocalDateTimePlusMinutesRecipe(), new LocalDateTimePlusHoursRecipe(), new LocalDateTimePlusDaysRecipe(), new LocalDateTimePlusWeeksRecipe(), new LocalDateTimePlusMonthsRecipe(), new LocalDateTimePlusYearsRecipe(), new LocalDateTimeMinusNanosRecipe(), new LocalDateTimeMinusSecondsRecipe(), new LocalDateTimeMinusMinutesRecipe(), new LocalDateTimeMinusHoursRecipe(), new LocalDateTimeMinusDaysRecipe(), new LocalDateTimeMinusWeeksRecipe(), new LocalDateTimeMinusMonthsRecipe(), new LocalDateTimeMinusYearsRecipe(), new OffsetDateTimePlusNanosRecipe(), new OffsetDateTimePlusSecondsRecipe(), new OffsetDateTimePlusMinutesRecipe(), new OffsetDateTimePlusHoursRecipe(), new OffsetDateTimePlusDaysRecipe(), new OffsetDateTimePlusWeeksRecipe(), new OffsetDateTimePlusMonthsRecipe(), new OffsetDateTimePlusYearsRecipe(), new OffsetDateTimeMinusNanosRecipe(), new OffsetDateTimeMinusSecondsRecipe(), new OffsetDateTimeMinusMinutesRecipe(), new OffsetDateTimeMinusHoursRecipe(), new OffsetDateTimeMinusDaysRecipe(), new OffsetDateTimeMinusWeeksRecipe(), new OffsetDateTimeMinusMonthsRecipe(), new OffsetDateTimeMinusYearsRecipe(), new ZonedDateTimePlusNanosRecipe(), new ZonedDateTimePlusSecondsRecipe(), new ZonedDateTimePlusMinutesRecipe(), new ZonedDateTimePlusHoursRecipe(), new ZonedDateTimePlusDaysRecipe(), new ZonedDateTimePlusWeeksRecipe(), new ZonedDateTimePlusMonthsRecipe(), new ZonedDateTimePlusYearsRecipe(), new ZonedDateTimeMinusNanosRecipe(), new ZonedDateTimeMinusSecondsRecipe(), new ZonedDateTimeMinusMinutesRecipe(), new ZonedDateTimeMinusHoursRecipe(), new ZonedDateTimeMinusDaysRecipe(), new ZonedDateTimeMinusWeeksRecipe(), new ZonedDateTimeMinusMonthsRecipe(), new ZonedDateTimeMinusYearsRecipe()});
    }

    @NonNullApi
    public static class ClockInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Clock#instant()` over `Instant#now(Clock)`, as it is more concise and more \"OOP-py\"";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ClockInstant {\n    \n    @BeforeTemplate\n    Instant before(Clock clock) {\n        return Instant.now(clock);\n    }\n    \n    @AfterTemplate\n    Instant after(Clock clock) {\n        return clock.instant();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", clock -> Instant.now(clock)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", clock -> clock.instant()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Clock", Boolean.valueOf(true)), new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesMethod("java.time.Instant now(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimeOfInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#ofInstant(Instant, ZoneId)` over more indirect alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimeOfInstant {\n    \n    @BeforeTemplate\n    OffsetDateTime before(Instant instant, ZoneId zoneId) {\n        return instant.atZone(zoneId).toOffsetDateTime();\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(Instant instant, ZoneId zoneId) {\n        return OffsetDateTime.ofInstant(instant, zoneId);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (instant, zoneId) -> instant.atZone((ZoneId)zoneId).toOffsetDateTime()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (instant, zoneId) -> OffsetDateTime.ofInstant(instant, zoneId)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime toOffsetDateTime(..)"), new UsesMethod("java.time.Instant atZone(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class InstantAtOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Instant#atOffset(ZoneOffset)` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InstantAtOffset {\n    \n    @BeforeTemplate\n    OffsetDateTime before(Instant instant, ZoneOffset zoneOffset) {\n        return OffsetDateTime.ofInstant(instant, zoneOffset);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(Instant instant, ZoneOffset zoneOffset) {\n        return instant.atOffset(zoneOffset);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (instant, zoneOffset) -> OffsetDateTime.ofInstant(instant, zoneOffset)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (instant, zoneOffset) -> instant.atOffset((ZoneOffset)zoneOffset)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneOffset", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime ofInstant(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetTimeOfInstantRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetTime#ofInstant(Instant, ZoneId)` over more indirect alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetTimeOfInstant {\n    \n    @BeforeTemplate\n    OffsetTime before(Instant instant, ZoneId zoneId) {\n        return OffsetDateTime.ofInstant(instant, zoneId).toOffsetTime();\n    }\n    \n    @BeforeTemplate\n    OffsetTime before(Instant instant, ZoneOffset zoneId) {\n        return instant.atOffset(zoneId).toOffsetTime();\n    }\n    \n    @AfterTemplate\n    OffsetTime after(Instant instant, ZoneId zoneId) {\n        return OffsetTime.ofInstant(instant, zoneId);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (instant, zoneId) -> OffsetDateTime.ofInstant(instant, zoneId).toOffsetTime()).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (instant, zoneId) -> instant.atOffset((ZoneOffset)zoneId).toOffsetTime()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (instant, zoneId) -> OffsetTime.ofInstant(instant, zoneId)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.OffsetDateTime");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.ZoneOffset");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime toOffsetTime(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime ofInstant(..)")}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZoneOffset", Boolean.valueOf(true)), new UsesMethod("java.time.Instant atOffset(..)")})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class InstantAtZoneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Instant#atZone(ZoneId)` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InstantAtZone {\n    \n    @BeforeTemplate\n    ZonedDateTime before(Instant instant, ZoneId zoneId) {\n        return ZonedDateTime.ofInstant(instant, zoneId);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(Instant instant, ZoneId zoneId) {\n        return instant.atZone(zoneId);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (instant, zoneId) -> ZonedDateTime.ofInstant(instant, zoneId)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (instant, zoneId) -> instant.atZone((ZoneId)zoneId)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("java.time.ZoneId", Boolean.valueOf(true)), new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime ofInstant(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class UtcClockRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Use `Clock#systemUTC()` when possible";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class UtcClock {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"TimeZoneUsage\")\n    Clock before() {\n        return Clock.system(UTC);\n    }\n    \n    @AfterTemplate\n    @SuppressWarnings(value = \"TimeZoneUsage\")\n    Clock after() {\n        return Clock.systemUTC();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", () -> Clock.system(ZoneOffset.UTC)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", () -> Clock.systemUTC()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.ZoneOffset.UTC");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Clock", Boolean.valueOf(true)), new UsesMethod("java.time.Clock system(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateAtStartOfDayRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDate#atStartOfDay()` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateAtStartOfDay {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDate localDate) {\n        return localDate.atTime(LocalTime.MIN);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDate localDate) {\n        return localDate.atStartOfDay();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", localDate -> localDate.atTime(LocalTime.MIN)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", localDate -> localDate.atStartOfDay()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.LocalTime");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate atTime(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DurationOfDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Duration#ofDays(long)` over alternative representations";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DurationOfDays {\n    \n    @BeforeTemplate\n    Duration before(long amount) {\n        return Duration.of(amount, ChronoUnit.DAYS);\n    }\n    \n    @AfterTemplate\n    Duration after(long amount) {\n        return Duration.ofDays(amount);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", amount -> Duration.of(amount, ChronoUnit.DAYS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", amount -> Duration.ofDays(amount)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DurationOfHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Duration#ofHours(long)` over alternative representations";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DurationOfHours {\n    \n    @BeforeTemplate\n    Duration before(long amount) {\n        return Duration.of(amount, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    Duration after(long amount) {\n        return Duration.ofHours(amount);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", amount -> Duration.of(amount, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", amount -> Duration.ofHours(amount)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DurationOfMillisRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Duration#ofMillis(long)` over alternative representations";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DurationOfMillis {\n    \n    @BeforeTemplate\n    Duration before(long amount) {\n        return Duration.of(amount, ChronoUnit.MILLIS);\n    }\n    \n    @AfterTemplate\n    Duration after(long amount) {\n        return Duration.ofMillis(amount);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", amount -> Duration.of(amount, ChronoUnit.MILLIS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", amount -> Duration.ofMillis(amount)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DurationOfMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Duration#ofMinutes(long)` over alternative representations";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DurationOfMinutes {\n    \n    @BeforeTemplate\n    Duration before(long amount) {\n        return Duration.of(amount, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    Duration after(long amount) {\n        return Duration.ofMinutes(amount);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", amount -> Duration.of(amount, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", amount -> Duration.ofMinutes(amount)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DurationOfNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Duration#ofNanos(long)` over alternative representations";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DurationOfNanos {\n    \n    @BeforeTemplate\n    Duration before(long amount) {\n        return Duration.of(amount, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    Duration after(long amount) {\n        return Duration.ofNanos(amount);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", amount -> Duration.of(amount, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", amount -> Duration.ofNanos(amount)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DurationOfSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Duration#ofSeconds(long)` over alternative representations";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DurationOfSeconds {\n    \n    @BeforeTemplate\n    Duration before(long amount) {\n        return Duration.of(amount, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    Duration after(long amount) {\n        return Duration.ofSeconds(amount);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", amount -> Duration.of(amount, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", amount -> Duration.ofSeconds(amount)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true)), new UsesMethod("java.time.Duration of(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DurationBetweenInstantsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't unnecessarily convert to and from milliseconds. (This way nanosecond precision is retained.) <p><strong>Warning:</strong> this rewrite rule increases precision!";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DurationBetweenInstants {\n    \n    @BeforeTemplate\n    Duration before(Instant a, Instant b) {\n        return Duration.ofMillis(b.toEpochMilli() - a.toEpochMilli());\n    }\n    \n    @AfterTemplate\n    Duration after(Instant a, Instant b) {\n        return Duration.between(a, b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (a, b) -> Duration.ofMillis(b.toEpochMilli() - a.toEpochMilli())).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (a, b) -> Duration.between(a, b)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMillis(..)"), new UsesMethod("java.time.Instant toEpochMilli(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDatePlusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDate#plusDays(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDatePlusDays {\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, int days) {\n        return localDate.plus(Period.ofDays(days));\n    }\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, long days) {\n        return localDate.plus(days, ChronoUnit.DAYS);\n    }\n    \n    @AfterTemplate\n    LocalDate after(LocalDate localDate, int days) {\n        return localDate.plusDays(days);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDate, days) -> localDate.plus(Period.ofDays(days))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDate, days) -> localDate.plus((long)days, ChronoUnit.DAYS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDate, days) -> localDate.plusDays(days.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDatePlusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDate#plusWeeks(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDatePlusWeeks {\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, int weeks) {\n        return localDate.plus(Period.ofWeeks(weeks));\n    }\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, long weeks) {\n        return localDate.plus(weeks, ChronoUnit.WEEKS);\n    }\n    \n    @AfterTemplate\n    LocalDate after(LocalDate localDate, int weeks) {\n        return localDate.plusWeeks(weeks);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDate, weeks) -> localDate.plus(Period.ofWeeks(weeks))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDate, weeks) -> localDate.plus((long)weeks, ChronoUnit.WEEKS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDate, weeks) -> localDate.plusWeeks(weeks.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDatePlusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDate#plusMonths(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDatePlusMonths {\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, int months) {\n        return localDate.plus(Period.ofMonths(months));\n    }\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, long months) {\n        return localDate.plus(months, ChronoUnit.MONTHS);\n    }\n    \n    @AfterTemplate\n    LocalDate after(LocalDate localDate, int months) {\n        return localDate.plusMonths(months);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDate, months) -> localDate.plus(Period.ofMonths(months))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDate, months) -> localDate.plus((long)months, ChronoUnit.MONTHS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDate, months) -> localDate.plusMonths(months.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDatePlusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDate#plusYears(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDatePlusYears {\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, int years) {\n        return localDate.plus(Period.ofYears(years));\n    }\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, long years) {\n        return localDate.plus(years, ChronoUnit.YEARS);\n    }\n    \n    @AfterTemplate\n    LocalDate after(LocalDate localDate, int years) {\n        return localDate.plusYears(years);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDate, years) -> localDate.plus(Period.ofYears(years))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDate, years) -> localDate.plus((long)years, ChronoUnit.YEARS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDate, years) -> localDate.plusYears(years.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateMinusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDate#minusDays(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateMinusDays {\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, int days) {\n        return localDate.minus(Period.ofDays(days));\n    }\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, long days) {\n        return localDate.minus(days, ChronoUnit.DAYS);\n    }\n    \n    @AfterTemplate\n    LocalDate after(LocalDate localDate, int days) {\n        return localDate.minusDays(days);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDate, days) -> localDate.minus(Period.ofDays(days))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDate, days) -> localDate.minus((long)days, ChronoUnit.DAYS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDate, days) -> localDate.minusDays(days.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateMinusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDate#minusWeeks(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateMinusWeeks {\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, int weeks) {\n        return localDate.minus(Period.ofWeeks(weeks));\n    }\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, long weeks) {\n        return localDate.minus(weeks, ChronoUnit.WEEKS);\n    }\n    \n    @AfterTemplate\n    LocalDate after(LocalDate localDate, int weeks) {\n        return localDate.minusWeeks(weeks);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDate, weeks) -> localDate.minus(Period.ofWeeks(weeks))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDate, weeks) -> localDate.minus((long)weeks, ChronoUnit.WEEKS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDate, weeks) -> localDate.minusWeeks(weeks.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateMinusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDate#minusMonths(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateMinusMonths {\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, int months) {\n        return localDate.minus(Period.ofMonths(months));\n    }\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, long months) {\n        return localDate.minus(months, ChronoUnit.MONTHS);\n    }\n    \n    @AfterTemplate\n    LocalDate after(LocalDate localDate, int months) {\n        return localDate.minusMonths(months);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDate, months) -> localDate.minus(Period.ofMonths(months))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDate, months) -> localDate.minus((long)months, ChronoUnit.MONTHS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDate, months) -> localDate.minusMonths(months.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateMinusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDate#minusYears(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateMinusYears {\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, int years) {\n        return localDate.minus(Period.ofYears(years));\n    }\n    \n    @BeforeTemplate\n    LocalDate before(LocalDate localDate, long years) {\n        return localDate.minus(years, ChronoUnit.YEARS);\n    }\n    \n    @AfterTemplate\n    LocalDate after(LocalDate localDate, int years) {\n        return localDate.minusYears(years);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDate, years) -> localDate.minus(Period.ofYears(years))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDate, years) -> localDate.minus((long)years, ChronoUnit.YEARS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDate, years) -> localDate.minusYears(years.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDate", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDate minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalTime#plusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalTimePlusNanos {\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, int nanos) {\n        return localTime.plus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, long nanos) {\n        return localTime.plus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    LocalTime after(LocalTime localTime, int nanos) {\n        return localTime.plusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localTime, nanos) -> localTime.plus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localTime, nanos) -> localTime.plus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localTime, nanos) -> localTime.plusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalTime#plusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalTimePlusSeconds {\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, int seconds) {\n        return localTime.plus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, long seconds) {\n        return localTime.plus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    LocalTime after(LocalTime localTime, int seconds) {\n        return localTime.plusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localTime, seconds) -> localTime.plus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localTime, seconds) -> localTime.plus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localTime, seconds) -> localTime.plusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalTime#plusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalTimePlusMinutes {\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, int minutes) {\n        return localTime.plus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, long minutes) {\n        return localTime.plus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    LocalTime after(LocalTime localTime, int minutes) {\n        return localTime.plusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localTime, minutes) -> localTime.plus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localTime, minutes) -> localTime.plus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localTime, minutes) -> localTime.plusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalTime#plusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalTimePlusHours {\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, int hours) {\n        return localTime.plus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, long hours) {\n        return localTime.plus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    LocalTime after(LocalTime localTime, int hours) {\n        return localTime.plusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localTime, hours) -> localTime.plus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localTime, hours) -> localTime.plus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localTime, hours) -> localTime.plusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalTime#minusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalTimeMinusNanos {\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, int nanos) {\n        return localTime.minus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, long nanos) {\n        return localTime.minus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    LocalTime after(LocalTime localTime, int nanos) {\n        return localTime.minusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localTime, nanos) -> localTime.minus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localTime, nanos) -> localTime.minus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localTime, nanos) -> localTime.minusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalTime#minusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalTimeMinusSeconds {\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, int seconds) {\n        return localTime.minus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, long seconds) {\n        return localTime.minus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    LocalTime after(LocalTime localTime, int seconds) {\n        return localTime.minusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localTime, seconds) -> localTime.minus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localTime, seconds) -> localTime.minus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localTime, seconds) -> localTime.minusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalTime#minusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalTimeMinusMinutes {\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, int minutes) {\n        return localTime.minus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, long minutes) {\n        return localTime.minus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    LocalTime after(LocalTime localTime, int minutes) {\n        return localTime.minusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localTime, minutes) -> localTime.minus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localTime, minutes) -> localTime.minus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localTime, minutes) -> localTime.minusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalTime#minusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalTimeMinusHours {\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, int hours) {\n        return localTime.minus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    LocalTime before(LocalTime localTime, long hours) {\n        return localTime.minus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    LocalTime after(LocalTime localTime, int hours) {\n        return localTime.minusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localTime, hours) -> localTime.minus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localTime, hours) -> localTime.minus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localTime, hours) -> localTime.minusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetTime#plusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetTimePlusNanos {\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, int nanos) {\n        return offsetTime.plus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, long nanos) {\n        return offsetTime.plus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    OffsetTime after(OffsetTime offsetTime, int nanos) {\n        return offsetTime.plusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetTime, nanos) -> offsetTime.plus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetTime, nanos) -> offsetTime.plus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetTime, nanos) -> offsetTime.plusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetTime#plusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetTimePlusSeconds {\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, int seconds) {\n        return offsetTime.plus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, long seconds) {\n        return offsetTime.plus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    OffsetTime after(OffsetTime offsetTime, int seconds) {\n        return offsetTime.plusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetTime, seconds) -> offsetTime.plus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetTime, seconds) -> offsetTime.plus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetTime, seconds) -> offsetTime.plusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetTime#plusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetTimePlusMinutes {\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, int minutes) {\n        return offsetTime.plus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, long minutes) {\n        return offsetTime.plus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    OffsetTime after(OffsetTime offsetTime, int minutes) {\n        return offsetTime.plusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetTime, minutes) -> offsetTime.plus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetTime, minutes) -> offsetTime.plus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetTime, minutes) -> offsetTime.plusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetTime#plusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetTimePlusHours {\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, int hours) {\n        return offsetTime.plus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, long hours) {\n        return offsetTime.plus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    OffsetTime after(OffsetTime offsetTime, int hours) {\n        return offsetTime.plusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetTime, hours) -> offsetTime.plus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetTime, hours) -> offsetTime.plus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetTime, hours) -> offsetTime.plusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetTime#minusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetTimeMinusNanos {\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, int nanos) {\n        return offsetTime.minus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, long nanos) {\n        return offsetTime.minus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    OffsetTime after(OffsetTime offsetTime, int nanos) {\n        return offsetTime.minusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetTime, nanos) -> offsetTime.minus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetTime, nanos) -> offsetTime.minus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetTime, nanos) -> offsetTime.minusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetTime#minusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetTimeMinusSeconds {\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, int seconds) {\n        return offsetTime.minus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, long seconds) {\n        return offsetTime.minus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    OffsetTime after(OffsetTime offsetTime, int seconds) {\n        return offsetTime.minusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetTime, seconds) -> offsetTime.minus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetTime, seconds) -> offsetTime.minus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetTime, seconds) -> offsetTime.minusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetTime#minusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetTimeMinusMinutes {\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, int minutes) {\n        return offsetTime.minus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, long minutes) {\n        return offsetTime.minus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    OffsetTime after(OffsetTime offsetTime, int minutes) {\n        return offsetTime.minusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetTime, minutes) -> offsetTime.minus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetTime, minutes) -> offsetTime.minus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetTime, minutes) -> offsetTime.minusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetTime#minusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetTimeMinusHours {\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, int hours) {\n        return offsetTime.minus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    OffsetTime before(OffsetTime offsetTime, long hours) {\n        return offsetTime.minus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    OffsetTime after(OffsetTime offsetTime, int hours) {\n        return offsetTime.minusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetTime, hours) -> offsetTime.minus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetTime, hours) -> offsetTime.minus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetTime, hours) -> offsetTime.minusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#plusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimePlusNanos {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int nanos) {\n        return localDateTime.plus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long nanos) {\n        return localDateTime.plus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int nanos) {\n        return localDateTime.plusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, nanos) -> localDateTime.plus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, nanos) -> localDateTime.plus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, nanos) -> localDateTime.plusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#plusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimePlusSeconds {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int seconds) {\n        return localDateTime.plus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long seconds) {\n        return localDateTime.plus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int seconds) {\n        return localDateTime.plusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, seconds) -> localDateTime.plus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, seconds) -> localDateTime.plus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, seconds) -> localDateTime.plusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#plusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimePlusMinutes {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int minutes) {\n        return localDateTime.plus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long minutes) {\n        return localDateTime.plus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int minutes) {\n        return localDateTime.plusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, minutes) -> localDateTime.plus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, minutes) -> localDateTime.plus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, minutes) -> localDateTime.plusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#plusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimePlusHours {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int hours) {\n        return localDateTime.plus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long hours) {\n        return localDateTime.plus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int hours) {\n        return localDateTime.plusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, hours) -> localDateTime.plus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, hours) -> localDateTime.plus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, hours) -> localDateTime.plusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimePlusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#plusDays(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimePlusDays {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int days) {\n        return localDateTime.plus(Period.ofDays(days));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long days) {\n        return localDateTime.plus(days, ChronoUnit.DAYS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int days) {\n        return localDateTime.plusDays(days);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, days) -> localDateTime.plus(Period.ofDays(days))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, days) -> localDateTime.plus((long)days, ChronoUnit.DAYS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, days) -> localDateTime.plusDays(days.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimePlusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#plusWeeks(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimePlusWeeks {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int weeks) {\n        return localDateTime.plus(Period.ofWeeks(weeks));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long weeks) {\n        return localDateTime.plus(weeks, ChronoUnit.WEEKS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int weeks) {\n        return localDateTime.plusWeeks(weeks);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, weeks) -> localDateTime.plus(Period.ofWeeks(weeks))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, weeks) -> localDateTime.plus((long)weeks, ChronoUnit.WEEKS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, weeks) -> localDateTime.plusWeeks(weeks.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimePlusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#plusMonths(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimePlusMonths {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int months) {\n        return localDateTime.plus(Period.ofMonths(months));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long months) {\n        return localDateTime.plus(months, ChronoUnit.MONTHS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int months) {\n        return localDateTime.plusMonths(months);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, months) -> localDateTime.plus(Period.ofMonths(months))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, months) -> localDateTime.plus((long)months, ChronoUnit.MONTHS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, months) -> localDateTime.plusMonths(months.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimePlusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#plusYears(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimePlusYears {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int years) {\n        return localDateTime.plus(Period.ofYears(years));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long years) {\n        return localDateTime.plus(years, ChronoUnit.YEARS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int years) {\n        return localDateTime.plusYears(years);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, years) -> localDateTime.plus(Period.ofYears(years))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, years) -> localDateTime.plus((long)years, ChronoUnit.YEARS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, years) -> localDateTime.plusYears(years.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#minusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimeMinusNanos {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int nanos) {\n        return localDateTime.minus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long nanos) {\n        return localDateTime.minus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int nanos) {\n        return localDateTime.minusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, nanos) -> localDateTime.minus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, nanos) -> localDateTime.minus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, nanos) -> localDateTime.minusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#minusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimeMinusSeconds {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int seconds) {\n        return localDateTime.minus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long seconds) {\n        return localDateTime.minus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int seconds) {\n        return localDateTime.minusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, seconds) -> localDateTime.minus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, seconds) -> localDateTime.minus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, seconds) -> localDateTime.minusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#minusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimeMinusMinutes {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int minutes) {\n        return localDateTime.minus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long minutes) {\n        return localDateTime.minus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int minutes) {\n        return localDateTime.minusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, minutes) -> localDateTime.minus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, minutes) -> localDateTime.minus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, minutes) -> localDateTime.minusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#minusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimeMinusHours {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int hours) {\n        return localDateTime.minus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long hours) {\n        return localDateTime.minus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int hours) {\n        return localDateTime.minusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, hours) -> localDateTime.minus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, hours) -> localDateTime.minus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, hours) -> localDateTime.minusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimeMinusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#minusDays(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimeMinusDays {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int days) {\n        return localDateTime.minus(Period.ofDays(days));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long days) {\n        return localDateTime.minus(days, ChronoUnit.DAYS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int days) {\n        return localDateTime.minusDays(days);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, days) -> localDateTime.minus(Period.ofDays(days))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, days) -> localDateTime.minus((long)days, ChronoUnit.DAYS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, days) -> localDateTime.minusDays(days.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimeMinusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#minusWeeks(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimeMinusWeeks {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int weeks) {\n        return localDateTime.minus(Period.ofWeeks(weeks));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long weeks) {\n        return localDateTime.minus(weeks, ChronoUnit.WEEKS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int weeks) {\n        return localDateTime.minusWeeks(weeks);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, weeks) -> localDateTime.minus(Period.ofWeeks(weeks))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, weeks) -> localDateTime.minus((long)weeks, ChronoUnit.WEEKS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, weeks) -> localDateTime.minusWeeks(weeks.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimeMinusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#minusMonths(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimeMinusMonths {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int months) {\n        return localDateTime.minus(Period.ofMonths(months));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long months) {\n        return localDateTime.minus(months, ChronoUnit.MONTHS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int months) {\n        return localDateTime.minusMonths(months);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, months) -> localDateTime.minus(Period.ofMonths(months))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, months) -> localDateTime.minus((long)months, ChronoUnit.MONTHS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, months) -> localDateTime.minusMonths(months.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LocalDateTimeMinusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LocalDateTime#minusYears(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LocalDateTimeMinusYears {\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, int years) {\n        return localDateTime.minus(Period.ofYears(years));\n    }\n    \n    @BeforeTemplate\n    LocalDateTime before(LocalDateTime localDateTime, long years) {\n        return localDateTime.minus(years, ChronoUnit.YEARS);\n    }\n    \n    @AfterTemplate\n    LocalDateTime after(LocalDateTime localDateTime, int years) {\n        return localDateTime.minusYears(years);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (localDateTime, years) -> localDateTime.minus(Period.ofYears(years))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (localDateTime, years) -> localDateTime.minus((long)years, ChronoUnit.YEARS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (localDateTime, years) -> localDateTime.minusYears(years.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.LocalDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.LocalDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#plusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimePlusNanos {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int nanos) {\n        return offsetDateTime.plus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long nanos) {\n        return offsetDateTime.plus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int nanos) {\n        return offsetDateTime.plusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, nanos) -> offsetDateTime.plus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, nanos) -> offsetDateTime.plus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, nanos) -> offsetDateTime.plusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#plusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimePlusSeconds {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int seconds) {\n        return offsetDateTime.plus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long seconds) {\n        return offsetDateTime.plus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int seconds) {\n        return offsetDateTime.plusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, seconds) -> offsetDateTime.plus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, seconds) -> offsetDateTime.plus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, seconds) -> offsetDateTime.plusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#plusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimePlusMinutes {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int minutes) {\n        return offsetDateTime.plus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long minutes) {\n        return offsetDateTime.plus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int minutes) {\n        return offsetDateTime.plusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, minutes) -> offsetDateTime.plus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, minutes) -> offsetDateTime.plus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, minutes) -> offsetDateTime.plusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#plusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimePlusHours {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int hours) {\n        return offsetDateTime.plus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long hours) {\n        return offsetDateTime.plus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int hours) {\n        return offsetDateTime.plusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, hours) -> offsetDateTime.plus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, hours) -> offsetDateTime.plus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, hours) -> offsetDateTime.plusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimePlusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#plusDays(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimePlusDays {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int days) {\n        return offsetDateTime.plus(Period.ofDays(days));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long days) {\n        return offsetDateTime.plus(days, ChronoUnit.DAYS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int days) {\n        return offsetDateTime.plusDays(days);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, days) -> offsetDateTime.plus(Period.ofDays(days))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, days) -> offsetDateTime.plus((long)days, ChronoUnit.DAYS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, days) -> offsetDateTime.plusDays(days.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimePlusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#plusWeeks(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimePlusWeeks {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int weeks) {\n        return offsetDateTime.plus(Period.ofWeeks(weeks));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long weeks) {\n        return offsetDateTime.plus(weeks, ChronoUnit.WEEKS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int weeks) {\n        return offsetDateTime.plusWeeks(weeks);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, weeks) -> offsetDateTime.plus(Period.ofWeeks(weeks))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, weeks) -> offsetDateTime.plus((long)weeks, ChronoUnit.WEEKS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, weeks) -> offsetDateTime.plusWeeks(weeks.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimePlusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#plusMonths(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimePlusMonths {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int months) {\n        return offsetDateTime.plus(Period.ofMonths(months));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long months) {\n        return offsetDateTime.plus(months, ChronoUnit.MONTHS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int months) {\n        return offsetDateTime.plusMonths(months);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, months) -> offsetDateTime.plus(Period.ofMonths(months))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, months) -> offsetDateTime.plus((long)months, ChronoUnit.MONTHS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, months) -> offsetDateTime.plusMonths(months.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimePlusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#plusYears(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimePlusYears {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int years) {\n        return offsetDateTime.plus(Period.ofYears(years));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long years) {\n        return offsetDateTime.plus(years, ChronoUnit.YEARS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int years) {\n        return offsetDateTime.plusYears(years);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, years) -> offsetDateTime.plus(Period.ofYears(years))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, years) -> offsetDateTime.plus((long)years, ChronoUnit.YEARS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, years) -> offsetDateTime.plusYears(years.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#minusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimeMinusNanos {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int nanos) {\n        return offsetDateTime.minus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long nanos) {\n        return offsetDateTime.minus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int nanos) {\n        return offsetDateTime.minusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, nanos) -> offsetDateTime.minus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, nanos) -> offsetDateTime.minus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, nanos) -> offsetDateTime.minusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#minusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimeMinusSeconds {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int seconds) {\n        return offsetDateTime.minus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long seconds) {\n        return offsetDateTime.minus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int seconds) {\n        return offsetDateTime.minusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, seconds) -> offsetDateTime.minus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, seconds) -> offsetDateTime.minus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, seconds) -> offsetDateTime.minusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#minusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimeMinusMinutes {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int minutes) {\n        return offsetDateTime.minus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long minutes) {\n        return offsetDateTime.minus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int minutes) {\n        return offsetDateTime.minusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, minutes) -> offsetDateTime.minus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, minutes) -> offsetDateTime.minus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, minutes) -> offsetDateTime.minusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#minusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimeMinusHours {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int hours) {\n        return offsetDateTime.minus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long hours) {\n        return offsetDateTime.minus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int hours) {\n        return offsetDateTime.minusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, hours) -> offsetDateTime.minus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, hours) -> offsetDateTime.minus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, hours) -> offsetDateTime.minusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimeMinusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#minusDays(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimeMinusDays {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int days) {\n        return offsetDateTime.minus(Period.ofDays(days));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long days) {\n        return offsetDateTime.minus(days, ChronoUnit.DAYS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int days) {\n        return offsetDateTime.minusDays(days);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, days) -> offsetDateTime.minus(Period.ofDays(days))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, days) -> offsetDateTime.minus((long)days, ChronoUnit.DAYS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, days) -> offsetDateTime.minusDays(days.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimeMinusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#minusWeeks(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimeMinusWeeks {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int weeks) {\n        return offsetDateTime.minus(Period.ofWeeks(weeks));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long weeks) {\n        return offsetDateTime.minus(weeks, ChronoUnit.WEEKS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int weeks) {\n        return offsetDateTime.minusWeeks(weeks);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, weeks) -> offsetDateTime.minus(Period.ofWeeks(weeks))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, weeks) -> offsetDateTime.minus((long)weeks, ChronoUnit.WEEKS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, weeks) -> offsetDateTime.minusWeeks(weeks.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimeMinusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#minusMonths(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimeMinusMonths {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int months) {\n        return offsetDateTime.minus(Period.ofMonths(months));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long months) {\n        return offsetDateTime.minus(months, ChronoUnit.MONTHS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int months) {\n        return offsetDateTime.minusMonths(months);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, months) -> offsetDateTime.minus(Period.ofMonths(months))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, months) -> offsetDateTime.minus((long)months, ChronoUnit.MONTHS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, months) -> offsetDateTime.minusMonths(months.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class OffsetDateTimeMinusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `OffsetDateTime#minusYears(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OffsetDateTimeMinusYears {\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, int years) {\n        return offsetDateTime.minus(Period.ofYears(years));\n    }\n    \n    @BeforeTemplate\n    OffsetDateTime before(OffsetDateTime offsetDateTime, long years) {\n        return offsetDateTime.minus(years, ChronoUnit.YEARS);\n    }\n    \n    @AfterTemplate\n    OffsetDateTime after(OffsetDateTime offsetDateTime, int years) {\n        return offsetDateTime.minusYears(years);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (offsetDateTime, years) -> offsetDateTime.minus(Period.ofYears(years))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (offsetDateTime, years) -> offsetDateTime.minus((long)years, ChronoUnit.YEARS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (offsetDateTime, years) -> offsetDateTime.minusYears(years.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.OffsetDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.OffsetDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimePlusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#plusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimePlusNanos {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int nanos) {\n        return zonedDateTime.plus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long nanos) {\n        return zonedDateTime.plus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int nanos) {\n        return zonedDateTime.plusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, nanos) -> zonedDateTime.plus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, nanos) -> zonedDateTime.plus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, nanos) -> zonedDateTime.plusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimePlusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#plusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimePlusSeconds {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int seconds) {\n        return zonedDateTime.plus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long seconds) {\n        return zonedDateTime.plus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int seconds) {\n        return zonedDateTime.plusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, seconds) -> zonedDateTime.plus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, seconds) -> zonedDateTime.plus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, seconds) -> zonedDateTime.plusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimePlusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#plusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimePlusMinutes {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int minutes) {\n        return zonedDateTime.plus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long minutes) {\n        return zonedDateTime.plus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int minutes) {\n        return zonedDateTime.plusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, minutes) -> zonedDateTime.plus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, minutes) -> zonedDateTime.plus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, minutes) -> zonedDateTime.plusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimePlusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#plusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimePlusHours {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int hours) {\n        return zonedDateTime.plus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long hours) {\n        return zonedDateTime.plus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int hours) {\n        return zonedDateTime.plusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, hours) -> zonedDateTime.plus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, hours) -> zonedDateTime.plus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, hours) -> zonedDateTime.plusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimePlusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#plusDays(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimePlusDays {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int days) {\n        return zonedDateTime.plus(Period.ofDays(days));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long days) {\n        return zonedDateTime.plus(days, ChronoUnit.DAYS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int days) {\n        return zonedDateTime.plusDays(days);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, days) -> zonedDateTime.plus(Period.ofDays(days))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, days) -> zonedDateTime.plus((long)days, ChronoUnit.DAYS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, days) -> zonedDateTime.plusDays(days.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimePlusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#plusWeeks(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimePlusWeeks {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int weeks) {\n        return zonedDateTime.plus(Period.ofWeeks(weeks));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long weeks) {\n        return zonedDateTime.plus(weeks, ChronoUnit.WEEKS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int weeks) {\n        return zonedDateTime.plusWeeks(weeks);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, weeks) -> zonedDateTime.plus(Period.ofWeeks(weeks))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, weeks) -> zonedDateTime.plus((long)weeks, ChronoUnit.WEEKS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, weeks) -> zonedDateTime.plusWeeks(weeks.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimePlusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#plusMonths(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimePlusMonths {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int months) {\n        return zonedDateTime.plus(Period.ofMonths(months));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long months) {\n        return zonedDateTime.plus(months, ChronoUnit.MONTHS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int months) {\n        return zonedDateTime.plusMonths(months);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, months) -> zonedDateTime.plus(Period.ofMonths(months))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, months) -> zonedDateTime.plus((long)months, ChronoUnit.MONTHS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, months) -> zonedDateTime.plusMonths(months.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimePlusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#plusYears(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimePlusYears {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int years) {\n        return zonedDateTime.plus(Period.ofYears(years));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long years) {\n        return zonedDateTime.plus(years, ChronoUnit.YEARS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int years) {\n        return zonedDateTime.plusYears(years);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, years) -> zonedDateTime.plus(Period.ofYears(years))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, years) -> zonedDateTime.plus((long)years, ChronoUnit.YEARS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, years) -> zonedDateTime.plusYears(years.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime plus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimeMinusNanosRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#minusNanos(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimeMinusNanos {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int nanos) {\n        return zonedDateTime.minus(Duration.ofNanos(nanos));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long nanos) {\n        return zonedDateTime.minus(nanos, ChronoUnit.NANOS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int nanos) {\n        return zonedDateTime.minusNanos(nanos);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, nanos) -> zonedDateTime.minus(Duration.ofNanos(nanos.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, nanos) -> zonedDateTime.minus((long)nanos, ChronoUnit.NANOS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, nanos) -> zonedDateTime.minusNanos(nanos.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofNanos(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimeMinusSecondsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#minusSeconds(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimeMinusSeconds {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int seconds) {\n        return zonedDateTime.minus(Duration.ofSeconds(seconds));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long seconds) {\n        return zonedDateTime.minus(seconds, ChronoUnit.SECONDS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int seconds) {\n        return zonedDateTime.minusSeconds(seconds);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, seconds) -> zonedDateTime.minus(Duration.ofSeconds(seconds.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, seconds) -> zonedDateTime.minus((long)seconds, ChronoUnit.SECONDS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, seconds) -> zonedDateTime.minusSeconds(seconds.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofSeconds(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimeMinusMinutesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#minusMinutes(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimeMinusMinutes {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int minutes) {\n        return zonedDateTime.minus(Duration.ofMinutes(minutes));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long minutes) {\n        return zonedDateTime.minus(minutes, ChronoUnit.MINUTES);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int minutes) {\n        return zonedDateTime.minusMinutes(minutes);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, minutes) -> zonedDateTime.minus(Duration.ofMinutes(minutes.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, minutes) -> zonedDateTime.minus((long)minutes, ChronoUnit.MINUTES)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, minutes) -> zonedDateTime.minusMinutes(minutes.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofMinutes(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimeMinusHoursRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#minusHours(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimeMinusHours {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int hours) {\n        return zonedDateTime.minus(Duration.ofHours(hours));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long hours) {\n        return zonedDateTime.minus(hours, ChronoUnit.HOURS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int hours) {\n        return zonedDateTime.minusHours(hours);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, hours) -> zonedDateTime.minus(Duration.ofHours(hours.intValue()))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, hours) -> zonedDateTime.minus((long)hours, ChronoUnit.HOURS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, hours) -> zonedDateTime.minusHours(hours.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Duration");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("java.time.Duration ofHours(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimeMinusDaysRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#minusDays(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimeMinusDays {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int days) {\n        return zonedDateTime.minus(Period.ofDays(days));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long days) {\n        return zonedDateTime.minus(days, ChronoUnit.DAYS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int days) {\n        return zonedDateTime.minusDays(days);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, days) -> zonedDateTime.minus(Period.ofDays(days))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, days) -> zonedDateTime.minus((long)days, ChronoUnit.DAYS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, days) -> zonedDateTime.minusDays(days.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofDays(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimeMinusWeeksRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#minusWeeks(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimeMinusWeeks {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int weeks) {\n        return zonedDateTime.minus(Period.ofWeeks(weeks));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long weeks) {\n        return zonedDateTime.minus(weeks, ChronoUnit.WEEKS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int weeks) {\n        return zonedDateTime.minusWeeks(weeks);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, weeks) -> zonedDateTime.minus(Period.ofWeeks(weeks))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, weeks) -> zonedDateTime.minus((long)weeks, ChronoUnit.WEEKS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, weeks) -> zonedDateTime.minusWeeks(weeks.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofWeeks(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimeMinusMonthsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#minusMonths(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimeMinusMonths {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int months) {\n        return zonedDateTime.minus(Period.ofMonths(months));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long months) {\n        return zonedDateTime.minus(months, ChronoUnit.MONTHS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int months) {\n        return zonedDateTime.minusMonths(months);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, months) -> zonedDateTime.minus(Period.ofMonths(months))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, months) -> zonedDateTime.minus((long)months, ChronoUnit.MONTHS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, months) -> zonedDateTime.minusMonths(months.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofMonths(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ZonedDateTimeMinusYearsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `ZonedDateTime#minusYears(long)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZonedDateTimeMinusYears {\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, int years) {\n        return zonedDateTime.minus(Period.ofYears(years));\n    }\n    \n    @BeforeTemplate\n    ZonedDateTime before(ZonedDateTime zonedDateTime, long years) {\n        return zonedDateTime.minus(years, ChronoUnit.YEARS);\n    }\n    \n    @AfterTemplate\n    ZonedDateTime after(ZonedDateTime zonedDateTime, int years) {\n        return zonedDateTime.minusYears(years);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (zonedDateTime, years) -> zonedDateTime.minus(Period.ofYears(years))).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (zonedDateTime, years) -> zonedDateTime.minus((long)years, ChronoUnit.YEARS)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (zonedDateTime, years) -> zonedDateTime.minusYears(years.intValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.Period");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.time.temporal.ChronoUnit");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.ZonedDateTime", Boolean.valueOf(true)), new UsesMethod("java.time.ZonedDateTime minus(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Period", Boolean.valueOf(true)), new UsesMethod("java.time.Period ofYears(..)")}), new UsesType("java.time.temporal.ChronoUnit", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }
}

