/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.data.Offset;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;
import org.testng.Assert;

public class TestNGToAssertJRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules that replace TestNG assertions with equivalent AssertJ assertions";
    }

    public String getDescription() {
        return "<p>Some of the classes below have TestNG `@BeforeTemplate`s that reference wildcard type\n bounds (`<?>`), while the associated AssertJ `@AfterTemplate`s reference stricter\n type bounds. This introduces the risk of producing invalid code. We do this anyway, because\n TestNG's wildcard types can cause javac to infer less specific types than AssertJ requires, while\n the appropriate (more specific) types _will_ be inferred properly when plugged into AssertJ's\n API.\n\n <p>The following is an example of a TestNG statement, which would not be rewritten if it weren't\n for the wildcard matching (note that the type parameters of the map on the right-hand side will\n be inferred to be `<Object, Object>` rather than `<String, Object>`).\n\n <pre>{@code\n List<Map<String, Object>> myMaps = new ArrayList<>();\n assertEquals(myMaps, ImmutableList.of(ImmutableMap.of()));\n }</pre>.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new FailRecipe(), new FailWithMessageRecipe(), new FailWithMessageAndThrowableRecipe(), new AssertTrueRecipe(), new AssertTrueWithMessageRecipe(), new AssertFalseRecipe(), new AssertFalseWithMessageRecipe(), new AssertNullRecipe(), new AssertNullWithMessageRecipe(), new AssertNotNullRecipe(), new AssertNotNullWithMessageRecipe(), new AssertSameRecipe(), new AssertSameWithMessageRecipe(), new AssertNotSameRecipe(), new AssertNotSameWithMessageRecipe(), new AssertEqualRecipe(), new AssertEqualWithMessageRecipe(), new AssertEqualFloatsWithDeltaRecipe(), new AssertEqualFloatsWithDeltaWithMessageRecipe(), new AssertEqualDoublesWithDeltaRecipe(), new AssertEqualDoublesWithDeltaWithMessageRecipe(), new AssertEqualArrayIterationOrderRecipe(), new AssertEqualArrayIterationOrderWithMessageRecipe(), new AssertEqualArraysIrrespectiveOfOrderRecipe(), new AssertEqualArraysIrrespectiveOfOrderWithMessageRecipe(), new AssertUnequalRecipe(), new AssertUnequalWithMessageRecipe(), new AssertUnequalFloatsWithDeltaRecipe(), new AssertUnequalFloatsWithDeltaWithMessageRecipe(), new AssertUnequalDoublesWithDeltaRecipe(), new AssertUnequalDoublesWithDeltaWithMessageRecipe(), new AssertThrowsRecipe()});
    }

    @NonNullApi
    public static class FailRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.Fail`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class Fail {\n    \n    @BeforeTemplate\n    void before() {\n        Assert.fail();\n    }\n    \n    @AfterTemplate\n    @DoNotCall\n    void after() {\n        throw new AssertionError();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", () -> Assert.fail()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", () -> {
                    throw new AssertionError();
                }).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.testng.Assert", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert fail(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FailWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.FailWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithMessage {\n    \n    @BeforeTemplate\n    void before(String message) {\n        Assert.fail(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(String message) {\n        fail(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", message -> Assert.fail((String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", message -> Assertions.fail((String)message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.testng.Assert", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert fail(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FailWithMessageAndThrowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.FailWithMessageAndThrowable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithMessageAndThrowable {\n    \n    @BeforeTemplate\n    void before(String message, Throwable throwable) {\n        Assert.fail(message, throwable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(String message, Throwable throwable) {\n        fail(message, throwable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (message, throwable) -> Assert.fail((String)message, (Throwable)throwable)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (message, throwable) -> Assertions.fail((String)message, (Throwable)throwable)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.testng.Assert", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert fail(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertTrue {\n    \n    @BeforeTemplate\n    void before(boolean condition) {\n        assertTrue(condition);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition) {\n        assertThat(condition).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", condition -> Assert.assertTrue((boolean)condition)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", condition -> Assertions.assertThat((Boolean)condition).isTrue()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertTrue");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertTrue(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertTrueWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertTrueWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertTrueWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean condition, String message) {\n        assertTrue(condition, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition, String message) {\n        assertThat(condition).withFailMessage(message).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (condition, message) -> Assert.assertTrue((boolean)condition, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (condition, message) -> ((AbstractBooleanAssert)Assertions.assertThat((Boolean)condition).withFailMessage(message, new Object[0])).isTrue()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertTrue");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertTrue(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertFalse {\n    \n    @BeforeTemplate\n    void before(boolean condition) {\n        assertFalse(condition);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition) {\n        assertThat(condition).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", condition -> Assert.assertFalse((boolean)condition)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", condition -> Assertions.assertThat((Boolean)condition).isFalse()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertFalse");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertFalse(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertFalseWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertFalseWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertFalseWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean condition, String message) {\n        assertFalse(condition, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition, String message) {\n        assertThat(condition).withFailMessage(message).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (condition, message) -> Assert.assertFalse((boolean)condition, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (condition, message) -> ((AbstractBooleanAssert)Assertions.assertThat((Boolean)condition).withFailMessage(message, new Object[0])).isFalse()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertFalse");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertFalse(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNull {\n    \n    @BeforeTemplate\n    void before(Object object) {\n        assertNull(object);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object) {\n        assertThat(object).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", object -> Assert.assertNull((Object)object)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", object -> Assertions.assertThat((Object)object).isNull()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNull(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertNullWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNullWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNullWithMessage {\n    \n    @BeforeTemplate\n    void before(Object object, String message) {\n        assertNull(object, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object, String message) {\n        assertThat(object).withFailMessage(message).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (object, message) -> Assert.assertNull((Object)object, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (object, message) -> ((ObjectAssert)Assertions.assertThat((Object)object).withFailMessage(message, new Object[0])).isNull()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNull(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNotNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotNull {\n    \n    @BeforeTemplate\n    void before(Object object) {\n        assertNotNull(object);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object) {\n        assertThat(object).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", object -> Assert.assertNotNull((Object)object)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", object -> Assertions.assertThat((Object)object).isNotNull()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotNull(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertNotNullWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNotNullWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotNullWithMessage {\n    \n    @BeforeTemplate\n    void before(Object object, String message) {\n        assertNotNull(object, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object, String message) {\n        assertThat(object).withFailMessage(message).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (object, message) -> Assert.assertNotNull((Object)object, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (object, message) -> ((ObjectAssert)Assertions.assertThat((Object)object).withFailMessage(message, new Object[0])).isNotNull()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotNull");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotNull(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertSameRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertSame`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertSame {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertSame(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected) -> Assert.assertSame((Object)actual, (Object)expected)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected) -> Assertions.assertThat((Object)actual).isSameAs(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertSame(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertSameWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertSameWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertSameWithMessage {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertSame(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected) -> Assert.assertSame((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected) -> ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isSameAs(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertSame(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertNotSameRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNotSame`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotSame {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertNotSame(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected) -> Assert.assertNotSame((Object)actual, (Object)expected)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected) -> Assertions.assertThat((Object)actual).isNotSameAs(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotSame(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertNotSameWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNotSameWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotSameWithMessage {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertNotSame(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected) -> Assert.assertNotSame((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected) -> ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNotSameAs(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotSame");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotSame(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqual`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqual {\n    \n    @BeforeTemplate\n    void before(boolean actual, boolean expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, byte expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, char expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, short expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, int expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, long expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, float expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, double expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, Map<?, ?> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isEqualTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected) -> Assert.assertEquals((Boolean)actual, (Boolean)expected)).build();
                final JavaTemplate before0 = Semantics.statement((JavaVisitor)this, (String)"before0", (actual, expected) -> Assert.assertEquals((Byte)actual, (Byte)expected)).build();
                final JavaTemplate before1 = Semantics.statement((JavaVisitor)this, (String)"before1", (actual, expected) -> Assert.assertEquals((Character)actual, (Character)expected)).build();
                final JavaTemplate before2 = Semantics.statement((JavaVisitor)this, (String)"before2", (actual, expected) -> Assert.assertEquals((Short)actual, (Short)expected)).build();
                final JavaTemplate before3 = Semantics.statement((JavaVisitor)this, (String)"before3", (actual, expected) -> Assert.assertEquals((Integer)actual, (Integer)expected)).build();
                final JavaTemplate before4 = Semantics.statement((JavaVisitor)this, (String)"before4", (actual, expected) -> Assert.assertEquals((Long)actual, (Long)expected)).build();
                final JavaTemplate before5 = Semantics.statement((JavaVisitor)this, (String)"before5", (actual, expected) -> Assert.assertEquals((Float)actual, (Float)expected)).build();
                final JavaTemplate before6 = Semantics.statement((JavaVisitor)this, (String)"before6", (actual, expected) -> Assert.assertEquals((Double)actual, (Double)expected)).build();
                final JavaTemplate before7 = Semantics.statement((JavaVisitor)this, (String)"before7", (actual, expected) -> Assert.assertEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before8 = Semantics.statement((JavaVisitor)this, (String)"before8", (actual, expected) -> Assert.assertEquals((String)actual, (String)expected)).build();
                final JavaTemplate before9 = Semantics.statement((JavaVisitor)this, (String)"before9", (actual, expected) -> Assert.assertEquals((Map)actual, (Map)expected)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected) -> Assertions.assertThat((Object)actual).isEqualTo(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before7.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before8.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before9.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.testng.Assert assertEquals(..)"), new UsesType("java.util.Map", Boolean.valueOf(true))}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message, boolean expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, String message, byte expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, String message, char expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, String message, short expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, String message, int expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, String message, long expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String message, String expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, String message, Map<?, ?> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isEqualTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected) -> Assert.assertEquals((Boolean)actual, (Boolean)expected, (String)message)).build();
                final JavaTemplate before0 = Semantics.statement((JavaVisitor)this, (String)"before0", (actual, message, expected) -> Assert.assertEquals((Byte)actual, (Byte)expected, (String)message)).build();
                final JavaTemplate before1 = Semantics.statement((JavaVisitor)this, (String)"before1", (actual, message, expected) -> Assert.assertEquals((Character)actual, (Character)expected, (String)message)).build();
                final JavaTemplate before2 = Semantics.statement((JavaVisitor)this, (String)"before2", (actual, message, expected) -> Assert.assertEquals((Short)actual, (Short)expected, (String)message)).build();
                final JavaTemplate before3 = Semantics.statement((JavaVisitor)this, (String)"before3", (actual, message, expected) -> Assert.assertEquals((Integer)actual, (Integer)expected, (String)message)).build();
                final JavaTemplate before4 = Semantics.statement((JavaVisitor)this, (String)"before4", (actual, message, expected) -> Assert.assertEquals((Long)actual, (Long)expected, (String)message)).build();
                final JavaTemplate before5 = Semantics.statement((JavaVisitor)this, (String)"before5", (actual, message, expected) -> Assert.assertEquals((Float)actual, (Float)expected, (String)message)).build();
                final JavaTemplate before6 = Semantics.statement((JavaVisitor)this, (String)"before6", (actual, message, expected) -> Assert.assertEquals((Double)actual, (Double)expected, (String)message)).build();
                final JavaTemplate before7 = Semantics.statement((JavaVisitor)this, (String)"before7", (actual, message, expected) -> Assert.assertEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before8 = Semantics.statement((JavaVisitor)this, (String)"before8", (actual, message, expected) -> Assert.assertEquals((String)actual, (String)expected, (String)message)).build();
                final JavaTemplate before9 = Semantics.statement((JavaVisitor)this, (String)"before9", (actual, message, expected) -> Assert.assertEquals((Map)actual, (Map)expected, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected) -> ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isEqualTo(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before7.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before8.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before9.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.testng.Assert assertEquals(..)"), new UsesType("java.util.Map", Boolean.valueOf(true))}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualFloatsWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatsWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatsWithDelta {\n    \n    @BeforeTemplate\n    void before(float actual, float expected, float delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, float expected, float delta) {\n        assertThat(actual).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected, delta) -> Assert.assertEquals((float)actual.floatValue(), (float)expected.floatValue(), (float)delta.floatValue())).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected, delta) -> Assertions.assertThat((Float)actual).isCloseTo(expected, Offset.offset((Number)delta))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualFloatsWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatsWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatsWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected, float delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, String message, float expected, float delta) {\n        assertThat(actual).withFailMessage(message).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected, delta) -> Assert.assertEquals((float)actual.floatValue(), (float)expected.floatValue(), (float)delta.floatValue(), (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected, delta) -> ((AbstractFloatAssert)Assertions.assertThat((Float)actual).withFailMessage(message, new Object[0])).isCloseTo(expected, Offset.offset((Number)delta))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualDoublesWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoublesWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoublesWithDelta {\n    \n    @BeforeTemplate\n    void before(double actual, double expected, double delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, double expected, double delta) {\n        assertThat(actual).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected, delta) -> Assert.assertEquals((double)actual, (double)expected, (double)delta)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected, delta) -> Assertions.assertThat((Double)actual).isCloseTo(expected, Offset.offset((Number)delta))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualDoublesWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoublesWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoublesWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected, double delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, String message, double expected, double delta) {\n        assertThat(actual).withFailMessage(message).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected, delta) -> Assert.assertEquals((double)actual, (double)expected, (double)delta, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected, delta) -> ((AbstractDoubleAssert)Assertions.assertThat((Double)actual).withFailMessage(message, new Object[0])).isCloseTo(expected, Offset.offset((Number)delta))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualArrayIterationOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualArrayIterationOrder`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArrayIterationOrder {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, boolean[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte[] actual, byte[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char[] actual, char[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short[] actual, short[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int[] actual, int[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long[] actual, long[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float[] actual, float[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double[] actual, double[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Object[] actual, Object[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Object[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected) -> Assert.assertEquals((boolean[])actual, (boolean[])expected)).build();
                final JavaTemplate before0 = Semantics.statement((JavaVisitor)this, (String)"before0", (actual, expected) -> Assert.assertEquals((byte[])actual, (byte[])expected)).build();
                final JavaTemplate before1 = Semantics.statement((JavaVisitor)this, (String)"before1", (actual, expected) -> Assert.assertEquals((char[])actual, (char[])expected)).build();
                final JavaTemplate before2 = Semantics.statement((JavaVisitor)this, (String)"before2", (actual, expected) -> Assert.assertEquals((short[])actual, (short[])expected)).build();
                final JavaTemplate before3 = Semantics.statement((JavaVisitor)this, (String)"before3", (actual, expected) -> Assert.assertEquals((int[])actual, (int[])expected)).build();
                final JavaTemplate before4 = Semantics.statement((JavaVisitor)this, (String)"before4", (actual, expected) -> Assert.assertEquals((long[])actual, (long[])expected)).build();
                final JavaTemplate before5 = Semantics.statement((JavaVisitor)this, (String)"before5", (actual, expected) -> Assert.assertEquals((float[])actual, (float[])expected)).build();
                final JavaTemplate before6 = Semantics.statement((JavaVisitor)this, (String)"before6", (actual, expected) -> Assert.assertEquals((double[])actual, (double[])expected)).build();
                final JavaTemplate before7 = Semantics.statement((JavaVisitor)this, (String)"before7", (actual, expected) -> Assert.assertEquals((Object[])actual, (Object[])expected)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected) -> Assertions.assertThat((Object[])actual).containsExactly(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before7.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualArrayIterationOrderWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualArrayIterationOrderWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArrayIterationOrderWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, String message, boolean[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte[] actual, String message, byte[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char[] actual, String message, char[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short[] actual, String message, short[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int[] actual, String message, int[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long[] actual, String message, long[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float[] actual, String message, float[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double[] actual, String message, double[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Object[] actual, String message, Object[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, String message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected) -> Assert.assertEquals((boolean[])actual, (boolean[])expected, (String)message)).build();
                final JavaTemplate before0 = Semantics.statement((JavaVisitor)this, (String)"before0", (actual, message, expected) -> Assert.assertEquals((byte[])actual, (byte[])expected, (String)message)).build();
                final JavaTemplate before1 = Semantics.statement((JavaVisitor)this, (String)"before1", (actual, message, expected) -> Assert.assertEquals((char[])actual, (char[])expected, (String)message)).build();
                final JavaTemplate before2 = Semantics.statement((JavaVisitor)this, (String)"before2", (actual, message, expected) -> Assert.assertEquals((short[])actual, (short[])expected, (String)message)).build();
                final JavaTemplate before3 = Semantics.statement((JavaVisitor)this, (String)"before3", (actual, message, expected) -> Assert.assertEquals((int[])actual, (int[])expected, (String)message)).build();
                final JavaTemplate before4 = Semantics.statement((JavaVisitor)this, (String)"before4", (actual, message, expected) -> Assert.assertEquals((long[])actual, (long[])expected, (String)message)).build();
                final JavaTemplate before5 = Semantics.statement((JavaVisitor)this, (String)"before5", (actual, message, expected) -> Assert.assertEquals((float[])actual, (float[])expected, (String)message)).build();
                final JavaTemplate before6 = Semantics.statement((JavaVisitor)this, (String)"before6", (actual, message, expected) -> Assert.assertEquals((double[])actual, (double[])expected, (String)message)).build();
                final JavaTemplate before7 = Semantics.statement((JavaVisitor)this, (String)"before7", (actual, message, expected) -> Assert.assertEquals((Object[])actual, (Object[])expected, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected) -> ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).withFailMessage(message, new Object[0])).containsExactly(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before7.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualArraysIrrespectiveOfOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualArraysIrrespectiveOfOrder`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArraysIrrespectiveOfOrder {\n    \n    @BeforeTemplate\n    void before(Object[] actual, Object[] expected) {\n        assertEqualsNoOrder(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Object[] expected) {\n        assertThat(actual).containsExactlyInAnyOrder(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected) -> Assert.assertEqualsNoOrder((Object[])actual, (Object[])expected)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected) -> Assertions.assertThat((Object[])actual).containsExactlyInAnyOrder(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEqualsNoOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEqualsNoOrder(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertEqualArraysIrrespectiveOfOrderWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualArraysIrrespectiveOfOrderWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArraysIrrespectiveOfOrderWithMessage {\n    \n    @BeforeTemplate\n    void before(Object[] actual, String message, Object[] expected) {\n        assertEqualsNoOrder(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, String message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactlyInAnyOrder(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected) -> Assert.assertEqualsNoOrder((Object[])actual, (Object[])expected, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected) -> ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).withFailMessage(message, new Object[0])).containsExactlyInAnyOrder(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertEqualsNoOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEqualsNoOrder(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertUnequalRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequal`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequal {\n    \n    @BeforeTemplate\n    void before(boolean actual, boolean expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, byte expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, char expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, short expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, int expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, long expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, float expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, double expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Set<?> actual, Set<?> expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, Map<?, ?> expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isNotEqualTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before0 = Semantics.statement((JavaVisitor)this, (String)"before0", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before1 = Semantics.statement((JavaVisitor)this, (String)"before1", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before2 = Semantics.statement((JavaVisitor)this, (String)"before2", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before3 = Semantics.statement((JavaVisitor)this, (String)"before3", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before4 = Semantics.statement((JavaVisitor)this, (String)"before4", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before5 = Semantics.statement((JavaVisitor)this, (String)"before5", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before6 = Semantics.statement((JavaVisitor)this, (String)"before6", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before7 = Semantics.statement((JavaVisitor)this, (String)"before7", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before8 = Semantics.statement((JavaVisitor)this, (String)"before8", (actual, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected)).build();
                final JavaTemplate before9 = Semantics.statement((JavaVisitor)this, (String)"before9", (actual, expected) -> Assert.assertNotEquals((Set)actual, (Set)expected)).build();
                final JavaTemplate before10 = Semantics.statement((JavaVisitor)this, (String)"before10", (actual, expected) -> Assert.assertNotEquals((Map)actual, (Map)expected)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected) -> Assertions.assertThat((Object)actual).isNotEqualTo(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before7.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before8.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before9.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Set");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before10.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.testng.Assert assertNotEquals(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertUnequalWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message, boolean expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, String message, byte expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, String message, char expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, String message, short expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, String message, int expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, String message, long expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String message, String expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Set<?> actual, String message, Set<?> expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, String message, Map<?, ?> expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isNotEqualTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before0 = Semantics.statement((JavaVisitor)this, (String)"before0", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before1 = Semantics.statement((JavaVisitor)this, (String)"before1", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before2 = Semantics.statement((JavaVisitor)this, (String)"before2", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before3 = Semantics.statement((JavaVisitor)this, (String)"before3", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before4 = Semantics.statement((JavaVisitor)this, (String)"before4", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before5 = Semantics.statement((JavaVisitor)this, (String)"before5", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before6 = Semantics.statement((JavaVisitor)this, (String)"before6", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before7 = Semantics.statement((JavaVisitor)this, (String)"before7", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before8 = Semantics.statement((JavaVisitor)this, (String)"before8", (actual, message, expected) -> Assert.assertNotEquals((Object)actual, (Object)expected, (String)message)).build();
                final JavaTemplate before9 = Semantics.statement((JavaVisitor)this, (String)"before9", (actual, message, expected) -> Assert.assertNotEquals((Set)actual, (Set)expected, (String)message)).build();
                final JavaTemplate before10 = Semantics.statement((JavaVisitor)this, (String)"before10", (actual, message, expected) -> Assert.assertNotEquals((Map)actual, (Map)expected, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected) -> ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNotEqualTo(expected)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before7.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before8.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before9.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Set");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before10.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.testng.Assert assertNotEquals(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true))})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertUnequalFloatsWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalFloatsWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalFloatsWithDelta {\n    \n    @BeforeTemplate\n    void before(float actual, float expected, float delta) {\n        assertNotEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, float expected, float delta) {\n        assertThat(actual).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected, delta) -> Assert.assertNotEquals((float)actual.floatValue(), (float)expected.floatValue(), (float)delta.floatValue())).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected, delta) -> Assertions.assertThat((Float)actual).isNotCloseTo(expected, Offset.offset((Number)delta))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertUnequalFloatsWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalFloatsWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalFloatsWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected, float delta) {\n        assertNotEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, String message, float expected, float delta) {\n        assertThat(actual).withFailMessage(message).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected, delta) -> Assert.assertNotEquals((float)actual.floatValue(), (float)expected.floatValue(), (float)delta.floatValue(), (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected, delta) -> ((AbstractFloatAssert)Assertions.assertThat((Float)actual).withFailMessage(message, new Object[0])).isNotCloseTo(expected, Offset.offset((Number)delta))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertUnequalDoublesWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalDoublesWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalDoublesWithDelta {\n    \n    @BeforeTemplate\n    void before(double actual, double expected, double delta) {\n        assertNotEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, double expected, double delta) {\n        assertThat(actual).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, expected, delta) -> Assert.assertNotEquals((double)actual, (double)expected, (double)delta)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, expected, delta) -> Assertions.assertThat((Double)actual).isNotCloseTo(expected, Offset.offset((Number)delta))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertUnequalDoublesWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalDoublesWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalDoublesWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected, double delta) {\n        assertNotEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, String message, double expected, double delta) {\n        assertThat(actual).withFailMessage(message).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (actual, message, expected, delta) -> Assert.assertNotEquals((double)actual, (double)expected, (double)delta, (String)message)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (actual, message, expected, delta) -> ((AbstractDoubleAssert)Assertions.assertThat((Double)actual).withFailMessage(message, new Object[0])).isNotCloseTo(expected, Offset.offset((Number)delta))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThrowsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertThrows`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThrows {\n    \n    @BeforeTemplate\n    void before(ThrowingRunnable runnable) {\n        assertThrows(runnable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable runnable) {\n        assertThatThrownBy(runnable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", runnable -> Assert.assertThrows((Assert.ThrowingRunnable)runnable)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", runnable -> Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)runnable)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.testng.Assert.ThrowingRunnable");
                        this.maybeRemoveImport("org.testng.Assert.assertThrows");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.testng.Assert.ThrowingRunnable", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert assertThrows(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

