/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.function.LongPredicate;
import java.util.stream.LongStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class LongStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `LongStream`s";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.LongStreamRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new LongStreamClosedOpenRangeRecipe(), new ConcatOneLongStreamRecipe(), new ConcatTwoLongStreamsRecipe(), new LongStreamFilterSortedRecipe(), new LongStreamMinRecipe(), new LongStreamAllMatchRecipe(), new LongStreamTakeWhileRecipe()});
    }

    @NonNullApi
    public static class LongStreamClosedOpenRangeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LongStream#range(long, long)` over the more contrived alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamClosedOpenRange {\n    \n    @BeforeTemplate\n    LongStream before(long from, long to) {\n        return LongStream.rangeClosed(from, to - 1);\n    }\n    \n    @AfterTemplate\n    LongStream after(long from, long to) {\n        return LongStream.range(from, to);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (from, to) -> LongStream.rangeClosed(from, to - 1L)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (from, to) -> LongStream.range(from, to)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream rangeClosed(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ConcatOneLongStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't unnecessarily call `Streams#concat(LongStream...)`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConcatOneLongStream {\n    \n    @BeforeTemplate\n    LongStream before(LongStream stream) {\n        return Streams.concat(stream);\n    }\n    \n    @AfterTemplate\n    @CanIgnoreReturnValue\n    LongStream after(LongStream stream) {\n        return stream;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", stream -> Streams.concat((LongStream[])new LongStream[]{stream})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", stream -> stream).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ConcatTwoLongStreamsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LongStream#concat(LongStream, LongStream)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConcatTwoLongStreams {\n    \n    @BeforeTemplate\n    LongStream before(LongStream s1, LongStream s2) {\n        return Streams.concat(s1, s2);\n    }\n    \n    @AfterTemplate\n    LongStream after(LongStream s1, LongStream s2) {\n        return LongStream.concat(s1, s2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (s1, s2) -> Streams.concat((LongStream[])new LongStream[]{s1, s2})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (s1, s2) -> LongStream.concat(s1, s2)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamFilterSortedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Apply `LongStream#filter(LongPredicate)` before `LongStream#sorted()` to reduce the number of elements to sort";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamFilterSorted {\n    \n    @BeforeTemplate\n    LongStream before(LongStream stream, LongPredicate predicate) {\n        return stream.sorted().filter(predicate);\n    }\n    \n    @AfterTemplate\n    LongStream after(LongStream stream, LongPredicate predicate) {\n        return stream.filter(predicate).sorted();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (stream, predicate) -> stream.sorted().filter((LongPredicate)predicate)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (stream, predicate) -> stream.filter((LongPredicate)predicate).sorted()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream filter(..)"), new UsesMethod("java.util.stream.LongStream sorted(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamMin`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamMin {\n    \n    @BeforeTemplate\n    OptionalLong before(LongStream stream) {\n        return stream.sorted().findFirst();\n    }\n    \n    @AfterTemplate\n    OptionalLong after(LongStream stream) {\n        return stream.min();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", stream -> stream.sorted().findFirst()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", stream -> stream.min()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalLong", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream findFirst(..)"), new UsesMethod("java.util.stream.LongStream sorted(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamAllMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamAllMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamAllMatch {\n    \n    @BeforeTemplate\n    boolean before(LongStream stream, LongPredicate predicate) {\n        return stream.noneMatch(predicate.negate());\n    }\n    \n    @AfterTemplate\n    boolean after(LongStream stream, LongPredicate predicate) {\n        return stream.allMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (stream, predicate) -> stream.noneMatch(predicate.negate())).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (stream, predicate) -> stream.allMatch((LongPredicate)predicate)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream noneMatch(..)"), new UsesMethod("java.util.function.LongPredicate negate(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamTakeWhileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamTakeWhile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamTakeWhile {\n    \n    @BeforeTemplate\n    LongStream before(LongStream stream, LongPredicate predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    LongStream after(LongStream stream, LongPredicate predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (stream, predicate) -> stream.takeWhile((LongPredicate)predicate).filter((LongPredicate)predicate)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (stream, predicate) -> stream.takeWhile((LongPredicate)predicate)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream filter(..)"), new UsesMethod("java.util.stream.LongStream takeWhile(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

