/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class InputStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `InputStream`s";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.InputStreamRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new InputStreamTransferToRecipe(), new InputStreamReadAllBytesRecipe()});
    }

    @NonNullApi
    public static class InputStreamTransferToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamTransferTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamTransferTo {\n    \n    @BeforeTemplate\n    long before(InputStream in, OutputStream out) throws IOException {\n        return ByteStreams.copy(in, out);\n    }\n    \n    @AfterTemplate\n    long after(InputStream in, OutputStream out) throws IOException {\n        return in.transferTo(out);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (in, out) -> ByteStreams.copy((InputStream)in, (OutputStream)out)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (in, out) -> in.transferTo((OutputStream)out)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.io.ByteStreams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.io.ByteStreams", Boolean.valueOf(true)), new UsesType("java.io.InputStream", Boolean.valueOf(true)), new UsesType("java.io.OutputStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.io.ByteStreams copy(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class InputStreamReadAllBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `InputStreamRules.InputStreamReadAllBytes`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InputStreamReadAllBytes {\n    \n    @BeforeTemplate\n    byte[] before(InputStream in) throws IOException {\n        return ByteStreams.toByteArray(in);\n    }\n    \n    @AfterTemplate\n    byte[] after(InputStream in) throws IOException {\n        return in.readAllBytes();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", in -> ByteStreams.toByteArray((InputStream)in)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", in -> in.readAllBytes()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.io.ByteStreams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.io.ByteStreams", Boolean.valueOf(true)), new UsesType("java.io.InputStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.io.ByteStreams toByteArray(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

