/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class InputStreamRules {
    private InputStreamRules() {
    }

    static final class InputStreamReadAllBytes {
        InputStreamReadAllBytes() {
        }

        byte[] before(InputStream in) throws IOException {
            return ByteStreams.toByteArray((InputStream)in);
        }

        byte[] after(InputStream in) throws IOException {
            return in.readAllBytes();
        }
    }

    static final class InputStreamTransferTo {
        InputStreamTransferTo() {
        }

        long before(InputStream in, OutputStream out) throws IOException {
            return ByteStreams.copy((InputStream)in, (OutputStream)out);
        }

        long after(InputStream in, OutputStream out) throws IOException {
            return in.transferTo(out);
        }
    }
}

