/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class EqualityRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with (in)equalities";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.EqualityRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new DoubleNegationRecipe()});
    }

    @NonNullApi
    public static class DoubleNegationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Avoid double negations; this is not Javascript";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleNegation {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S2761\")\n    boolean before(boolean b) {\n        return !!b;\n    }\n    \n    @AfterTemplate\n    @CanIgnoreReturnValue\n    boolean after(boolean b) {\n        return b;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", b -> b != false).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", b -> b).build();

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return javaVisitor;
        }
    }
}

